/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.AbstractDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetColumn;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetMetaData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Properties;

public class FileDriver
extends AbstractDriver {
    public static final int SELECT_COLUMN = 0;
    public static final int WHERE_COLUMN = 1;
    private static final String URL_PREFIX = "jdbc:semarchy:file";
    private static final String LEGACY_URL_PREFIX = "jdbc:stambia:file";
    private static final String URL_FOLDER = "folder=";
    private static final String URL_METADATA = "metadata=";
    private static final String URL_LOG = "log=";
    public static final String URL_READER_VERSION = "readerversion=";

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String ret = sw.toString();
        return ret;
    }

    public static FileDriverResultSetColumn createColMetadata(FileDriverResultSetMetaData colFather, String colClassName, int colNum, String colName, String colLabel, int colType, int colDisplaySize, int colPrecision, int colScale) {
        FileDriverResultSetColumn col = new FileDriverResultSetColumn();
        col.setClassName(colClassName);
        col.setFather(colFather);
        col.setColNum(colNum);
        col.setName(colName);
        col.setLabel(colLabel);
        col.setType(colType);
        col.setDisplaySize(colDisplaySize);
        col.setPrecision(colPrecision);
        col.setScale(colScale);
        return col;
    }

    public static String getTypeNameFromSQLType(int colType) {
        return switch (colType) {
            case -5 -> "java.lang.Long";
            case -7 -> "java.lang.Boolean";
            case 1 -> "java.lang.String";
            case 91 -> "java.sql.Date";
            case 3 -> "java.math.BigDecimal";
            case 8 -> "java.lang.Double";
            case 6 -> "java.lang.Double";
            case 4 -> "java.lang.Integer";
            case -1 -> "java.lang.String";
            case 2 -> "java.math.BigDecimal";
            case 7 -> "java.lang.Float";
            case 5 -> "java.lang.Short";
            case 92 -> "java.sql.Time";
            case 93 -> "java.sql.TimeStamp";
            case -6 -> "java.lang.Byte";
            case 12 -> "java.lang.String";
            default -> "java.lang.String";
        };
    }

    @Override
    public int getMajorVersion() {
        return FileDriver.getDriverMajorVersion();
    }

    public static int getDriverMajorVersion() {
        return 1;
    }

    public static int getDriverMinorVersion() {
        return 250;
    }

    @Override
    public int getMinorVersion() {
        return FileDriver.getDriverMinorVersion();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!url.startsWith(URL_PREFIX) && !url.startsWith(LEGACY_URL_PREFIX)) {
            return null;
        }
        String metadataPath = "";
        String logPath = "";
        String readerVersion = "";
        int paramIndex = url.indexOf("?");
        if (paramIndex > 0 && url.length() > paramIndex) {
            String[] params;
            for (String param : params = url.substring(paramIndex + 1).split("&")) {
                if (param.startsWith(URL_READER_VERSION)) {
                    readerVersion = param.substring(URL_READER_VERSION.length());
                    continue;
                }
                if (param.startsWith(URL_LOG)) {
                    logPath = param.substring(URL_LOG.length());
                    continue;
                }
                if (!param.startsWith(URL_METADATA)) continue;
                metadataPath = param.substring(URL_METADATA.length());
            }
        }
        if (readerVersion != null && !readerVersion.isEmpty()) {
            info = new Properties(info);
            info.put("readerversion", readerVersion);
        }
        FileDriverConnection fdc = new FileDriverConnection(info);
        if (!logPath.equals("")) {
            fdc.setLogFileName(logPath);
            fdc.openLogFile();
        }
        if (!metadataPath.equals("")) {
            fdc.setMetadataFromXmlFile(metadataPath);
        }
        return fdc;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url != null) {
            return url.startsWith(URL_PREFIX) || url.startsWith(LEGACY_URL_PREFIX);
        }
        return false;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public static String leftPad(String stringToPad, String padder, int size) {
        if (padder.length() == 0) {
            return stringToPad;
        }
        StringBuffer strb = new StringBuffer(size);
        StringCharacterIterator sci = new StringCharacterIterator(padder);
        while (strb.length() < size - stringToPad.length()) {
            char ch = sci.first();
            while (ch != '\uffff') {
                if (strb.length() < size - stringToPad.length()) {
                    strb.insert(strb.length(), String.valueOf(ch));
                }
                ch = sci.next();
            }
        }
        return strb.append(stringToPad).toString();
    }

    public static String rightPad(String stringToPad, String padder, int size) {
        if (padder.length() == 0) {
            return stringToPad;
        }
        StringBuffer strb = new StringBuffer(stringToPad);
        StringCharacterIterator sci = new StringCharacterIterator(padder);
        while (strb.length() < size) {
            char ch = sci.first();
            while (ch != '\uffff') {
                if (strb.length() < size) {
                    strb.append(String.valueOf(ch));
                }
                ch = sci.next();
            }
        }
        return strb.toString();
    }

    public static String ltrim(String _string) {
        _string = _string.replaceAll("^ *", "");
        return _string;
    }

    public static String rtrim(String _string) {
        _string = _string.replaceAll(" *$", "");
        return _string;
    }

    static {
        try {
            DriverManager.registerDriver(new FileDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum FD_CODE_MSG {
        FD_010_001,
        FD_010_002,
        FD_010_003,
        FD_010_004,
        FD_010_005,
        FD_010_006,
        FD_010_007,
        FD_010_008,
        FD_010_009,
        FD_010_010,
        FD_010_011,
        FD_010_012;


        public String getMessage() {
            return this.getMessage(null, new String[0]);
        }

        public String getMessage(String data, String[] str) {
            String tmp = this._getMessage(data, str);
            if (tmp != null) {
                return this.toString() + ": " + tmp;
            }
            return this.toString();
        }

        private String _getMessage(String data, String[] str) {
            if (data != null) {
                str = Arrays.copyOf(str, str.length + 1);
                str[str.length - 1] = data;
            }
            switch (this) {
                case FD_010_002: {
                    return Messages.getString("FileDriver.0");
                }
                case FD_010_003: {
                    return Messages.getString("FileDriver.1");
                }
                case FD_010_004: {
                    return Messages.getString("FileDriver.2");
                }
                case FD_010_005: {
                    return Messages.getString("FileDriver.3");
                }
                case FD_010_006: {
                    return String.format(Messages.getString("FileDriver.4"), str);
                }
                case FD_010_007: {
                    return String.format(Messages.getString("FileDriver.5"), str);
                }
                case FD_010_008: {
                    return String.format(Messages.getString("FileDriver.6"), str);
                }
                case FD_010_009: {
                    return String.format(Messages.getString("FileDriver.7"), str);
                }
                case FD_010_010: {
                    return String.format(Messages.getString("FileDriver.8"), str);
                }
                case FD_010_011: {
                    return String.format(Messages.getString("FileDriver.9"), str);
                }
                case FD_010_012: {
                    return Messages.getString("FileDriver.10");
                }
            }
            return null;
        }
    }
}

