/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.AbstractConnection;
import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverDatabaseMetaData;
import com.stambia.jdbc.driver.file.FileDriverGenericStatement;
import com.stambia.jdbc.driver.file.FileDriverPreparedRawStatement;
import com.stambia.jdbc.driver.file.FileDriverPreparedStatement;
import com.stambia.jdbc.driver.file.FileDriverStatement;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.fileMetadata.Dataypes;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataDirectory;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataEnreg;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilter;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileContentColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.InternalColumn;
import com.stambia.jdbc.driver.file.parser.MetadataValueObject;
import com.stambia.jdbc.driver.file.tools.XPathAPI;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.insert.Insert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileDriverConnection
extends AbstractConnection {
    private List<Statement> statements = new ArrayList<Statement>();
    private boolean hasMedatada = false;
    MetadataServer metServ = null;
    String numericPadChar = " ";
    String stringPadChar = " ";
    private String logFileName = null;
    private FileOutputStream fstream;
    private boolean useLogFile = false;
    String metadata;
    private String fileReaderVersion = null;
    Map<String, Writer> writers = new HashMap<String, Writer>();
    public static final String outputStreamName = "$___OutputStream___$";
    private String uniqueFilePath;

    public void openLogFile() throws SQLException {
        try {
            File f = new File(this.logFileName);
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            f = null;
            this.fstream = new FileOutputStream(this.logFileName);
        }
        catch (FileNotFoundException e) {
            throw new SQLException(Messages.getString("FileDriverConnection.0"), e);
        }
        this.useLogFile = true;
    }

    public void log(String data) throws SQLException {
        if (this.useLogFile) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.S");
            try {
                String sMess = dateFormat.format(new Date()) + " : ";
                sMess = sMess + data + System.getProperty("line.separator");
                this.fstream.write(sMess.getBytes());
            }
            catch (IOException e) {
                System.out.println("FileDriverConnection::log, IO Exception : " + e.getMessage());
                throw new SQLException(Messages.getString("FileDriverConnection.1") + e.getMessage(), e);
            }
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public MetadataServer getMetadataServer() {
        return this.metServ;
    }

    public void setMetadataServer(MetadataServer metServ) {
        this.metServ = metServ;
        this.hasMedatada = true;
    }

    public boolean hasMedatada() {
        return this.hasMedatada;
    }

    public void setHasMedatada(boolean hasMedatada) {
        this.hasMedatada = hasMedatada;
    }

    private List<MetadataDirectory> parseDir(Node nodedir, MetadataDirectory parent) throws SQLException {
        ArrayList<MetadataDirectory> list = new ArrayList<MetadataDirectory>();
        MetadataDirectory dir = new MetadataDirectory();
        list.add(dir);
        Object path = parent != null ? parent.getPath() + File.separator : "";
        path = (String)path + nodedir.getAttributes().getNamedItem("path").getNodeValue();
        dir.setPath((String)path);
        dir.setPathName(nodedir.getAttributes().getNamedItem("name").getNodeValue());
        dir.setId(nodedir.getAttributes().getNamedItem("id").getNodeValue());
        NodeList lstNodeFiles = nodedir.getChildNodes();
        int nbNodeFiles = 0;
        for (int ctNode = 0; ctNode < lstNodeFiles.getLength(); ++ctNode) {
            Node nFile = lstNodeFiles.item(ctNode);
            if (!nFile.getNodeName().equals("file")) continue;
            ++nbNodeFiles;
        }
        MetadataFile[] lstFiles = new MetadataFile[nbNodeFiles];
        nbNodeFiles = 0;
        for (int j = 0; j < lstNodeFiles.getLength(); ++j) {
            Node nFile = lstNodeFiles.item(j);
            if (nFile.getNodeName().equals("file")) {
                String tmp9;
                String tmp22;
                MetadataFile file = new MetadataFile(dir);
                file.setId(nFile.getAttributes().getNamedItem("id").getNodeValue());
                try {
                    file.setHexaLineSeparator(nFile.getAttributes().getNamedItem("lineSeparator").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    file.setHexaFieldSeparator(nFile.getAttributes().getNamedItem("fieldSeparator").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    file.setHexaStringDelimiter(nFile.getAttributes().getNamedItem("stringDelimiter").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    file.setHexaDecimalSeparator(nFile.getAttributes().getNamedItem("decimalSeparator").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    file.setEscapeChar(nFile.getAttributes().getNamedItem("escapeChar").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    String tmp3 = nFile.getAttributes().getNamedItem("encloseAllWithDelim").getNodeValue();
                    file.setAddDelimiterToAll(Boolean.parseBoolean(tmp3));
                }
                catch (Exception tmp3) {
                    // empty catch block
                }
                int headerSize = 0;
                try {
                    headerSize = Integer.parseInt(nFile.getAttributes().getNamedItem("header").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    int tmp4 = Integer.parseInt(nFile.getAttributes().getNamedItem("lineToSkip").getNodeValue());
                    if (tmp4 > headerSize) {
                        headerSize = tmp4;
                    }
                }
                catch (Exception tmp4) {
                    // empty catch block
                }
                file.setHeaderSize(headerSize);
                int lastLineToSkip = 0;
                try {
                    lastLineToSkip = Integer.parseInt(nFile.getAttributes().getNamedItem("lastLineToSkip").getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file.setLastLineToSkip(lastLineToSkip);
                try {
                    boolean tmp5 = Boolean.parseBoolean(nFile.getAttributes().getNamedItem("fieldErrorRedirectToBadFile").getNodeValue());
                    file.getFieldErrorBehaviour().setRedirectToBadFile(tmp5);
                }
                catch (Exception tmp5) {
                    // empty catch block
                }
                try {
                    tmp22 = nFile.getAttributes().getNamedItem("fieldErrorRule").getNodeValue();
                    if (tmp22 == null || tmp22.isEmpty()) {
                        tmp22 = "raiseException";
                    }
                    file.getFieldErrorBehaviour().setErrorMode(MetadataFile.ErrorMode.from(tmp22));
                }
                catch (Exception tmp22) {
                    // empty catch block
                }
                try {
                    tmp22 = nFile.getAttributes().getNamedItem("fieldCheckSizeError").getNodeValue();
                    file.getFieldErrorBehaviour().setCheckSize(Boolean.parseBoolean(tmp22));
                }
                catch (Exception tmp6) {
                    // empty catch block
                }
                try {
                    tmp22 = nFile.getAttributes().getNamedItem("fieldCountRule").getNodeValue();
                    if (tmp22 == null || tmp22.isEmpty()) {
                        tmp22 = "disableCheck";
                    }
                    file.getWrongNumberFieldBehaviour().setErrorMode(MetadataFile.ErrorMode.from(tmp22));
                }
                catch (Exception tmp7) {
                    // empty catch block
                }
                try {
                    tmp22 = nFile.getAttributes().getNamedItem("trailingFieldsRule").getNodeValue();
                    if (tmp22 == null || tmp22.isEmpty()) {
                        tmp22 = "disableCheck";
                    }
                    file.getTrailingFieldsBehaviour().setErrorMode(MetadataFile.ErrorMode.from(tmp22));
                }
                catch (Exception tmp8) {
                    // empty catch block
                }
                try {
                    file.getWrongNumberFieldBehaviour().setRedirectToBadFile(Boolean.parseBoolean(nFile.getAttributes().getNamedItem("fieldCountRedirectToBadFile").getNodeValue()));
                    file.getTrailingFieldsBehaviour().setRedirectToBadFile(Boolean.parseBoolean(nFile.getAttributes().getNamedItem("fieldCountRedirectToBadFile").getNodeValue()));
                }
                catch (Exception tmp8) {
                    // empty catch block
                }
                try {
                    file.setRaiseExceptionAtTheEnd(Boolean.parseBoolean(nFile.getAttributes().getNamedItem("raiseExceptionAtTheEnd").getNodeValue()));
                }
                catch (Exception tmp8) {
                    // empty catch block
                }
                boolean emptyStringAsNull = false;
                try {
                    tmp9 = nFile.getAttributes().getNamedItem("emptyStringAsNull").getNodeValue();
                    boolean b = Boolean.valueOf(tmp9);
                    if (b) {
                        emptyStringAsNull = true;
                        file.setEmptyStringAsNull(true);
                    } else {
                        file.setEmptyStringAsNull(false);
                    }
                }
                catch (Exception tmp9) {
                    // empty catch block
                }
                if (!emptyStringAsNull) {
                    try {
                        file.setStringDefaultValue(nFile.getAttributes().getNamedItem("stringDefaultValue").getNodeValue());
                    }
                    catch (Exception tmp9) {
                        // empty catch block
                    }
                }
                try {
                    file.setNumericDefaultValue(nFile.getAttributes().getNamedItem("numericDefaultValue").getNodeValue());
                }
                catch (Exception tmp9) {
                    // empty catch block
                }
                try {
                    file.setDateDefaultValue(nFile.getAttributes().getNamedItem("dateDefaultValue").getNodeValue());
                }
                catch (Exception tmp9) {
                    // empty catch block
                }
                try {
                    file.setTimestampDefaultValue(nFile.getAttributes().getNamedItem("timestampDefaultValue").getNodeValue());
                }
                catch (Exception tmp9) {
                    // empty catch block
                }
                try {
                    file.setEnableLeftTrimOnString(nFile.getAttributes().getNamedItem("enableLeftTrimOnString").getNodeValue());
                }
                catch (Exception e) {
                    file.setEnableLeftTrimOnString("false");
                }
                try {
                    file.setDisableRightTrimOnString(nFile.getAttributes().getNamedItem("disableRightTrimOnString").getNodeValue());
                }
                catch (Exception e) {
                    file.setDisableRightTrimOnString("false");
                }
                try {
                    file.setDefaultTimestampFormat(nFile.getAttributes().getNamedItem("defaultTimestampFormat").getNodeValue());
                }
                catch (Exception e) {
                    file.setDefaultTimestampFormat(MetadataServer.DEFAULT_TIMESTAMP_FORMAT);
                }
                try {
                    file.setDefaultDateFormat(nFile.getAttributes().getNamedItem("defaultDateFormat").getNodeValue());
                }
                catch (Exception e) {
                    file.setDefaultDateFormat(MetadataServer.DEFAULT_DATE_FORMAT);
                }
                try {
                    file.setDefaultDecimalFormat(nFile.getAttributes().getNamedItem("defaultNumericFormat").getNodeValue());
                }
                catch (Exception e) {
                    file.setDefaultDecimalFormat("#,##0.###;-#,##0.###");
                }
                try {
                    file.setDefaultHexaGroupingSeparator(nFile.getAttributes().getNamedItem("defaultGroupingSeparator").getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    file.setLineSize(nFile.getAttributes().getNamedItem("lineSize").getNodeValue());
                }
                catch (Exception e) {
                    file.setLineSize("-1");
                }
                try {
                    file.setReadScript(nFile.getAttributes().getNamedItem("transformScript").getNodeValue());
                }
                catch (Exception e) {
                    file.setReadScript(null);
                }
                try {
                    file.setReadingScriptLanguage(nFile.getAttributes().getNamedItem("transformScriptLanguage").getNodeValue());
                }
                catch (Exception e) {
                    file.setReadingScriptLanguage(null);
                }
                try {
                    file.setTransformLineScript(nFile.getAttributes().getNamedItem("transformLineScript").getNodeValue());
                }
                catch (Exception e) {
                    file.setTransformLineScript(null);
                }
                try {
                    file.setTransformLineScriptLanguage(nFile.getAttributes().getNamedItem("transformLineScriptLanguage").getNodeValue());
                }
                catch (Exception e) {
                    file.setTransformLineScriptLanguage(null);
                }
                try {
                    tmp9 = nFile.getAttributes().getNamedItem("charsetName").getNodeValue();
                    tmp9 = tmp9 == null || tmp9.isEmpty() ? Charset.defaultCharset().displayName() : tmp9;
                    file.setCharsetName(tmp9);
                }
                catch (Exception e) {
                    file.setCharsetName(Charset.defaultCharset().displayName());
                }
                try {
                    String byteOrder = nFile.getAttributes().getNamedItem("byteOrder").getNodeValue();
                    if (byteOrder != null) {
                        if (byteOrder.equalsIgnoreCase("LITTLE_ENDIAN")) {
                            file.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                        } else if (byteOrder.equalsIgnoreCase("BIG_ENDIAN")) {
                            file.setByteOrder(ByteOrder.BIG_ENDIAN);
                        }
                    }
                }
                catch (Exception e) {
                    file.setByteOrder(null);
                }
                try {
                    file.setHexaNumericPaddingChar(nFile.getAttributes().getNamedItem("numericPaddingChar").getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    file.setPropertyFieldPrefix(nFile.getAttributes().getNamedItem("propertyFieldPrefix").getNodeValue());
                }
                catch (Exception e) {
                    file.setPropertyFieldPrefix("");
                }
                String typeFile = null;
                try {
                    typeFile = nFile.getAttributes().getNamedItem("type").getNodeValue();
                }
                catch (NullPointerException e) {
                    throw new SQLException(Messages.getString("FileDriverConnection.2"));
                }
                if (typeFile.equals("DELIMITED")) {
                    file.setType(0);
                }
                if (typeFile.equals("POSITIONAL")) {
                    file.setType(1);
                }
                file.setLogicalName(nFile.getAttributes().getNamedItem("name").getNodeValue());
                file.setPhysicalName(nFile.getAttributes().getNamedItem("physicalName").getNodeValue());
                this.parseEnreg(nFile, file, file);
                lstFiles[nbNodeFiles++] = file;
                continue;
            }
            if (!nFile.getNodeName().equals("directory")) continue;
            List<MetadataDirectory> childDir = this.parseDir(nFile, dir);
            list.addAll(childDir);
        }
        dir.setLstFiles(lstFiles);
        return list;
    }

    private MetadataServer getMetadataFromXml(Document doc) throws SQLException {
        MetadataServer metServ = null;
        try {
            doc.getDocumentElement().normalize();
            NodeList nlServer = XPathAPI.selectNodeList(doc, "/server");
            metServ = new MetadataServer();
            Node n = nlServer.item(0);
            if (n == null) {
                throw new SQLException(Messages.getString("FileDriverConnection.3"));
            }
            metServ.setId(n.getAttributes().getNamedItem("id").getNodeValue());
            try {
                metServ.setServerName(nlServer.item(0).getAttributes().getNamedItem("name").getNodeValue());
            }
            catch (Exception e) {
                metServ.setServerName("default");
            }
            nlServer = XPathAPI.selectNodeList(doc, "/server/directory");
            ArrayList<MetadataDirectory> dirs = new ArrayList<MetadataDirectory>();
            for (int i = 0; i < nlServer.getLength(); ++i) {
                dirs.addAll(this.parseDir(nlServer.item(i), null));
            }
            MetadataDirectory[] lstDir = new MetadataDirectory[dirs.size()];
            dirs.toArray(lstDir);
            metServ.setLstDirectories(lstDir);
        }
        catch (XPathFactoryConfigurationException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXml XPathFactoryConfigurationException", e);
        }
        catch (XPathExpressionException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXml XPathExpressionException", e);
        }
        return metServ;
    }

    private void parseEnreg(Node node, MetadataFile file, MetadataEnreg enreg) throws SQLException {
        int i;
        MetadataColumn col = null;
        NodeList lstNodeColumns = node.getChildNodes();
        int nbNodeColumns = 0;
        for (int ctNode = 0; ctNode < lstNodeColumns.getLength(); ++ctNode) {
            node = lstNodeColumns.item(ctNode);
            if (!node.getNodeName().equals("field") && !node.getNodeName().equals("computedField")) continue;
            ++nbNodeColumns;
        }
        IMetadataColumn[] lstColumns = new MetadataColumn[nbNodeColumns];
        nbNodeColumns = 0;
        int maxPosition = -1;
        MetadataColumn lastColumn = null;
        for (int k = 0; k < lstNodeColumns.getLength(); ++k) {
            Node nChild = lstNodeColumns.item(k);
            if (nChild.getNodeName().equals("field") || nChild.getNodeName().equals("computedField")) {
                col = new MetadataColumn();
                col.setId(nChild.getAttributes().getNamedItem("id").getNodeValue());
                try {
                    col.setLabel(nChild.getAttributes().getNamedItem("name").getNodeValue());
                }
                catch (Exception e) {
                    throw new SQLException(Messages.getString("FileDriverConnection.4") + col.getId() + "\"");
                }
                try {
                    col.setName(nChild.getAttributes().getNamedItem("physicalName").getNodeValue());
                }
                catch (Exception e) {
                    throw new SQLException(Messages.getString("FileDriverConnection.5") + col.getLabel() + "\"");
                }
                try {
                    String colType = nChild.getAttributes().getNamedItem("type").getNodeValue();
                    if (colType.equalsIgnoreCase("String")) {
                        col.setType(12);
                        col.setClassName("java.lang.String");
                    } else if (colType.equalsIgnoreCase("Numeric")) {
                        col.setType(2);
                        col.setClassName("java.math.BigDecimal");
                    } else if (colType.equalsIgnoreCase("Date")) {
                        col.setType(91);
                        col.setClassName("java.sql.Date");
                    } else if (colType.equalsIgnoreCase("Timestamp")) {
                        col.setType(93);
                        col.setClassName("java.sql.Timestamp");
                    } else {
                        Dataypes type = Dataypes.getType(colType);
                        if (type != null) {
                            col.setType(type.getSqlType());
                            col.setConverter(type.getConverter());
                        }
                    }
                }
                catch (Exception e) {
                    throw new SQLException(Messages.getString("FileDriverConnection.6") + col.getName() + "\"");
                }
                try {
                    col.setDisplaySize(Integer.parseInt(nChild.getAttributes().getNamedItem("size").getNodeValue()));
                    col.setPhysicalSize(col.getDisplaySize());
                }
                catch (Exception e) {
                    throw new SQLException(Messages.getString("FileDriverConnection.7") + col.getName() + "\"");
                }
                try {
                    col.setPhysicalSize(Integer.parseInt(nChild.getAttributes().getNamedItem("physicalSize").getNodeValue()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    col.setPrecision(Integer.parseInt(nChild.getAttributes().getNamedItem("precision").getNodeValue()));
                }
                catch (Exception e) {
                    try {
                        col.setPrecision(Integer.parseInt(nChild.getAttributes().getNamedItem("size").getNodeValue()));
                    }
                    catch (Exception type) {
                        // empty catch block
                    }
                }
                try {
                    col.setHexaDecimalSeparator(nChild.getAttributes().getNamedItem("decimalSeparator").getNodeValue());
                }
                catch (Exception e) {
                    col.setDecimalSeparator(file.getDecimalSeparator());
                }
                try {
                    String str = nChild.getAttributes().getNamedItem("groupingSeparator").getNodeValue();
                    if (str.length() == 2) {
                        col.setHexaGroupingSeparator(str);
                    } else {
                        col.setGroupingSeparator(str);
                    }
                }
                catch (Exception str) {
                    // empty catch block
                }
                try {
                    col.setScale(Integer.parseInt(nChild.getAttributes().getNamedItem("scale").getNodeValue()));
                }
                catch (Exception e) {
                    try {
                        col.setScale(Integer.parseInt(nChild.getAttributes().getNamedItem("decimal").getNodeValue()));
                    }
                    catch (Exception e2) {
                        col.setScale(-1);
                    }
                }
                try {
                    col.setStartPosition(Integer.parseInt(nChild.getAttributes().getNamedItem("position").getNodeValue()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    col.setAncestorLevel(Integer.parseInt(nChild.getAttributes().getNamedItem("ancestorLevel").getNodeValue()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    col.setOffset(Integer.parseInt(nChild.getAttributes().getNamedItem("offset").getNodeValue()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    col.setFormat(nChild.getAttributes().getNamedItem("format").getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    col.setExpression(nChild.getAttributes().getNamedItem("expression").getNodeValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    col.setPosition(Integer.parseInt(nChild.getAttributes().getNamedItem("position").getNodeValue()));
                    if (col.getPosition() > maxPosition) {
                        maxPosition = col.getPosition();
                        lastColumn = col;
                    }
                }
                catch (Exception e) {
                    if (col.getExpression() == null || col.getExpression().isEmpty()) {
                        throw new SQLException(Messages.getString("FileDriverConnection.8") + col.getName() + "\"");
                    }
                    col.setPosition(-1);
                }
                try {
                    String byteOrder = nChild.getAttributes().getNamedItem("byteOrder").getNodeValue();
                    if (byteOrder != null) {
                        if (byteOrder.equalsIgnoreCase("LITTLE_ENDIAN")) {
                            col.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                        } else if (byteOrder.equalsIgnoreCase("BIG_ENDIAN")) {
                            col.setByteOrder(ByteOrder.BIG_ENDIAN);
                        }
                    }
                }
                catch (Exception e) {
                    col.setByteOrder(file.getByteOrder());
                }
                col.setNumericPaddingChar(file.getNumericPaddingChar());
                col.computeFormats(file);
                col.setColumnIndex(nbNodeColumns);
                lstColumns[nbNodeColumns++] = col;
                continue;
            }
            if (nChild.getNodeName().equals("filter")) {
                MetadataFilter filter = new MetadataFilter();
                try {
                    filter.setTest(nChild.getAttributes().getNamedItem("value").getNodeValue());
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    filter.setNot(Boolean.parseBoolean(nChild.getAttributes().getNamedItem("not").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setNot(false);
                }
                try {
                    filter.setAncestorLevel(Integer.valueOf(nChild.getAttributes().getNamedItem("ancestorLevel").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setAncestorLevel(0);
                }
                try {
                    filter.setFirstLinePosition(Integer.valueOf(nChild.getAttributes().getNamedItem("firstLinePosition").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setFirstLinePosition(0);
                }
                try {
                    filter.setLastLinePosition(Integer.valueOf(nChild.getAttributes().getNamedItem("lastLinePosition").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setLastLinePosition(0);
                }
                try {
                    filter.setOperator(MetadataFilter.Operator.valueOf(nChild.getAttributes().getNamedItem("operator").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setOperator(MetadataFilter.Operator.StartsWith);
                }
                try {
                    filter.setStartsAt(Integer.valueOf(nChild.getAttributes().getNamedItem("start").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setStartsAt(1);
                }
                try {
                    filter.setLength(Integer.valueOf(nChild.getAttributes().getNamedItem("length").getNodeValue()));
                }
                catch (Exception e) {
                    filter.setLength(-1);
                }
                enreg.addFilter(filter);
                continue;
            }
            if (!nChild.getNodeName().equals("record")) continue;
            MetadataEnreg enregChild = new MetadataEnreg();
            enregChild.setId(nChild.getAttributes().getNamedItem("id").getNodeValue());
            try {
                enregChild.setLogicalName(nChild.getAttributes().getNamedItem("name").getNodeValue());
            }
            catch (Exception e) {
                throw new SQLException(Messages.getString("FileDriverConnection.9") + enregChild.getId() + "\"");
            }
            try {
                enregChild.setAncestorLevel(Integer.valueOf(nChild.getAttributes().getNamedItem("ancestorLevel").getNodeValue()));
            }
            catch (Exception e) {
                enregChild.setAncestorLevel(0);
            }
            try {
                enregChild.setOccurenceNumber(Integer.valueOf(nChild.getAttributes().getNamedItem("occurenceNumber").getNodeValue()));
            }
            catch (Exception e) {
                enregChild.setOccurenceNumber(-1);
            }
            try {
                enregChild.setOccurenceSize(Integer.valueOf(nChild.getAttributes().getNamedItem("occurenceSize").getNodeValue()));
            }
            catch (Exception e) {
                enregChild.setOccurenceSize(-1);
            }
            try {
                enregChild.setOccurenceStart(Integer.valueOf(nChild.getAttributes().getNamedItem("occurenceStart").getNodeValue()));
            }
            catch (Exception e) {
                enregChild.setOccurenceStart(-1);
            }
            try {
                enregChild.setPosition(Integer.valueOf(nChild.getAttributes().getNamedItem("position").getNodeValue()));
            }
            catch (Exception e) {
                enregChild.setPosition(0);
            }
            enreg.add(enregChild);
            this.parseEnreg(nChild, file, enregChild);
        }
        enreg.setLastColumn(lastColumn);
        for (i = 0; i < lstColumns.length; ++i) {
            lstColumns[i].setColumnIndex(i);
            if (lstColumns[i].getPosition() != -1) continue;
            lstColumns[i].setPosition(++maxPosition);
        }
        Arrays.sort(lstColumns, new Comparator<MetadataColumn>(){

            @Override
            public int compare(MetadataColumn o1, MetadataColumn o2) {
                return o1.getPosition() - o2.getPosition();
            }
        });
        for (i = 0; i < lstColumns.length; ++i) {
            lstColumns[i].setIndex(i);
            ((MetadataColumn)lstColumns[i]).setColumnIndex(i);
        }
        enreg.setLstColumns(lstColumns);
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) throws UnsupportedEncodingException, SQLException {
        String xmlPart = FileDriverPreparedStatement.getXmlPart(metadata);
        this.metServ = this.getMetadataFromXml(xmlPart);
        this.hasMedatada = true;
    }

    public MetadataServer getMetadataFromXml(String xmlDef) throws SQLException {
        MetadataServer met = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            met = this.getMetadataFromXml(docBuilder.parse(new ByteArrayInputStream(xmlDef.getBytes(StandardCharsets.UTF_8.toString()))));
        }
        catch (SAXException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile SAXException", e);
        }
        catch (FileNotFoundException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile FileNotFoundException", e);
        }
        catch (IOException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile IOException", e);
        }
        catch (ParserConfigurationException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile ParserConfigurationException", e);
        }
        return met;
    }

    public void setMetadataFromXmlFile(String fileName) throws SQLException {
        this.metServ = this.getMetadataFromXmlFile(fileName);
        this.hasMedatada = true;
    }

    private MetadataServer getMetadataFromXmlFile(String fileName) throws SQLException {
        MetadataServer met = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            met = this.getMetadataFromXml(docBuilder.parse(new FileInputStream(fileName)));
        }
        catch (SAXException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile SAXException", e);
        }
        catch (FileNotFoundException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile FileNotFoundException", e);
        }
        catch (IOException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile IOException", e);
        }
        catch (ParserConfigurationException e) {
            this.log(FileDriver.getStackTrace(e));
            throw new SQLException("getMetadataFromXmlFile ParserConfigurationException", e);
        }
        return met;
    }

    public FileDriverConnection(MetadataServer server) {
        this.metServ = server;
        this.hasMedatada = true;
    }

    protected FileDriverConnection(Properties properties) throws SQLException {
        if (properties != null) {
            String file;
            String metadata = properties.getProperty("metadata");
            if (metadata != null) {
                try {
                    this.setMetadata(metadata);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException(e);
                }
            }
            if ((file = properties.getProperty("file")) != null) {
                this.uniqueFilePath = file;
            }
            this.fileReaderVersion = properties.getProperty("readerversion");
        }
    }

    public String getFileReaderVersion() {
        return this.fileReaderVersion;
    }

    @Override
    public Statement createStatement() throws SQLException {
        FileDriverStatement statement = new FileDriverStatement(this, 1004);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String xmlPart;
        try {
            xmlPart = FileDriverPreparedStatement.getXmlPart(sql);
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e);
        }
        MetadataServer metServ = null;
        if (xmlPart != null) {
            sql = sql.replaceFirst(FileDriverPreparedStatement.xmlDefPattern, "");
            metServ = this.getMetadataFromXml(xmlPart);
        } else if (this.hasMedatada()) {
            metServ = this.getMetadataServer();
        } else {
            this.log(Messages.getString("FileDriverConnection.10"));
            throw new SQLException(Messages.getString("FileDriverConnection.11"));
        }
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        try {
            net.sf.jsqlparser.statement.Statement st = parserManager.parse((Reader)new StringReader(sql));
            if (st instanceof Insert) {
                Insert ins = (Insert)st;
                MetadataServer.MetadataFileAndEnreg mf = FileDriverPreparedStatement.getMetadataFileFromSQL(st, "Insert", metServ);
                List lstCols = ins.getColumns();
                Iterator itCol = lstCols.iterator();
                boolean rawData = false;
                boolean fieldData = false;
                ArrayList<IMetadataColumn> cols = new ArrayList<IMetadataColumn>();
                while (itCol.hasNext()) {
                    IMetadataColumn metCol;
                    String colName = ((Column)itCol.next()).getColumnName();
                    if (colName != null && colName.startsWith("\"") && colName.endsWith("\"")) {
                        colName = colName.substring(1, colName.length() - 1);
                    }
                    if ((metCol = mf.getMetadataEnreg().getColumn(colName)) == null) {
                        metCol = InternalColumn.getColumn(mf.getMetadataFile().getPropertyFieldPrefix(), colName);
                        if (metCol == null) {
                            throw new SQLException(Messages.getString("FileDriverConnection.12") + colName + Messages.getString("FileDriverConnection.13"));
                        }
                        if (metCol == FileColumn.filePathColumn) {
                            rawData = true;
                        } else if (metCol == FileContentColumn.StringInstance) {
                            rawData = true;
                        } else if (metCol == FileContentColumn.BinaryInstance) {
                            rawData = true;
                        } else {
                            fieldData = true;
                        }
                    } else {
                        fieldData = true;
                    }
                    if (metCol == null) continue;
                    cols.add(metCol);
                }
                if (fieldData && !rawData) {
                    FileDriverPreparedStatement fdps = new FileDriverPreparedStatement(this);
                    fdps.prepareSQL(sql, (Insert)st, metServ, mf);
                    return fdps;
                }
                if (rawData && !fieldData) {
                    MetadataValueObject[] statementLstValues = FileDriverGenericStatement.getLstValues(st);
                    return new FileDriverPreparedRawStatement(this, mf, cols, statementLstValues);
                }
                throw new SQLException(Messages.getString("FileDriverConnection.14"));
            }
            this.log(Messages.getString("FileDriverConnection.15"));
            throw new SQLException(Messages.getString("FileDriverConnection.16"));
        }
        catch (JSQLParserException e) {
            this.log(Messages.getString("FileDriverConnection.17") + sql);
            this.log(FileDriver.getStackTrace((Exception)((Object)e)));
            throw new SQLException(Messages.getString("FileDriverConnection.18") + sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        for (Statement st : this.statements) {
            st.close();
        }
        if (this.metServ != null) {
            this.metServ.close();
            this.metServ = null;
        }
        if (this.writers != null) {
            this.writers.clear();
            this.writers = null;
        }
        super.close();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new FileDriverDatabaseMetaData(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        FileDriverStatement statement = new FileDriverStatement(this, resultSetType);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (name.equals("metadata")) {
            try {
                this.setMetadata(value);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLClientInfoException(null, (Throwable)e);
            }
            catch (SQLException e) {
                throw new SQLClientInfoException(null, (Throwable)e);
            }
        }
    }

    OutputStreamWriter openWriter(String filePath, boolean fileAppend, String writerCharSetName, int writerBufferSize) throws IOException {
        Writer writer = this.writers.get(filePath);
        if (writer == null) {
            writer = new Writer();
            writer.writerCharSetName = writerCharSetName;
            writer.writerBufferSize = writerBufferSize;
            writer.fileAppend = fileAppend;
            writer.filePath = filePath;
            this.writers.put(filePath, writer);
        }
        return writer.open();
    }

    OutputStreamWriter openWriter(OutputStream os, String writerCharSetName, int writerBufferSize) throws IOException {
        Writer writer = this.writers.get(outputStreamName);
        if (writer == null) {
            writer = new Writer();
            writer.writerCharSetName = writerCharSetName;
            writer.writerBufferSize = writerBufferSize;
            writer.os = os;
            this.writers.put(outputStreamName, writer);
        }
        return writer.open();
    }

    void closeWriter(String filePath) throws IOException {
        Writer writer = this.writers.get(filePath);
        if (writer != null) {
            writer.close();
        }
    }

    String getFilePath(MetadataFile mFile) {
        if (this.uniqueFilePath != null) {
            return this.uniqueFilePath;
        }
        return mFile.getFather().getPath() + File.separator + mFile.getPhysicalName();
    }

    class Writer {
        int nbUses = 0;
        private String writerCharSetName;
        private OutputStream writerFileOutputStream;
        public int writerBufferSize;
        public boolean fileAppend;
        public String filePath;
        private BufferedOutputStream writerBufferedOutputStream;
        private OutputStreamWriter writerOutputStreamWriter;
        public OutputStream os;

        Writer() {
        }

        OutputStreamWriter open() throws IOException {
            if (this.writerOutputStreamWriter == null) {
                if (this.os != null) {
                    this.writerFileOutputStream = this.os;
                } else if (FileDriverConnection.this.uniqueFilePath != null) {
                    this.writerFileOutputStream = new FileOutputStream(FileDriverConnection.this.uniqueFilePath, this.fileAppend);
                }
                if (this.writerFileOutputStream == null) {
                    this.writerFileOutputStream = new FileOutputStream(this.filePath, this.fileAppend);
                }
                this.writerBufferedOutputStream = new BufferedOutputStream(this.writerFileOutputStream, this.writerBufferSize);
                this.writerOutputStreamWriter = new OutputStreamWriter((OutputStream)this.writerBufferedOutputStream, this.writerCharSetName);
            }
            ++this.nbUses;
            return this.writerOutputStreamWriter;
        }

        void close() throws IOException {
            --this.nbUses;
            if (this.nbUses == 0) {
                if (this.writerOutputStreamWriter != null) {
                    this.writerOutputStreamWriter.close();
                }
                this.writerOutputStreamWriter = null;
                if (this.writerBufferedOutputStream != null) {
                    this.writerBufferedOutputStream.close();
                }
                this.writerBufferedOutputStream = null;
                if (this.writerFileOutputStream != null) {
                    this.writerFileOutputStream.close();
                }
                this.writerFileOutputStream = null;
            }
        }
    }
}

