/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.AbstractDatabaseMetadata;
import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataDirectory;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.resultset.FileDriverArrayListResultset;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetColumn;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetMetaData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class FileDriverDatabaseMetaData
extends AbstractDatabaseMetadata {
    private FileDriverConnection metadataConnection = null;

    public FileDriverDatabaseMetaData(FileDriverConnection createdByConnection) {
        this.metadataConnection = createdByConnection;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        MetadataServer metServ;
        MetadataDirectory[] lstDir;
        FileDriverArrayListResultset rset = null;
        if (this.metadataConnection.hasMedatada() && (lstDir = (metServ = this.metadataConnection.getMetadataServer()).getLstDirectories()) != null) {
            FileDriverResultSetMetaData frsmd = new FileDriverResultSetMetaData();
            FileDriverResultSetColumn[] lstCols = new FileDriverResultSetColumn[]{FileDriver.createColMetadata(frsmd, String.class.getName(), 0, "TABLE_CAT", "TABLE_CAT", 12, 150, 0, 0)};
            frsmd.setColumns(lstCols);
            ArrayList<String[]> al = new ArrayList<String[]>();
            for (int i = 0; i < lstDir.length; ++i) {
                String[] values = new String[]{lstDir[i].getPath()};
                al.add(values);
            }
            rset = new FileDriverArrayListResultset(al, frsmd);
        }
        return rset;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "/";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "Folder";
    }

    @Override
    public ResultSet getColumns(String pCatalog, String pSchemaPattern, String pTableName, String pColumnName) throws SQLException {
        MetadataServer metServ;
        MetadataDirectory[] lstDir;
        FileDriverArrayListResultset rset = null;
        String tSchema = null;
        String tTable = null;
        if (this.metadataConnection.hasMedatada() && (lstDir = (metServ = this.metadataConnection.getMetadataServer()).getLstDirectories()) != null) {
            HashSet ht = new HashSet();
            ArrayList<String[]> al = new ArrayList<String[]>();
            for (int i = 0; i < lstDir.length; ++i) {
                MetadataFile[] lstFiles;
                tSchema = pCatalog == null ? lstDir[i].getPath() : pCatalog;
                if (!tSchema.equals(lstDir[i].getPath()) || (lstFiles = lstDir[i].getLstFiles()) == null) continue;
                for (int j = 0; j < lstFiles.length; ++j) {
                    MetadataFile metFile;
                    IMetadataColumn[] lstColumns;
                    tTable = pTableName == null ? lstFiles[j].getPhysicalName() : pTableName;
                    if (!lstFiles[j].getLogicalName().equals(tTable) || (lstColumns = (metFile = lstFiles[j]).getLstColumns()) == null) continue;
                    for (int k = 0; k < lstColumns.length; ++k) {
                        IMetadataColumn metCol = lstColumns[k];
                        String[] values = new String[]{lstDir[i].getPath(), null, lstFiles[j].getLogicalName(), metCol.getName(), String.valueOf(metCol.getType()), FileDriver.getTypeNameFromSQLType(metCol.getType()), String.valueOf(metCol.getDisplaySize()), null, String.valueOf(metCol.getScale()), null, null, "", null, null, null, String.valueOf(metCol.getDisplaySize()), String.valueOf(k), "YES", null, null, null, null, "NO"};
                        al.add(values);
                    }
                }
            }
            FileDriverResultSetMetaData frsmd = new FileDriverResultSetMetaData();
            FileDriverResultSetColumn[] lstCols = new FileDriverResultSetColumn[]{FileDriver.createColMetadata(frsmd, String.class.getName(), 0, "TABLE_CAT", "TABLE_CAT", 12, 150, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 1, "TABLE_SCHEM", "TABLE_SCHEM", 12, 100, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 2, "TABLE_NAME", "TABLE_NAME", 12, 100, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 3, "COLUMN_NAME", "COLUMN_NAME", 12, 100, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 4, "DATA_TYPE", "DATA_TYPE", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 5, "TYPE_NAME", "TYPE_NAME", 12, 50, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 6, "COLUMN_SIZE", "COLUMN_SIZE", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 7, "BUFFER_LENGTH", "BUFFER_LENGTH", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 8, "DECIMAL_DIGITS", "SDECIMAL_DIGITS", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 9, "NUM_PREC_RADIX", "NUM_PREC_RADIX", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 10, "NULLABLE", "NULLABLE", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 11, "REMARKS", "REMARKS", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 12, "COLUMN_DEF", "COLUMN_DEF", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 13, "SQL_DATA_TYPE", "SQL_DATA_TYPE", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 14, "SQL_DATETIME_SUB", "SQL_DATETIME_SUB", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 15, "CHAR_OCTET_LENGTH", "CHAR_OCTET_LENGTH", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 16, "ORDINAL_POSITION", "ORDINAL_POSITION", 4, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 17, "IS_NULLABLE", "IS_NULLABLE", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 18, "SCOPE_CATLOG", "SCOPE_CATLOG", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 19, "SCOPE_SCHEMA", "SCOPE_SCHEMA", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 20, "SCOPE_TABLE", "SCOPE_TABLE", 12, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 21, "SOURCE_DATA_TYPE", "SOURCE_DATA_TYPE", 5, 10, 0, 0), FileDriver.createColMetadata(frsmd, String.class.getName(), 22, "IS_AUTOINCREMENT", "IS_AUTOINCREMENT", 12, 10, 0, 0)};
            frsmd.setColumns(lstCols);
            rset = new FileDriverArrayListResultset(al, frsmd);
        }
        return rset;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.metadataConnection;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return FileDriver.getDriverMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return FileDriver.getDriverMinorVersion();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Stambia Jdbc file driver";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return String.valueOf(FileDriver.getDriverMajorVersion());
    }

    @Override
    public int getDriverMajorVersion() {
        return FileDriver.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return FileDriver.getDriverMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Stambia Jdbc file driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return String.valueOf(FileDriver.getDriverMajorVersion() + "." + FileDriver.getDriverMinorVersion());
    }

    @Override
    public ResultSet getTables(String pCatalog, String pSchemaNamePattern, String pTableNamePattern, String[] pTypes) throws SQLException {
        MetadataServer metServ;
        MetadataDirectory[] lstDir;
        FileDriverArrayListResultset rset = null;
        String tSchema = null;
        if (this.metadataConnection.hasMedatada() && (lstDir = (metServ = this.metadataConnection.getMetadataServer()).getLstDirectories()) != null) {
            HashSet ht = new HashSet();
            ArrayList<String[]> al = new ArrayList<String[]>();
            for (int i = 0; i < lstDir.length; ++i) {
                MetadataFile[] lstFiles;
                tSchema = pCatalog == null ? lstDir[i].getPath() : pCatalog;
                if (!tSchema.equals(lstDir[i].getPath()) || (lstFiles = lstDir[i].getLstFiles()) == null) continue;
                for (int j = 0; j < lstFiles.length; ++j) {
                    String[] values = new String[10];
                    values[0] = lstDir[i].getPath();
                    values[1] = null;
                    values[2] = lstFiles[j].getLogicalName();
                    if (lstFiles[j].getType() == 0) {
                        values[3] = "DELIMITED";
                    } else if (lstFiles[j].getType() == 1) {
                        values[3] = "POSITIONAL";
                    }
                    values[4] = lstFiles[j].getPhysicalName();
                    values[5] = null;
                    values[6] = null;
                    values[7] = null;
                    values[8] = null;
                    values[9] = null;
                    al.add(values);
                }
            }
            FileDriverResultSetMetaData frsmd = new FileDriverResultSetMetaData();
            FileDriverResultSetColumn[] lstCols = new FileDriverResultSetColumn[10];
            FileDriverResultSetColumn col = new FileDriverResultSetColumn();
            lstCols[0] = FileDriver.createColMetadata(frsmd, String.class.getName(), 0, "TABLE_CAT", "TABLE_CAT", 12, 150, 0, 0);
            lstCols[1] = FileDriver.createColMetadata(frsmd, String.class.getName(), 1, "TABLE_SCHEM", "TABLE_SCHEM", 12, 150, 0, 0);
            lstCols[2] = FileDriver.createColMetadata(frsmd, String.class.getName(), 1, "TABLE_NAME", "TABLE_NAME", 12, 150, 0, 0);
            lstCols[3] = FileDriver.createColMetadata(frsmd, String.class.getName(), 3, "TABLE_TYPE", "TABLE_TYPE", 12, 150, 0, 0);
            lstCols[4] = FileDriver.createColMetadata(frsmd, String.class.getName(), 4, "REMARKS", "REMARKS", 12, 150, 0, 0);
            lstCols[5] = FileDriver.createColMetadata(frsmd, String.class.getName(), 5, "TYPE_CAT", "TYPE_CAT", 12, 150, 0, 0);
            lstCols[6] = FileDriver.createColMetadata(frsmd, String.class.getName(), 6, "TYPE_SCHEM", "TYPE_SCHEM", 12, 150, 0, 0);
            lstCols[7] = FileDriver.createColMetadata(frsmd, String.class.getName(), 7, "TYPE_NAME", "TYPE_NAME", 12, 150, 0, 0);
            lstCols[8] = FileDriver.createColMetadata(frsmd, String.class.getName(), 8, "SELF_REFERENCING_COL_NAME", "SELF_REFERENCING_COL_NAME", 12, 150, 0, 0);
            lstCols[9] = FileDriver.createColMetadata(frsmd, String.class.getName(), 9, "REF_GENERATION", "REF_GENERATION", 12, 150, 0, 0);
            frsmd.setColumns(lstCols);
            rset = new FileDriverArrayListResultset(al, frsmd);
        }
        return rset;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        MetadataServer metServ;
        MetadataDirectory[] lstDir;
        FileDriverArrayListResultset rset = null;
        if (this.metadataConnection.hasMedatada() && (lstDir = (metServ = this.metadataConnection.getMetadataServer()).getLstDirectories()) != null) {
            HashSet<String> ht = new HashSet<String>();
            for (int i = 0; i < lstDir.length; ++i) {
                MetadataFile[] lstFiles = lstDir[i].getLstFiles();
                if (lstFiles == null) continue;
                for (int j = 0; j < lstFiles.length; ++j) {
                    if (lstFiles[j].getType() == 0) {
                        ht.add("DELIMITED");
                        continue;
                    }
                    if (lstFiles[j].getType() != 1) continue;
                    ht.add("POSITIONAL");
                }
            }
            ArrayList<String[]> al = new ArrayList<String[]>();
            Iterator it = ht.iterator();
            while (it.hasNext()) {
                String[] values = new String[]{(String)it.next()};
                al.add(values);
            }
            FileDriverResultSetMetaData frsmd = new FileDriverResultSetMetaData();
            FileDriverResultSetColumn[] lstCols = new FileDriverResultSetColumn[1];
            FileDriverResultSetColumn col = new FileDriverResultSetColumn();
            col.setClassName(String.class.getName());
            col.setFather(frsmd);
            col.setColNum(0);
            col.setName("TABLE_TYPES");
            col.setLabel("TABLE_TYPES");
            col.setType(12);
            col.setDisplaySize(150);
            col.setPrecision(0);
            col.setScale(0);
            lstCols[0] = col;
            frsmd.setColumns(lstCols);
            rset = new FileDriverArrayListResultset(al, frsmd);
        }
        return rset;
    }
}

