/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.OutputStreamStatement;
import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataEnreg;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.parser.MetadataInsertValuesVisitor;
import com.stambia.jdbc.driver.file.parser.MetadataValueObject;
import com.stambia.jdbc.driver.file.tools.XPathAPI;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.truncate.Truncate;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileDriverGenericStatement
implements OutputStreamStatement {
    protected MetadataServer statementMetadataServer = null;
    protected FileDriverConnection connection;
    protected String headerFieldSeparator = ",";
    protected String lineSeparatorBeforeStr = "";
    protected String lineSeparatorAfterStr = "";
    protected int generateHeader = 0;
    protected VerifyLength verifyLength = VerifyLength._true;
    protected boolean lineSeparatorBefore = true;
    protected boolean lineSeparatorBeforeIsSet = false;
    protected boolean lineSeparatorAfter = false;
    protected boolean addDelimiterToAll = false;
    protected IMetadataColumn[] lstInsertColumnMetadata = null;
    protected IMetadataColumn[] lstColumns;
    protected int[] indexColumnToMetadataIndex;
    protected int[] statementColumnIndex = null;
    protected int[] inverseStatementColumnIndex;
    protected MetadataValueObject[] statementLstValues = null;
    protected String[] initRow = null;
    protected String[] currentRow = null;
    protected int nbLineColumns;
    protected int nbStatementColumns;
    boolean isInitFilePath = false;
    protected String filePath;
    protected OutputStreamWriter writerOutputStreamWriter = null;
    protected String writerCharSetName = "";
    protected int writerBufferSize = 8192;
    protected boolean fileAppend = true;
    protected boolean hasgeneratedHeader;
    boolean writerOutputStreamWriterIsNotSetted;
    boolean hasWriteRow = false;
    OutputStream os;

    public static MetadataValueObject[] getLstValues(Statement st) throws SQLException {
        Insert ins = (Insert)st;
        int nbStatementColumns = ins.getColumns().size();
        MetadataInsertValuesVisitor mivv = new MetadataInsertValuesVisitor();
        ins.getItemsList().accept((ItemsListVisitor)mivv);
        ArrayList<MetadataValueObject> lstValue = mivv.getLstValue();
        if (lstValue.size() > nbStatementColumns) {
            throw new SQLException(Messages.getString("FileDriverGenericStatement.0"));
        }
        if (lstValue.size() < nbStatementColumns) {
            throw new SQLException(Messages.getString("FileDriverGenericStatement.1"));
        }
        int nbParameters = mivv.getNbParameters();
        MetadataValueObject[] statementLstValues = new MetadataValueObject[nbStatementColumns];
        Iterator<MetadataValueObject> it = lstValue.iterator();
        int nbValues = lstValue.size() - nbParameters;
        int i = 0;
        while (it.hasNext()) {
            MetadataValueObject o;
            statementLstValues[i] = o = it.next();
            ++i;
        }
        lstValue.clear();
        return statementLstValues;
    }

    protected IMetadataColumn[] constructStatementColumnIndex(Statement st, MetadataEnreg mEnreg) throws SQLException {
        int j;
        IMetadataColumn[] lst = null;
        Insert ins = (Insert)st;
        List lstCols = ins.getColumns();
        lst = new MetadataColumn[this.nbLineColumns];
        Iterator itCol = lstCols.iterator();
        this.statementColumnIndex = new int[this.lstColumns.length];
        this.inverseStatementColumnIndex = new int[this.lstColumns.length];
        int i = 0;
        int parameterIndex = 0;
        boolean valueIndex = false;
        for (j = 0; j < this.inverseStatementColumnIndex.length; ++j) {
            this.inverseStatementColumnIndex[j] = -1;
        }
        while (itCol.hasNext()) {
            IMetadataColumn metCol;
            String colName = ((Column)itCol.next()).getColumnName();
            if (colName != null && colName.startsWith("\"") && colName.endsWith("\"")) {
                colName = colName.substring(1, colName.length() - 1);
            }
            if ((metCol = mEnreg.getColumn(colName)) == null) {
                throw new SQLException(Messages.getString("FileDriverGenericStatement.2") + colName + Messages.getString("FileDriverGenericStatement.3"));
            }
            this.inverseStatementColumnIndex[metCol.getColumnIndex()] = parameterIndex;
            this.statementColumnIndex[parameterIndex++] = metCol.getColumnIndex();
            lst[metCol.getColumnIndex()] = metCol;
            ++i;
        }
        lstCols.clear();
        for (j = 0; j < this.nbLineColumns; ++j) {
            if (lst[j] != null) continue;
            lst[j] = mEnreg.getColumn(j);
        }
        return lst;
    }

    protected static MetadataServer.MetadataFileAndEnreg getMetadataFileFromSQL(Statement st, String type, MetadataServer statementMetadataServer) {
        MetadataServer.MetadataFileAndEnreg mf = null;
        Table table = null;
        if (type.equals("Insert")) {
            table = ((Insert)st).getTable();
        } else if (type.equals("Truncate")) {
            table = ((Truncate)st).getTable();
        }
        if (table != null) {
            mf = statementMetadataServer.getFile(table.getSchemaName(), table.getName());
        } else {
            System.out.println(Messages.getString("FileDriverGenericStatement.4"));
        }
        return mf;
    }

    protected int getInsertStatementNbColumns(Statement st) {
        int ret = 0;
        Insert ins = (Insert)st;
        ret = ins.getColumns().size();
        return ret;
    }

    protected String formatPositionnalColumn(String val, int column, MetadataFile mFile) throws SQLException {
        if (val == null) {
            val = "";
        }
        String tmpStr = "";
        String colName = "";
        int colType = 0;
        try {
            try {
                colName = this.lstColumns[column].getName();
                colType = this.lstColumns[column].getType();
                switch (colType) {
                    case -16: 
                    case -1: 
                    case 1: 
                    case 12: {
                        tmpStr = FileDriver.rightPad(val, MetadataServer.DEFAULT_STRING_PADDING_CHAR, this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 91: {
                        tmpStr = FileDriver.rightPad(val, MetadataServer.DEFAULT_STRING_PADDING_CHAR, this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 3: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 8: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 6: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 4: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 2: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 7: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 5: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 92: {
                        tmpStr = FileDriver.rightPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case 93: {
                        tmpStr = FileDriver.rightPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case -6: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case -5: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                        break;
                    }
                    case -7: {
                        tmpStr = FileDriver.leftPad(val, this.lstColumns[column].getNumericPaddingChar(), this.lstColumns[column].getPhysicalSize());
                    }
                }
            }
            catch (NullPointerException e) {
                tmpStr = "";
            }
        }
        catch (Exception e) {
            throw new SQLException(Messages.getString("FileDriverGenericStatement.5") + colName + "'");
        }
        return tmpStr;
    }

    boolean hasDecimalSeparator(StringBuilder value, boolean enableNumericDelimiter, String decimalSeparator) {
        return enableNumericDelimiter && value.indexOf(decimalSeparator) > -1;
    }

    public static void replaceString(StringBuilder sb, String toReplace, String replacement) {
        int index = -1;
        int previousIndex = 0;
        while ((index = sb.indexOf(toReplace, previousIndex)) != -1) {
            sb.replace(index, index + toReplace.length(), replacement);
            previousIndex = index + replacement.length();
        }
    }

    void addStringDelimiters(StringBuilder builder, boolean hasStringDelimiter, String stringDelimiter, String stringDelimiterReplacement) {
        if (hasStringDelimiter) {
            if (builder.indexOf(stringDelimiter) > -1) {
                FileDriverGenericStatement.replaceString(builder, stringDelimiter, stringDelimiterReplacement);
            }
            builder.append(stringDelimiter);
            builder.insert(0, stringDelimiter);
        }
    }

    private boolean hasDelimiter(StringBuilder builder, boolean hasStringDelimiter, String stringDelimiter, String fieldSep, String rowSep) {
        return hasStringDelimiter && (builder.indexOf(stringDelimiter) > -1 || builder.indexOf(fieldSep) > -1 || builder.indexOf(rowSep) > -1);
    }

    protected String formatDelimitedColumn(String val, int column, String stringDelimiter, String decimalSeparator, String fieldSep, String rowSep, String escapeChar, boolean hasStringDelimiter, boolean hasDecimalDelimiter) throws SQLException {
        boolean wasNull;
        boolean bl = wasNull = val == null;
        if (val == null) {
            val = "";
        }
        StringBuilder builder = new StringBuilder(val);
        boolean delimitedField = false;
        if (!this.addDelimiterToAll) {
            IMetadataColumn metCol = this.lstColumns[column];
            String colName = metCol.getName();
            int colType = 0;
            try {
                try {
                    colType = metCol.getType();
                    switch (colType) {
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            delimitedField = !wasNull;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            delimitedField = this.hasDelimiter(builder, hasStringDelimiter, stringDelimiter, fieldSep, rowSep);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 8: {
                            delimitedField = this.hasDecimalSeparator(builder, hasDecimalDelimiter, decimalSeparator);
                            break;
                        }
                        default: {
                            delimitedField = false;
                            break;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (Exception e) {
                throw new SQLException(Messages.getString("FileDriverGenericStatement.6") + colName + "'");
            }
        } else {
            delimitedField = true;
        }
        if (delimitedField) {
            if (hasStringDelimiter) {
                this.addStringDelimiters(builder, hasStringDelimiter, stringDelimiter, stringDelimiter + stringDelimiter);
            } else if (escapeChar != null && !escapeChar.isEmpty()) {
                this.escapeSpecialCharacters(builder, rowSep, fieldSep, escapeChar);
            }
        }
        return builder.toString();
    }

    private void escapeSpecialCharacters(StringBuilder builder, String rowSep, String fieldSep, String escapeChar) {
        FileDriverGenericStatement.replaceString(builder, fieldSep, escapeChar + fieldSep);
        FileDriverGenericStatement.replaceString(builder, rowSep, escapeChar + rowSep);
    }

    protected void writeDelimitedRow(String[] row, int numRow, MetadataServer.MetadataFileAndEnreg mFile) throws SQLException {
        try {
            if (this.hasWriteRow) {
                this.write(mFile.getMetadataFile().getLineSeparator());
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("FileDriverGenericStatement.7") + numRow);
        }
        this.hasWriteRow = true;
        int count = 0;
        String stringDelimiter = mFile.getMetadataFile().getStringDelimiter();
        String decimalSeparator = mFile.getMetadataFile().getDecimalSeparator();
        String fieldSeparator = mFile.getMetadataFile().getFieldSeparator();
        String rowSeparator = mFile.getMetadataFile().getLineSeparator();
        String escapeChar = mFile.getMetadataFile().getEscapeChar();
        this.addDelimiterToAll = mFile.getMetadataFile().isAddDelimiterToAll();
        boolean hasStringDelimiter = stringDelimiter != null && !stringDelimiter.isEmpty();
        boolean hasDecimalDelimiter = hasStringDelimiter && decimalSeparator != null && !decimalSeparator.isEmpty() && decimalSeparator.equals(fieldSeparator);
        for (int i = 0; i < this.lstColumns.length; ++i) {
            int index = this.indexColumnToMetadataIndex[i];
            String expression = null;
            if (index > -1) {
                expression = this.lstInsertColumnMetadata[index].getExpression();
            }
            if (expression != null && !expression.isEmpty()) continue;
            try {
                int stIndex;
                if (count > 0) {
                    this.write(mFile.getMetadataFile().getFieldSeparator());
                }
                String val = (stIndex = this.inverseStatementColumnIndex[i]) > -1 ? row[stIndex] : "";
                this.write(this.formatDelimitedColumn(val, i, stringDelimiter, decimalSeparator, fieldSeparator, rowSeparator, escapeChar, hasStringDelimiter, hasDecimalDelimiter));
                ++count;
                continue;
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("FileDriverGenericStatement.8") + this.lstColumns[i].getName() + "' (" + i + Messages.getString("FileDriverGenericStatement.9") + numRow);
            }
        }
    }

    protected void writePositionalRow(String[] row, int numRow, MetadataFile mFile) throws SQLException {
        try {
            if (this.hasWriteRow) {
                this.write(mFile.getLineSeparator());
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.getString("FileDriverGenericStatement.10") + numRow);
        }
        this.hasWriteRow = true;
        for (int i = 0; i < this.lstColumns.length; ++i) {
            int index = this.indexColumnToMetadataIndex[i];
            String expression = null;
            if (index > -1) {
                expression = this.lstInsertColumnMetadata[index].getExpression();
            }
            if (expression != null && !expression.isEmpty()) continue;
            try {
                int stIndex = this.inverseStatementColumnIndex[i];
                String val = stIndex > -1 ? row[stIndex] : "";
                this.write(this.formatPositionnalColumn(val, i, mFile));
                continue;
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("FileDriverGenericStatement.11") + this.lstColumns[i].getName() + "' (" + i + Messages.getString("FileDriverGenericStatement.12") + numRow);
            }
        }
    }

    void write(String str) throws IOException {
        this.getWriter().write(str);
    }

    public OutputStreamWriter getWriter() throws IOException {
        if (!this.writerOutputStreamWriterIsNotSetted) {
            this.writerOutputStreamWriterIsNotSetted = true;
            this.writerOutputStreamWriter = this.os != null ? this.connection.openWriter(this.os, this.writerCharSetName, this.writerBufferSize) : this.connection.openWriter(this.filePath, this.fileAppend, this.writerCharSetName, this.writerBufferSize);
        }
        return this.writerOutputStreamWriter;
    }

    protected void init(MetadataServer.MetadataFileAndEnreg mfae) {
        if (!this.isInitFilePath) {
            this.isInitFilePath = true;
            this.filePath = this.connection.getFilePath(mfae.getMetadataFile());
            this.writerCharSetName = mfae.getMetadataFile().getCharsetName();
        }
    }

    protected void findOptionsInSQL(String sql) throws SQLException {
        String xmlDefPattern = ".*(<properties.*></properties>).*";
        Pattern patt = Pattern.compile(xmlDefPattern);
        Matcher m1 = patt.matcher(sql);
        if (m1.find()) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(m1.group(1).getBytes());){
                String p;
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(is);
                doc.getDocumentElement().normalize();
                NodeList nlProperties = XPathAPI.selectNodeList(doc, "/properties");
                NamedNodeMap props = nlProperties.item(0).getAttributes();
                try {
                    p = props.getNamedItem("verifyLength").getNodeValue();
                    this.setVerifyLength(p);
                }
                catch (Exception e) {
                    this.setVerifyLength("true");
                }
                try {
                    p = props.getNamedItem("generateHeader").getNodeValue();
                    if (p != null && !p.isEmpty()) {
                        this.generateHeader = p.equals("onFileCreation") ? 2 : (Boolean.parseBoolean(p) ? 1 : 0);
                    }
                }
                catch (Exception e) {
                    this.generateHeader = 0;
                }
                try {
                    this.headerFieldSeparator = props.getNamedItem("headerFieldSeparator").getNodeValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.lineSeparatorBefore = Boolean.parseBoolean(props.getNamedItem("lineSeparatorBefore").getNodeValue());
                    this.lineSeparatorBeforeIsSet = true;
                }
                catch (Exception e) {
                    this.lineSeparatorBefore = true;
                }
                try {
                    this.lineSeparatorAfter = Boolean.parseBoolean(props.getNamedItem("lineSeparatorAfter").getNodeValue());
                }
                catch (Exception e) {
                    this.lineSeparatorAfter = false;
                }
                if (this.lineSeparatorAfter && this.lineSeparatorBefore) {
                    throw new SQLException(Messages.getString("FileDriverGenericStatement.13"));
                }
            }
            catch (SAXException e) {
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.21"), e);
            }
            catch (FileNotFoundException e) {
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.22"), e);
            }
            catch (IOException e) {
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.23"), e);
            }
            catch (ParserConfigurationException e) {
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.24"), e);
            }
            catch (XPathFactoryConfigurationException e) {
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.25"), e);
            }
            catch (XPathExpressionException e) {
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.26"), e);
            }
        }
    }

    public void setVerifyLength(String verifyLength) {
        this.verifyLength = VerifyLength.valueOf2(verifyLength);
        if (this.verifyLength == null) {
            this.verifyLength = VerifyLength._true;
        }
    }

    protected void generateHeader(MetadataServer.MetadataFileAndEnreg mFileAndEnreg) throws SQLException {
        if (!this.hasgeneratedHeader) {
            this.hasWriteRow = false;
            Object header = "";
            try {
                IMetadataColumn[] metcols = mFileAndEnreg.getMetadataEnreg().getLstColumns();
                header = this.lineSeparatorBeforeStr;
                for (int i = 0; i < metcols.length; ++i) {
                    header = i != metcols.length - 1 ? (String)header + metcols[i].getLabel() + this.headerFieldSeparator : (String)header + metcols[i].getLabel();
                }
                header = (String)header + mFileAndEnreg.getMetadataFile().getLineSeparator();
                this.init(mFileAndEnreg);
                this.write((String)header);
                metcols = null;
                this.hasgeneratedHeader = true;
            }
            catch (FileNotFoundException e) {
                this.connection.log(Messages.getString("FileDriverGenericStatement.14"));
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.15"), e);
            }
            catch (UnsupportedEncodingException e) {
                this.connection.log(Messages.getString("FileDriverGenericStatement.16"));
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.17"), e);
            }
            catch (IOException e) {
                this.connection.log(Messages.getString("FileDriverGenericStatement.18"));
                this.connection.log(FileDriver.getStackTrace(e));
                throw new SQLException(Messages.getString("FileDriverGenericStatement.19"), e);
            }
        }
    }

    public void setHasWriteRow(boolean hasWriteRow) {
        this.hasWriteRow = hasWriteRow;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped statement is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public void setOutputStream(OutputStream os) throws Exception {
        this.os = os;
    }

    protected void closeFile() throws SQLException {
        if (this.writerOutputStreamWriter != null) {
            try {
                if (this.hasWriteRow) {
                    this.write(this.lineSeparatorAfterStr);
                }
                if (this.os != null) {
                    this.connection.closeWriter("$___OutputStream___$");
                } else {
                    this.connection.closeWriter(this.filePath);
                }
                this.writerOutputStreamWriter = null;
            }
            catch (IOException e) {
                throw new SQLException(Messages.getString("FileDriverGenericStatement.20"));
            }
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    static enum VerifyLength {
        _true,
        _false,
        rightTruncation,
        leftTruncation;


        static VerifyLength valueOf2(String name) {
            if (name.equals("true")) {
                return _true;
            }
            if (name.equals("false")) {
                return _false;
            }
            return VerifyLength.valueOf(name);
        }
    }
}

