/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.FileContentColumn;
import com.stambia.jdbc.driver.file.parser.MetadataValueObject;
import com.stambia.jdbc.driver.file.tools.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileDriverPreparedRawStatement
implements PreparedStatement {
    RAW currentRAW = null;
    List<RAW> raws = new ArrayList<RAW>();
    private MetadataServer.MetadataFileAndEnreg mf;
    Map<String, IMetadataColumn> index = new HashMap<String, IMetadataColumn>();
    List<IMetadataColumn> cols;
    private FileDriverConnection connection;
    private MetadataValueObject[] statementLstValues;

    public FileDriverPreparedRawStatement(FileDriverConnection connection, MetadataServer.MetadataFileAndEnreg mf, List<IMetadataColumn> cols, MetadataValueObject[] statementLstValues) throws SQLException {
        this.statementLstValues = statementLstValues;
        this.mf = mf;
        for (IMetadataColumn col : cols) {
            this.index.put(mf.getMetadataFile().getPropertyFieldPrefix() + col.getName(), col);
        }
        this.cols = cols;
        this.connection = connection;
        this.newRAW();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    public void close() throws SQLException {
        for (RAW raw : this.raws) {
            raw.close();
        }
        if (this.currentRAW != null) {
            this.currentRAW.close();
        }
        this.connection = null;
        this.mf = null;
        this.cols.clear();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i = 0;
        int[] ret = new int[this.raws.size()];
        for (RAW raw : this.raws) {
            raw.write();
            ret[i++] = 1;
        }
        this.raws.clear();
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        IMetadataColumn col = this.getColumn(parameterIndex);
        if (col == FileColumn.filePathColumn) {
            this.currentRAW.filePath = x;
        } else if (col == FileColumn.fileParentPathColumn) {
            this.currentRAW.parentPath = x;
        } else if (col == FileContentColumn.StringInstance || col == FileContentColumn.BinaryInstance) {
            this.currentRAW.data = x;
        }
    }

    private IMetadataColumn getColumn(int parameterIndex) {
        return this.cols.get(parameterIndex - 1);
    }

    private IMetadataColumn getColumn(String name) {
        return this.index.get(name);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        IMetadataColumn col = this.getColumn(parameterIndex);
        if (col == FileContentColumn.StringInstance || col == FileContentColumn.BinaryInstance) {
            this.currentRAW.data = x;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.raws.size() == 0) {
            this.addBatch();
            this.executeBatch();
            return true;
        }
        throw new SQLException(Messages.getString("FileDriverPreparedRawStatement.0"));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void addBatch() throws SQLException {
        this.raws.add(this.currentRAW);
        this.newRAW();
    }

    private void newRAW() throws SQLException {
        this.currentRAW = new RAW();
        for (int i = 0; i < this.statementLstValues.length; ++i) {
            MetadataValueObject o = this.statementLstValues[i];
            if (o.getValueType() != 1) continue;
            this.setString(i + 1, o.getValue());
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        IMetadataColumn col = this.getColumn(parameterIndex);
        if ((col == FileContentColumn.StringInstance || col == FileContentColumn.BinaryInstance) && x != null) {
            this.currentRAW.data = x.getBinaryStream();
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        IMetadataColumn col = this.getColumn(parameterIndex);
        if ((col == FileContentColumn.StringInstance || col == FileContentColumn.BinaryInstance) && x != null) {
            this.currentRAW.data = x.getCharacterStream();
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        IMetadataColumn col = this.getColumn(parameterIndex);
        if (col == FileContentColumn.StringInstance || col == FileContentColumn.BinaryInstance) {
            this.currentRAW.data = x;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        IMetadataColumn col = this.getColumn(parameterIndex);
        if (col == FileContentColumn.StringInstance || col == FileContentColumn.BinaryInstance) {
            this.currentRAW.data = reader;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    class RAW {
        Object data;
        File file;
        String parentPath;
        String filePath;

        RAW() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write() throws SQLException {
            block46: {
                try {
                    File file = this.file;
                    File originalFile = new File(FileDriverPreparedRawStatement.this.connection.getFilePath(FileDriverPreparedRawStatement.this.mf.getMetadataFile()));
                    if (file == null) {
                        if (this.filePath != null) {
                            if (this.parentPath != null) {
                                file = new File(this.parentPath.replace("\\", "\\\\"), this.filePath.replace("\\", "\\\\"));
                            } else {
                                file = new File(this.filePath.replace("\\", "\\\\"));
                                if (!file.isAbsolute()) {
                                    file = new File(originalFile.getParentFile(), this.filePath.replace("\\", "\\\\"));
                                }
                            }
                        } else {
                            file = originalFile;
                        }
                    }
                    if (this.data instanceof String) {
                        Writer writer = null;
                        try {
                            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), FileDriverPreparedRawStatement.this.mf.getMetadataFile().getCharsetName());
                            writer.write((String)this.data);
                            break block46;
                        }
                        finally {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (this.data instanceof InputStream) {
                        try {
                            FileOutputStream os = null;
                            try {
                                os = new FileOutputStream(file);
                                Utils.copy((InputStream)this.data, os);
                                break block46;
                            }
                            finally {
                                if (os != null) {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                        finally {
                            ((InputStream)this.data).close();
                        }
                    }
                    if (this.data instanceof Reader) {
                        Writer os = null;
                        try {
                            os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), FileDriverPreparedRawStatement.this.mf.getMetadataFile().getCharsetName());
                            Utils.copy((Reader)this.data, os);
                            break block46;
                        }
                        finally {
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    if (!(this.data instanceof byte[])) break block46;
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(file);
                        ((OutputStream)os).write((byte[])this.data);
                    }
                    finally {
                        if (os != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
        }

        public void close() {
            this.data = null;
        }
    }
}

