/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.FileDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.FileDriverGenericStatement;
import com.stambia.jdbc.driver.file.FileDriverPreparedStatement;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataEnreg;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import com.stambia.jdbc.driver.file.fileMetadata.internal.InternalColumn;
import com.stambia.jdbc.driver.file.parser.MetadataColumnDesc;
import com.stambia.jdbc.driver.file.parser.MetadataColumnVisitor;
import com.stambia.jdbc.driver.file.parser.MetadataFromItemsVisitor;
import com.stambia.jdbc.driver.file.parser.MetadataTableObject;
import com.stambia.jdbc.driver.file.parser.MetadataValueObject;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSet;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetColumn;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetMetaData;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetTable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.truncate.Truncate;

public class FileDriverStatement
extends FileDriverGenericStatement
implements Statement {
    private ResultSet fileResultSet = null;
    private int fetchSize = 100;
    private int maxRows = -1;
    protected int isScrollable = 1004;

    protected FileDriverStatement(FileDriverConnection connection, int isScrollable) {
        this.connection = connection;
        this.isScrollable = isScrollable;
    }

    @Override
    public void setMaxRows(int p0) throws SQLException {
        this.maxRows = p0;
    }

    @Override
    public void setFetchSize(int p0) throws SQLException {
        this.fetchSize = p0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.fileResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return -1;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return -1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.isScrollable;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    private IMetadataColumn searchColumnInMetadata(MetadataServer metServ, String colName, String colAlias, TreeMap<String, FileDriverResultSetTable> lstTables, FileDriverResultSetMetaData resultSetMd) throws SQLException {
        if (colAlias == null && colName == null) {
            this.connection.log(Messages.getString("FileDriverStatement.0"));
            throw new SQLException(Messages.getString("FileDriverStatement.1"));
        }
        AtomicReference<String> localColName = new AtomicReference<String>(colName);
        if (colName.startsWith("\"") && colName.endsWith("\"")) {
            localColName.set(colName.substring(1, colName.length() - 1));
        }
        if (colAlias != null) {
            opt = lstTables.values().stream().filter(t -> t.getTableAlias().equals(colAlias)).map(t -> t.getMetaDataEnreg()).findFirst();
            if (opt.isPresent() && opt.get().getColumn(localColName.get()) != null) {
                return ((MetadataEnreg)opt.get()).getColumn(localColName.get());
            }
        } else {
            opt = resultSetMd.getLstTables().values().stream().map(t -> metServ.getFile(null, t.getTableName())).map(m -> m.getMetadataEnreg().getColumn((String)localColName.get())).filter(m -> m != null).findFirst();
            if (opt.isPresent()) {
                return (IMetadataColumn)opt.get();
            }
        }
        String fileName = resultSetMd.getLstTables().firstKey();
        FileDriverResultSetTable fdrst = resultSetMd.getLstTables().get(fileName);
        MetadataFile metadataFile = fdrst.getMetaDataFile();
        return InternalColumn.getColumn(metadataFile.getPropertyFieldPrefix(), colName);
    }

    private TreeMap<String, IMetadataColumn> getLstColumnsFromSelectExpression(MetadataServer metServ, SelectExpressionItem sel, FileDriverResultSetMetaData resultSetMd) throws SQLException {
        TreeMap<String, FileDriverResultSetTable> lstTables = resultSetMd.getLstTables();
        TreeMap<String, IMetadataColumn> ret = null;
        TreeMap<String, MetadataColumnDesc> lstColumns = null;
        String tabAlias = null;
        String colName = null;
        MetadataColumnDesc mdd = null;
        IMetadataColumn mc = null;
        ret = new TreeMap<String, IMetadataColumn>();
        if (sel.getExpression() instanceof NullValue) {
            mc = new MetadataColumn();
            mc.setType(0);
            ret.put("NULL", mc);
        } else {
            MetadataColumnVisitor metColV = new MetadataColumnVisitor();
            metColV.computeColListFromSelect(sel.getExpression());
            lstColumns = metColV.getLstColumns();
            Iterator<String> it = lstColumns.keySet().iterator();
            while (it.hasNext()) {
                mdd = lstColumns.get(it.next());
                tabAlias = mdd.getColAlias();
                colName = mdd.getColName();
                mc = this.searchColumnInMetadata(metServ, colName, tabAlias, lstTables, resultSetMd);
                if (mc != null) {
                    ret.put(colName, mc);
                    continue;
                }
                this.connection.log(Messages.getString("FileDriverStatement.6") + colName + Messages.getString("FileDriverStatement.7"));
                throw new SQLException(Messages.getString("FileDriverStatement.8") + colName + Messages.getString("FileDriverStatement.9"));
            }
        }
        return ret;
    }

    TreeMap<String, FileDriverResultSetTable> getLstTablesFromSQL(MetadataServer metServ, net.sf.jsqlparser.statement.Statement st) throws SQLException {
        TreeMap<String, FileDriverResultSetTable> tm = null;
        MetadataFromItemsVisitor fromItemsVisitor = new MetadataFromItemsVisitor();
        Select selectSt = (Select)st;
        ArrayList<MetadataTableObject> l = fromItemsVisitor.getTableList(selectSt);
        Iterator<MetadataTableObject> itF = l.iterator();
        if (itF != null) {
            if (l.size() > 1) {
                this.connection.log(Messages.getString("FileDriverStatement.10"));
                throw new SQLException(Messages.getString("FileDriverStatement.11"));
            }
            tm = new TreeMap<String, FileDriverResultSetTable>();
            while (itF.hasNext()) {
                MetadataTableObject mfo = itF.next();
                MetadataServer.MetadataFileAndEnreg metFileAndEnreg = metServ.getFile(null, mfo.getTableName());
                MetadataFile metFile = metFileAndEnreg.getMetadataFile();
                if (metFile == null) {
                    this.connection.log(Messages.getString("FileDriverStatement.12") + mfo.getTableName());
                    throw new SQLException(Messages.getString("FileDriverStatement.13") + mfo.getTableName());
                }
                FileDriverResultSetTable fdrs = new FileDriverResultSetTable(metFile, metFileAndEnreg.getMetadataEnreg());
                fdrs.setSourceId(metFile.getId());
                fdrs.setTableAlias(mfo.getAliasName());
                fdrs.setTableName(mfo.getTableName());
                tm.put(metFile.getId(), fdrs);
            }
        }
        return tm;
    }

    private FileDriverResultSetColumn[] verifySQLWithMetadata(MetadataServer metServ, net.sf.jsqlparser.statement.Statement st, FileDriverResultSetMetaData resultSetMd) throws SQLException {
        FileDriverResultSetColumn[] ret = null;
        TreeMap<String, FileDriverResultSetTable> lstTables = resultSetMd.getLstTables();
        IMetadataColumn mc = null;
        PlainSelect plainSelect = (PlainSelect)((Select)st).getSelectBody();
        int nbWhereColumns = 0;
        boolean allColumns = plainSelect.getSelectItems().size() == 1 && PlainSelect.getStringList((List)plainSelect.getSelectItems()).equals("*");
        int lenLstCols = allColumns ? lstTables.firstEntry().getValue().getMetaDataEnreg().getLstColumns().length : plainSelect.getSelectItems().size() + nbWhereColumns;
        ret = new FileDriverResultSetColumn[lenLstCols];
        if (!allColumns) {
            String alias = null;
            Expression exp = null;
            Iterator it = plainSelect.getSelectItems().iterator();
            int i = 0;
            while (it.hasNext()) {
                String columnName;
                SelectExpressionItem sel = (SelectExpressionItem)it.next();
                TreeMap<String, IMetadataColumn> lstColsAdd = this.getLstColumnsFromSelectExpression(metServ, sel, resultSetMd);
                FileDriverResultSetColumn col = new FileDriverResultSetColumn();
                col.setFather(resultSetMd);
                if (lstColsAdd.size() > 1) {
                    this.connection.log(Messages.getString("FileDriverStatement.14"));
                    throw new SQLException(Messages.getString("FileDriverStatement.15"));
                }
                exp = sel.getExpression();
                alias = sel.getAlias() != null ? sel.getAlias() : null;
                if (alias != null) {
                    col.setName(alias);
                    col.setLabel(alias);
                }
                col.setSqlType(0);
                col.setColNum(i);
                col.setExpression(exp.toString());
                if (!(exp instanceof NullValue)) {
                    Column colObj = (Column)sel.getExpression();
                    columnName = colObj.getColumnName();
                    String columnAlias = colObj.getTable().getName();
                    mc = this.searchColumnInMetadata(metServ, columnName, columnAlias, lstTables, resultSetMd);
                    col.setPrecision(mc.getPrecision());
                    col.setScale(mc.getScale());
                    col.setDisplaySize(mc.getDisplaySize());
                    col.setType(mc.getType());
                    col.setClassName(mc.getClassName());
                } else {
                    columnName = "NULL";
                    col.setType(0);
                }
                if (alias == null) {
                    col.setName(columnName);
                    col.setLabel(columnName);
                }
                col.setLstExpressionColumns(lstColsAdd);
                ret[i] = col;
                ++i;
            }
        } else {
            IMetadataColumn[] lstCols = lstTables.firstEntry().getValue().getMetaDataEnreg().getLstColumns();
            for (int i = 0; i < lstCols.length; ++i) {
                mc = lstCols[i];
                FileDriverResultSetColumn col = new FileDriverResultSetColumn();
                col.setName(mc.getName());
                col.setLabel(mc.getLabel());
                col.setFather(resultSetMd);
                col.setExpression(mc.getName());
                col.setPrecision(mc.getPrecision());
                col.setScale(mc.getScale());
                col.setDisplaySize(mc.getDisplaySize());
                col.setType(mc.getType());
                col.setColNum(i);
                col.setClassName(mc.getClassName());
                col.setSqlType(0);
                TreeMap<String, IMetadataColumn> lstColsAdd = new TreeMap<String, IMetadataColumn>();
                lstColsAdd.put(mc.getName(), mc);
                col.setLstExpressionColumns(lstColsAdd);
                ret[i] = col;
            }
        }
        return ret;
    }

    public void setMetadata(String metadata) throws UnsupportedEncodingException, SQLException {
        this.connection.setMetadata(metadata);
    }

    private String parseSQLForMetadata(String sql) throws SQLException {
        String newSQL = sql;
        String xmlPart = null;
        try {
            xmlPart = FileDriverPreparedStatement.getXmlPart(sql);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (xmlPart != null) {
            newSQL = sql.replaceFirst(FileDriverPreparedStatement.xmlDefPattern, "");
            this.connection.log("FileDriverStatement::parseSQLForMetadata, XML=" + xmlPart);
            this.statementMetadataServer = this.connection.getMetadataFromXml(xmlPart);
        } else if (this.connection.hasMedatada()) {
            this.statementMetadataServer = this.connection.getMetadataServer();
        } else {
            this.connection.log(Messages.getString("FileDriverStatement.16"));
            throw new SQLException(Messages.getString("FileDriverStatement.17"));
        }
        return newSQL;
    }

    private int executeStatement(String query) throws SQLException {
        int ret;
        block5: {
            ret = 0;
            String sql = this.parseSQLForMetadata(query);
            this.connection.log("FileDriverStatement::executeStatement, SQL=" + sql);
            CCJSqlParserManager parserManager = new CCJSqlParserManager();
            try {
                net.sf.jsqlparser.statement.Statement st = parserManager.parse((Reader)new StringReader(sql));
                if (st instanceof Select) {
                    this.executeSelect(sql);
                    break block5;
                }
                if (st instanceof Truncate) {
                    this.executeTruncate(sql);
                    break block5;
                }
                if (st instanceof Insert) {
                    PreparedStatement ps = this.connection.prepareStatement(query);
                    ps.executeUpdate();
                    ps.close();
                    break block5;
                }
                this.connection.log(Messages.getString("FileDriverStatement.18"));
                throw new SQLException(Messages.getString("FileDriverStatement.19"));
            }
            catch (JSQLParserException e) {
                this.connection.log(Messages.getString("FileDriverStatement.20") + sql);
                this.connection.log(FileDriver.getStackTrace((Exception)((Object)e)));
                throw new SQLException(Messages.getString("FileDriverStatement.21") + sql, e);
            }
        }
        return ret;
    }

    protected void constructCurrentRow() {
        for (int i = 0; i < this.statementLstValues.length; ++i) {
            MetadataValueObject o = this.statementLstValues[i];
            if (o.getValueType() != 1) continue;
            this.currentRow[i] = o.getValue();
        }
    }

    private void executeTruncate(String sql) throws SQLException {
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        String fileStr = null;
        try {
            net.sf.jsqlparser.statement.Statement st = parserManager.parse((Reader)new StringReader(sql));
            if (st instanceof Truncate) {
                MetadataServer.MetadataFileAndEnreg mFileAndEnreg = FileDriverStatement.getMetadataFileFromSQL(st, "Truncate", this.statementMetadataServer);
                MetadataFile mFile = mFileAndEnreg.getMetadataFile();
                if (mFile.getType() == 0) {
                    this.headerFieldSeparator = mFile.getFieldSeparator();
                }
                this.findOptionsInSQL(sql);
                fileStr = mFile.getFather().getPath() + File.separator + mFile.getPhysicalName();
                File f = new File(fileStr);
                Files.delete(f.toPath());
                if (this.generateHeader > 0) {
                    this.generateHeader(mFileAndEnreg);
                    this.closeFile();
                }
            }
        }
        catch (SecurityException e) {
            this.connection.log(Messages.getString("FileDriverStatement.22") + fileStr);
            this.connection.log(FileDriver.getStackTrace(e));
            throw new SQLException(Messages.getString("FileDriverStatement.23") + fileStr, e);
        }
        catch (IOException | JSQLParserException e) {
            this.connection.log(Messages.getString("FileDriverStatement.24") + sql);
            this.connection.log(FileDriver.getStackTrace((Exception)e));
            throw new SQLException(Messages.getString("FileDriverStatement.25") + sql, e);
        }
        this.fileResultSet = null;
    }

    private void executeSelect(String sql) throws SQLException {
        FileDriverResultSet resultSet = null;
        FileDriverResultSetMetaData resultSetMd = new FileDriverResultSetMetaData();
        TreeMap<String, FileDriverResultSetTable> lstTables = null;
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        try {
            net.sf.jsqlparser.statement.Statement st = parserManager.parse((Reader)new StringReader(sql));
            if (!(st instanceof Select)) {
                this.connection.log(Messages.getString("FileDriverStatement.26"));
                throw new SQLException(Messages.getString("FileDriverStatement.27"));
            }
            lstTables = this.getLstTablesFromSQL(this.statementMetadataServer, st);
            resultSetMd.setLstTables(lstTables);
            resultSetMd.setColumns(this.verifySQLWithMetadata(this.statementMetadataServer, st, resultSetMd));
        }
        catch (JSQLParserException e) {
            this.connection.log(Messages.getString("FileDriverStatement.28") + sql);
            this.connection.log(FileDriver.getStackTrace((Exception)((Object)e)));
            throw new SQLException(Messages.getString("FileDriverStatement.29") + sql, e);
        }
        String fileName = resultSetMd.getLstTables().firstKey();
        FileDriverResultSetTable fdrst = resultSetMd.getLstTables().get(fileName);
        MetadataFile metadataFile = fdrst.getMetaDataFile();
        List<File> list = this.listFile(metadataFile.getFather().getPath() + File.separator + metadataFile.getPhysicalName());
        String v = ((FileDriverConnection)this.getConnection()).getFileReaderVersion();
        int fileReaderVersion = 1;
        if ("2".equals(v)) {
            fileReaderVersion = 2;
        }
        if (list.isEmpty()) {
            resultSet = new FileDriverResultSet(this, resultSetMd, new File(metadataFile.getFather().getPath() + File.separator + metadataFile.getPhysicalName()));
        } else if (list.size() == 1) {
            resultSet = new FileDriverResultSet(this, resultSetMd, list.get(0));
        } else {
            resultSet = new FileDriverResultSet(this, resultSetMd, null);
            resultSet.setFiles(list);
        }
        resultSet.setReadLineModeVersion(fileReaderVersion);
        this.connection.log(Messages.getString("FileDriverStatement.30"));
        this.fileResultSet = resultSet;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeStatement(sql);
        return this.fileResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int ret = 0;
        this.executeStatement(sql);
        return ret;
    }

    @Override
    public void close() {
        try {
            if (this.statementMetadataServer != null) {
                this.statementMetadataServer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fileResultSet != null) {
                    this.fileResultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean ret = false;
        this.executeStatement(sql);
        if (this.fileResultSet != null) {
            ret = true;
        }
        return ret;
    }

    protected List<File> listFile(String filePath) {
        boolean isFileSystemCaseSensitive;
        String exp;
        ArrayList<File> ret = new ArrayList<File>();
        File file = new File(filePath);
        File parent = (file = file.getAbsoluteFile()).getParentFile();
        File[] folderFiles = parent.listFiles(new FileFilter(){
            final String includeRegexp;
            final /* synthetic */ String val$exp;
            final /* synthetic */ boolean val$isFileSystemCaseSensitive;
            {
                this.val$exp = string;
                this.val$isFileSystemCaseSensitive = bl;
                this.includeRegexp = FileDriverStatement.replaceWildCharsWithGroups(this.val$exp);
            }

            @Override
            public boolean accept(File pathname) {
                if (this.val$isFileSystemCaseSensitive) {
                    return pathname.getName().matches(this.includeRegexp);
                }
                return pathname.getName().toLowerCase().matches(this.includeRegexp.toLowerCase());
            }
        });
        if (folderFiles != null) {
            for (File _file : folderFiles) {
                if (!_file.isFile()) continue;
                ret.add(_file);
            }
        }
        return ret;
    }

    private static String replaceWildCharsWithGroups(String wild) {
        StringBuilder buffer = new StringBuilder();
        char[] chars = wild.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '*') {
                buffer.append("(.*)");
                continue;
            }
            if (chars[i] == '?') {
                buffer.append("(.)");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
                continue;
            }
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }
}

