/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileManagment;

import com.indy.engine.common.scripting.StbScriptEngineManager;
import com.stambia.jdbc.driver.file.fileManagment.ScriptingPipedInputStream;
import com.stambia.jdbc.driver.file.tools.BinaryNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformInputStreamWithScript {
    private static final Logger LOGGER = LogManager.getLogger(TransformInputStreamWithScript.class);

    private TransformInputStreamWithScript() {
    }

    public static InputStream transform(InputStream is, String script, String language) throws IOException {
        StbScriptEngineManager scriptEngineManager = new StbScriptEngineManager(TransformInputStreamWithScript.class.getClassLoader());
        language = language == null ? "rhino" : language;
        ScriptEngine scriptEngine = ((ScriptEngineManager)scriptEngineManager).getEngineByName(language);
        Bindings bindings = scriptEngine.getBindings(100);
        ScriptingPipedInputStream in = new ScriptingPipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        Thread t = new Thread(() -> {
            try {
                bindings.put("__in__", (Object)is);
                bindings.put("__out__", (Object)out);
                Api api = new Api();
                bindings.put("__api__", (Object)api);
                scriptEngine.eval(script);
            }
            catch (ScriptException e) {
                in.scriptingException = e;
            }
            finally {
                try {
                    is.close();
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.warn("unexpected", (Throwable)e);
                }
            }
        });
        t.start();
        return in;
    }

    public static class Api {
        public String leftPad(String s, int length, String pad) {
            return this.pad(s, length, pad, true);
        }

        public String rightPad(String s, int length, String pad) {
            return this.pad(s, length, pad, false);
        }

        private String pad(String s, int length, String pad, boolean leftPad) {
            while (((String)s).length() < length) {
                if (leftPad) {
                    s = pad + (String)s;
                    continue;
                }
                s = (String)s + pad;
            }
            if (((String)s).length() > length) {
                if (leftPad) {
                    return ((String)s).substring(((String)s).length() - length);
                }
                return ((String)s).substring(0, length);
            }
            return s;
        }

        public long parseFixedBinary(String str, boolean signed, ByteOrder order, String encoding) {
            byte[] result = encoding != null ? str.getBytes(Charset.forName(encoding)) : str.getBytes();
            return BinaryNumber.getLong(result, signed, order);
        }

        public long parseFixedBinary(byte[] b, boolean signed, ByteOrder order) {
            return BinaryNumber.getLong(b, signed, order);
        }

        public long parseFixedBinary(int[] b, boolean signed, ByteOrder order) {
            byte[] b2 = new byte[b.length];
            for (int i = 0; i < b.length; ++i) {
                b2[i] = (byte)b[i];
            }
            return BinaryNumber.getLong(b2, signed, order);
        }
    }
}

