/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata;

import com.stambia.jdbc.driver.file.fileMetadata.MetadataDirectory;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataEnreg;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;

public class MetadataServer {
    public static final int FILE_TYPE_DELIMITED = 0;
    public static final int FILE_TYPE_POSITIONAL = 1;
    public static final String FILE_TYPE_STR_DELIMITED = "DELIMITED";
    public static final String FILE_TYPE_STR_POSITIONAL = "POSITIONAL";
    public static final String TYPE_STRING_STR = "String";
    public static final String TYPE_NUMERIC_STR = "Numeric";
    public static final String TYPE_DATE_STR = "Date";
    public static final String TYPE_TIMESTAMP_STR = "Timestamp";
    public static final String DEFAULT_STRING_DELIMITER = "\"";
    public static final String DEFAULT_DECIMAL_SEPARATOR = ".";
    public static final String DEFAULT_FIELD_SEPARATOR = ",";
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    public static String DEFAULT_STRING_PADDING_CHAR = " ";
    public static String DEFAULT_NUMERIC_PADDING_CHAR = " ";
    public static String DEFAULT_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    public static String DEFAULT_TIMESTAMP_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    public static String DEFAULT_NUMERIC_GROUPING_CHAR = "";
    public static String DEFAULT_NUMERIC_SEPARATOR = ".";
    String serverName;
    String driverURL;
    String driverClass;
    Properties[] driverProperties;
    MetadataDirectory[] lstDirectories;
    String id;
    public static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDriverURL() {
        return this.driverURL;
    }

    public void setDriverURL(String driverURL) {
        this.driverURL = driverURL;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public Properties[] getDriverProperties() {
        return this.driverProperties;
    }

    public void setDriverProperties(Properties[] driverProperties) {
        this.driverProperties = driverProperties;
    }

    public MetadataDirectory[] getLstDirectories() {
        return this.lstDirectories;
    }

    public void setLstDirectories(MetadataDirectory[] lstDirectories) {
        this.lstDirectories = lstDirectories;
    }

    public static String arrayByteToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] hexStringToArrayByte(String hexStr) {
        return DatatypeConverter.parseHexBinary((String)hexStr);
    }

    public static String hexStringToString(String hexStr) throws UnsupportedEncodingException {
        return new String(MetadataServer.hexStringToArrayByte(hexStr), StandardCharsets.UTF_8.toString());
    }

    public MetadataFileAndEnreg getFile(String directoryName, String fileName) {
        MetadataFileAndEnreg ret = new MetadataFileAndEnreg();
        if (this.lstDirectories != null) {
            for (int i = 0; i < this.lstDirectories.length; ++i) {
                MetadataDirectory dir = this.lstDirectories[i];
                if (directoryName != null && !dir.pathName.equals(directoryName) || dir.getLstFiles() == null) continue;
                for (int j = 0; j < dir.getLstFiles().length; ++j) {
                    MetadataFile file = dir.getLstFiles()[j];
                    if (file == null) continue;
                    MetadataEnreg enreg = file.findEnregByLogicalName(fileName);
                    if (enreg != null) {
                        ret.metadataEnreg = enreg;
                        ret.metadataFile = file;
                        return ret;
                    }
                    if (!file.getLogicalName().equals(fileName) && !file.getPhysicalName().equals(fileName)) continue;
                    ret.metadataEnreg = file;
                    ret.metadataFile = file;
                    return ret;
                }
            }
        }
        return ret;
    }

    public void close() {
        for (MetadataDirectory md : this.lstDirectories) {
            md.close();
        }
    }

    public class MetadataFileAndEnreg {
        MetadataFile metadataFile;
        MetadataEnreg metadataEnreg;

        public MetadataFile getMetadataFile() {
            return this.metadataFile;
        }

        public MetadataEnreg getMetadataEnreg() {
            return this.metadataEnreg;
        }
    }
}

