/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.resultset;

import com.stambia.jdbc.driver.file.FileDriverStatement;
import com.stambia.jdbc.driver.file.fileManagment.IInputStreamSet;
import com.stambia.jdbc.driver.file.fileManagment.ILineContext;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.IStambiaReader;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilterSet;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileDriverMultiResultSet
implements AutoCloseable {
    Statement st;
    StambiaReader stambiaReader = new StambiaReader();
    Map<String, ResultSet> resultSets = new HashMap<String, ResultSet>();
    IInputStreamSet input;
    IInputStreamSet stambiaInput = new StambiaInput();
    IReadContext context;
    String currentLine;
    long num;
    Map<String, IResultSetHandler> handlers = new HashMap<String, IResultSetHandler>();
    Map<String, StambiaReader> readers = new HashMap<String, StambiaReader>();

    public FileDriverStatement getFileDriverStatement() throws SQLException {
        return this.st.unwrap(FileDriverStatement.class);
    }

    public FileDriverMultiResultSet(Statement st) {
        this.st = st;
        Date dte = null;
        try {
            dte = new SimpleDateFormat("yyyyMMdd").parse("20120201");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.num = dte != null ? System.currentTimeMillis() - dte.getTime() : System.currentTimeMillis();
    }

    public String addQuery(String query, IResultSetHandler handler) throws SQLException {
        ResultSet rs = this.st.executeQuery(query);
        FileDriverResultSet rs2 = rs.unwrap(FileDriverResultSet.class);
        if (this.input == null) {
            this.input = rs2.getInput();
        }
        rs2.setMultiSource(true);
        ResultSetMetaData rsm = rs.getMetaData();
        String tableName = rsm.getTableName(1);
        this.resultSets.put(tableName, rs);
        try {
            rs2.setReader(this.stambiaInput);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        if (handler != null) {
            this.handlers.put(tableName, handler);
        }
        return tableName;
    }

    synchronized long incr() {
        return ++this.num;
    }

    public boolean next() throws IOException, SQLException {
        if (this.input.isNotStart()) {
            this.input.next();
        }
        this.currentLine = this.input.getReader().readLine();
        while (this.currentLine == null && this.input.hasNext()) {
            this.input.next();
            this.currentLine = this.input.getReader().readLine();
        }
        MetadataFilterSet set = this.input.getReader().getCurrentSet();
        if (set != null) {
            IResultSetHandler handler;
            boolean b;
            String name = set.getName();
            ResultSet rs = this.resultSets.get(name);
            this.stambiaReader.setCurrentLine(this.currentLine);
            if (rs != null && (b = rs.next()) && (handler = this.handlers.get(name)) != null) {
                handler.handleResultSet(name, rs);
            }
        }
        return this.currentLine != null;
    }

    @Override
    public void close() throws SQLException, IOException {
        if (this.input != null) {
            this.input.close();
        }
    }

    class StambiaReader
    implements IStambiaReader {
        String currentLine;

        StambiaReader() {
        }

        public void setCurrentLine(String currentLine) {
            this.currentLine = currentLine;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String readLine() throws IOException {
            return this.currentLine;
        }

        @Override
        public void setMonoSourceName(String name) {
        }

        @Override
        public ILineContext getAncestorContext(int ancestorLevel) throws IOException {
            return FileDriverMultiResultSet.this.input.getReader().getAncestorContext(ancestorLevel);
        }

        @Override
        public String getEncoding() throws IOException {
            return FileDriverMultiResultSet.this.input.getReader().getEncoding();
        }

        @Override
        public int getCurrentLinePosition() throws IOException {
            return FileDriverMultiResultSet.this.input.getReader().getCurrentLinePosition();
        }

        @Override
        public MetadataFilterSet getCurrentSet() throws IOException {
            return FileDriverMultiResultSet.this.input.getReader().getCurrentSet();
        }
    }

    class StambiaInput
    implements IInputStreamSet {
        StambiaInput() {
        }

        @Override
        public File getFile() throws IOException {
            return FileDriverMultiResultSet.this.input.getFile();
        }

        @Override
        public int getStreamPosition() throws IOException {
            return FileDriverMultiResultSet.this.input.getStreamPosition();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return FileDriverMultiResultSet.this.input.getInputStream();
        }

        @Override
        public boolean next() throws IOException {
            return FileDriverMultiResultSet.this.input.next();
        }

        @Override
        public boolean hasNext() throws IOException {
            return FileDriverMultiResultSet.this.input.hasNext();
        }

        @Override
        public boolean isNotStart() throws IOException {
            return FileDriverMultiResultSet.this.input.isNotStart();
        }

        @Override
        public IStambiaReader getReader() throws IOException {
            return FileDriverMultiResultSet.this.stambiaReader;
        }

        @Override
        public IReadContext getContext() throws IOException {
            return FileDriverMultiResultSet.this.input.getContext();
        }

        @Override
        public void close() throws IOException {
            FileDriverMultiResultSet.this.input.close();
        }
    }

    public static interface IResultSetHandler {
        public void handleResultSet(String var1, ResultSet var2) throws SQLException;
    }

    public class ResultSetContainer {
        private String name;
        public long num;
        FileDriverResultSet resultSet;
        ResultSetContainer parent;

        public ResultSetContainer(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getNum() {
            return this.num;
        }

        public FileDriverResultSet getResultSet() {
            return this.resultSet;
        }

        public ResultSetContainer getParent() {
            return this.parent;
        }
    }
}

