/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.resultset;

import com.stambia.jdbc.driver.file.resultset.AbstractResultSetMetaData;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetColumn;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetTable;
import com.stambia.jdbc.driver.file.resultset.Messages;
import java.sql.SQLException;
import java.util.TreeMap;

public class FileDriverResultSetMetaData
extends AbstractResultSetMetaData {
    TreeMap<String, FileDriverResultSetTable> lstTables = null;
    FileDriverResultSetColumn[] columns;

    public int getColumnId(String name) throws SQLException {
        int ret = -1;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!name.equals(this.columns[i].getName())) continue;
            return i + 1;
        }
        if (ret == -1) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.0") + name + Messages.getString("FileDriverResultSetMetaData.1"));
        }
        return ret;
    }

    public FileDriverResultSetColumn[] getColumns() {
        return this.columns;
    }

    public void setColumns(FileDriverResultSetColumn[] columns) {
        this.columns = columns;
    }

    public TreeMap<String, FileDriverResultSetTable> getLstTables() {
        return this.lstTables;
    }

    public void setLstTables(TreeMap<String, FileDriverResultSetTable> lstTables) {
        this.lstTables = lstTables;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            FileDriverResultSetColumn fdrsc = this.columns[column - 1];
            return fdrsc.getLabel();
        }
        catch (NullPointerException e) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.3"));
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            FileDriverResultSetColumn fdrsc = this.columns[column - 1];
            return fdrsc.getName();
        }
        catch (NullPointerException e) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.4"));
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        try {
            FileDriverResultSetColumn fdrsc = this.columns[column - 1];
            return fdrsc.getPrecision();
        }
        catch (NullPointerException e) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.6"));
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        try {
            FileDriverResultSetColumn fdrsc = this.columns[column - 1];
            return fdrsc.getScale();
        }
        catch (NullPointerException e) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.7"));
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.lstTables != null) {
            FileDriverResultSetTable fdrst = this.lstTables.get(this.lstTables.firstKey());
            return fdrst.getTableName();
        }
        throw new SQLException(Messages.getString("FileDriverResultSetMetaData.8"));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            FileDriverResultSetColumn fdrsc = this.columns[column - 1];
            return fdrsc.getType();
        }
        catch (NullPointerException e) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.9"));
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            FileDriverResultSetColumn fdrsc = this.columns[column - 1];
            return fdrsc.getTypeName();
        }
        catch (NullPointerException e) {
            throw new SQLException(Messages.getString("FileDriverResultSetMetaData.10"));
        }
    }
}

