/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.resultset;

import com.stambia.jdbc.driver.file.fileManagment.IInputStreamSet;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.IStambiaReader;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

class MultiFileInputStreamSet
implements IInputStreamSet {
    int position = 0;
    IStambiaReader isr;
    IReadContext context;
    InputStream current;
    boolean start = false;
    List<File> files;
    FileDriverResultSet resultSet;

    MultiFileInputStreamSet(List<File> files, FileDriverResultSet resultSet) {
        this.files = files;
        this.resultSet = resultSet;
    }

    @Override
    public boolean next() throws IOException {
        if (this.files.size() == this.position) {
            return false;
        }
        if (this.files.size() > this.position) {
            this.start = true;
            ++this.position;
            if (this.isr != null) {
                this.isr.close();
                this.isr = null;
            }
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public IStambiaReader getReader() throws IOException {
        if (this.position == 0) {
            throw new IOException();
        }
        if (this.isr == null) {
            this.isr = FileDriverResultSet.initBufferReader(this.resultSet.metadataFile, this.getInputStream(), this.resultSet.readerBufferSize, this.resultSet.readLineModeVersion);
            this.context = (IReadContext)((Object)this.isr);
            if (!this.resultSet.multiSource) {
                this.isr.setMonoSourceName(this.resultSet.metadataEnreg.getLogicalName());
            }
        }
        return this.isr;
    }

    @Override
    public int getStreamPosition() {
        return this.position;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.current == null) {
            this.current = new FileInputStream(this.getFile());
        }
        return this.current;
    }

    @Override
    public File getFile() {
        return this.files.get(this.position - 1);
    }

    @Override
    public void close() throws IOException {
        if (this.isr != null) {
            this.isr.close();
        } else if (this.current != null) {
            this.current.close();
            this.current = null;
        }
    }

    @Override
    public IReadContext getContext() throws IOException {
        return this.context;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.files.size() > this.position;
    }

    @Override
    public boolean isNotStart() throws IOException {
        return !this.start;
    }
}

