/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.tools;

import com.stambia.jdbc.driver.file.tools.PackedDecimal;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class BinaryNumber {
    public static long getLongBak(byte[] in, boolean signed, ByteOrder order) throws Exception {
        int bufferSize = 0;
        long maxByte = 256L;
        long maxSigned = 0L;
        switch (in.length) {
            case 1: 
            case 2: {
                bufferSize = 2;
                maxSigned = maxByte * maxByte;
                break;
            }
            case 3: 
            case 4: {
                maxSigned = maxByte * maxByte * maxByte * maxByte;
                bufferSize = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                maxSigned = 0L;
                if (!signed) {
                    throw new Exception("Unsigned numbers is not supported for buffers of more than 4 bytes");
                }
                bufferSize = 8;
                break;
            }
            default: {
                throw new Exception("Input buffer too large");
            }
        }
        ByteBuffer _bb = ByteBuffer.allocate(bufferSize);
        int delta = bufferSize - in.length;
        if (order != null) {
            _bb.order(order);
        }
        for (int i = 0; i < bufferSize; ++i) {
            if (i < delta) {
                _bb.put((byte)0);
                continue;
            }
            _bb.put(in[i - delta]);
        }
        long tmp = 0L;
        switch (bufferSize) {
            case 2: {
                tmp = _bb.getShort(0);
                break;
            }
            case 4: {
                tmp = _bb.getInt(0);
                break;
            }
            case 8: {
                tmp = _bb.getLong(0);
            }
        }
        long ret = tmp;
        if (!signed) {
            ret = tmp < 0L ? maxSigned + tmp : tmp;
        }
        return ret;
    }

    public static long getLong(byte[] in, boolean signed, ByteOrder order) {
        ByteBuffer _bb = ByteBuffer.allocate(8);
        if (order != null) {
            _bb.order(order);
        }
        int delta = 8 - in.length;
        for (int i = 0; i < 8; ++i) {
            if (i < delta) {
                _bb.put((byte)0);
                continue;
            }
            if (signed) {
                _bb.put(in[i - delta]);
                continue;
            }
            _bb.put((byte)(in[i - delta] & 0xFF));
        }
        long ret = _bb.getLong(0);
        return ret;
    }

    public static long getPackedLong(byte[] in, boolean signed) throws Exception {
        return PackedDecimal.parse(in);
    }

    public static BigDecimal getBigDecimal(byte[] in, boolean signed, ByteOrder order, int precision, boolean packed) throws Exception {
        long l = packed ? BinaryNumber.getPackedLong(in, signed) : BinaryNumber.getLong(in, signed, order);
        Object str = String.valueOf(l);
        if (((String)str).length() <= precision) {
            int offset = precision - ((String)str).length() + 1;
            for (int i = 0; i < offset; ++i) {
                str = "0" + (String)str;
            }
        }
        char[] lc = ((String)str).toCharArray();
        char[] rer = new char[lc.length + (precision > 0 || lc.length == 1 ? 1 : 0)];
        int i = 0;
        for (char c : lc) {
            rer[i++] = c;
            if (lc.length - i != precision) continue;
            rer[i++] = 46;
        }
        return new BigDecimal(rer);
    }

    public static byte getByte(byte in, Charset charset) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[]{0, in});
        ByteBuffer bb2 = charset.encode(bb.asCharBuffer());
        return bb2.get();
    }
}

