/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.tools;

public class PackedDecimal {
    static final int PlusSign = 12;
    static final int MinusSign = 13;
    static final int NoSign = 15;
    static final int DropHO = 255;
    static final int GetLONibble = 15;

    public static long parse(byte[] pdIn) throws Exception {
        long val = 0L;
        for (int i = 0; i < pdIn.length; ++i) {
            int digit;
            int aByte = pdIn[i] & 0xFF;
            if (i == pdIn.length - 1) {
                digit = aByte >> 4;
                val = val * 10L + (long)digit;
                int sign = aByte & 0xF;
                if (sign == 13) {
                    val = -val;
                    continue;
                }
                if (sign == 12 || sign == 15) continue;
                throw new Exception("OC7");
            }
            digit = aByte >> 4;
            val = val * 10L + (long)digit;
            digit = aByte & 0xF;
            val = val * 10L + (long)digit;
        }
        return val;
    }

    public static byte[] pack(String nbrs) throws Exception {
        int digit = 12;
        int startAt = 0;
        if (nbrs.startsWith("+") || nbrs.startsWith("-")) {
            digit = nbrs.startsWith("+") ? 12 : 13;
            startAt = 1;
        }
        byte[] chars = nbrs.getBytes();
        byte[] packed = new byte[(nbrs.length() - startAt) / 2 + 1];
        int inIdx = chars.length - 1;
        int outIdx = packed.length - 1;
        int temp = (chars[inIdx--] & 0xF) << 4;
        packed[outIdx--] = (byte)((digit |= temp) & 0xFF);
        while (outIdx >= 0 && inIdx >= 0) {
            if (chars[inIdx] < 48 || chars[inIdx] > 57) {
                throw new Exception("Not numberic data: " + nbrs + " at " + inIdx);
            }
            digit = chars[inIdx--] & 0xF;
            if (inIdx >= 0) {
                temp = (chars[inIdx--] & 0xF) << 4;
                digit |= temp;
            }
            packed[outIdx] = (byte)digit;
            --outIdx;
        }
        return packed;
    }

    static String bytesToHex(byte[] buf) {
        String HexChars = "0123456789ABCDEF";
        StringBuffer sb = new StringBuffer(buf.length / 2 * 5 + 3);
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            b = (byte)(b >> 4);
            b = (byte)(b & 0xF);
            sb.append("0123456789ABCDEF".charAt(b));
            b = buf[i];
            b = (byte)(b & 0xF);
            sb.append("0123456789ABCDEF".charAt(b));
            if (i % 2 != 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String nbr1 = "-12345";
        byte[] packed = PackedDecimal.pack(nbr1);
        System.out.println("packed=" + PackedDecimal.bytesToHex(packed));
        System.out.println(PackedDecimal.parse(packed));
        byte[] bs = new byte[]{2, 58, 0, 0, 2, 54, 0, 0};
        System.out.println(PackedDecimal.parse(bs));
    }
}

