/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.tools;

public class PackedDecimal2 {
    static final int MinusSignMask = 9;
    static final int PlusSign1 = 10;
    static final int PlusSignPreferred = 12;
    static final int PlusSign2 = 14;
    static final int MinusSign1 = 11;
    static final int MinusSignPreferred = 13;
    static final int UnsignedMask = 15;
    static final int LastDigitMask = 15;

    public static long parse(byte[] pRawPackedDecimal) throws Exception {
        long ret = 0L;
        for (int i = 0; i < pRawPackedDecimal.length; ++i) {
            byte curByte = pRawPackedDecimal[i];
            int digit = curByte >> 4;
            ret = ret * 10L + (long)digit;
            if (i == pRawPackedDecimal.length - 1) {
                int sign = curByte & 0xF;
                if (sign == 15) continue;
                if ((sign & 9) == 9) {
                    if ((sign & 0xD) == 13 || (sign & 0xB) == 11) {
                        ret = -ret;
                        continue;
                    }
                    throw new Exception("Negative sign is malformated: " + PackedDecimal2.bytesToHex(pRawPackedDecimal));
                }
                if ((sign & 0xC) == 12 || (sign & 0xA) == 10 || (sign & 0xE) == 14) continue;
                throw new Exception("Positive sign is malformated: " + PackedDecimal2.bytesToHex(pRawPackedDecimal));
            }
            digit = curByte & 0xF;
            ret = ret * 10L + (long)digit;
        }
        return ret;
    }

    public static byte[] pack(long pInputNumber, int pMaxDigits, boolean pIsUnsigned) {
        byte[] ret = new byte[1 + pMaxDigits / 2];
        byte curDigit = 0;
        int curOffset = 1;
        boolean highBitsNotFilled = true;
        ret[ret.length - 1] = pIsUnsigned ? 15 : (pInputNumber > 0L ? 12 : 13);
        for (long numberToPack = Math.abs(pInputNumber); numberToPack > 0L; numberToPack /= 10L) {
            curDigit = (byte)(numberToPack % 10L);
            if (highBitsNotFilled) {
                curDigit = (byte)(curDigit << 4);
                curDigit = (byte)(curDigit & 0xF0);
                ret[ret.length - curOffset] = (byte)(ret[ret.length - curOffset] | curDigit);
                ++curOffset;
            } else {
                ret[ret.length - curOffset] = curDigit;
            }
            highBitsNotFilled = !highBitsNotFilled;
        }
        return ret;
    }

    static String bytesToHex(byte[] buf) {
        String HexChars = "0123456789ABCDEF";
        StringBuffer sb = new StringBuffer(buf.length / 2 * 5 + 3);
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            b = (byte)(b >> 4);
            b = (byte)(b & 0xF);
            sb.append("0123456789ABCDEF".charAt(b));
            b = buf[i];
            b = (byte)(b & 0xF);
            sb.append("0123456789ABCDEF".charAt(b));
            if (i % 2 != 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }
}

