/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.tools;

public class ZonedDecimal {
    static final int MinusSignMask = 144;
    static final int PlusSign1 = 160;
    static final int PlusSignPreferred = 192;
    static final int PlusSign2 = 224;
    static final int MinusSign1 = 176;
    static final int MinusSignPreferred = 208;
    static final int UnsignedMask = 240;
    static final int DigitMask = 15;
    static final int SignMask = 240;

    public static long parse(byte[] pRawZonedDecimal) throws Exception {
        long ret = 0L;
        for (int i = 0; i < pRawZonedDecimal.length; ++i) {
            int digit;
            byte curByte;
            if (i == pRawZonedDecimal.length - 1) {
                curByte = pRawZonedDecimal[i];
                digit = curByte & 0xF;
                ret = ret * 10L + (long)digit;
                int sign = curByte & 0xF0;
                if (sign == 240) continue;
                if ((sign & 0x90) == 144) {
                    if ((sign & 0xD0) == 208 || (sign & 0xB0) == 176) {
                        ret = -ret;
                        continue;
                    }
                    throw new Exception("Negative sign is malformated: " + ZonedDecimal.bytesToHex(pRawZonedDecimal));
                }
                if ((sign & 0xC0) == 192 || (sign & 0xA0) == 160 || (sign & 0xE0) == 224) continue;
                throw new Exception("Positive sign is malformated: " + ZonedDecimal.bytesToHex(pRawZonedDecimal));
            }
            curByte = pRawZonedDecimal[i];
            digit = curByte & 0xF;
            ret = ret * 10L + (long)digit;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ZonedDecimal.parse("12A".getBytes()));
    }

    public static byte[] pack(long pInputNumber, int pMaxDigits, boolean pIsUnsigned) {
        byte[] ret = new byte[pMaxDigits];
        byte curDigit = 0;
        int curOffset = 1;
        long numberToPack = Math.abs(pInputNumber);
        ret[ret.length - curOffset] = pIsUnsigned ? -16 : (pInputNumber > 0L ? -64 : -48);
        curDigit = (byte)(numberToPack % 10L);
        ret[ret.length - curOffset] = (byte)(curDigit | ret[ret.length - 1]);
        while (numberToPack > 0L) {
            ret[ret.length - ++curOffset] = curDigit = (byte)((numberToPack /= 10L) % 10L);
        }
        return ret;
    }

    static String bytesToHex(byte[] buf) {
        String HexChars = "0123456789ABCDEF";
        StringBuffer sb = new StringBuffer(buf.length / 2 * 5 + 3);
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            b = (byte)(b >> 4);
            b = (byte)(b & 0xF);
            sb.append("0123456789ABCDEF".charAt(b));
            b = buf[i];
            b = (byte)(b & 0xF);
            sb.append("0123456789ABCDEF".charAt(b));
            if (i % 2 != 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }
}

