/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.handler;

import com.stambia.jdbc.driver.handler.JdbcHandler;
import com.stambia.jdbc.driver.handler.JdbcListener;
import com.stambia.jdbc.driver.handler.Messages;
import com.stambia.jdbc.driver.handler.internal.BSFEvaluation;
import com.stambia.jdbc.driver.handler.internal.ConnectionWrapper;
import com.stambia.jdbc.driver.handler.internal.ScriptEngineEvaluation;
import com.stambia.jdbc.driver.handler.internal.StambiaSystemClassLoader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;

public class DriverHandler1
implements Driver {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(DriverHandler1.class);

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:stambia:handler1:");
    }

    protected String getOriginalDriver(String paramUrl) throws SQLException {
        String url = paramUrl.substring("jdbc:stambia:handler1:".length());
        int index = url.indexOf(":");
        if (index == -1) {
            throw new SQLException(Messages.getString("DriverHandler1.0"));
        }
        return url.substring(0, index);
    }

    protected String getOriginalUrl(String paramUrl) throws SQLException {
        String url = paramUrl.substring("jdbc:stambia:handler1:".length());
        int index = url.indexOf(":");
        if (index == -1) {
            throw new SQLException(Messages.getString("DriverHandler1.1"));
        }
        return url.substring(index + 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Connection connect(final String url, Properties info) throws SQLException {
        prefix = "JDBC_HANDLER.";
        localDebug = info.getProperty(prefix + "DEBUG");
        debug = new boolean[]{false};
        if (localDebug != null && localDebug.equals("true")) {
            debug[0] = true;
            DriverHandler1.LOGGER.debug("url: {}", (Object)url);
            DriverHandler1.LOGGER.debug("properties: {}", (Object)info);
        }
        classLoaderExpression = info.getProperty(prefix + "CLASS_LOADER1.PATTERNS");
        language = info.getProperty(prefix + "SCRIPT.LANGUAGE");
        script = info.getProperty(prefix + "SCRIPT");
        handlerName = info.getProperty(prefix + "SCRIPT.HANDLER_NAME");
        listenername = info.getProperty(prefix + "SCRIPT.LISTENER_NAME");
        className = info.getProperty(prefix + "CLASS_NAME");
        localDisable = info.getProperty(prefix + "DISABLE");
        disable = false;
        if (localDisable != null && localDisable.equals("true")) {
            disable = true;
        }
        copyInfo = new Properties();
        jdbcHandlerProp = new Properties();
        toDelete = new HashSet<Object>();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            if (((String)entry.getKey()).startsWith(prefix)) {
                toDelete.add(entry.getKey());
                if (!((String)entry.getKey()).startsWith(prefix + "PROPERTY.")) continue;
                jdbcHandlerProp.setProperty(((String)entry.getKey()).substring((prefix + "PROPERTY").length() + 1), (String)entry.getValue());
                continue;
            }
            copyInfo.put(entry.getKey(), entry.getValue());
        }
        mainListener = new DriverHandlerImpl();
        mainListener.initCL(classLoaderExpression);
        mainListener.initDriver(url);
        if (!disable) {
            if (debug[0]) {
                DriverHandler1.LOGGER.debug("init Handler");
            }
            mainListener.initHandler(className, language, script, handlerName, listenername);
        }
        mainListener.beforeOpenConnection(url, info);
        connection = new Connection[1];
        ct = new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                if (debug[0]) {
                    LOGGER.debug("init Handler");
                }
                connection[0] = mainListener.wrappedDriver.connect(DriverHandler1.this.getOriginalUrl(url), copyInfo);
                return connection[0];
            }
        };
        if (mainListener.hook != null) {
            try {
                if (debug[0]) {
                    DriverHandler1.LOGGER.debug("jdbcProp:" + jdbcHandlerProp);
                }
                if ((ret = mainListener.hook.handleConnection(ct, copyInfo, jdbcHandlerProp)) == null) ** GOTO lbl58
                connection[0] = ret;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            try {
                ct.call();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
lbl58:
        // 3 sources

        new ConnectionWrapper(connection[0]){

            @Override
            public void close() throws SQLException {
                mainListener.beforeCloseConnection(connection[0]);
                super.close();
                mainListener.afterCloseConnection(connection[0]);
            }

            @Override
            public void commit() throws SQLException {
                mainListener.beforeCommitConnection(connection[0]);
                super.commit();
                mainListener.afterCommitConnection(connection[0]);
            }
        };
        mainListener.afterOpenConnection(connection[0]);
        return connection[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new DriverHandler1());
        }
        catch (SQLException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
    }

    class DriverHandlerImpl
    implements JdbcListener {
        public JdbcHandler hook;
        Driver wrappedDriver;
        ClassLoader cl;
        List<JdbcListener> listeners = Collections.synchronizedList(new ArrayList());

        DriverHandlerImpl() {
        }

        private void initCL(String classLoaderExpression) throws SQLException {
            if (this.cl == null && classLoaderExpression != null) {
                try {
                    this.cl = new StambiaSystemClassLoader(ClassLoader.getSystemClassLoader(), classLoaderExpression.split(";"));
                }
                catch (UnsupportedEncodingException | MalformedURLException e) {
                    throw new SQLException(e);
                }
            }
        }

        private void initDriver(String url) throws SQLException {
            String originalDriver = DriverHandler1.this.getOriginalDriver(url);
            try {
                Class<?> clazz = this.cl != null ? Class.forName(originalDriver, true, this.cl) : Class.forName(originalDriver);
                this.wrappedDriver = (Driver)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e);
            }
            catch (InstantiationException e) {
                throw new SQLException(e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e);
            }
        }

        private void initHandler(String className, String language, String script, String hookName, String handlerName) throws SQLException {
            block9: {
                if (className != null) {
                    try {
                        Class<?> clazz = this.cl != null ? Class.forName(className, true, this.cl) : Class.forName(className);
                        this.hook = (JdbcHandler)clazz.newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new SQLException(e);
                    }
                }
                if (language != null) {
                    try {
                        BSFEvaluation be = new BSFEvaluation();
                        be.initJdbcHandler(this.cl, language, hookName, script, handlerName);
                        this.hook = be.getHandler();
                        JdbcListener listener = be.getListener();
                        if (this.hook instanceof JdbcListener) {
                            this.listeners.add((JdbcListener)((Object)this.hook));
                        }
                        if (listener != null) {
                            this.listeners.add(listener);
                        }
                    }
                    catch (Exception t) {
                        ScriptEngineEvaluation see = new ScriptEngineEvaluation();
                        see.initJdbcHandler(language, hookName, script, handlerName);
                        this.hook = see.getHandler();
                        JdbcListener listener = see.getListener();
                        if (this.hook instanceof JdbcListener) {
                            this.listeners.add((JdbcListener)((Object)this.hook));
                        }
                        if (listener == null) break block9;
                        this.listeners.add(listener);
                    }
                }
            }
        }

        @Override
        public void beforeOpenConnection(String url, Properties info) {
            for (JdbcListener handler : this.listeners) {
                handler.beforeOpenConnection(url, info);
            }
        }

        @Override
        public void afterOpenConnection(Connection connection) {
            for (JdbcListener handler : this.listeners) {
                handler.afterOpenConnection(connection);
            }
        }

        @Override
        public void beforeCloseConnection(Connection connection) {
            for (JdbcListener handler : this.listeners) {
                handler.beforeCloseConnection(connection);
            }
        }

        @Override
        public void afterCloseConnection(Connection connection) {
            for (JdbcListener handler : this.listeners) {
                handler.afterCloseConnection(connection);
            }
        }

        @Override
        public void beforeCommitConnection(Connection connection) {
            for (JdbcListener handler : this.listeners) {
                handler.beforeCommitConnection(connection);
            }
        }

        @Override
        public void afterCommitConnection(Connection connection) {
            for (JdbcListener handler : this.listeners) {
                handler.afterCommitConnection(connection);
            }
        }
    }
}

