/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.handler.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StambiaSystemClassLoader
extends URLClassLoader {
    static List<URL> _list = new ArrayList<URL>();

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        for (File file : StambiaSystemClassLoader.getFile("d:/work/stambiaRuntime/lib/**/*.jar", "d:/work/stambiaRuntime/lib/**/*.zip", "d:/work/stambiaRuntime/lib/**/*.dll", "exclude::d:/work/stambiaRuntime/lib/indyEngineLauncher.jar", "exclude::d:/work/stambiaRuntime/lib/scripting/cachedir", "exclude::d:/work/stambiaRuntime/lib/scripting/Lib")) {
            System.out.println(file.toString());
        }
        System.out.println(System.currentTimeMillis() - l);
    }

    static void fillStack(File file, List<File> stack) {
        if (file != null) {
            StambiaSystemClassLoader.fillStack(file.getParentFile(), stack);
            stack.add(file);
        }
    }

    public static String replaceWildCharsWithGroups(String wild) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = wild.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '*') {
                buffer.append("(.*)");
                continue;
            }
            if (chars[i] == '?') {
                buffer.append("(.)");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
                continue;
            }
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }

    static void getAllRecursDir(File dir, List<File> list, List<File> excludes) {
        if (dir.isDirectory() && (excludes == null || !excludes.contains(dir))) {
            list.add(dir);
            for (File child : dir.listFiles()) {
                StambiaSystemClassLoader.getAllRecursDir(child, list, excludes);
            }
        }
    }

    static void fillList2(File parentRealFile, Level parentLevel, List<File> list, int index, boolean recursive, List<File> excludes) {
        if (parentRealFile == null) {
            ++index;
            for (Level child : parentLevel.level.values()) {
                StambiaSystemClassLoader.fillList2(child.file, child, list, index, recursive, excludes);
            }
            return;
        }
        if (excludes != null && excludes.contains(parentRealFile)) {
            return;
        }
        if (!parentRealFile.exists()) {
            return;
        }
        if (parentLevel.isLeaf) {
            list.add(parentRealFile);
            return;
        }
        if (!parentLevel.isLeaf && parentRealFile.isDirectory()) {
            for (Level childLevel : parentLevel.level.values()) {
                File childRealFile = new File(parentRealFile, childLevel.file.getName());
                String name = childRealFile.getName();
                if (name.equals("**")) {
                    ArrayList<File> allDirs = new ArrayList<File>();
                    StambiaSystemClassLoader.getAllRecursDir(parentRealFile, allDirs, excludes);
                    for (File dir : allDirs) {
                        StambiaSystemClassLoader.fillList2(dir, childLevel, list, index, true, excludes);
                    }
                    continue;
                }
                if (name.indexOf(42) > -1 || name.indexOf(63) > -1) {
                    String pattern = StambiaSystemClassLoader.replaceWildCharsWithGroups(name);
                    for (File _file : parentRealFile.listFiles()) {
                        if (!_file.getName().matches(pattern)) continue;
                        StambiaSystemClassLoader.fillList2(_file, childLevel, list, index, recursive, excludes);
                    }
                    continue;
                }
                StambiaSystemClassLoader.fillList2(childRealFile, childLevel, list, index, recursive, excludes);
            }
        }
    }

    static void fillRoot(Level root, List<List<File>> stacks) {
        for (List<File> stack : stacks) {
            Level current = root;
            int i = -1;
            for (File fi : stack) {
                ++i;
                Level l = current.level.get(fi.getName());
                if (l == null) {
                    l = new Level();
                    l.file = fi;
                    if (i + 1 == stack.size()) {
                        l.isLeaf = true;
                    }
                    current.level.put(fi.getName(), l);
                }
                current = l;
            }
        }
    }

    static List<File> getFile(String ... mask) {
        ArrayList<List<File>> stacks = new ArrayList<List<File>>();
        ArrayList<List<File>> excludes = new ArrayList<List<File>>();
        for (String _mask : mask) {
            boolean exclude = _mask.startsWith("exclude::");
            if (exclude) {
                _mask = _mask.substring(9);
            }
            ArrayList<File> stack = new ArrayList<File>();
            File f = new File(_mask);
            StambiaSystemClassLoader.fillStack(f, stack);
            if (exclude) {
                excludes.add(stack);
                continue;
            }
            stacks.add(stack);
        }
        Level root = new Level();
        StambiaSystemClassLoader.fillRoot(root, stacks);
        Level rootExclude = new Level();
        StambiaSystemClassLoader.fillRoot(rootExclude, excludes);
        ArrayList<File> _excludes = new ArrayList<File>();
        StambiaSystemClassLoader.fillList2(null, rootExclude, _excludes, -1, false, null);
        ArrayList<File> list = new ArrayList<File>();
        StambiaSystemClassLoader.fillList2(null, root, list, -1, false, _excludes);
        return list;
    }

    public StambiaSystemClassLoader(ClassLoader paramClassLoader, String ... path) throws MalformedURLException, UnsupportedEncodingException {
        super(StambiaSystemClassLoader.getURL(path).toArray(new URL[StambiaSystemClassLoader.getURL(path).size()]), paramClassLoader);
    }

    static List<URL> getURL(String ... mask) throws MalformedURLException, UnsupportedEncodingException {
        ArrayList<URL> list = new ArrayList<URL>();
        for (File file : StambiaSystemClassLoader.getFile(mask)) {
            if (file.getName().equals("indyEngineLauncher.jar")) continue;
            list.add(file.toURI().toURL());
        }
        return list;
    }

    static {
        long l = System.currentTimeMillis();
        Properties prop = System.getProperties();
        Enumeration<Object> enu = prop.keys();
        while (enu.hasMoreElements()) {
            String[] path;
            Object o = enu.nextElement();
            if (!(o instanceof String) || !((String)o).startsWith("stambia.classpath.v1.") || (path = System.getProperty((String)o).split(";")) == null) continue;
            try {
                _list.addAll(StambiaSystemClassLoader.getURL(path));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Level {
        Map<String, Level> level = new HashMap<String, Level>();
        File file;
        boolean isLeaf;

        Level() {
        }
    }
}

