/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class InjectChecksum
extends Task {
    String checksum;
    String metadataFile;

    public void execute() throws BuildException {
        File metadata = new File(this.metadataFile);
        File tmp = new File(metadata.getParent(), String.valueOf(metadata.getName()) + ".tmp");
        try {
            this.mergeConfXml(metadata, tmp);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        try {
            Files.deleteIfExists(metadata.toPath());
            Files.move(tmp.toPath(), metadata.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setMetadataFile(String metadataFile) {
        this.metadataFile = metadataFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeConfXml(File currentConf, File newFile) throws Exception {
        XMLEventReader reader = null;
        XMLStreamWriter writer = null;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                BufferedInputStream fisConf = new BufferedInputStream(new FileInputStream(currentConf));
                try {
                    try (BufferedOutputStream bwConf = new BufferedOutputStream(new FileOutputStream(newFile, true));){
                        writer = XMLOutputFactory.newInstance().createXMLStreamWriter(bwConf, "UTF-8");
                        writer.writeStartDocument("UTF-8", "1.0");
                        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                        reader = inputFactory.createXMLEventReader(fisConf);
                        boolean first = true;
                        while (reader.hasNext()) {
                            XMLEvent ev = reader.nextEvent();
                            switch (ev.getEventType()) {
                                case 1: {
                                    this.handleStartElement(ev.asStartElement(), writer, first);
                                    first = false;
                                    break;
                                }
                                case 2: {
                                    writer.writeEndElement();
                                    break;
                                }
                                case 4: {
                                    writer.writeCharacters(ev.asCharacters().getData());
                                }
                            }
                        }
                        writer.writeEndDocument();
                        writer.flush();
                    }
                    if (fisConf == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fisConf == null) throw throwable;
                    ((InputStream)fisConf).close();
                    throw throwable;
                }
                ((InputStream)fisConf).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void handleStartElement(StartElement s, XMLStreamWriter writer, boolean readNamespaces) throws XMLStreamException {
        if (s.getName().getPrefix() != null && !s.getName().getPrefix().isEmpty()) {
            writer.writeStartElement(String.valueOf(s.getName().getPrefix()) + ":" + s.getName().getLocalPart());
        } else {
            writer.writeStartElement(s.getName().getLocalPart());
        }
        Iterator<Namespace> itNm = s.getNamespaces();
        if (readNamespaces) {
            while (itNm.hasNext()) {
                Namespace n = itNm.next();
                writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
            }
        }
        Iterator<Attribute> itAtt = s.getAttributes();
        while (itAtt.hasNext()) {
            Attribute a = itAtt.next();
            writer.writeAttribute(a.getName().toString(), a.getValue());
        }
        if (s.getName().getLocalPart().equals("externalize")) {
            writer.writeAttribute("checksum", this.checksum);
        }
    }
}

