/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.decorator.ImageImageDescriptor;
import com.indy.emf.uri.decorator.IndyElementImageDescriptor;
import com.indy.emf.uri.decorator.ProblemMarkerManager;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.navigator.CommonNavigator;

public class CacheDecorator
extends LabelProvider
implements ILabelDecorator,
ProblemMarkerManager.IProblemChangedListener {
    private ListenerList fListeners;
    private ImageDescriptorRegistry fRegistry;
    public static Set<CacheDecorator> cacheDecorator = new HashSet<CacheDecorator>();
    ICacheService cacheService;

    public static void refreshProjectExplorer() {
        IViewPart v = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (v != null && v instanceof CommonNavigator) {
            ((CommonNavigator)v).getCommonViewer().refresh();
        }
    }

    public static boolean isHideExtension() {
        ICommandService s = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command c = s.getCommand("com.indy.emf.uri.command.hideFileExtensionDecoration");
        if (c == null) {
            return true;
        }
        State state = c.getState("org.eclipse.ui.commands.toggleState");
        boolean oldValue = (Boolean)state.getValue();
        return oldValue;
    }

    public CacheDecorator() {
        cacheDecorator.add(this);
        Activator.getDefault().getProblemMarkerManager().addListener(this);
        this.cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
    }

    private boolean isElligibleResource(IResource r) {
        return IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(r.getFileExtension());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String decorateText(String text, Object element) {
        if (CacheDecorator.isHideExtension() && element instanceof IFile && this.cacheService.isInit() && this.isElligibleResource((IResource)element)) {
            text = text.replace(((IFile)element).getFullPath().lastSegment(), ((IFile)element).getFullPath().removeFileExtension().lastSegment());
        }
        if (!(element instanceof IResource)) return null;
        if (this.cacheService != null && this.cacheService.isInit() && this.isElligibleResource((IResource)element)) {
            IResource file = (IResource)element;
            try {
                Object o;
                IMarker[] marquers = file.findMarkers("com.semarchy.resource.marker.roleRequired", false, 0);
                if (marquers != null && marquers.length > 0 && (o = marquers[0].getAttribute("com.semarchy.resource.marker.roleRequired.role")) instanceof String) {
                    return String.valueOf(text) + String.format(Messages.CacheDecorator_resource_missing_role_tag, o);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            URI uri = Util.convertIFileToEMFURI((IFile)((IFile)file));
            ICacheService.SourceState s = this.cacheService.getSourceState(uri);
            if (s == null) return String.valueOf(text) + Messages.CacheDecorator_resource_not_indexed_tag;
            if (s.isSync()) {
                if (s.getRemark("com.indy.emf.uri.remark.udfActiveId") == null) return text;
                return String.valueOf(text) + Messages.CacheDecorator_resource_disabled_tag;
            }
            if (!s.isDuplicate()) return null;
            return String.valueOf(text) + Messages.CacheDecorator_resource_duplicate_tag;
        }
        if (((IResource)element).getType() != 1 || !IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(((IResource)element).getFileExtension())) return null;
        return String.valueOf(text) + Messages.CacheDecorator_resouce_discarded_tag;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public Image decorateImage(Image image, Object element) {
        ImageImageDescriptor baseImage;
        ImageDescriptor id;
        URI resourceURI;
        int state;
        block16: {
            IResource file;
            state = -1;
            resourceURI = null;
            if (element instanceof IResource && (file = (IResource)element).exists() && (!(file instanceof IProject) || ((IProject)file).isOpen())) {
                try {
                    IMarker[] markers2;
                    IMarker[] markers = file.findMarkers("com.stambia.resource.marker", true, 2);
                    if (markers.length > 0) {
                        state = 64;
                        break block16;
                    }
                    markers = file.findMarkers("com.stambia.resource.marker.invalidmodel", true, 2);
                    IMarker[] iMarkerArray = markers2 = file.getType() == 1 ? new IMarker[]{} : file.findMarkers("com.stambia.resource.marker.duplicate", true, 2);
                    if (markers.length > 0 || markers2.length > 0) {
                        state = 32;
                        IMarker[] iMarkerArray2 = markers;
                        int n = markers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker m = iMarkerArray2[n2];
                            try {
                                if (!Integer.valueOf(1).equals(m.getAttribute("severity"))) {
                                    state = 64;
                                }
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                            ++n2;
                        }
                        break block16;
                    }
                    IMarker[] markers3 = file.findMarkers("com.stambia.resource.marker.invalidXML", true, 2);
                    if (markers3.length > 0) {
                        state = 32;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        Image result = null;
        int descriptorType = 0;
        if (resourceURI != null && ((IOverrideService)E4InjectorHelper.getService(IOverrideService.class)).isOverrider(resourceURI)) {
            descriptorType = 128;
        }
        if (state == 64) {
            id = Activator.imageDescriptorFromPlugin((String)"com.indy.emf.uri", (String)"icons/full/obj16/error_obj.gif");
            baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            result = this.getRegistry().get((ImageDescriptor)new IndyElementImageDescriptor(baseImage, descriptorType | 0x40, new Point(bounds.width, bounds.height)));
        } else if (state == 32) {
            id = Activator.imageDescriptorFromPlugin((String)"com.indy.emf.uri", (String)"icons/full/ovr16/warning_co.gif");
            baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            result = this.getRegistry().get((ImageDescriptor)new IndyElementImageDescriptor(baseImage, descriptorType | 0x20, new Point(bounds.width, bounds.height)));
        } else if ((descriptorType & 0x80) != -1) {
            ImageImageDescriptor baseImage2 = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            result = this.getRegistry().get((ImageDescriptor)new IndyElementImageDescriptor(baseImage2, descriptorType, new Point(bounds.width, bounds.height)));
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void fireProblemsChangedPublic(IResource[] changedResources, boolean isMarkerChange) {
        this.fireProblemsChanged(changedResources, isMarkerChange);
    }

    public void dispose() {
        cacheDecorator.remove(this);
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        this.fireProblemsChangedPublic(changedResources, isMarkerChange);
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

