/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.action;

import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IndyResourceUtil;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

class XDIResourceIDGenerator {
    private static final String OPTION_MODEL_ID = "xdi.semarchy.modelid";
    ResourceSet resourceSet;
    Logger logger = LogManager.getLogger(XDIResourceIDGenerator.class);
    Path temporaryFolder;
    Map<URI, Path> temporaryGeneratedFiles = new HashMap<URI, Path>();

    static IUndoableOperation createOperation(Collection<URI> resourceURI) {
        ResetIdsOperation operation = new ResetIdsOperation(resourceURI);
        operation.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        return operation;
    }

    public void cleanup() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Stream<Path> paths = Files.walk(this.temporaryFolder, new FileVisitOption[0]);){
                paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.logger.error("Failed to delete {}", (Object)this.temporaryFolder, (Object)ex);
        }
    }

    XDIResourceIDGenerator() {
        this.resourceSet = new ResourceSetImpl();
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(new WeakHashMap());
        this.resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter(false){

            public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
                String modelId = (String)options.get(XDIResourceIDGenerator.OPTION_MODEL_ID);
                Path output = XDIResourceIDGenerator.this.temporaryFolder.resolve(modelId);
                BufferedOutputStream res = new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0]), 0x100000);
                XDIResourceIDGenerator.this.temporaryGeneratedFiles.put(uri, output);
                return res;
            }
        });
        this.resourceSet.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.resourceSet.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
        this.resourceSet.getLoadOptions().put("com.indy.md.ui.validateMdXML", Boolean.TRUE);
    }

    private Map<URI, Path> resetResourceIds(URI resourceURI) throws IOException {
        Resource re;
        if (this.temporaryFolder == null) {
            this.temporaryFolder = Files.createTempDirectory("resetResourceIds", new FileAttribute[0]);
        }
        if (!((re = this.resourceSet.getResource(resourceURI, true)) instanceof IndyResourceUtil.IndyResource)) {
            return Collections.emptyMap();
        }
        List dependent = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsage(resourceURI);
        Map oldIdToNewId = ((IndyXMLResource)re).reinitAllId(null, null);
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        Util util = Util.INSTANCE;
        util.getClass();
        saveOptions.put("URI_HANDLER", new Util.URIHandlerImpl2(util, oldIdToNewId));
        saveOptions.put("ENCODING", StandardCharsets.UTF_8.name());
        saveOptions.put("com.indy.gmf.map.SAVE_OPTION_NO_REF_SAVE", Boolean.TRUE);
        saveOptions.put("com.indy.gmf.proc.util.ProcResourceImpl.saveOption.noCrossRefModel", Boolean.TRUE);
        saveOptions.put(OPTION_MODEL_ID, ((IndyXMLResource)re).getId());
        re.save(saveOptions);
        for (URI u : dependent) {
            this.updateDependency(u, saveOptions);
        }
        return this.temporaryGeneratedFiles;
    }

    private void updateDependency(URI resourceURI, Map<String, Object> saveOptions) throws IOException {
        Resource re = this.resourceSet.getResource(resourceURI, true);
        try {
            saveOptions.put(OPTION_MODEL_ID, ((IndyXMLResource)re).getId());
            re.save(saveOptions);
        }
        finally {
            re.unload();
            this.resourceSet.getResources().remove((Object)re);
        }
    }

    static class ResetIdsOperation
    extends AbstractOperation {
        List<IFile> updatedFiles = new ArrayList<IFile>();
        Collection<URI> resourceURI;
        XDIResourceIDGenerator generator = new XDIResourceIDGenerator();

        ResetIdsOperation(Collection<URI> resourceURI) {
            super("Reset id");
            this.resourceURI = resourceURI;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                this.updatedFiles.clear();
                HashMap tempFiles = new HashMap();
                MultiStatus ms = new MultiStatus(((Object)((Object)this)).getClass(), 0, this.getLabel());
                for (URI u : this.resourceURI) {
                    try {
                        tempFiles.putAll(this.generator.resetResourceIds(u));
                    }
                    catch (IOException e2) {
                        ms.add((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Failed to reset ids for " + URIUtils.toPath((URI)u), (Throwable)e2));
                    }
                }
                tempFiles.entrySet().forEach(e -> {
                    IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(URIUtils.toPath((URI)((URI)e.getKey())));
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream((Path)e.getValue(), new OpenOption[0]));){
                            f.setContents((InputStream)is, true, true, monitor);
                            this.updatedFiles.add(f);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        ms.add((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Failed to replace content  for " + f.toString(), (Throwable)ex));
                    }
                });
                if (!ms.isOK()) {
                    this.undo(monitor, info);
                }
                MultiStatus multiStatus = ms;
                return multiStatus;
            }
            finally {
                this.generator.cleanup();
            }
        }

        public boolean canUndo() {
            return !this.updatedFiles.isEmpty();
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            MultiStatus ms = new MultiStatus(((Object)((Object)this)).getClass(), 0, this.getLabel());
            for (IFile f : this.updatedFiles) {
                try {
                    IFileState[] states = f.getHistory(monitor);
                    if (states.length <= 0) continue;
                    f.setContents(states[0], true, false, null);
                }
                catch (CoreException e) {
                    ms.add((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Failed to restore " + f.getFullPath(), (Throwable)e));
                }
            }
            this.updatedFiles.clear();
            return ms;
        }
    }
}

