/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.commands;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.CacheUtil;
import com.indy.emf.uri.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ActivateResourceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!s.isEmpty()) {
            Object o = ((IStructuredSelection)s).getFirstElement();
            IFile f = (IFile)o;
            ICacheService.IWorkspaceSynchronizer service = (ICacheService.IWorkspaceSynchronizer)E4InjectorHelper.getService(ICacheService.IWorkspaceSynchronizer.class);
            ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            cacheService.enableTrigger(false);
            try {
                try {
                    String activeId = (String)f.getPersistentProperties().get(CacheUtil.RESOURCE_PROPERTY_ACTIVE_FILE_ID);
                    URI activeFile = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(activeId);
                    IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);
                    registryService.unregisterObjectsFrom(activeId);
                    service.handleModifiedFile(Util.convertIFileToEMFURI((IFile)f));
                    service.handleModifiedFile(activeFile);
                }
                catch (Throwable ex) {
                    Activator.log((IStatus)new Status(4, "com.indy.emf.uri", String.valueOf(Messages.ActivateResourceHandler_0) + f.getFullPath(), ex));
                    cacheService.enableTrigger(true);
                }
            }
            finally {
                cacheService.enableTrigger(true);
            }
        }
        return null;
    }
}

