/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.commands;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.patch.FileDialogPatch;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.registry.TechExtension;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ConfigurationInfo;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExportModelsHandler
extends AbstractHandler
implements IResourceVisitor {
    private List<IFile> visitedFiles = new ArrayList<IFile>();
    private static String lastPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List<IFile> list = this.visitedFiles;
        synchronized (list) {
            block19: {
                WizardDialog optsDialog;
                block17: {
                    this.visitedFiles.clear();
                    for (Object o : ((IStructuredSelection)s).toList()) {
                        if (!(o instanceof IResource)) continue;
                        IResource r = (IResource)o;
                        try {
                            r.accept((IResourceVisitor)this);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    optsDialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)new CustomWizard());
                    if (optsDialog.open() == 0) break block17;
                    return null;
                }
                Job job = new Job(Messages.ExportModelsHandler_11){

                    private Set<IFile> gatherDependancies(IProgressMonitor monitor) {
                        ICacheService cache = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
                        XDIModelURIResolver modelResolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
                        ExportModelsHandler mapRefCollector = new ExportModelsHandler();
                        HashSet<IFile> selectedFiles = new HashSet<IFile>();
                        for (IFile f : ExportModelsHandler.this.visitedFiles) {
                            if (!selectedFiles.contains(f)) {
                                selectedFiles.add(f);
                            }
                            for (URI d : cache.getDependencyHelper().getDependancies(Util.convertIFileToEMFURI((IFile)f))) {
                                if (d == null || !d.isPlatformResource()) continue;
                                IFile _f = Util.convertEMFURIToFile((URI)d);
                                selectedFiles.add(_f);
                                if ("md".equals(d.fileExtension())) {
                                    selectedFiles.addAll(this.gatherTechnologyDependancies(d));
                                }
                                try {
                                    if ("map".equals(f.getFileExtension()) && "proc".equals(_f.getFileExtension())) {
                                        for (URI u2 : cache.getDependencyHelper().getUsage(Util.convertIFileToEMFURI((IFile)_f))) {
                                            if (!"tpc".equals(u2.fileExtension()) || !u2.isPlatformResource()) continue;
                                            selectedFiles.add(Util.convertEMFURIToFile((URI)u2));
                                            for (URI uu : cache.getDependencyHelper().getDependancies(u2)) {
                                                if (!uu.isPlatformResource()) continue;
                                                IFile __f = Util.convertEMFURIToFile((URI)uu);
                                                selectedFiles.add(__f);
                                            }
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.emf.uri", Messages.ExportModelsHandler_15, (Throwable)ex));
                                }
                                if (!"map".equals(_f.getFileExtension())) continue;
                                Collection builtFiles = URIUtils.getMappingBuiltFiles((URI)d, (XDIModelURIResolver)modelResolver, (boolean)true);
                                builtFiles.forEach(u -> {
                                    boolean bl = selectedFiles.add(Util.convertEMFURIToFile((URI)u));
                                });
                                try {
                                    mapRefCollector.visit((IResource)_f);
                                    selectedFiles.addAll(mapRefCollector.visitedFiles);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        return selectedFiles;
                    }

                    private Set<IFile> gatherTechnologyDependancies(URI uri) {
                        HashSet<IFile> selectedFiles = new HashSet<IFile>();
                        ResourceSetImpl rs = new ResourceSetImpl();
                        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
                        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
                        Resource mdResource = rs.getResource(uri, true);
                        EcoreUtil.resolveAll((Resource)mdResource);
                        EObject node = (EObject)mdResource.getContents().get(0);
                        EcoreUtil.resolveAll((ResourceSet)node.eResource().getResourceSet());
                        IRegistryService registryService = (IRegistryService)E4InjectorHelper.getService(IRegistryService.class);
                        for (Resource r : node.eResource().getResourceSet().getResources()) {
                            if (!"tech".equals(r.getURI().fileExtension())) continue;
                            selectedFiles.addAll(this.getExtentedTechsByTechIdentifier(((IndyXMLResource)r).getId(), registryService));
                        }
                        return selectedFiles;
                    }

                    private Set<IFile> getExtentedTechsByTechIdentifier(String techIdentifier, IRegistryService registryService) {
                        HashSet<IFile> selectedFiles = new HashSet<IFile>();
                        if (techIdentifier == null || techIdentifier.isEmpty()) {
                            return selectedFiles;
                        }
                        IRegistryService.IRegistry techExtensionRegistry = registryService.getRegistry(TechExtension.class);
                        List exts = techExtensionRegistry.find((IRegistryService.IRegistryMatcher)new TechExtension.TechExtensionMatcher(techIdentifier));
                        if (exts != null) {
                            for (TechExtension ext : exts) {
                                URI uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(ext.getRegistrationKey().getProviderFileID());
                                if (uri == null) continue;
                                ResourceSetImpl resourceSet = new ResourceSetImpl();
                                resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", true);
                                resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter());
                                Resource resource = resourceSet.getResource(uri, true);
                                EObject node = (EObject)((EObject)resource.getContents().get(0)).eContents().get(0);
                                EcoreUtil.resolveAll((ResourceSet)node.eResource().getResourceSet());
                                for (Resource subResource : node.eResource().getResourceSet().getResources()) {
                                    IFile file;
                                    if (!"tech_ext".equals(subResource.getURI().fileExtension()) || (file = Util.convertEMFURIToFile((URI)subResource.getURI())) == null) continue;
                                    selectedFiles.add(file);
                                }
                            }
                        }
                        return selectedFiles;
                    }

                    private List<IFile> gatherDiagrams(Collection<IFile> selectedFiles, IProgressMonitor monitor) {
                        ArrayList<IFile> diagrams = new ArrayList<IFile>();
                        for (IFile f : selectedFiles) {
                            IPath p = f.getProjectRelativePath();
                            Path diagramPath = new Path("/");
                            int i = 0;
                            while (i < p.segmentCount() - 1) {
                                diagramPath = diagramPath.append("/" + URI.decode((String)p.segment(i)));
                                ++i;
                            }
                            diagramPath = diagramPath.append("/indy.diagram");
                            if (f.getFileExtension().equals("map")) {
                                diagramPath = diagramPath.append("/map");
                            } else if (f.getFileExtension().equals("proc")) {
                                diagramPath = diagramPath.append("/proc");
                            }
                            diagramPath = diagramPath.append("/" + f.getName() + "_diagram");
                            IFile diagramFile = f.getProject().getFile((IPath)diagramPath);
                            if (diagramFile == null || !diagramFile.exists()) continue;
                            diagrams.add(diagramFile);
                        }
                        return diagrams;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.setTaskName(Messages.ExportModelsHandler_27);
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        Set<IFile> selectedFiles = null;
                        try {
                            selectedFiles = this.gatherDependancies((IProgressMonitor)progress.newChild(30));
                            progress.worked(30);
                            selectedFiles.addAll(this.gatherDiagrams(selectedFiles, (IProgressMonitor)progress.newChild(20)));
                            progress.worked(20);
                            this.buildZip(((ExportOptions)optsDialog.getCurrentPage()).output, selectedFiles, (IProgressMonitor)progress.newChild(50));
                            progress.worked(50);
                        }
                        catch (Throwable ex) {
                            return new Status(4, "com.indy.emf.uri", Messages.ExportModelsHandler_28, ex);
                        }
                        return new Status(0, "com.indy.emf.uri", Messages.bind((String)Messages.ExportModelsHandler_29, (Object)((ExportOptions)optsDialog.getCurrentPage()).output));
                    }

                    private void buildZip(String filePath, Collection<IFile> selectedFiles, IProgressMonitor monitor) throws Exception {
                        FilterOutputStream fos = null;
                        ZipOutputStream zos = null;
                        try {
                            try {
                                block46: {
                                    File _f = new File(filePath);
                                    if (_f.exists()) {
                                        _f.delete();
                                    }
                                    fos = new BufferedOutputStream(new FileOutputStream(_f));
                                    zos = new ZipOutputStream(fos);
                                    ZipEntry configEntry = new ZipEntry("export.configuration");
                                    zos.putNextEntry(configEntry);
                                    try {
                                        try {
                                            int length;
                                            ByteArrayInputStream is = new ByteArrayInputStream(ConfigurationInfo.getSystemSummary().getBytes());
                                            byte[] bytes = new byte[1024];
                                            while ((length = is.read(bytes)) >= 0) {
                                                zos.write(bytes, 0, length);
                                            }
                                        }
                                        catch (Throwable ex) {
                                            Activator.getDefault().getLog().warn(String.format("Failed to write entry %s from configuration's syste summary", configEntry.getName()), ex);
                                            try {
                                                zos.closeEntry();
                                            }
                                            catch (IOException ex2) {
                                                Activator.getDefault().getLog().warn("Failed to generate export.configuration", (Throwable)ex2);
                                            }
                                            break block46;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            zos.closeEntry();
                                        }
                                        catch (IOException ex) {
                                            Activator.getDefault().getLog().warn("Failed to generate export.configuration", (Throwable)ex);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        zos.closeEntry();
                                    }
                                    catch (IOException ex) {
                                        Activator.getDefault().getLog().warn("Failed to generate export.configuration", (Throwable)ex);
                                    }
                                }
                                for (IFile f : selectedFiles) {
                                    String name = f.getFullPath().toOSString().replace("\\", "/");
                                    if (!((ExportOptions)optsDialog.getCurrentPage()).includeBuiltFiles && f.getFullPath().toString().contains("/indy.build/")) continue;
                                    if (name.startsWith("/") || name.startsWith("\\")) {
                                        name = name.substring(1);
                                    }
                                    ZipEntry ze = new ZipEntry(name);
                                    BufferedInputStream is = null;
                                    try {
                                        try {
                                            int length;
                                            zos.putNextEntry(ze);
                                            is = new BufferedInputStream(f.getContents());
                                            byte[] bytes = new byte[1024];
                                            while ((length = ((InputStream)is).read(bytes)) >= 0) {
                                                zos.write(bytes, 0, length);
                                            }
                                        }
                                        catch (IOException ex) {
                                            throw new Exception(String.valueOf(Messages.ExportModelsHandler_36) + f, ex);
                                        }
                                        catch (CoreException ex) {
                                            throw new Exception(String.valueOf(Messages.ExportModelsHandler_37) + f, ex);
                                        }
                                    }
                                    finally {
                                        try {
                                            zos.closeEntry();
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                        if (is != null) {
                                            try {
                                                ((InputStream)is).close();
                                            }
                                            catch (IOException ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                throw new Exception(Messages.ExportModelsHandler_38, ex);
                            }
                        }
                        finally {
                            if (zos != null) {
                                try {
                                    zos.close();
                                }
                                catch (IOException _ex) {
                                    _ex.printStackTrace();
                                }
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException _ex) {
                                    _ex.printStackTrace();
                                }
                            }
                        }
                    }
                };
                job.setUser(true);
                job.schedule();
                try {
                    try {
                        job.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        IStatus st = job.getResult();
                        if (st.isOK()) {
                            StatusManager.getManager().handle(st, 1);
                        } else {
                            StatusManager.getManager().handle(st, 2);
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    IStatus st = job.getResult();
                    if (st.isOK()) {
                        StatusManager.getManager().handle(st, 1);
                    } else {
                        StatusManager.getManager().handle(st, 2);
                    }
                    throw throwable;
                }
                IStatus st = job.getResult();
                if (st.isOK()) {
                    StatusManager.getManager().handle(st, 1);
                } else {
                    StatusManager.getManager().handle(st, 2);
                }
            }
        }
        return null;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (!resource.getProject().isOpen()) {
            return false;
        }
        if (resource.getType() == 1 && resource.getFileExtension() != null) {
            if (resource.getFileExtension().equals("map") || resource.getFileExtension().equals("proc") || resource.getFileExtension().equals("tech") || resource.getFileExtension().equals("md") || resource.getFileExtension().equals("tpc") || resource.getFileExtension().equals("tech_ext")) {
                try {
                    if (resource.getFileExtension().equals("map")) {
                        IPath p = resource.getProjectRelativePath().removeLastSegments(1);
                        String resourceName = resource.getProjectRelativePath().lastSegment().substring(0, resource.getName().length() - 4);
                        Path buildPath = new Path("indy.build");
                        buildPath = buildPath.append(p);
                        Path p1 = new Path(buildPath.toString());
                        IResource r = resource.getProject().findMember(p1.append(resourceName).addFileExtension("proc"));
                        if (r != null && r.exists()) {
                            this.visitedFiles.add((IFile)r);
                        }
                        if ((r = resource.getProject().findMember(p1.append(resourceName).addFileExtension("md"))) != null && r.exists()) {
                            this.visitedFiles.add((IFile)r);
                        }
                        if ((r = resource.getProject().findMember(p1.append(resourceName).addFileExtension("map_ref"))) != null && r.exists()) {
                            this.visitedFiles.add((IFile)r);
                        }
                    }
                }
                catch (Exception ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.emf.uri", Messages.ExportModelsHandler_49, (Throwable)ex));
                }
                this.visitedFiles.add((IFile)resource);
                return true;
            }
        } else if (resource.getType() == 4 || resource.getType() == 2) {
            return true;
        }
        return false;
    }

    public class CustomWizard
    extends Wizard {
        private ExportOptions pageExport;

        public CustomWizard() {
            this.setNeedsProgressMonitor(true);
        }

        public String getWindowTitle() {
            return Messages.ExportModelsHandler_11;
        }

        public void addPages() {
            FileDialog fd = new FileDialog(this.getShell(), 8192);
            fd.setFilterExtensions(new String[]{"*.zip"});
            if (lastPath != null) {
                fd.setFilterPath(lastPath);
            }
            this.pageExport = new ExportOptions(this.getShell(), fd);
            this.addPage((IWizardPage)this.pageExport);
        }

        public boolean performFinish() {
            return true;
        }
    }

    private class ExportOptions
    extends WizardPage {
        private FormToolkit tk;
        private String output;
        private boolean includeBuiltFiles;
        private FileDialog fd;

        protected ExportOptions(Shell parentShell, FileDialog fd) {
            super(Messages.ExportModelsHandler_11, Messages.ExportModelsHandler_11, null);
            this.includeBuiltFiles = false;
            this.setDescription(Messages.ExportModelsHandler_12);
            this.tk = new FormToolkit(parentShell.getDisplay());
            this.fd = fd;
        }

        public void createControl(Composite parent) {
            Composite main = this.tk.createComposite(parent);
            main.setLayout((Layout)new GridLayout(3, false));
            main.setLayoutData((Object)new GridData(1808));
            Label l = this.tk.createLabel(main, Messages.ExportModelsHandler_1);
            l.setLayoutData((Object)new GridData());
            final Text txt = this.tk.createText(main, this.fd.getFileName());
            txt.setLayoutData((Object)new GridData(768));
            txt.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!txt.getText().contains(".")) {
                        txt.setText(String.valueOf(txt.getText()) + ".zip");
                    }
                    ExportOptions.this.output = txt.getText();
                    ExportOptions.this.setPageComplete(ExportOptions.this.output != null && !ExportOptions.this.output.isEmpty());
                }
            });
            Button b = this.tk.createButton(main, "...", 8);
            b.setLayoutData((Object)new GridData(3, 2, false, false));
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExportOptions.this.output = ExportOptions.this.fd.open();
                    ExportOptions.this.output = FileDialogPatch.addFileExtensionIfRequired((String)ExportOptions.this.output, (FileDialog)ExportOptions.this.fd);
                    txt.setText(ExportOptions.this.output);
                    ExportOptions.this.setPageComplete(ExportOptions.this.output != null && !ExportOptions.this.output.isEmpty());
                }
            });
            b = this.tk.createButton(main, Messages.ExportModelsHandler_3, 32);
            b.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExportOptions.this.includeBuiltFiles = ((Button)e.getSource()).getSelection();
                }
            });
            this.setControl((Control)main);
            this.setPageComplete(this.output != null && !this.output.isEmpty());
        }
    }
}

