/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.decorator;

import com.indy.emf.uri.Activator;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class IndyElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDEN = 128;
    private static ImageDescriptor OVERRIDEN_IMAGE_DESCRIPTOR;
    private static ImageDescriptor ERROR_IMAGE_DESCRIPTOR;
    private static ImageDescriptor WARNING_IMAGE_DESCRIPTOR;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    static {
        try {
            OVERRIDEN_IMAGE_DESCRIPTOR = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.environment/icons/full/19.png"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ERROR_IMAGE_DESCRIPTOR = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.emf.uri/icons/full/ovr16/error_co.gif"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            WARNING_IMAGE_DESCRIPTOR = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.emf.uri/icons/full/ovr16/warning_co.gif"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public IndyElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !IndyElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        IndyElementImageDescriptor other = (IndyElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            Activator.getDefault();
            Activator.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    private void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x;
        int y = pos.y - data.height;
        if (x + data.width < this.getSize().x && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x + data.width;
        }
    }

    private void addTopLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = 0;
        int y = 0;
        this.drawImage(data, x, y);
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        if ((this.fFlags & 0x40) != 0) {
            this.addBottomLeftImage(ERROR_IMAGE_DESCRIPTOR, pos);
        }
        if ((this.fFlags & 0x20) != 0) {
            this.addBottomLeftImage(WARNING_IMAGE_DESCRIPTOR, pos);
        }
        if ((this.fFlags & 0x80) != 0) {
            this.addTopLeftImage(OVERRIDEN_IMAGE_DESCRIPTOR, pos);
        }
    }
}

