/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal;

import com.indy.emf.uri.Messages;
import com.indy.emf.uri.action.ActionReinitId;
import com.indy.ui.custom.out.IndyJob;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.Constants;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class LinkedFileJob
extends IndyJob {
    public static final int MOVE_MODE = 1;
    public static final int REMOVE_MODE = 2;
    public static final int COPY_MODE = 3;
    private Collection<IResourceDelta> resources;
    private int mode;
    private static final IPath __buildPath = new Path("indy.build");
    private static final IPath __tmpMoveDestinationPath = __buildPath.append("___tmpMove__loc__");

    public LinkedFileJob(IResourceDelta resource, int mode) {
        this(Collections.singletonList(resource), mode);
    }

    public LinkedFileJob(Collection<IResourceDelta> resources, int mode) {
        super(Messages.LinkedFileJob_0);
        this.resources = resources;
        this.mode = mode;
    }

    private static IStatus handleRemove(IFile f, IProgressMonitor monitor) {
        XDIModelURIResolver modelResolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
        LogService logger = (LogService)E4InjectorHelper.getService(LogService.class);
        if (f.getFileExtension() != null) {
            if (f.getFileExtension().equals("proc")) {
                IPath diagramFolder = Util.getProcDiagramDirectory((IPath)f.getFullPath());
                String name = f.getName().substring(0, f.getName().lastIndexOf("."));
                IFile diagramFile = f.getProject().getFile(diagramFolder.removeFirstSegments(1).append(String.valueOf(name) + ".proc_diagram"));
                if (diagramFile.exists()) {
                    try {
                        diagramFile.delete(true, monitor);
                    }
                    catch (CoreException e) {
                        logger.getLogger(LinkedFileJob.class).trace(String.format("Failed to delete %s", diagramFile), (Object)e);
                    }
                } else {
                    Path buildPath = new Path(f.getWorkspace().getRoot().getLocation() + "/");
                    buildPath = buildPath.append(diagramFile.getFullPath());
                    File fs = new File(buildPath.toFile().getAbsolutePath());
                    fs.delete();
                }
            } else if (f.getFileExtension().equals("map")) {
                IPath diagramFolder = Util.getMapDiagramDirectory((IPath)f.getFullPath());
                String name = f.getName().substring(0, f.getName().lastIndexOf("."));
                IFile diagramFile = f.getProject().getFile(diagramFolder.removeFirstSegments(1).append(String.valueOf(name) + ".map_diagram"));
                if (diagramFile.exists()) {
                    try {
                        diagramFile.delete(true, monitor);
                    }
                    catch (CoreException e) {
                        logger.getLogger(LinkedFileJob.class).trace(String.format("Failed to delete %s", diagramFile), (Object)e);
                    }
                } else {
                    Path buildPath = new Path(f.getWorkspace().getRoot().getLocation() + "/");
                    buildPath = buildPath.append(diagramFile.getFullPath());
                    File fs = new File(buildPath.toFile().getAbsolutePath());
                    fs.delete();
                }
                boolean stageMdHandled = false;
                for (URI builtResource : URIUtils.getMappingBuiltFiles((URI)Util.convertIFileToEMFURI((IFile)f), (XDIModelURIResolver)modelResolver, (boolean)true)) {
                    IFile builtFile = Util.convertEMFURIToFile((URI)builtResource);
                    if (builtFile.exists()) {
                        try {
                            builtFile.delete(true, monitor);
                        }
                        catch (CoreException e) {
                            logger.getLogger(LinkedFileJob.class).trace(String.format("Failed to delete %s", builtFile), (Object)e);
                        }
                        if (stageMdHandled) continue;
                        try {
                            try {
                                IResource[] m = builtFile.getParent().members();
                                if (m != null) {
                                    Stream.of(m).filter(r -> r.getType() == 1 && "md".endsWith(r.getFileExtension()) && r.getFullPath().removeFileExtension().lastSegment().startsWith(String.valueOf(builtFile.getFullPath().removeFileExtension().lastSegment()) + "-ref-")).forEach(r -> {
                                        try {
                                            r.delete(true, monitor);
                                        }
                                        catch (CoreException e) {
                                            logger.getLogger(LinkedFileJob.class).trace(String.format("Failed to delete %s", builtFile), (Object)e);
                                        }
                                    });
                                }
                            }
                            catch (CoreException e) {
                                logger.getLogger(LinkedFileJob.class).trace(String.format("Failed to delete %s", builtFile), (Object)e);
                                stageMdHandled = true;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            stageMdHandled = true;
                            throw throwable;
                        }
                        stageMdHandled = true;
                        continue;
                    }
                    java.nio.file.Path p = null;
                    try {
                        p = modelResolver.resolve(builtResource).toPath();
                        Files.deleteIfExists(p);
                    }
                    catch (Exception e) {
                        logger.getLogger(LinkedFileJob.class).trace(String.format("Failed to delete %s", p != null ? p : builtResource), (Object)e);
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus moveOrRemoveLinkedFile(int mode, IPath fromPath, IPath toPath, IProgressMonitor monitor, Map<String, String> oldIdToNewId) {
        LogService logger = (LogService)E4InjectorHelper.getService(LogService.class);
        if (fromPath != null) {
            Logger.getLogger("com.indy.emf.uri").info(String.valueOf(Messages.LinkedFileJob_1) + toPath);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fromPath);
            if (mode == 2) {
                return LinkedFileJob.handleRemove(file, monitor);
            }
            IContainer container = file.getParent();
            ICacheService.IWorkspaceSynchronizer synchronizer = (ICacheService.IWorkspaceSynchronizer)E4InjectorHelper.getService(ICacheService.IWorkspaceSynchronizer.class);
            try {
                List list = Util.getWorkDirectories((IPath)fromPath);
                String fromName = Util.removeLastFileExtension((String)fromPath.lastSegment());
                for (IPath path : list) {
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                    if (folder.exists()) {
                        IResource[] iResourceArray = folder.members();
                        int n = iResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource r = iResourceArray[n2];
                            if (r.getType() == 1) {
                                String tmp = null;
                                tmp = "cross".equals(r.getFileExtension()) && r.getProjectRelativePath().removeFileExtension().lastSegment().equals(fromPath.lastSegment()) ? Util.removeLastFileExtension((String)Util.removeLastFileExtension((String)r.getFullPath().lastSegment())) : Util.removeLastFileExtension((String)r.getFullPath().lastSegment());
                                boolean isBuiltStageMd = LinkedFileJob.checkIsBuildStage(file, r);
                                if (tmp.equals(fromName) || isBuiltStageMd) {
                                    String extension = Util.getLastFileExtension((String)r.getFullPath().lastSegment());
                                    if (mode == 1 || mode == 3) {
                                        ArrayList<String> difference = new ArrayList<String>();
                                        int depth = r.getFullPath().segmentCount() - fromPath.segmentCount();
                                        if (path.segmentCount() > 1 && "indy.build".equals(path.segment(1))) {
                                            --depth;
                                        }
                                        int i = depth + 1;
                                        while (i > 1) {
                                            difference.add(r.getFullPath().segment(r.getFullPath().segmentCount() - i));
                                            --i;
                                        }
                                        String toName = Util.removeLastFileExtension((String)toPath.lastSegment());
                                        IPath destination = toPath.removeLastSegments(1);
                                        if (((IFile)r).getFileExtension() != null && !((IFile)r).getFileExtension().contains("_diagram")) {
                                            IPath p = new Path("/" + destination.segment(0)).append(Constants.indyWorkBuildDirectoryName);
                                            int i2 = 1;
                                            while (i2 < destination.segmentCount()) {
                                                p = p.append(destination.segment(i2));
                                                ++i2;
                                            }
                                            destination = p;
                                        }
                                        for (String segment : difference) {
                                            destination = destination.append(segment);
                                        }
                                        if (isBuiltStageMd) {
                                            String refUuidPart = Util.removeLastFileExtension((String)r.getFullPath().lastSegment());
                                            refUuidPart = refUuidPart.substring(refUuidPart.indexOf("-ref-"));
                                            destination = destination.append(String.valueOf(toName) + refUuidPart);
                                        } else {
                                            destination = destination.append(toName);
                                        }
                                        if ("cross".equals(r.getFileExtension())) {
                                            String s = r.getFullPath().removeFileExtension().lastSegment();
                                            destination = destination.addFileExtension(new Path(s).getFileExtension());
                                        }
                                        destination = destination.addFileExtension(extension);
                                        Util.mkDirRecursively((IPath)destination.removeLastSegments(1), (IProgressMonitor)monitor);
                                        if (mode == 1) {
                                            if (!LinkedFileJob.isMappingProcessDiagram(r)) {
                                                IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(destination);
                                                if (f.exists()) {
                                                    try {
                                                        f.setContents(((IFile)r).getContents(), 3, monitor);
                                                    }
                                                    catch (Exception ex) {
                                                        r.move(destination, true, monitor);
                                                    }
                                                    r.delete(3, monitor);
                                                } else {
                                                    r.move(destination, true, monitor);
                                                }
                                                Logger.getLogger("com.indy.emf.uri").info("moved " + r.getLocation() + " to " + destination);
                                                if (!fromName.equals(toName) && extension.endsWith("diagram")) {
                                                    Util.changeIdIntoGMFResource((IPath)destination, null, (IPath)fromPath, (IPath)toPath);
                                                    Logger.getLogger("com.indy.emf.uri").info("updated GMF paths " + r.getLocation() + " to " + destination);
                                                }
                                            }
                                        } else if (!(mode != 3 || LinkedFileJob.isMappingProcessDiagram(r) || "indy.build".equals(r.getProjectRelativePath().segment(0)) || "map_ref".equals(r.getFileExtension()))) {
                                            URI dest = Util.convertIPathToEMFURI2((IPath)destination);
                                            IFile dest2 = Util.convertEMFURIToFile((URI)dest);
                                            if (dest2 != null && dest2.exists()) {
                                                dest2.delete(true, monitor);
                                                Logger.getLogger("com.indy.emf.uri").info("updated deleted " + dest2.getLocation());
                                            }
                                            r.copy(dest2.getFullPath(), true, monitor);
                                            try {
                                                oldIdToNewId.putAll(ActionReinitId.reinit(toPath, Collections.singleton(dest2), monitor, oldIdToNewId));
                                            }
                                            catch (Exception ex) {
                                                logger.getLogger(LinkedFileJob.class).warn(String.format("Failed to re-init model ids when moving resources to %s", toPath), (Object)ex);
                                            }
                                            Logger.getLogger("com.indy.emf.uri").info("copied " + r.getLocation() + " at " + dest2.getLocation());
                                            if (extension.endsWith("diagram")) {
                                                Util.changeIdIntoGMFResource((IPath)destination, oldIdToNewId, (IPath)fromPath, (IPath)toPath);
                                                logger.getLogger(LinkedFileJob.class).info("updated GMF paths " + r.getLocation() + " to " + destination);
                                            }
                                            if (r.getProjectRelativePath().segment(0).equals("indy.build") && ("md".equals(r.getFileExtension()) || "proc".equals(r.getFileExtension()))) {
                                                synchronizer.handleAddedFile(Util.convertIFileToEMFURI((IFile)((IFile)r)));
                                            }
                                        }
                                    } else if (mode == 2) {
                                        if (LinkedFileJob.isMappingProcess(r)) {
                                            String modelId = String.valueOf(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(Util.convertIFileToEMFURI((IFile)((IFile)r)))) + ".proc_diagram";
                                            IPath p = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.indy.gmf.map.diagram")).append(modelId);
                                            File f = p.toFile();
                                            if (f.exists()) {
                                                f.delete();
                                                Logger.getLogger("com.indy.emf.uri").info("deleted  " + f.getAbsolutePath());
                                            }
                                        }
                                        IContainer c = r.getParent();
                                        r.delete(3, monitor);
                                    }
                                }
                            }
                            ++n2;
                        }
                        continue;
                    }
                    if (mode != 1 || !"map".equals(fromPath.getFileExtension()) && !"proc".equals(fromPath.getFileExtension()) || path.segmentCount() < 3 || !path.segment(path.segmentCount() - 2).equals("indy.diagram")) continue;
                    List l = Util.getWorkDirectories((IPath)toPath);
                    IPath diagramPath = l.size() == 1 ? ((IPath)l.get(0)).append(String.valueOf(toPath.lastSegment()) + "_diagram") : ((IPath)l.get(1)).append(String.valueOf(toPath.lastSegment()) + "_diagram");
                    IFile diagramFile = ResourcesPlugin.getWorkspace().getRoot().getFile(diagramPath);
                    if (diagramFile == null || !diagramFile.exists()) continue;
                    Util.changePathIntoGMFResource((IPath)diagramPath, oldIdToNewId);
                }
            }
            catch (Exception e) {
                String t = null;
                switch (mode) {
                    case 3: {
                        t = " Copy ";
                        break;
                    }
                    case 1: {
                        t = " Move ";
                        break;
                    }
                    case 2: {
                        t = " Remove ";
                    }
                }
                String fromClause = "";
                if (fromPath != null) {
                    fromClause = " from " + fromPath.toOSString();
                }
                String toClause = "";
                if (toPath != null) {
                    toClause = " to " + toPath.toOSString();
                }
                return new Status(4, "com.indy.emf.uri", "Failed to " + t + fromClause + toClause, (Throwable)e);
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static boolean checkIsBuildStage(IFile file, IResource r) {
        return "map".equals(file.getFileExtension()) && "md".equals(r.getFileExtension()) && r.getName().startsWith(String.valueOf(Util.removeLastFileExtension((String)file.getName())) + "-ref-");
    }

    private static boolean isMappingProcessDiagram(IResource r) {
        return "proc_diagram".equals(r.getFileExtension()) && r.getParent().getName().equals("map") && r.getParent().getParent() != null && r.getParent().getParent().getType() == 2 && r.getParent().getParent().getName().equals("indy.diagram");
    }

    private static boolean isMappingProcess(IResource r) {
        return "proc".equals(r.getFileExtension()) && r.getProjectRelativePath().segment(0).equals(Constants.indyWorkBuildDirectoryName);
    }

    protected IStatus run(IProgressMonitor monitor) {
        ArrayList<IStatus> children = new ArrayList<IStatus>();
        int code = 0;
        for (IResourceDelta resource : this.resources) {
            IPath fromPath = null;
            IPath toPath = resource.getFullPath();
            if (this.mode == 1) {
                monitor.beginTask("Move", 1);
                fromPath = resource.getMovedFromPath();
            } else if (this.mode == 2) {
                monitor.beginTask("Remove", 1);
                fromPath = resource.getFullPath();
            } else if (this.mode == 3) {
                monitor.beginTask("Copy", 1);
                fromPath = resource.getFullPath();
                this.mode = 1;
                if ("win32".equals(Platform.getOS()) && !fromPath.segment(1).equals("indy.build") && fromPath.toString().equalsIgnoreCase(toPath.toString())) {
                    IFolder f;
                    Path caseChangedFolderPath = null;
                    Path caseOriginalFolderPath = null;
                    int i = 1;
                    while (i < fromPath.segmentCount() - 1) {
                        if (!fromPath.segment(i).equals(toPath.segment(i))) {
                            caseChangedFolderPath = new Path("");
                            caseOriginalFolderPath = new Path("");
                            int k = 1;
                            while (k <= i) {
                                caseChangedFolderPath = caseChangedFolderPath.append(toPath.segment(k));
                                caseOriginalFolderPath = caseOriginalFolderPath.append(fromPath.segment(k));
                                ++k;
                            }
                            break;
                        }
                        ++i;
                    }
                    if (caseChangedFolderPath != null && !(f = resource.getResource().getProject().getFolder(__buildPath.append(caseChangedFolderPath.toString()))).exists()) {
                        f = resource.getResource().getProject().findMember(__buildPath.append(caseOriginalFolderPath.toString()));
                        IPath tmp = null;
                        IPath dest = null;
                        try {
                            tmp = resource.getResource().getProject().getFullPath().append(__tmpMoveDestinationPath);
                            f.move(tmp, true, monitor);
                            f = resource.getResource().getProject().getWorkspace().getRoot().findMember(tmp);
                            dest = resource.getResource().getProject().getFullPath().append(__buildPath).append((IPath)caseChangedFolderPath);
                            f.move(dest, true, monitor);
                            f = resource.getResource().getProject().getWorkspace().getRoot().findMember(dest);
                        }
                        catch (Exception ex) {
                            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(LinkedFileJob.class).error("Move issue", (Object)ex);
                        }
                    }
                }
            } else if (this.mode == 2) {
                monitor.beginTask("Remove", 1);
                fromPath = resource.getFullPath();
            } else if (this.mode == 3) {
                monitor.beginTask("Copy", 1);
                fromPath = resource.getFullPath();
                this.mode = 1;
            }
            IStatus st = LinkedFileJob.moveOrRemoveLinkedFile(this.mode, fromPath, toPath, monitor, null);
            children.add(st);
            code = Math.max(code, st.getSeverity());
            this.log(st, fromPath, toPath);
        }
        return new MultiStatus("com.indy.emf.uri", code, children.toArray(new IStatus[children.size()]), "Linked Job Result", null);
    }

    private void log(IStatus st, IPath fromPath, IPath toPath) {
        Logger l = Logger.getLogger("com.indy.emf.uri");
        String t = null;
        switch (this.mode) {
            case 3: {
                t = " Copy ";
                break;
            }
            case 1: {
                t = " Move ";
                break;
            }
            case 2: {
                t = " Remove ";
            }
        }
        String fromClause = "";
        if (fromPath != null) {
            fromClause = this.mode == 2 ? fromPath.toOSString() : " from " + fromPath.toOSString();
        }
        String toClause = "";
        if (toPath != null && this.mode != 2) {
            toClause = " to " + toPath.toOSString();
        }
        if (st.isOK()) {
            l.info(String.valueOf(t) + fromClause + toClause);
        } else {
            l.log(Level.SEVERE, "Failed to " + t + fromClause + toClause, st.getException());
        }
    }
}

