/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.internal.ICacheConsole;
import com.indy.emf.uri.internal.MarkerHelper;
import com.indy.ui.custom.out.tools.ApplicationHelper;
import com.semarchy.xdi.designer.core.services.ICacheService;
import java.io.IOException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ICacheConsole.class}, immediate=true)
public class WorkspaceCallbackComponent
implements ICacheConsole {
    MessageConsole console;
    private ICacheService cacheService;

    @Reference(service=ICacheService.class, policy=ReferencePolicy.DYNAMIC)
    public void bind(ICacheService cache) {
        cache.addUpdateTask(Messages.WorkspaceCallbackComponent_refreshConsoleSubtask, () -> this.refreshConsole());
        cache.addUpdateTask(Messages.WorkspaceCallbackComponent_updatingMarkerSubtask, () -> this.updateMarkers());
        this.cacheService = cache;
    }

    public void unbind(ICacheService cache) {
        cache.removeUpdateTask(Messages.WorkspaceCallbackComponent_refreshConsoleSubtask);
        cache.removeUpdateTask(Messages.WorkspaceCallbackComponent_updatingMarkerSubtask);
        this.cacheService = null;
    }

    @Override
    public void refreshAndActivate() {
        this.refreshConsole();
        this.console.activate();
    }

    private MessageConsole getConsole() {
        if (this.console == null) {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            this.console = new MessageConsole("Cache", null);
            conMan.addConsoles(new IConsole[]{this.console});
        }
        return this.console;
    }

    private void refreshConsole() {
        if (!ApplicationHelper.isRunningWorkbench()) {
            return;
        }
        this.getConsole().clearConsole();
        ICacheService.Statistics stat = this.cacheService.getStatistics();
        String msg = Messages.bind((String)Messages.WorkspaceCallbackComponent_cacheConsole, (Object[])new Object[]{stat.getResourcesNumber(), stat.getElementNumber()});
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (MessageConsoleStream stream = this.console.newMessageStream();){
                stream.println(msg);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void updateMarkers() {
        try {
            MarkerHelper.INSTANCE.updateStambiaMarkers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

