/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal;

import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.BuiltPlatformResourceURIHandler;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={XDIModelURIResolver.class})
public class WorkspaceXDIModelURIResolver
implements XDIModelURIResolver {
    @Reference
    private IWorkspace workspace;

    public File resolve(URI uri) {
        File res = null;
        if (uri == null) {
            return null;
        }
        if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            if (path.segmentCount() == 1) {
                IProject p = (IProject)this.workspace.getRoot().findMember(path.toString());
                String filePath = p.getLocationURI().getPath().toString();
                res = new File(URI.decode((String)filePath));
            } else {
                IPath p = this.workspace.getRoot().getFile((IPath)path).getLocation();
                if (p != null) {
                    String filePath = p.toFile().toURI().getPath().toString();
                    res = new File(URI.decode((String)filePath));
                }
            }
        } else {
            StringBuilder s;
            URI resolvedUri;
            URI u;
            String fileID;
            if (uri.fragment() != null && (fileID = CacheHelper.extractFileID((String)uri.fragment())) != null && (u = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(fileID)) != null) {
                uri = u;
            }
            if (!(resolvedUri = CommonPlugin.resolve((URI)uri)).isHierarchical() || !"file".equals(resolvedUri.scheme())) {
                s = new StringBuilder();
                int i = 2;
                while (i < uri.segmentCount()) {
                    s.append("/");
                    s.append(URI.decode((String)uri.trimFragment().segment(i)));
                    ++i;
                }
                IPath p = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.semarchy.xdi.designer.index")).append("/internalResource").append("/" + s.toString());
                res = p.toFile();
            } else {
                s = new StringBuilder();
                if (resolvedUri.device() != null) {
                    s.append(resolvedUri.device());
                }
                int i = 0;
                while (i < resolvedUri.segmentCount()) {
                    s.append("/");
                    s.append(resolvedUri.trimFragment().segment(i));
                    ++i;
                }
                res = new File(URI.decode((String)s.toString()));
            }
        }
        return res;
    }

    public List<URI> getAllModels() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            root.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ArrayList<URI> res = new ArrayList<URI>();
        try {
            root.accept(r -> {
                switch (r.getType()) {
                    case 1: {
                        res.add(Util.convertIFileToEMFURI((IFile)((IFile)r)));
                        return true;
                    }
                    case 4: {
                        return r.getProject().isOpen();
                    }
                    case 2: {
                        return !"indy.diagram".equals(r.getName());
                    }
                }
                return true;
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return res;
    }

    public ISchedulingRule createSchedulingRule(URI resourceURI) {
        if (resourceURI == null) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        IFile rule = Util.convertEMFURIToFile((URI)resourceURI);
        if ("map".equals(resourceURI.fileExtension())) {
            URI procURI = URIUtils.getMappingBuiltProcFile((URI)resourceURI);
            IContainer buildFolder = Util.convertEMFURIToFile((URI)procURI).getParent();
            rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)buildFolder);
            rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)Util.convertEMFURIToFile((URI)resourceURI.trimFileExtension().appendFileExtension("map_ref")));
            IFolder projectBuildFolder = buildFolder.getProject().getFolder("indy.build");
            if (!projectBuildFolder.exists() || !projectBuildFolder.isLinked()) {
                rule = MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)projectBuildFolder.getProject());
            }
        }
        return rule;
    }

    public boolean exists(URI resourceURI) {
        File f = this.resolve(resourceURI);
        return f != null && f.isFile() && f.exists();
    }

    public void deleteResource(URI resourceURI) throws Exception {
        IFile f = Util.convertEMFURIToFile((URI)resourceURI);
        if (f.exists()) {
            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void refreshResurce(URI resourceURI) throws Exception {
        IFile f = Util.convertEMFURIToFile((URI)resourceURI);
        IFolder buildFolder = f.getProject().getFolder("indy.build");
        if (!buildFolder.exists() || !buildFolder.isLinked()) {
            IPath buildPath = BuiltPlatformResourceURIHandler.getBuildFolder().append(f.getProject().getName());
            buildFolder.createLink(buildPath, 272, (IProgressMonitor)new NullProgressMonitor());
        }
        f.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
    }
}

