/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal.workspace;

import com.indy.emf.uri.internal.workspace.LinkedFileOperationBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class MoveProjectOperation
implements LinkedFileOperationBuilder.Operation {
    private IWorkspace workspace;
    private Logger logger = LogManager.getLogger(this.getClass());
    private IProject newProject;
    private String oldProjectName;

    MoveProjectOperation(IWorkspace wksp, IPath from, IPath toPath) {
        this.workspace = wksp;
        this.newProject = this.workspace.getRoot().getProject(toPath.toString());
        this.oldProjectName = from.segment(0);
    }

    @Override
    public void perform() {
        File newFolder;
        File oldFolder;
        block17: {
            IPath linkPath = new Path("WORKSPACE_LOC").append("/.indy.build").append(this.newProject.getName());
            IFolder buildFolder = this.newProject.getFolder("indy.build");
            try {
                buildFolder.createLink(linkPath, 272, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                this.logger.error(() -> String.format("Failed to create linked folder %s", linkPath.toString()), (Throwable)e);
            }
            URI newFolderURI = buildFolder.getLocationURI();
            URI oldFolderURI = this.workspace.getRoot().getLocationURI();
            oldFolder = new File(new File(oldFolderURI), ".indy.build/" + this.oldProjectName);
            newFolder = new File(newFolderURI);
            try {
                if (!Files.exists(newFolder.toPath(), new LinkOption[0])) break block17;
                Throwable throwable = null;
                Object var8_13 = null;
                try (Stream<java.nio.file.Path> stream = Files.walk(newFolder.toPath(), new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).map(java.nio.file.Path::toFile).forEach(File::delete);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.error(() -> String.format("Failed to delete %s", oldFolder), (Throwable)e);
            }
        }
        try {
            Files.move(oldFolder.toPath(), newFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.logger.error(() -> String.format("Failed to move %s to %s", oldFolder, newFolder), (Throwable)e);
        }
        try {
            this.newProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.logger.error(() -> String.format("Failed to refresh %s", this.newProject.getName()), (Throwable)e);
        }
    }

    @Override
    public ISchedulingRule getRule() {
        AtomicReference<IProject> ruleRef = new AtomicReference<IProject>(this.newProject);
        return (ISchedulingRule)ruleRef.get();
    }
}

