/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal.workspace;

import com.indy.administration.AdministrationHelper;
import com.indy.emf.uri.Activator;
import com.indy.emf.uri.internal.workspace.LinkedFileOperationBuilder;
import com.indy.ui.custom.out.EngineVariable;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.progress.WorkbenchJob;

public class WorkspaceListener
implements IResourceChangeListener {
    static final String BUILD_FOLDER_NAME = "indy.build";
    static Set<String> extensions = new HashSet<String>(Arrays.asList("map", "proc", "tech", "tech_ext", "md", "tpc", "translation"));
    List<IResourceDelta> moved;
    List<IResourceDelta> added;
    List<IResourceDelta> changed;
    List<IResourceDelta> removed;
    IResourceDelta projectMovedDelta;
    MessageConsole console;
    private List<IResourceDelta> copied;
    private final Logger logger = LogManager.getLogger(this.getClass());

    private void reset() {
        this.projectMovedDelta = null;
        this.copied = new ArrayList<IResourceDelta>();
        this.moved = new ArrayList<IResourceDelta>();
        this.added = new ArrayList<IResourceDelta>();
        this.changed = new ArrayList<IResourceDelta>();
        this.removed = new ArrayList<IResourceDelta>();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        if (!cacheService.isInit()) {
            return;
        }
        ICacheService.IWorkspaceSynchronizer wkspSynchronizer = (ICacheService.IWorkspaceSynchronizer)E4InjectorHelper.getService(ICacheService.IWorkspaceSynchronizer.class);
        try {
            this.reset();
            IResourceDelta docDelta = event.getDelta();
            if (docDelta == null || event.getType() != 1) {
                return;
            }
            this.visitDelta(docDelta);
            LinkedFileOperationBuilder operationBuilder = new LinkedFileOperationBuilder();
            this.handleMoved(wkspSynchronizer, operationBuilder);
            this.handleRemoved(wkspSynchronizer, operationBuilder);
            this.handleChanged(wkspSynchronizer);
            this.handleAdded(wkspSynchronizer);
            this.handleCopied(operationBuilder);
            this.runJob(cacheService, operationBuilder);
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private void visitDelta(IResourceDelta docDelta) {
        Visitor visitor = new Visitor();
        try {
            docDelta.accept((IResourceDeltaVisitor)visitor);
            this.projectMovedDelta = visitor.movedProject;
            this.removed = this.removed.stream().filter(ird -> !visitor.movedModels.contains(ird.getResource().getFullPath())).collect(Collectors.toList());
            this.added = this.added.stream().filter(ird -> !visitor.movedModels.contains(ird.getResource().getFullPath())).collect(Collectors.toList());
        }
        catch (CoreException e) {
            this.logger.error(() -> "Failed to handle workspace content change", (Throwable)e);
        }
    }

    private void handleAdded(ICacheService.IWorkspaceSynchronizer wkspSynchronizer) {
        for (IResourceDelta ird : this.added) {
            IResource res = ird.getResource();
            wkspSynchronizer.handleAddedFile(URIUtils.convertIPathToEMFURI2((IPath)res.getFullPath()));
            this.logger.info(() -> "added " + res.getFullPath());
            boolean replaceWithoutConfirm = EngineVariable.INSTANCE.getReplaceFileWithOutConfirm().contains(res.getFullPath().toString());
            if (!replaceWithoutConfirm) continue;
            EngineVariable.INSTANCE.getReplaceFileWithOutConfirm().remove(res.getFullPath().toString());
        }
    }

    private void handleCopied(LinkedFileOperationBuilder operationBuilder) {
        ArrayList<IPath> copiedPath = new ArrayList<IPath>();
        for (IResourceDelta ird : this.copied) {
            copiedPath.add(ird.getResource().getFullPath());
            this.logger.debug(() -> "copied " + ird.getMovedFromPath() + " to " + ird.getResource().getFullPath());
        }
        if (!copiedPath.isEmpty()) {
            operationBuilder.handleFileCopied(copiedPath);
        }
    }

    private void handleChanged(ICacheService.IWorkspaceSynchronizer wkspSynchronizer) {
        for (IResourceDelta ird : this.changed) {
            wkspSynchronizer.handleModifiedFile(URIUtils.convertIPathToEMFURI2((IPath)ird.getResource().getFullPath()));
            this.logger.info(() -> "changed " + ird.getResource().getFullPath());
        }
    }

    private void handleRemoved(ICacheService.IWorkspaceSynchronizer wkspSynchronizer, LinkedFileOperationBuilder operationBuilder) {
        for (IResourceDelta ird : this.removed) {
            wkspSynchronizer.handleDeletedFile(URIUtils.convertIPathToEMFURI2((IPath)ird.getResource().getFullPath()));
            this.logger.info(() -> "deleted " + ird.getResource().getFullPath());
            operationBuilder.handleFileDeleted(ird.getResource().getFullPath());
        }
    }

    private void handleMoved(ICacheService.IWorkspaceSynchronizer wkspSynchronizer, LinkedFileOperationBuilder operationBuilder) {
        if (this.projectMovedDelta != null) {
            operationBuilder.handleProjectMoved(this.projectMovedDelta.getMovedFromPath(), this.projectMovedDelta.getResource().getFullPath());
        }
        for (IResourceDelta ird : this.moved) {
            wkspSynchronizer.handleMoveFile(URIUtils.convertIPathToEMFURI2((IPath)ird.getResource().getFullPath()), ird.getMovedFromPath());
            this.logger.info(() -> "moved " + ird.getMovedFromPath() + " to " + ird.getResource().getFullPath());
            if (this.projectMovedDelta == null) {
                operationBuilder.handleFileMoved(ird.getMovedFromPath(), ird.getResource().getFullPath());
            }
            this.removed.remove(ird);
        }
    }

    private void runJob(final ICacheService cacheService, final LinkedFileOperationBuilder builder) {
        if (builder.isEmpty() && this.added.isEmpty() && this.changed.isEmpty()) {
            return;
        }
        WorkbenchJob j = new WorkbenchJob("Linked Resource synchronization"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Job.getJobManager().cancel((Object)"MAPPING_BUILD_JOB_FAMILY");
                try {
                    cacheService.enableTrigger(false);
                    builder.runOperations(monitor);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception ex) {
                    Status status = new Status(4, ((Object)((Object)this)).getClass(), "Linked workspace operations failed", (Throwable)ex);
                    return status;
                }
                finally {
                    cacheService.enableTrigger(true);
                }
            }
        };
        j.setRule(builder.computeSchedulingRule());
        j.schedule(100L);
    }

    public class Visitor
    implements IResourceDeltaVisitor {
        private Set<IPath> movedModels = new HashSet<IPath>();
        private IResourceDelta movedProject;

        void handleAdded(IResourceDelta delta) {
            if ((delta.getFlags() & 0x1000) != 0) {
                WorkspaceListener.this.moved.add(delta);
                this.movedModels.add(delta.getMovedFromPath());
            } else if ((delta.getFlags() & 0x800) != 0) {
                WorkspaceListener.this.copied.add(delta);
                WorkspaceListener.this.added.add(delta);
            } else {
                WorkspaceListener.this.added.add(delta);
            }
        }

        void handleRemoved(IResourceDelta delta) {
            if ((delta.getFlags() & 0x2000) == 0) {
                WorkspaceListener.this.removed.add(delta);
            }
        }

        void handleChanged(IResourceDelta delta) {
            if ((delta.getFlags() & 0x100) != 0) {
                WorkspaceListener.this.changed.add(delta);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getResource().getType() == 1 && "tech".equals(delta.getResource().getFileExtension()) && !AdministrationHelper.supportTechModelFromWorkspace()) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 4 && (delta.getFlags() & 0x1000) != 0) {
                this.movedProject = delta;
            }
            if (resource.getType() != 1) {
                return true;
            }
            if (resource.getFileExtension() == null || !extensions.contains(resource.getFileExtension())) {
                return false;
            }
            switch (delta.getKind()) {
                case 1: {
                    this.handleAdded(delta);
                    break;
                }
                case 2: {
                    this.handleRemoved(delta);
                    break;
                }
                case 4: {
                    this.handleChanged(delta);
                }
            }
            return true;
        }
    }
}

