/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.validation2;

import com.indy.administration.AdministrationService;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseOffline;
import com.semarchy.xdi.designer.preferences.license.LicenseServer;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.Bundle;

public class PopupValidation
extends Dialog {
    public static final int APPLY_ID = 8;
    public static final int STOP_ID = 9;
    public static final int CONTINUE_ID = 10;
    public static final int CANCEL_ID = 11;
    private Button offline;
    private Button local;
    private Button online;
    private Text keyFile;
    private Text licenseServerURL;
    private Text licenseKey;
    private Bean data = new Bean();
    private String message;

    protected PopupValidation(Shell parentShell, String msg, PopupType popupType) {
        super(parentShell);
        this.data.popupType = popupType;
        this.message = msg;
        this.setShellStyle(68720);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PopupValidation_popupRegisterLicenseTitle);
    }

    protected Point getInitialSize() {
        return new Point(600, 350);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button openProxySettings = new Button(parent, 8);
        openProxySettings.setText(Messages.PopupValidation_8);
        openProxySettings.setLayoutData((Object)new GridData(1, 2, false, false));
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.net");
        if (bundle == null) {
            openProxySettings.setEnabled(false);
        }
        openProxySettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dial = PreferencesUtil.createPreferenceDialogOn((Shell)new Shell(Display.getCurrent()), (String)"org.eclipse.ui.net.NetPreferences", null, null);
                dial.open();
            }
        });
        switch (this.data.popupType) {
            case POPUP_FIRST_CONNECTION: {
                this.createButton(parent, 8, Messages.PopupValidation_register, true);
                this.createButton(parent, 9, Messages.PopupValidation_17, false);
                break;
            }
            case POPUP_FIRST_LEVEL_TOLERANCE: {
                this.createButton(parent, 8, Messages.PopupValidation_register, false);
                this.createButton(parent, 10, Messages.PopupValidation_19, true);
                this.createButton(parent, 9, Messages.PopupValidation_20, false);
                break;
            }
            case POPUP_MANAGER: {
                this.createButton(parent, 11, IDialogConstants.CANCEL_LABEL, false);
                this.createButton(parent, 8, Messages.PopupValidation_register, true);
                break;
            }
            case POPUP_SECOND_LEVEL_TOLERANCE: {
                this.createButton(parent, 8, Messages.PopupValidation_register, true);
                this.createButton(parent, 9, Messages.PopupValidation_24, false);
                break;
            }
            default: {
                this.createButton(parent, 8, Messages.PopupValidation_register, false);
                this.createButton(parent, 10, Messages.PopupValidation_26, true);
                this.createButton(parent, 9, Messages.PopupValidation_27, false);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(1808));
        Group group = new Group(main, 0);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setText(Messages.PopupValidation_licenseOrigin);
        group.setLayout((Layout)new GridLayout());
        this.offline = new Button((Composite)group, 16);
        this.offline.setLayoutData((Object)new GridData());
        this.offline.setText(Messages.PopupValidation_licenseKeyFile);
        this.local = new Button((Composite)group, 16);
        this.local.setLayoutData((Object)new GridData());
        this.local.setText(Messages.PopupValidation_licenseLocalServerUrl);
        this.online = new Button((Composite)group, 16);
        this.online.setLayoutData((Object)new GridData());
        this.online.setText(Messages.PopupValidation_licenseCentralServerURL);
        final Composite keyFileC = new Composite(main, 0);
        keyFileC.setLayoutData((Object)new GridData(4, 1, true, false));
        keyFileC.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(keyFileC, 0);
        l.setText(Messages.PopupValidation_licenseKeyFile);
        l.setLayoutData((Object)new GridData());
        this.keyFile = new Text(keyFileC, 2048);
        this.keyFile.setLayoutData((Object)new GridData(4, 1, true, false));
        final Button browser = new Button(keyFileC, 8);
        browser.setText("...");
        browser.setLayoutData((Object)new GridData(3, 1, false, false));
        final Composite server = new Composite(main, 0);
        server.setLayoutData((Object)new GridData(4, 4, true, true));
        server.setLayout((Layout)new GridLayout(2, false));
        l = new Label(server, 0);
        l.setText(Messages.PopupValidation_licenseServerURL);
        l.setLayoutData((Object)new GridData());
        this.licenseServerURL = new Text(server, 2048);
        this.licenseServerURL.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite key = new Composite(main, 0);
        key.setLayout((Layout)new GridLayout(2, false));
        l = new Label(server, 0);
        l.setText(Messages.PopupValidation_licenseKey);
        l.setLayoutData((Object)new GridData(1, 1, false, false));
        this.licenseKey = new Text(server, 2626);
        this.licenseKey.setLayoutData((Object)new GridData(4, 4, true, true));
        this.keyFile.setText(this.data.keyFile);
        if (this.data.mode == Validation.Mode.TRIAL || this.data.mode == Validation.Mode.ONLINE) {
            this.licenseServerURL.setText(this.data.onlineURL);
        } else {
            this.licenseServerURL.setText(this.data.localURL);
        }
        this.licenseKey.setText(this.data.licenseKey);
        SelectionAdapter radioAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean wasOffline = ((PopupValidation)PopupValidation.this).data.mode == Validation.Mode.OFFLINE;
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    if (b == PopupValidation.this.offline) {
                        PopupValidation.this.keyFile.setEnabled(true);
                        keyFileC.setVisible(true);
                        ((GridData)keyFileC.getLayoutData()).exclude = false;
                        browser.setEnabled(true);
                        server.setVisible(false);
                        ((PopupValidation)PopupValidation.this).data.mode = Validation.Mode.OFFLINE;
                    } else if (b == PopupValidation.this.local) {
                        PopupValidation.this.keyFile.setEnabled(false);
                        keyFileC.setVisible(false);
                        ((GridData)keyFileC.getLayoutData()).exclude = true;
                        browser.setEnabled(false);
                        server.setVisible(true);
                        PopupValidation.this.licenseServerURL.setText(((PopupValidation)PopupValidation.this).data.localURL);
                        PopupValidation.this.licenseServerURL.setEnabled(true);
                        ((PopupValidation)PopupValidation.this).data.mode = Validation.Mode.LOCAL;
                    } else if (b == PopupValidation.this.online) {
                        PopupValidation.this.keyFile.setEnabled(false);
                        keyFileC.setVisible(false);
                        ((GridData)keyFileC.getLayoutData()).exclude = true;
                        browser.setEnabled(false);
                        server.setVisible(true);
                        ((PopupValidation)PopupValidation.this).data.mode = Validation.Mode.ONLINE;
                        PopupValidation.this.licenseServerURL.setText(((PopupValidation)PopupValidation.this).data.onlineURL);
                        PopupValidation.this.licenseServerURL.setEnabled(false);
                    }
                }
                if (wasOffline || ((PopupValidation)PopupValidation.this).data.mode == Validation.Mode.OFFLINE) {
                    keyFileC.getParent().layout(true);
                }
            }
        };
        this.offline.addSelectionListener((SelectionListener)radioAdapter);
        this.local.addSelectionListener((SelectionListener)radioAdapter);
        this.online.addSelectionListener((SelectionListener)radioAdapter);
        browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(PopupValidation.this.getShell(), 4096);
                if (fd.open() != null) {
                    ((PopupValidation)PopupValidation.this).data.keyFile = String.valueOf(fd.getFilterPath()) + File.separator + fd.getFileName();
                    PopupValidation.this.keyFile.setText(((PopupValidation)PopupValidation.this).data.keyFile);
                }
            }
        });
        this.keyFile.addModifyListener(e -> this.updateKeyFile(this.keyFile.getText()));
        this.licenseKey.addModifyListener(e -> this.updateKey(this.licenseKey.getText()));
        this.licenseKey.addPaintListener(e -> {
            if (this.data.envVariableDefined.get((Object)this.data.mode).booleanValue() && this.licenseKey.getText().isEmpty() && e.display.getFocusControl() != e.widget) {
                e.gc.setForeground(e.display.getSystemColor(15));
                e.gc.drawText("XDI_DESIGNER_LICENSE_KEY", 5, 1);
            }
        });
        this.licenseServerURL.addPaintListener(e -> {
            if (this.data.envVariableDefined.get((Object)this.data.mode).booleanValue() && this.data.mode == Validation.Mode.LOCAL && this.licenseServerURL.getText().isEmpty() && e.display.getFocusControl() != e.widget) {
                e.gc.setForeground(e.display.getSystemColor(15));
                e.gc.drawText("XDI_DESIGNER_LICENSE_SERVER_URL", 5, 1);
            }
        });
        this.keyFile.addPaintListener(e -> {
            if (this.data.envVariableDefined.get((Object)this.data.mode).booleanValue() && this.data.mode == Validation.Mode.OFFLINE && this.keyFile.getText().isEmpty() && e.display.getFocusControl() != e.widget) {
                e.gc.setForeground(e.display.getSystemColor(15));
                e.gc.drawText("XDI_DESIGNER_LICENSE_KEY_FILE", 5, 1);
            }
        });
        this.licenseServerURL.addModifyListener(e -> this.updateServerURL(this.licenseServerURL.getText()));
        Event ev = new Event();
        switch (this.data.mode) {
            case LOCAL: {
                this.local.setSelection(true);
                ev.widget = this.local;
                this.local.notifyListeners(13, ev);
                break;
            }
            case OFFLINE: {
                this.offline.setSelection(true);
                ev.widget = this.offline;
                this.offline.notifyListeners(13, ev);
                break;
            }
            case ONLINE: {
                this.online.setSelection(true);
                ev.widget = this.online;
                this.online.notifyListeners(13, ev);
            }
        }
        return main;
    }

    private void updateKeyFile(String keyFile) {
        if (this.data.envVariableDefined.get((Object)this.data.mode).booleanValue() && keyFile.isEmpty()) {
            this.data.keyFile = System.getenv("XDI_DESIGNER_LICENSE_KEY_FILE");
            return;
        }
        this.data.keyFile = this.keyFile.getText();
    }

    private void updateKey(String key) {
        this.data.licenseKey = this.licenseKey.getText();
    }

    private void updateServerURL(String serverURL) {
        if (this.data.mode == Validation.Mode.LOCAL) {
            this.data.localURL = this.licenseServerURL.getText();
        }
    }

    public int open() {
        int buttonId = super.open();
        switch (buttonId) {
            case 10: {
                break;
            }
            case 9: {
                System.exit(3445);
            }
        }
        return buttonId;
    }

    private License configureLicense(License l) {
        switch (this.data.mode) {
            case LOCAL: {
                if (l == null) {
                    l = new LicenseServer(Validation.Mode.LOCAL);
                }
                ((LicenseServer)l).setLicenseServerURL(this.data.localURL);
                ((LicenseServer)l).setLicenseKey(this.data.licenseKey);
                break;
            }
            case ONLINE: {
                if (l == null) {
                    l = new LicenseServer(Validation.Mode.ONLINE);
                }
                ((LicenseServer)l).setLicenseServerURL(this.data.onlineURL);
                ((LicenseServer)l).setLicenseKey(this.data.licenseKey);
                break;
            }
            case OFFLINE: {
                if (l == null) {
                    l = new LicenseOffline();
                }
                ((LicenseOffline)l).setLicenseKeyFilePath(this.data.keyFile);
            }
        }
        return l;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        block0 : switch (buttonId) {
            case 8: {
                if (this.data.mode == Validation.Mode.OFFLINE) {
                    if (!this.data.envVariableDefined.get((Object)this.data.mode).booleanValue() && (this.data.keyFile == null || this.data.keyFile.isEmpty())) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PopupValidation_12, (String)Messages.PopupValidation_13);
                        return;
                    }
                } else if (this.data.mode == Validation.Mode.LOCAL && !this.data.envVariableDefined.get((Object)this.data.mode).booleanValue()) {
                    int i1 = this.licenseKey.getText().isEmpty() ? 1 : 0;
                    if ((i1 += this.licenseServerURL.getText().isEmpty() ? 10 : 0) != 0 && i1 != 11) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PopupValidation_12, (String)String.format(Messages.PopupValidation_errorEnvironmentVariableUsage, Messages.PopupValidation_licenseServerURL, Messages.PopupValidation_licenseKey));
                        return;
                    }
                    if (this.data.localURL.isEmpty()) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PopupValidation_12, (String)Messages.PopupValidation_15);
                        return;
                    }
                    if (this.data.licenseKey.isEmpty()) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PopupValidation_12, (String)Messages.PopupValidation_errorEmptyLicenseKey);
                        return;
                    }
                }
                License l = this.configureLicense(null);
                ValidationStatus status = l.checkValidity(new LicenseToleranceData());
                switch (status) {
                    case VALID: {
                        Validation.INSTANCE.setEnv(this.data.mode);
                        this.configureLicense(Validation.INSTANCE.getLicense());
                        Validation.INSTANCE.checkValidity();
                        AdministrationService adminService = (AdministrationService)E4InjectorHelper.getService(AdministrationService.class);
                        adminService.setCurrentRole(Validation.INSTANCE.getLicense().getRoles());
                        break block0;
                    }
                }
                String message = l.getErrorMessage();
                if (message == null) {
                    message = String.format(Messages.PopupValidation_popupRegisterFailureTitleMessage, new Object[0]);
                }
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.PopupValidation_popupRegisterFailureTitle, (String)message);
                return;
            }
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    class Bean {
        Validation.Mode mode = Validation.Mode.ONLINE;
        String licenseKey = "";
        final String onlineURL = "https://license-xdi.semarchy.com";
        String localURL = "";
        String keyFile = "";
        PopupType popupType;
        Map<Validation.Mode, Boolean> envVariableDefined = new HashMap<Validation.Mode, Boolean>();

        Bean() {
            License l = Validation.INSTANCE.getLicense();
            String _k = System.getenv("XDI_DESIGNER_LICENSE_KEY");
            String _f = System.getenv("XDI_DESIGNER_LICENSE_KEY_FILE");
            String _url = System.getenv("XDI_DESIGNER_LICENSE_SERVER_URL");
            this.envVariableDefined.put(Validation.Mode.LOCAL, _k != null && !_k.isEmpty() && _url != null && !_url.isEmpty());
            this.envVariableDefined.put(Validation.Mode.ONLINE, _k != null && !_k.isEmpty());
            this.envVariableDefined.put(Validation.Mode.OFFLINE, _f != null && !_f.isEmpty());
            if (l != null) {
                switch (l.getMode()) {
                    case LOCAL: {
                        if (((LicenseServer)l).getLicenseServerURL() != null) {
                            this.localURL = ((LicenseServer)l).getLicenseServerURL();
                        }
                        if (((LicenseServer)l).getLicenseKey() != null) {
                            this.licenseKey = ((LicenseServer)l).getLicenseKey();
                        }
                        this.mode = l.getMode();
                        break;
                    }
                    case ONLINE: {
                        this.licenseKey = ((LicenseServer)l).getLicenseKey();
                        if (((LicenseServer)l).getLicenseKey() != null) {
                            this.licenseKey = ((LicenseServer)l).getLicenseKey();
                        }
                        this.mode = l.getMode();
                        break;
                    }
                    case OFFLINE: {
                        this.keyFile = ((LicenseOffline)l).getLicenseKeyFilePath();
                        this.mode = l.getMode();
                        break;
                    }
                    case TRIAL: {
                        this.mode = Validation.Mode.ONLINE;
                    }
                }
            }
            if (this.licenseKey == null) {
                this.licenseKey = "";
            }
            if (this.localURL == null) {
                this.localURL = "";
            }
            if (this.keyFile == null) {
                this.keyFile = "";
            }
        }
    }

    static enum PopupType {
        POPUP_MANAGER,
        POPUP_SECOND_LEVEL_TOLERANCE,
        POPUP_FIRST_LEVEL_TOLERANCE,
        POPUP_FIRST_CONNECTION;

    }
}

