/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.validation2;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.PopupValidation;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.preferences.license.LicenseOffline;
import com.semarchy.xdi.designer.preferences.license.LicenseServer;
import com.semarchy.xdi.designer.preferences.license.LicenseTrial;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class ValidationJob
extends Job {
    public static final ValidationJob INSTANCE = new ValidationJob();
    public static final String REGISTER_BUTTON = Messages.ValidationJob_Register_Button;
    public static final String CLOSE_BUTTON = Messages.ValidationJob_Close_Button;
    Object lock = new Object();
    boolean popup = false;
    boolean doNothing = false;

    public ValidationJob() {
        super(Messages.ValidationJob_0);
        this.setSystem(true);
    }

    private int handleServerStatus(LicenseServer license, ValidationStatus status) {
        switch (status) {
            case TOLERANCE_2_START: {
                int ret = this.wrappedPopup(Messages.PopupValidation_0, PopupValidation.PopupType.POPUP_FIRST_LEVEL_TOLERANCE);
                if (ret == 11 || ret == 10) {
                    return Validation.INSTANCE.getLicenseTimeData().getRefreshDelay(Validation.INSTANCE.getLicense().isInTolerance());
                }
                return 0;
            }
            case TOLERANCE_END: {
                this.wrappedPopup(Messages.PopupValidation_2, PopupValidation.PopupType.POPUP_SECOND_LEVEL_TOLERANCE);
                return 0;
            }
            case VALID: 
            case TOLERANCE_2: 
            case TOLERANCE_1_START: 
            case TOLERANCE_1: 
            case CONNECTION_LOST: {
                return Validation.INSTANCE.getLicenseTimeData().getRefreshDelay(Validation.INSTANCE.getLicense().isInTolerance());
            }
        }
        this.wrappedPopup(Messages.PopupValidation_4, PopupValidation.PopupType.POPUP_FIRST_CONNECTION);
        return 0;
    }

    private int openChangeMode() {
        int ret = this.wrappedPopup(Messages.PopupValidation_1, PopupValidation.PopupType.POPUP_MANAGER);
        if (ret == 11 || ret == 10) {
            return Validation.INSTANCE.getLicenseTimeData().getRefreshDelay(Validation.INSTANCE.getLicense().isInTolerance());
        }
        return 0;
    }

    private int openKeyNotValid() {
        this.wrappedPopup(Messages.PopupValidation_3, PopupValidation.PopupType.POPUP_FIRST_CONNECTION);
        return 0;
    }

    private int wrappedPopup(final String message, final PopupValidation.PopupType mode) {
        final Integer[] retur = new Integer[1];
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                retur[0] = new PopupValidation(display.getActiveShell(), message, mode).open();
            }
        });
        return retur[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (!this.doNothing) {
            Object object = this.lock;
            synchronized (object) {
                block17: {
                    long nextDelay = 0L;
                    try {
                        try {
                            ValidationStatus status = Validation.INSTANCE.checkValidity();
                            if (Validation.INSTANCE.getLicense() instanceof LicenseServer) {
                                LicenseServer license = (LicenseServer)Validation.INSTANCE.getLicense();
                                nextDelay = this.handleServerStatus(license, status);
                            } else if (Validation.INSTANCE.getLicense() instanceof LicenseOffline) {
                                nextDelay = this.handleOfflineStatus(status);
                            } else if (Validation.INSTANCE.getLicense() instanceof LicenseTrial) {
                                LicenseTrial license = (LicenseTrial)Validation.INSTANCE.getLicense();
                                nextDelay = this.handleTrialStatus(license, status);
                            }
                        }
                        catch (Throwable e) {
                            Activator.getDefault().error(Messages.ValidationJob_8, e);
                            nextDelay = this.openKeyNotValid();
                            if (!this.doNothing) {
                                this.schedule(nextDelay);
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!this.doNothing) {
                            this.schedule(nextDelay);
                        }
                        throw throwable;
                    }
                    if (!this.doNothing) {
                        this.schedule(nextDelay);
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    private int handleOfflineStatus(ValidationStatus status) {
        int nextDelay = -1;
        nextDelay = status == ValidationStatus.EXPIRATION ? this.openChangeMode() : (status != ValidationStatus.VALID && status != ValidationStatus.TOLERANCE_1 && status != ValidationStatus.TOLERANCE_1_START && status != ValidationStatus.TOLERANCE_2 && status != ValidationStatus.TOLERANCE_2_START ? this.openKeyNotValid() : Validation.INSTANCE.getLicenseTimeData().getRefreshDelay(Validation.INSTANCE.getLicense().isInTolerance()).intValue());
        return nextDelay;
    }

    private int handleTrialStatus(LicenseTrial license, ValidationStatus status) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        boolean showExpirationPopup = status == ValidationStatus.EXPIRED || status == ValidationStatus.ERROR;
        Runnable runnable = () -> {
            if (showExpirationPopup) {
                this.createMessageDialog(Messages.ValidationJob_Expired_Evaluation_Period_Title, Messages.ValidationJob_Expired_Evaluation_Period_Message_1, Messages.ValidationJob_Expired_Evaluation_Period_Message_2, 1, true);
            } else {
                this.createMessageDialog(Messages.ValidationJob_Evaluation_Period_Reminder_Title, String.valueOf(Messages.ValidationJob_Evaluation_Period_Reminder_Message_1) + license.getNbday() + " " + Messages.ValidationJob_Evaluation_Period_Reminder_Message_2, Messages.ValidationJob_Evaluation_Period_Reminder_Message_3, 2, false);
            }
        };
        display.syncExec(runnable);
        return Validation.INSTANCE.getLicenseTimeData().getRefreshDelay(Validation.INSTANCE.getLicense().isInTolerance());
    }

    private void createMessageDialog(String dialogTitle, String dialogText, final String contactMessage, int information, boolean closeDesignerWhenClickingOnCloseButton) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), dialogTitle, null, dialogText, information, new String[]{REGISTER_BUTTON, CLOSE_BUTTON}, 0){

            protected Control createCustomArea(Composite comp) {
                this.setShellStyle(this.getShellStyle() | 0x10);
                Composite parent = new Composite(comp, 0);
                GridLayout layout = new GridLayout();
                parent.setLayout((Layout)layout);
                parent.setLayoutData((Object)new GridData(1808));
                Link httpLink = new Link(parent, 0);
                httpLink.setText(contactMessage);
                httpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Program.launch((String)Messages.ValidationJob_License_Registration_URL);
                    }
                });
                GridData data = new GridData(490, 30);
                httpLink.setLayoutData((Object)data);
                return parent;
            }
        };
        int res = dialog.open();
        if (res == 0) {
            if (closeDesignerWhenClickingOnCloseButton) {
                this.openKeyNotValid();
            } else {
                this.openChangeMode();
            }
            return;
        }
        if (closeDesignerWhenClickingOnCloseButton && res == 1) {
            System.exit(3445);
        }
    }

    public void unschedule() {
        try {
            this.doNothing = true;
            this.wakeUp();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.doNothing = false;
        }
    }

    public void scheduleChangePopup() {
        this.unschedule();
        this.openChangeMode();
        this.run(null);
    }
}

