/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.Messages;
import com.semarchy.xdi.designer.core.services.IDesignerVersionProvider;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;

public class HostInformation {
    static boolean networkIssuesHasBeenLoged = false;
    private String hostName;
    private String hostAddress;
    private String macAddress;
    private String macAdresses;
    private String precAddress;
    private String jvm;
    private String os;
    private String version;

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    private void setListMacAddress() {
        String list = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            int i = 1;
            while (interfaces.hasMoreElements()) {
                NetworkInterface interfaceN = null;
                try {
                    interfaceN = interfaces.nextElement();
                    byte[] b = interfaceN.getHardwareAddress();
                    String result = "";
                    if (b != null) {
                        int j = 0;
                        while (j < b.length) {
                            result = String.valueOf(result) + String.format("%02X%s", b[j], j < b.length - 1 ? "-" : "");
                            ++j;
                        }
                    }
                    if (result.length() == 17) {
                        list = list == null ? result : String.valueOf(list) + result;
                    }
                    ++i;
                }
                catch (Exception e1) {
                    String msg = interfaceN != null ? ", interface : " + interfaceN.getDisplayName() : "";
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", String.valueOf(Messages.Validation_9) + msg, (Throwable)e1));
                }
            }
        }
        catch (SocketException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", Messages.Validation_10, (Throwable)e1));
        }
        this.macAdresses = list;
    }

    public String getMacAdressesList() {
        return this.macAdresses;
    }

    private boolean compareBytes(byte[] bytes1, byte[] bytes2) {
        if (bytes1 != null && bytes2 != null && bytes1.length == bytes2.length) {
            int i = 0;
            while (i < bytes1.length) {
                if (bytes1[i] != bytes2[i]) break;
                if (i == bytes1.length - 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void refreshInformation(String address) throws IOException {
        if (this.precAddress == null || !this.precAddress.equals(address) || networkIssuesHasBeenLoged) {
            this.precAddress = address;
            URL url = new URL(address);
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = "https".equals(url.getProtocol()) ? 443 : 80;
            }
            URI uri = null;
            try {
                uri = url.toURI();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Proxy proxy = null;
            if (uri != null) {
                IProxyData[] iProxyDataArray;
                IProxyService proxyService = (IProxyService)PlatformUI.getWorkbench().getService(IProxyService.class);
                if (proxyService != null && (iProxyDataArray = proxyService.select(uri)).length != 0) {
                    IProxyData pData = iProxyDataArray[0];
                    proxy = pData.getType().equalsIgnoreCase("HTTP") || pData.getType().equalsIgnoreCase("HTTPS") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(pData.getHost(), pData.getPort())) : new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(pData.getHost(), pData.getPort()));
                }
                if (proxy != null) {
                    List<Proxy> proxys = ProxySelector.getDefault().select(uri);
                    proxy = proxys.get(0);
                }
            }
            Throwable throwable = null;
            Object var8_11 = null;
            try (Socket socket = proxy != null ? new Socket(((InetSocketAddress)proxy.address()).getHostName(), ((InetSocketAddress)proxy.address()).getPort()) : new Socket(host, port);){
                InetAddress inetAddress = socket.getLocalAddress();
                String result = this.findMacAdress(inetAddress);
                this.setAddressMac(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.setListMacAddress();
        IDesignerVersionProvider p = (IDesignerVersionProvider)E4InjectorHelper.getService(IDesignerVersionProvider.class);
        this.version = p.getInternalBuildVersion();
        this.setOs(String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        this.setJvm(String.valueOf(System.getProperty("java.vendor")) + " " + System.getProperty("java.version"));
    }

    public String findMacAdress(InetAddress inetAddress) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        byte[] b = null;
        String result = "";
        block0: while (interfaces.hasMoreElements()) {
            NetworkInterface interfaceN = interfaces.nextElement();
            Enumeration<InetAddress> en = interfaceN.getInetAddresses();
            while (en.hasMoreElements()) {
                InetAddress addr = en.nextElement();
                if (!this.compareBytes(addr.getAddress(), inetAddress.getAddress())) continue;
                b = interfaceN.getHardwareAddress();
                this.setLocalHostName(addr.getCanonicalHostName());
                this.setHostAddress(addr.getHostAddress());
                if (b == null) continue block0;
                int j = 0;
                while (j < b.length) {
                    result = String.valueOf(result) + String.format("%02X%s", b[j], j < b.length - 1 ? "-" : "");
                    ++j;
                }
                continue block0;
            }
        }
        return result;
    }

    private void setJvm(String property) {
        this.jvm = property;
    }

    private void setOs(String string) {
        this.os = string;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getOs() {
        return this.os;
    }

    private void setAddressMac(String result) {
        this.macAddress = result;
    }

    private void setLocalHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getVersion() {
        return this.version;
    }
}

