/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.administration.AdministrationService;
import com.indy.emf.uri.Activator;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.Messages;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.wiring.BundleWiring;

public abstract class License {
    protected static Unmarshaller unMarshaller;
    protected static Marshaller marshaller;
    private String errorMessage;
    private ValidationStatus status = ValidationStatus.UNSET;
    protected Validation.Mode mode;
    protected List<String> authorizedPermissions = Collections.EMPTY_LIST;
    protected SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd");

    static {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.semarchy.xdi.license.server.model", (ClassLoader)((BundleWiring)Platform.getBundle((String)"com.indy.ui.howto.model").adapt(BundleWiring.class)).getClassLoader());
            unMarshaller = jc.createUnmarshaller();
            marshaller = jc.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to create JAXBContext", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean matchAdressMac(String macAdress) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            int i = 1;
            while (true) {
                if (!interfaces.hasMoreElements()) {
                    return false;
                }
                NetworkInterface interfaceN = null;
                try {
                    interfaceN = interfaces.nextElement();
                    byte[] b = interfaceN.getHardwareAddress();
                    String result = "";
                    if (b != null) {
                        int j = 0;
                        while (j < b.length) {
                            result = String.valueOf(result) + String.format("%02X%s", b[j], j < b.length - 1 ? "-" : "");
                            ++j;
                        }
                    }
                    if (result.equals(macAdress)) {
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "com.indy.emf.uri", Messages.License_macAdressFound));
                        return true;
                    }
                    ++i;
                }
                catch (Exception e1) {
                    String msg = interfaceN != null ? ", interface : " + interfaceN.getDisplayName() : "";
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", String.format(Messages.License_errorScanMacAdress, msg), (Throwable)e1));
                }
            }
        }
        catch (SocketException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.emf.uri", String.format(Messages.License_errorScanMacAdress, new Object[0]), (Throwable)e1));
        }
        return false;
    }

    public String getFormatExpirationDate() {
        if (this.getExpirationDate() == null) {
            return null;
        }
        return this.dateFormater.format(this.getExpirationDate());
    }

    public boolean isInTolerance() {
        return this.getStatus() == ValidationStatus.TOLERANCE_1 || this.getStatus() == ValidationStatus.TOLERANCE_1_START || this.getStatus() == ValidationStatus.TOLERANCE_2 || this.getStatus() == ValidationStatus.TOLERANCE_2_START;
    }

    protected void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    protected void setValidationStatus(ValidationStatus status) {
        this.status = status;
    }

    public abstract ValidationStatus checkValidity(LicenseToleranceData var1);

    public ValidationStatus getStatus() {
        return this.status;
    }

    public abstract Date getExpirationDate();

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void applyPermissions() {
        AdministrationService adminService = (AdministrationService)E4InjectorHelper.getService(AdministrationService.class);
        HashSet<String> enabledRoles = new HashSet<String>(this.getPermissions());
        adminService.setCurrentRole((String[])enabledRoles.stream().toArray(String[]::new));
    }

    public Validation.Mode getMode() {
        return this.mode;
    }

    protected List<String> getPermissions() {
        return this.authorizedPermissions;
    }

    public String[] getRoles() {
        List<String> l = this.getPermissions();
        return l.toArray(new String[l.size()]);
    }

    public abstract String readFromRegistry() throws InvalidLicenseChecksumException;

    public abstract String computeChecksum(LicenseToleranceData var1);

    protected String computeHash(String s) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] bytes = digest.digest(s.getBytes("UTF-8"));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            sb.append(Integer.toHexString(bytes[i] & 0xFF | 0x100).substring(1, 3));
            ++i;
        }
        return sb.toString();
    }

    public void validateChecksum(String cks, LicenseToleranceData timeInfo) throws InvalidLicenseChecksumException {
        boolean valid = false;
        if (cks != null) {
            String ref = this.computeChecksum(timeInfo);
            if (cks.equals(ref)) {
                valid = true;
            }
        } else {
            valid = true;
        }
        if (!valid) {
            throw new InvalidLicenseChecksumException();
        }
    }

    public class InvalidLicenseChecksumException
    extends Exception {
    }

    public class InvalidLicenseFormatxception
    extends Exception {
        public InvalidLicenseFormatxception(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

