/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.Messages;
import com.semarchy.xdi.designer.preferences.license.RegistryHelper;
import com.semarchy.xdi.license.server.model.Designer;
import com.semarchy.xdi.license.server.model.Group;
import com.semarchy.xdi.license.server.model.Server;
import com.semarchy.xdi.license.server.model.Utils;
import com.semarchy.xdi.license.server.validation.SignatureUtil;
import com.semarchy.xdi.license.server.validation.VerificationUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.xml.sax.InputSource;

public class LicenseOffline
extends License {
    SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd");
    private Date expirationDate;
    private String keyFilePath;
    private String group;

    public LicenseOffline() {
        this.mode = Validation.Mode.OFFLINE;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public ValidationStatus checkValidity(LicenseToleranceData timeInfo) {
        ValidationStatus status = ValidationStatus.UNSET;
        String keyFilePath = this.keyFilePath;
        if (keyFilePath == null || keyFilePath.isEmpty()) {
            keyFilePath = System.getenv().get("XDI_DESIGNER_LICENSE_KEY_FILE");
        }
        if (keyFilePath == null) {
            status = ValidationStatus.ERROR;
            this.setErrorMessage(Messages.LicenseOffline_errorNoKeyFilePath);
        } else {
            Path file = Paths.get(keyFilePath, new String[0]);
            try {
                Throwable throwable = null;
                Object var6_10 = null;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file.toFile()));){
                    InputSource src = new InputSource();
                    src.setByteStream(is);
                    JAXBElement elt = (JAXBElement)unMarshaller.unmarshal(src);
                    Object o = elt.getValue();
                    if (o instanceof com.semarchy.xdi.license.server.model.Messages) {
                        String msg = Utils.printMessages((com.semarchy.xdi.license.server.model.Messages)((com.semarchy.xdi.license.server.model.Messages)o));
                        if (msg != null && !msg.isEmpty()) {
                            this.setErrorMessage(msg);
                        }
                        status = ValidationStatus.REFUSED;
                    } else if (o instanceof Server) {
                        Server server = (Server)o;
                        Designer designer = (Designer)((Group)server.getGroup().get(0)).getDesigner().get(0);
                        if (server.getGroup().size() != 1) {
                            throw new Exception(Messages.LicenseOffline_errorGroupNumber);
                        }
                        if (((Group)server.getGroup().get(0)).getDesigner().size() != 1) {
                            throw new Exception(Messages.LicenseOffline_errorLicenseNumber);
                        }
                        if (designer.getEndDate() == null) {
                            throw new Exception(Messages.LicenseOffline_errorMissingEndDate);
                        }
                        if (!"STATIC".equals(designer.getMode().toUpperCase())) {
                            throw new Exception(Messages.LicenseOffline_errorNotStatic);
                        }
                        String stringServer = VerificationUtil.getServerToString((Server)server, (Marshaller)marshaller);
                        if (!SignatureUtil.verifySignature((String)server.getsignature(), (String)stringServer)) {
                            throw new Exception(Messages.LicenseOffline_errorInvalidSignature);
                        }
                        String macAdress = designer.getMacAddress();
                        if (macAdress != null && !License.matchAdressMac(macAdress)) {
                            throw new Exception(Messages.LicenseOffline_noMacAdressMatch);
                        }
                        this.group = ((Group)server.getGroup().get(0)).getCode();
                        timeInfo.refreshDelay = designer.getRefreshDelay();
                        if (timeInfo.refreshDelay < 0) {
                            timeInfo.refreshDelay = 30;
                        }
                        timeInfo.remainingTolerance = designer.getToleranceLevel1Duration() + designer.getToleranceLevel2Duration();
                        timeInfo.refusedTolerance = designer.getToleranceKillDuration() != null ? designer.getToleranceKillDuration() : -1L;
                        timeInfo.tolerance2 = designer.getToleranceLevel2Duration();
                        this.expirationDate = designer.getEndDate().toGregorianCalendar().getTime();
                        GregorianCalendar currentDate = new GregorianCalendar();
                        currentDate.setTimeInMillis(System.currentTimeMillis());
                        this.authorizedPermissions = ((Group)server.getGroup().get(0)).getPermission().stream().filter(p -> {
                            if (p.getStartDate() != null && currentDate.compareTo(p.getStartDate().toGregorianCalendar()) < 0) {
                                return false;
                            }
                            return p.getEndDate() == null || currentDate.compareTo(p.getEndDate().toGregorianCalendar()) <= 0;
                        }).map(p -> p.getValue()).collect(Collectors.toList());
                        if (new Date().compareTo(this.expirationDate) > 0) {
                            status = ValidationStatus.EXPIRATION;
                            this.setErrorMessage(String.format(Messages.LicenseOffline_expirationMessage, this.dateFormater.format(this.expirationDate)));
                        } else {
                            status = ValidationStatus.VALID;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                status = ValidationStatus.ERROR;
                this.setErrorMessage(String.format(Messages.LicenseOffline_errorReadLicenseFile, file, ex.getMessage()));
                ex.printStackTrace();
            }
            catch (JAXBException ex) {
                status = ValidationStatus.ERROR;
                this.setErrorMessage(String.format(Messages.LicenseOffline_errorParseLicense, file, ex.getMessage()));
                ex.printStackTrace();
            }
            catch (Exception ex) {
                status = ValidationStatus.ERROR;
                this.setErrorMessage(ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.setValidationStatus(status);
        return this.getStatus();
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public String readFromRegistry() throws License.InvalidLicenseChecksumException {
        try {
            String s = RegistryHelper.INSTANCE.read("LicenseComponentPermissionList");
            if (s != null && !s.isEmpty()) {
                this.authorizedPermissions = Arrays.asList(s.split(","));
            }
        }
        catch (Exception e) {
            this.authorizedPermissions = Collections.EMPTY_LIST;
        }
        try {
            this.expirationDate = this.dateFormater.parse(RegistryHelper.INSTANCE.read("ExpirationDate"));
        }
        catch (Exception ex) {
            this.expirationDate = null;
        }
        this.keyFilePath = RegistryHelper.INSTANCE.read("LicenseKeyFile");
        return RegistryHelper.INSTANCE.read("Checksum");
    }

    public void setLicenseKeyFilePath(String keyFile) {
        this.keyFilePath = keyFile;
    }

    public String getLicenseKeyFilePath() {
        return this.keyFilePath;
    }

    @Override
    public String getFormatExpirationDate() {
        if (this.expirationDate != null) {
            return this.dateFormater.format(this.expirationDate);
        }
        return null;
    }

    @Override
    public String computeChecksum(LicenseToleranceData timeInfo) {
        String str = String.join((CharSequence)"/", this.getMode().name(), this.getFormatExpirationDate(), String.join((CharSequence)",", this.getPermissions().toArray(new String[this.getPermissions().size()])), Integer.toString(timeInfo.refreshDelay), Long.toString(timeInfo.refusedTolerance), Long.toString(timeInfo.remainingTolerance), Long.toString(timeInfo.tolerance2));
        try {
            return this.computeHash(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

