/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.Activator;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.preferences.license.HostInformation;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.RegistryHelper;
import com.semarchy.xdi.license.server.model.Messages;
import com.semarchy.xdi.license.server.model.Token;
import com.semarchy.xdi.license.server.model.Utils;
import com.stambia.ui.licence.manager.tools.Connection;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.WebResource;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import org.eclipse.core.runtime.Assert;
import org.xml.sax.InputSource;

public class LicenseServer
extends License {
    String uuid = UUID.randomUUID().toString();
    private Date expirationDate;
    protected String serverURL;
    protected String licenseKey;
    private String validLicenseServerAddress;
    private String newLicenseServerAddress;
    private boolean connectionSuccess = false;
    private String group;
    SimpleDateFormat hourFormatter = new SimpleDateFormat("mm:ss");

    public LicenseServer(Validation.Mode mode) {
        Assert.isTrue((mode == Validation.Mode.LOCAL || mode == Validation.Mode.ONLINE ? 1 : 0) != 0);
        this.mode = mode;
    }

    @Override
    public Validation.Mode getMode() {
        return this.mode;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public void setLicenseServerURL(String url) {
        this.serverURL = url;
    }

    public String getGroupAddress(String address) {
        try {
            URL url = new URL(address);
            String group = url.getPath();
            group = group == null || group.isEmpty() || group.replaceAll("/", "").isEmpty() ? String.valueOf(group) + "/default" : "";
            int i = address.indexOf("?");
            String _address = address;
            if (i > 0) {
                _address = address.substring(0, i);
            }
            if (_address.endsWith("/")) {
                _address = _address.substring(0, _address.length() - 1);
            }
            int index = _address.indexOf("//");
            String addressWithoutPRotocol = _address.substring(index + 2);
            String addressEnd = addressWithoutPRotocol.replaceAll("/", "/api/2/");
            _address = String.valueOf(url.getProtocol()) + "://" + addressEnd;
            return String.valueOf(_address) + group;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return address;
        }
    }

    public String getLicenseServerURL() {
        return this.serverURL;
    }

    @Override
    public ValidationStatus checkValidity(LicenseToleranceData timeInfo) {
        this.setErrorMessage(null);
        Token token = null;
        ValidationStatus status = ValidationStatus.UNSET;
        String elligibleAddress = this.getLicenseServerURL();
        if (elligibleAddress == null || elligibleAddress.isEmpty()) {
            elligibleAddress = this.mode == Validation.Mode.ONLINE ? "https://license-xdi.semarchy.com" : System.getenv().get("XDI_DESIGNER_LICENSE_SERVER_URL");
        }
        String group = null;
        try {
            String groupAddress;
            Validation.INSTANCE.getClient().refreshInformation(elligibleAddress);
            String macS = Validation.INSTANCE.getClient().getMacAdressesList();
            String query = new URL(elligibleAddress).getQuery();
            query = query != null ? "&" + query : "";
            String licenseKey = this.licenseKey;
            if (licenseKey == null || licenseKey.isEmpty()) {
                licenseKey = System.getenv().get("XDI_DESIGNER_LICENSE_KEY");
            }
            String decodedLicenceKey = null;
            try {
                decodedLicenceKey = new String(Base64.getDecoder().decode(licenseKey));
            }
            catch (Exception ex) {
                throw new License.InvalidLicenseFormatxception("The license key is invalid.", ex);
            }
            int separator = decodedLicenceKey.indexOf(":");
            group = separator > -1 ? decodedLicenceKey.substring(0, separator) : "";
            String groupKey = decodedLicenceKey.substring(separator + 1);
            if (group.length() > 1) {
                this.group = group;
                group = elligibleAddress.endsWith("/") ? URLEncoder.encode(group, "UTF-8") : "/" + URLEncoder.encode(group, "UTF-8");
            }
            this.newLicenseServerAddress = groupAddress = this.getGroupAddress(String.valueOf(elligibleAddress) + group);
            String str = String.valueOf(groupAddress) + "/token/designer?mac=" + Validation.INSTANCE.getClient().getMacAddress() + "&uuid=" + this.uuid + "&macs=" + macS + "&user=" + URLEncoder.encode(System.getProperty("user.name")) + "&ip=" + URLEncoder.encode(Validation.INSTANCE.getClient().getHostAddress()) + "&host=" + URLEncoder.encode(Validation.INSTANCE.getClient().getHostName()) + "&os=" + URLEncoder.encode(Validation.INSTANCE.getClient().getOs()) + "&jvm=" + URLEncoder.encode(Validation.INSTANCE.getClient().getJvm()) + "&stbversion=" + Validation.INSTANCE.getClient().getVersion() + (groupKey.length() > 0 ? "&key=" + groupKey : "");
            WebResource webResource = Connection.getClient().resource(str);
            webResource.accept(new String[]{"text/xml"});
            String xml = (String)webResource.get(String.class);
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            JAXBElement elt = (JAXBElement)unMarshaller.unmarshal(is);
            Object o = elt.getValue();
            this.connectionSuccess = true;
            if (o instanceof Messages) {
                String msg = Utils.printMessages((Messages)((Messages)o));
                if (msg != null && !msg.isEmpty()) {
                    this.setErrorMessage(msg);
                }
                status = ValidationStatus.REFUSED;
            } else if (o instanceof Token) {
                this.validLicenseServerAddress = groupAddress;
                this.newLicenseServerAddress = null;
                token = (Token)o;
                timeInfo.refreshDelay = token.getRefreshDelay();
                if (timeInfo.refreshDelay < 0) {
                    timeInfo.refreshDelay = 30;
                }
                timeInfo.remainingTolerance = token.getToleranceLevel1Duration() + token.getToleranceLevel2Duration();
                timeInfo.refusedTolerance = token.getToleranceKillDuration() != null ? token.getToleranceKillDuration() : -1L;
                timeInfo.tolerance2 = token.getToleranceLevel2Duration();
                this.expirationDate = token.getEndDate() != null && token.getEndDate().toGregorianCalendar() != null ? token.getEndDate().toGregorianCalendar().getTime() : null;
                this.authorizedPermissions = token.getPermission();
                status = ValidationStatus.VALID;
            }
            HostInformation.networkIssuesHasBeenLoged = false;
        }
        catch (UnknownHostException e) {
            status = ValidationStatus.ERROR;
            if (!HostInformation.networkIssuesHasBeenLoged) {
                HostInformation.networkIssuesHasBeenLoged = true;
                e.printStackTrace();
                Activator.getDefault().warn(com.indy.emf.uri.Messages.Validation_1, e);
            }
            this.setErrorMessage(com.indy.emf.uri.Messages.Validation_121);
        }
        catch (Throwable e) {
            HostInformation.networkIssuesHasBeenLoged = true;
            status = this.connectionSuccess && e instanceof ClientHandlerException && (e.getCause() instanceof UnknownHostException || e.getCause() instanceof SocketTimeoutException) ? ValidationStatus.CONNECTION_LOST : ValidationStatus.ERROR;
            e.printStackTrace();
            if (e instanceof License.InvalidLicenseFormatxception) {
                this.setErrorMessage(e.getMessage());
            } else {
                this.setErrorMessage(com.indy.emf.uri.Messages.Validation_121);
            }
            Activator.getDefault().warn(com.indy.emf.uri.Messages.Validation_123, e);
        }
        if (this.newLicenseServerAddress != null && this.validLicenseServerAddress != null && !this.newLicenseServerAddress.equals(this.validLicenseServerAddress)) {
            if (status == ValidationStatus.REFUSED) {
                status = ValidationStatus.ERROR;
            }
        } else if (status == ValidationStatus.ERROR) {
            status = ValidationStatus.UNSET;
        }
        return status;
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    protected List<String> getPermissions() {
        HashSet<String> l = new HashSet<String>(super.getPermissions());
        return new ArrayList<String>(l);
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public String readFromRegistry() throws License.InvalidLicenseChecksumException {
        try {
            String s = RegistryHelper.INSTANCE.read("LicenseComponentPermissionList");
            if (s != null && !s.isEmpty()) {
                this.authorizedPermissions = Arrays.asList(s.split(","));
            }
        }
        catch (Exception e) {
            this.authorizedPermissions = Collections.EMPTY_LIST;
        }
        try {
            this.expirationDate = this.dateFormater.parse(RegistryHelper.INSTANCE.read("ExpirationDate"));
        }
        catch (Exception ex) {
            this.expirationDate = null;
        }
        this.licenseKey = RegistryHelper.INSTANCE.read("LicenseKey");
        this.serverURL = RegistryHelper.INSTANCE.read("LicenseServerURL");
        String checksum = RegistryHelper.INSTANCE.read("Checksum");
        return checksum;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public String computeChecksum(LicenseToleranceData timeInfo) {
        String str = String.join((CharSequence)"/", this.getMode().name(), this.getFormatExpirationDate(), String.join((CharSequence)",", this.getPermissions().toArray(new String[this.getPermissions().size()])), Integer.toString(timeInfo.refreshDelay), Long.toString(timeInfo.refusedTolerance), Long.toString(timeInfo.remainingTolerance), Long.toString(timeInfo.tolerance2));
        try {
            return this.computeHash(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

