/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.RegistryHelper;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LicenseToleranceData {
    SimpleDateFormat hourFormatter = new SimpleDateFormat("mm:ss");
    protected Integer refreshDelay = 30;
    protected long remainingTolerance = 0L;
    protected long refusedTolerance = 0L;
    protected long tolerance2 = 0L;
    protected long lastRefresh = 0L;

    public String getFormatDelayFirstTolerance() {
        Long l = this.remainingTolerance;
        Long l2 = this.tolerance2;
        String res = null;
        if (l != null) {
            long hour;
            String _hour;
            if (l2 != null) {
                l = l - l2;
            }
            if ((_hour = Long.toString(hour = l / 3600L / 1000L)).length() == 0) {
                _hour = "0";
            } else if (_hour.length() == 1) {
                _hour = "0" + _hour;
            }
            String date = this.hourFormatter.format(new Date(l));
            res = String.valueOf(_hour) + ":" + date;
        }
        return res;
    }

    public String getFormatRemainingToleranceTime() {
        long hour = this.remainingTolerance / 3600L / 1000L;
        String _hour = Long.toString(hour);
        if (_hour.length() == 0) {
            _hour = "0";
        } else if (_hour.length() == 1) {
            _hour = "0" + _hour;
        }
        String date = this.hourFormatter.format(new Date(this.remainingTolerance));
        return String.valueOf(_hour) + ":" + date;
    }

    public Integer getRefreshDelay(boolean isInTolerance) {
        long i;
        long l = i = this.remainingTolerance > this.tolerance2 ? this.remainingTolerance - this.tolerance2 : this.remainingTolerance;
        if (isInTolerance && i < (long)this.refreshDelay.intValue()) {
            return Integer.valueOf(Long.toString(i));
        }
        return this.refreshDelay == null ? 1000 : this.refreshDelay;
    }

    public void readFromRegistry() {
        try {
            this.refreshDelay = Integer.parseInt(RegistryHelper.INSTANCE.read("LicenseTokenRefreshDelay"));
        }
        catch (Exception ex) {
            this.refreshDelay = 30;
        }
        try {
            this.refusedTolerance = Integer.parseInt(RegistryHelper.INSTANCE.read("LicenseRefusedToleranceDelay"));
        }
        catch (Exception ex) {
            this.refusedTolerance = 0L;
        }
        try {
            this.remainingTolerance = Integer.parseInt(RegistryHelper.INSTANCE.read("LicenseInterruptionToleranceRemainingDelay"));
        }
        catch (Exception ex) {
            this.remainingTolerance = 0L;
        }
        try {
            this.tolerance2 = Integer.parseInt(RegistryHelper.INSTANCE.read("LicenseInterruptionToleranceDelay"));
        }
        catch (Exception ex) {
            this.tolerance2 = 0L;
        }
    }

    public void checkTolerance(License license, ValidationStatus newStatus) {
        if (license.getMode() == Validation.Mode.TRIAL) {
            return;
        }
        if (newStatus == ValidationStatus.REFUSED && this.refusedTolerance > -1L && this.refusedTolerance <= this.tolerance2 && this.refusedTolerance < this.remainingTolerance) {
            this.remainingTolerance = this.refusedTolerance;
        }
        if (newStatus != ValidationStatus.VALID && newStatus != ValidationStatus.ERROR) {
            if (this.remainingTolerance > 0L) {
                long t = 0L;
                if (this.lastRefresh > 0L) {
                    t = System.currentTimeMillis() - this.lastRefresh;
                }
                this.remainingTolerance -= t;
                if (this.remainingTolerance < 0L) {
                    this.remainingTolerance = 0L;
                }
            }
            if (this.remainingTolerance > 0L) {
                if (this.remainingTolerance > this.tolerance2) {
                    if (license.getStatus() == ValidationStatus.TOLERANCE_1_START) {
                        license.setValidationStatus(ValidationStatus.TOLERANCE_1);
                    } else if (license.getStatus() != ValidationStatus.TOLERANCE_1) {
                        license.setValidationStatus(ValidationStatus.TOLERANCE_1_START);
                    }
                } else if (license.getStatus() == ValidationStatus.TOLERANCE_2_START) {
                    license.setValidationStatus(ValidationStatus.TOLERANCE_2);
                } else if (license.getStatus() != ValidationStatus.TOLERANCE_2) {
                    license.setValidationStatus(ValidationStatus.TOLERANCE_2_START);
                }
            } else {
                license.setValidationStatus(ValidationStatus.TOLERANCE_END);
            }
        } else {
            license.setValidationStatus(newStatus);
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    public LicenseToleranceData copy() {
        LicenseToleranceData r = new LicenseToleranceData();
        r.lastRefresh = this.lastRefresh;
        r.refreshDelay = this.refreshDelay;
        r.refusedTolerance = this.refusedTolerance;
        r.remainingTolerance = this.remainingTolerance;
        r.tolerance2 = this.tolerance2;
        return r;
    }
}

