/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;

public class CreateTableDeParser {
    protected StringBuffer buffer;

    public CreateTableDeParser(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void deParse(CreateTable createTable) {
        this.buffer.append("CREATE TABLE " + createTable.getTable().getWholeTableName());
        if (createTable.getColumnDefinitions() != null) {
            Iterator iterator;
            this.buffer.append(" { ");
            Iterator iter = createTable.getColumnDefinitions().iterator();
            while (iter.hasNext()) {
                ColumnDefinition columnDefinition = (ColumnDefinition)iter.next();
                this.buffer.append(columnDefinition.getColumnName());
                this.buffer.append(" ");
                this.buffer.append(columnDefinition.getColDataType().getDataType());
                if (columnDefinition.getColDataType().getArgumentsStringList() != null) {
                    iterator = columnDefinition.getColDataType().getArgumentsStringList().iterator();
                    while (iterator.hasNext()) {
                        this.buffer.append(" ");
                        this.buffer.append((String)iterator.next());
                    }
                }
                if (columnDefinition.getColumnSpecStrings() != null) {
                    iterator = columnDefinition.getColumnSpecStrings().iterator();
                    while (iterator.hasNext()) {
                        this.buffer.append(" ");
                        this.buffer.append((String)iterator.next());
                    }
                }
                if (!iter.hasNext()) continue;
                this.buffer.append(",\n");
            }
            iter = createTable.getIndexes().iterator();
            while (iter.hasNext()) {
                this.buffer.append(",\n");
                Index index = (Index)iter.next();
                this.buffer.append(index.getType() + " " + index.getName());
                this.buffer.append("(");
                iterator = index.getColumnsNames().iterator();
                while (iterator.hasNext()) {
                    this.buffer.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(")");
                if (!iter.hasNext()) continue;
                this.buffer.append(",\n");
            }
            this.buffer.append(" \n} ");
        }
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

