/*
 * Decompiled with CFR 0.152.
 */
package com.indy.connector.httprest.core;

import com.indy.engine.core.json.annotation.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebServiceMetaData {
    @JsonElement(name="parameters")
    public Map<String, Parameter> parameterByKey;
    @JsonElement(name="responses")
    public List<WebServiceResponseMetaData> responseByKey = new ArrayList<WebServiceResponseMetaData>();
    @JsonElement(name="method")
    public String verb;
    @JsonElement(name="requestbody")
    public RequestBody request;
    private String fullUrl;
    @JsonElement(name="baseUrl")
    public String baseUrl;
    @JsonElement(name="resource")
    public String resource;
    @JsonElement(name="outputFileFolder")
    public String outFolder;
    @JsonElement(name="logReqRes")
    public String logReqRes;
    @JsonElement(name="delayBetweenInvocations")
    public String delayBetweenInvocations;
    @JsonElement(name="functionalErrorAcceptanceNumber")
    public String functionalErrorAcceptanceNumber;
    @JsonElement(name="functionalErrorRetryNumber")
    public String functionalErrorRetryNumber;
    @JsonElement(name="functionalErrorRetryDelay")
    public String functionalErrorRetryDelay;
    @JsonElement(name="technicalErrorAcceptanceNumber")
    public String technicalErrorAcceptanceNumber;
    @JsonElement(name="technicalErrorRetryNumber")
    public String technicalErrorRetryNumber;
    @JsonElement(name="technicalErrorRetryDelay")
    public String technicalErrorRetryDelay;
    @JsonElement(name="timeout")
    public String readTimeout;
    @JsonElement(name="connectionTimeout")
    public String connectionTimeout;
    @JsonElement(name="security")
    public Map<String, Object> securityParams;
    @JsonElement(name="proxy")
    public Map<String, Object> proxyParams;
    @JsonElement(name="keyStore")
    public Map<String, Object> keyStoreParams;
    @JsonElement(name="trustStore")
    public Map<String, Object> trustStoreParams;
    @JsonElement(name="enableHostnameVerification")
    public Boolean enableHostnameVerification;
    @JsonElement(name="enableCertificateVerification")
    public Boolean enableCertificateVerification;
    private List<String> urlParts;
    public WebServiceResponseMetaData defaultResponse;

    public String getUrl() {
        return this.fullUrl;
    }

    public void init() {
        for (WebServiceResponseMetaData resp : this.responseByKey) {
            if (resp.code == null || !resp.code.equals("default")) continue;
            this.defaultResponse = resp;
        }
        StringBuilder resourceBuilder = new StringBuilder();
        String[] stringArray = this.resource.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("/")) {
                resourceBuilder.append(s);
            } else {
                resourceBuilder.append("/");
                resourceBuilder.append(s);
            }
            ++n2;
        }
        String fullResource = resourceBuilder.toString();
        this.fullUrl = "";
        boolean urlEndsWithSlash = this.baseUrl.endsWith("/");
        boolean resourceStartsWithSlash = fullResource.startsWith("/");
        if (urlEndsWithSlash && !resourceStartsWithSlash || !urlEndsWithSlash && resourceStartsWithSlash) {
            this.fullUrl = String.valueOf(this.baseUrl) + fullResource;
        } else if (urlEndsWithSlash && resourceStartsWithSlash) {
            this.fullUrl = String.valueOf(this.baseUrl) + fullResource.substring(1, fullResource.length());
        } else if (!urlEndsWithSlash && !resourceStartsWithSlash) {
            this.fullUrl = String.valueOf(this.baseUrl) + "/" + fullResource;
        }
        String regexp = "\\{([^\\}]*)\\}";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(this.fullUrl);
        int start = 0;
        this.urlParts = new ArrayList<String>();
        while (matcher.find()) {
            String paramName;
            int start2 = matcher.start();
            this.urlParts.add(this.fullUrl.substring(start, start2));
            int end = matcher.end();
            this.urlParts.add(this.fullUrl.substring(start2, end));
            start = end;
            if (this.parameterByKey == null || (paramName = matcher.group(1)) == null) continue;
            Parameter p = this.parameterByKey.get(paramName);
            if (p == null) {
                throw new RuntimeException("Missing path parameter : " + paramName + ". Please add the parameter to the metadata.");
            }
            p.urlPosition = this.urlParts.size() - 1;
        }
        if (start < this.fullUrl.length()) {
            this.urlParts.add(this.fullUrl.substring(start, this.fullUrl.length()));
        }
    }

    public List<String> getUrlParts() {
        return this.urlParts;
    }

    public static final class ContentMetadata {
        @JsonElement(name="mediaType")
        public ContentType mediaType;
        @JsonElement(name="contentType")
        public String contentType;
        @JsonElement(name="id")
        public String id;
    }

    public static enum ContentType {
        JSON,
        XML,
        TEXT,
        BINARY,
        FORM,
        AUTO;

    }

    public static final class CookieMetadata {
        @JsonElement(name="cookieName")
        public String cookieName;
        @JsonElement(name="valueFormat")
        public String valueFormat;
        @JsonElement(name="valueSelectorRegexp")
        public String valueSelectorRegexp;
    }

    public static final class MultipartMetadata {
        @JsonElement(name="boundary")
        public String boundary;
        @JsonElement(name="id")
        public String id;
        @JsonElement(name="partName")
        public String partName;
        @JsonElement(name="contentType")
        public String contentType;
        @JsonElement(name="parts")
        public List<PartMetadata> parts;
    }

    public static final class Parameter {
        @JsonElement(name="type")
        public String type;
        @JsonElement(name="location")
        public ParameterLocation location;
        @JsonElement(name="required")
        public boolean required;
        @JsonElement(name="allowEmptyValue")
        public boolean allowEmptyValue;
        @JsonElement(name="default")
        public String defaultValue;
        public int urlPosition;
    }

    public static enum ParameterLocation {
        path,
        header,
        query,
        cookie;

    }

    public static final class PartMetadata {
        @JsonElement(name="partName")
        public String partName;
        @JsonElement(name="partFilename")
        public String partFilename;
        @JsonElement(name="part")
        public ContentMetadata part;
        @JsonElement(name="multipart")
        public MultipartMetadata multipart;
    }

    public static final class RequestBody {
        @JsonElement(name="content")
        public ContentMetadata content;
        @JsonElement(name="multipart")
        public MultipartMetadata multipart;
    }

    public static final class WebServiceResponseMetaData {
        @JsonElement(name="name")
        public String name;
        @JsonElement(name="code")
        public String code;
        @JsonElement(name="content")
        public ContentMetadata content;
        @JsonElement(name="headers")
        public Map<String, Object> headers;
        @JsonElement(name="cookies")
        public Map<String, CookieMetadata> cookies = new HashMap<String, CookieMetadata>();
    }
}

