/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command;

import com.indy.engine.command.EngineCommandsRemote;
import com.indy.engine.command.Messages;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class EngineCommandStartI {
    public static void main(String[] args) throws FileNotFoundException {
        StringBuffer sb = new StringBuffer();
        String separator = ";";
        if (args != null && args.length > 0) {
            int i = 0;
            while (i < args.length) {
                String str;
                if (args[i].toLowerCase().equals("-separator")) {
                    if (i == args.length - 1) {
                        System.err.println(Messages.getString("EngineCommandStartI.0"));
                        System.exit(-1);
                    }
                    separator = args[++i];
                } else if (args[i].toLowerCase().equals("-file")) {
                    if (i == args.length - 1) {
                        System.err.println(Messages.getString("EngineCommandStartI.1"));
                        System.exit(-1);
                    }
                    str = args[++i];
                    FileInputStream is = new FileInputStream(str);
                    sb.append(EngineCommandStartI.inputStreamToString(is));
                } else if (args[i].toLowerCase().equals("-usage")) {
                    InputStream is = EngineCommandStartI.class.getResourceAsStream("usage.txt");
                    System.out.println(EngineCommandStartI.inputStreamToString(is));
                    System.exit(0);
                } else if (args[i].toLowerCase().equals("-conf")) {
                    ++i;
                } else {
                    str = args[i];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    str = str.replace(separator, "\n");
                    sb.append(str);
                }
                ++i;
            }
        }
        InputStream in = null;
        boolean displayStartLine = false;
        if (sb.length() > 0) {
            in = new ByteArrayInputStream(sb.toString().getBytes());
            displayStartLine = false;
        } else {
            in = System.in;
            displayStartLine = true;
        }
        EngineCommandsRemote engineCommands = new EngineCommandsRemote(in);
        engineCommands.setDisplayStartLine(displayStartLine);
        engineCommands.executeNew();
        if (engineCommands.getExitCode() != null) {
            System.exit(engineCommands.getExitCode());
        }
    }

    public static String inputStreamToString(InputStream is) {
        StringBuilder out;
        block14: {
            char[] buffer = new char[1024];
            out = new StringBuilder();
            try {
                InputStreamReader in = new InputStreamReader(is, "UTF-8");
                try {
                    try {
                        int rsz;
                        while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                            out.append(buffer, 0, rsz);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            ((Reader)in).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return out.toString();
    }

    public static boolean startCommand() {
        Throwable throwable = null;
        Object var1_3 = null;
        Scanner scanner = new Scanner(System.in, "UTF-8");
        try {
            HashMap<String, String> commandMap = new HashMap<String, String>();
            commandMap.put("singleCommand", "");
            String line = null;
            boolean exit = false;
            EngineCommandsRemote engineCommands = new EngineCommandsRemote(null);
            while (!exit) {
                System.out.print("> ");
                if (scanner.hasNext("exit")) {
                    exit = true;
                    continue;
                }
                line = scanner.nextLine();
                if (line.trim().startsWith("connect")) {
                    engineCommands.executeCommand(line);
                    continue;
                }
                if (!engineCommands.connectOrReconnect()) continue;
                commandMap.put("singleCommand", line);
                Map result = engineCommands.getEngineAPI().invokeCommand(commandMap);
                Map context = (Map)result.get("context");
                if (context != null) {
                    Object returnCode = context.get("lastExecutionDeliveryReturnCode");
                    System.out.println(returnCode);
                }
                System.out.println(result.get("singleResult"));
            }
            if (scanner != null) {
                scanner.close();
            }
            return true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (scanner != null) {
                        scanner.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

