/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command;

import com.indy.engine.Global;
import com.indy.engine.command.Messages;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.LocalSession;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EngineStopI {
    public static final Logger logger = LogManager.getLogger((String)"com.indy.engine");

    public static void writeUsage() {
        System.out.println("Usage : ");
        System.out.println("\tcommand [-host httpHost][-port httpPort] [-immediate]");
        System.out.println("");
        System.out.println(Messages.getString("EngineStopI.7"));
        System.out.println(Messages.getString("EngineStopI.0"));
        System.out.println(Messages.getString("EngineStopI.1"));
        System.out.println(Messages.getString("EngineStopI.2"));
        System.out.println(Messages.getString("EngineStopI.3"));
        System.out.println(Messages.getString("EngineStopI.4"));
        System.out.println(Messages.getString("EngineStopI.5"));
        System.out.println(Messages.getString("EngineStopI.6"));
    }

    public static void main(String[] args) {
        String host = "";
        String port = "";
        String user = null;
        String password = null;
        String uncryptedPassword = null;
        boolean immediate = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("-usage")) {
                EngineStopI.writeUsage();
                System.exit(-1);
            } else if (args[i].toLowerCase().equals("-immediate")) {
                immediate = true;
            } else if (args[i].toLowerCase().equals("-port")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("EngineStopI.8"));
                    EngineStopI.writeUsage();
                    System.exit(-1);
                }
                port = args[++i];
            } else if (args[i].toLowerCase().equals("-host")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("EngineStopI.9"));
                    EngineStopI.writeUsage();
                    System.exit(-1);
                }
                host = args[++i];
            } else if (args[i].toLowerCase().equals("-user")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("EngineStopI.10"));
                    EngineStopI.writeUsage();
                    System.exit(-1);
                }
                user = args[++i];
            } else if (args[i].toLowerCase().equals("-password")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("EngineStopI.11"));
                    EngineStopI.writeUsage();
                    System.exit(-1);
                }
                password = args[++i];
            } else if (args[i].toLowerCase().equals("-uncryptedpassword")) {
                if (i == args.length - 1) {
                    System.err.println(Messages.getString("EngineStopI.12"));
                    EngineStopI.writeUsage();
                    System.exit(-1);
                }
                uncryptedPassword = args[++i];
            }
            ++i;
        }
        if (port.equals("")) {
            port = String.valueOf(Global.HTTP_PORT);
        }
        if (host.equals("")) {
            host = "localhost";
        }
        IEngineClient engineAPI = null;
        try {
            LocalSession ls;
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("user", user);
            if (password != null) {
                credentials.put("password", password);
            }
            if (uncryptedPassword != null) {
                credentials.put("uncryptedPassword", uncryptedPassword);
            }
            if ((engineAPI = (ls = EngineFactory.getEngine((String)host, (int)new Integer(port), credentials)).getRemoteObject()) != null) {
                if (immediate) {
                    System.out.println(String.valueOf(Messages.getString("EngineStopI.13")) + host + Messages.getString("EngineStopI.14") + port + Messages.getString("EngineStopI.15"));
                } else {
                    System.out.println(String.valueOf(Messages.getString("EngineStopI.16")) + host + Messages.getString("EngineStopI.17") + port + "'");
                }
                engineAPI.stopEngine(immediate);
            }
        }
        catch (Exception e) {
            logger.warn("An exception occured : ", (Throwable)e);
            System.exit(-1);
        }
        System.out.println(String.valueOf(Messages.getString("EngineStopI.18")) + host + Messages.getString("EngineStopI.19") + port + "'");
    }
}

