/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant.optional.ssh;

import com.indy.engine.action.ant.optional.ssh.Messages;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ssh.LogListener;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHUserInfo;

public abstract class SSHBase
extends Task
implements LogListener {
    private static final int SSH_PORT = 22;
    private String host;
    private String knownHosts;
    private int port = 22;
    private boolean failOnError = true;
    private boolean verbose;
    private SSHUserInfo userInfo = new SSHUserInfo();
    public static final int PROXY_PROTOCOL_SOCKS5 = 5;
    public static final int PROXY_PROTOCOL_SOCKS4 = 4;
    public static final int PROXY_PROTOCOL_HTTP = 1;
    private static final int DEFAULT_PROXY_PROTOCOL = 5;
    private String proxyHost = null;
    private int proxyPort = -1;
    private int proxyProtocol = 5;
    private String proxyUser = null;
    private String proxyPassword = "";
    private Properties additionlConnectionProperties = null;

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setFailonerror(boolean failure) {
        this.failOnError = failure;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setUsername(String username) {
        this.userInfo.setName(username);
    }

    public void setPassword(String password) {
        this.userInfo.setPassword(password);
    }

    public void setKeyfile(String keyfile) {
        this.userInfo.setKeyfile(keyfile);
    }

    public void setPassphrase(String passphrase) {
        this.userInfo.setPassphrase(passphrase);
    }

    public void setKnownhosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setTrust(boolean yesOrNo) {
        this.userInfo.setTrust(yesOrNo);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void init() throws BuildException {
        super.init();
        this.knownHosts = String.valueOf(System.getProperty("user.home")) + "/.ssh/known_hosts";
        this.port = 22;
    }

    protected Session openSession() throws JSchException {
        JSch jsch = new JSch();
        if (this.userInfo.getKeyfile() != null) {
            jsch.addIdentity(this.userInfo.getKeyfile());
        }
        if (!this.userInfo.getTrust() && this.knownHosts != null) {
            this.log(String.valueOf(Messages.getString("SSHBase.0")) + this.knownHosts, 4);
            jsch.setKnownHosts(this.knownHosts);
        }
        Session session = jsch.getSession(this.userInfo.getName(), this.host, this.port);
        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        if (this.proxyHost != null) {
            switch (this.proxyProtocol) {
                case 5: {
                    ProxySOCKS5 prox5 = null;
                    if (this.proxyPort != -1) {
                        prox5 = new ProxySOCKS5(this.proxyHost, this.proxyPort);
                        if (this.proxyUser != null) {
                            prox5.setUserPasswd(this.proxyUser, this.proxyPassword);
                        }
                        session.setProxy((Proxy)prox5);
                        break;
                    }
                    prox5 = new ProxySOCKS5(this.proxyHost);
                    if (this.proxyUser != null) {
                        prox5.setUserPasswd(this.proxyUser, this.proxyPassword);
                    }
                    session.setProxy((Proxy)prox5);
                    break;
                }
                case 4: {
                    ProxySOCKS4 prox4 = null;
                    if (this.proxyPort != -1) {
                        prox4 = new ProxySOCKS4(this.proxyHost, this.proxyPort);
                        if (this.proxyUser != null) {
                            prox4.setUserPasswd(this.proxyUser, this.proxyPassword);
                        }
                        session.setProxy((Proxy)prox4);
                        break;
                    }
                    prox4 = new ProxySOCKS4(this.proxyHost);
                    if (this.proxyUser != null) {
                        prox4.setUserPasswd(this.proxyUser, this.proxyPassword);
                    }
                    session.setProxy((Proxy)prox4);
                    break;
                }
                case 1: {
                    ProxyHTTP proxh = null;
                    if (this.proxyPort != -1) {
                        proxh = new ProxyHTTP(this.proxyHost, this.proxyPort);
                        if (this.proxyUser != null) {
                            proxh.setUserPasswd(this.proxyUser, this.proxyPassword);
                        }
                        session.setProxy((Proxy)proxh);
                        break;
                    }
                    proxh = new ProxyHTTP(this.proxyHost);
                    if (this.proxyUser != null) {
                        proxh.setUserPasswd(this.proxyUser, this.proxyPassword);
                    }
                    session.setProxy((Proxy)proxh);
                }
            }
        }
        session.setUserInfo((UserInfo)this.userInfo);
        if (this.additionlConnectionProperties != null) {
            for (Object k : this.additionlConnectionProperties.keySet()) {
                if (!(k instanceof String)) continue;
                String value = this.additionlConnectionProperties.getProperty((String)k);
                session.setConfig((String)k, value);
            }
        }
        this.log(String.valueOf(Messages.getString("SSHBase.1")) + this.host + ":" + this.port);
        session.connect();
        return session;
    }

    protected SSHUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setAdditionalConnectionProperties(Properties additionalProperties) {
        this.additionlConnectionProperties = additionalProperties;
    }

    public Properties getAdditionlConnectionProperties() {
        return this.additionlConnectionProperties;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getProxyProtocol() {
        return this.proxyProtocol;
    }

    public void setProxyProtocol(int proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }
}

