/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.AMQPSendMessageActionCodeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.amqp.AMQPFileSender;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.concurrent.TimeoutException;

public class AMQPSendFileActionCodeI
extends AMQPSendMessageActionCodeI {
    private Boolean deleteSendFiles;
    private String doneDir;
    PostSentOperation postSentOperation;
    boolean fileMode;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initSender(ResultSet rSet) throws EngineExceptionI {
        this.jfs = new AMQPFileSender();
        String inFileMask = this.getLocalStringBindedParameter(rSet, "IN_FILE_MASK");
        String inFileDir = this.getLocalStringBindedParameter(rSet, "IN_FILE_DIR", null);
        if (inFileDir == null) {
            File file = new File(inFileMask);
            if (!file.isAbsolute()) throw new EngineExceptionI(Messages.getString("AMQP.ERROR_009"));
            ((AMQPFileSender)this.jfs).setSendDirectory(file.getParent());
            ((AMQPFileSender)this.jfs).setFileMask(file.getName());
        } else {
            ((AMQPFileSender)this.jfs).setFileMask(inFileMask);
            ((AMQPFileSender)this.jfs).setSendDirectory(inFileDir);
        }
        this.postSentOperation = PostSentOperation.valueOf(this.getLocalStringBindedParameter(rSet, "AMQP_SENT_FILES_BEHAVIOUR", this.doneDir != null ? "move" : "keep"));
        if ((this.postSentOperation == PostSentOperation.move || this.postSentOperation == PostSentOperation.copy) && this.doneDir == null) {
            throw new EngineExceptionI(Messages.getString("AMQP.ERROR_010"));
        }
        this.doneDir = this.getLocalStringBindedParameter(rSet, "AMQP_SENT_FILES_DIR", null);
    }

    @Override
    protected void send() throws IOException, InterruptedException, TimeoutException {
        ((AMQPFileSender)this.jfs).send(this.amqpConnection);
        this.commit();
        if (this.postSentOperation == PostSentOperation.delete) {
            if (this.deleteSendFiles.booleanValue()) {
                ((AMQPFileSender)this.jfs).deleteSendFiles();
            }
        } else if (this.postSentOperation == PostSentOperation.copy) {
            ((AMQPFileSender)this.jfs).copySentFiles(this.doneDir, false);
        } else if (this.postSentOperation == PostSentOperation.move) {
            ((AMQPFileSender)this.jfs).copySentFiles(this.doneDir, true);
        }
    }

    static enum PostSentOperation {
        keep,
        copy,
        move,
        delete;

    }
}

