/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.SqlFileExportActionCodeI;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class FileConcatActionCodeI
extends ActionCodeTypeI {
    private boolean appendMode;
    private boolean addAppendLineSeparator;
    private Integer headerSize;
    private Integer footerSize;
    private boolean keepHeaderOnFirstFile;
    private boolean keepFooterOnLastFile;
    private String outFileName;
    private Integer fileBufferSize;
    private String inEncoding;
    private String outEncoding;
    private String fileSeparator;
    private String fileSortOrder;
    private boolean isDirectBind;
    private boolean isFirstBindedResult;
    private Map<String, String> inputFileMaskMap = new LinkedHashMap<String, String>();

    public FileConcatActionCodeI() {
        this.actionCodeName = "File Concat Class";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        try {
            this.outFileName = this.getLocalStringBindedParameter(rSet, "OUT_FILE_NAME");
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(Messages.getString("FileConcatActionCodeI.0"));
        }
        try {
            String[] fileMaskArray;
            String sourceFileMask = this.getLocalStringBindedParameter(rSet, "IN_FILE_MASK");
            String[] stringArray = fileMaskArray = sourceFileMask.split(Pattern.quote("|"));
            int n = fileMaskArray.length;
            int n2 = 0;
            while (n2 < n) {
                String currentFileMask = stringArray[n2];
                File file = new File(currentFileMask).getParentFile();
                if (!file.exists()) {
                    throw new EngineExceptionI(String.valueOf(file.getAbsolutePath()) + Messages.getString("FileConcatActionCodeI.1"));
                }
                String fileMask = new File(currentFileMask).getName();
                this.inputFileMaskMap.put(file.getAbsolutePath(), fileMask);
                ++n2;
            }
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(Messages.getString("FileConcatActionCodeI.2"));
        }
        try {
            this.fileBufferSize = this.getLocalIntegerBindedParameter(rSet, "FILE_BUFFER_SIZE");
        }
        catch (EngineExceptionI e) {
            this.fileBufferSize = 8192;
        }
        try {
            this.appendMode = this.getLocalBooleanBindedParameter(rSet, "APPEND_MODE");
        }
        catch (EngineExceptionI e) {
            this.appendMode = false;
        }
        try {
            this.addAppendLineSeparator = this.getLocalBooleanBindedParameter(rSet, "APPEND_LINE_SEPARATOR");
        }
        catch (EngineExceptionI e) {
            this.addAppendLineSeparator = false;
        }
        try {
            this.keepHeaderOnFirstFile = this.getLocalBooleanBindedParameter(rSet, "KEEP_HEADER_ON_FIRST");
        }
        catch (EngineExceptionI e) {
            this.keepHeaderOnFirstFile = true;
        }
        try {
            this.keepFooterOnLastFile = this.getLocalBooleanBindedParameter(rSet, "KEEP_FOOTER_ON_LAST");
        }
        catch (EngineExceptionI e) {
            this.keepFooterOnLastFile = true;
        }
        try {
            String headerText = this.getLocalStringBindedParameter(rSet, "HEADER_TEXT");
            if (headerText != null) {
                this.headerSize = headerText.length();
            }
        }
        catch (EngineExceptionI e) {
            this.headerSize = 0;
        }
        if (this.headerSize == 0) {
            try {
                this.headerSize = this.getLocalIntegerBindedParameter(rSet, "HEADER_SIZE");
            }
            catch (EngineExceptionI e) {
                this.headerSize = 0;
            }
        }
        try {
            String footerText = this.getLocalStringBindedParameter(rSet, "FOOTER_TEXT");
            if (footerText != null) {
                this.footerSize = footerText.length();
            }
        }
        catch (EngineExceptionI e) {
            this.footerSize = 0;
        }
        if (this.footerSize == 0) {
            try {
                this.footerSize = this.getLocalIntegerBindedParameter(rSet, "FOOTER_SIZE");
            }
            catch (EngineExceptionI e) {
                this.footerSize = 0;
            }
        }
        this.inEncoding = this.getLocalStringBindedParameter(rSet, "IN_FILE_ENCODING", Charset.defaultCharset().displayName());
        this.outEncoding = this.getLocalStringBindedParameter(rSet, "OUT_FILE_ENCODING", Charset.defaultCharset().displayName());
        try {
            this.fileSeparator = this.getLocalStringBindedParameter(rSet, "FILE_SEPARATOR");
            this.fileSeparator = SqlFileExportActionCodeI.decodeSpecialChar(this.fileSeparator);
        }
        catch (EngineExceptionI e) {
            String tmp = this.getLocalStringBindedParameter(rSet, "FILE_XSEPARATOR", null);
            this.fileSeparator = tmp != null ? new String(StringOperations.hexStringToArrayByte((String)tmp)) : "";
        }
        try {
            this.fileSortOrder = this.getLocalStringBindedParameter(rSet, "FILE_SORT_ORDER");
        }
        catch (EngineExceptionI e) {
            this.fileSortOrder = "none";
        }
        boolean bl = this.isDirectBind = rSet != null;
        if (this.isDirectBind) {
            try {
                this.isFirstBindedResult = rSet.isFirst();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        long T1 = System.currentTimeMillis();
        final boolean isFileSystemCaseSensitive = !new File("a").equals(new File("A"));
        ArrayList<File> sourceFiles = new ArrayList<File>();
        if (!this.inputFileMaskMap.isEmpty()) {
            for (String inDirPath : this.inputFileMaskMap.keySet()) {
                String sourceFileMask = this.inputFileMaskMap.get(inDirPath);
                File dir = new File(inDirPath);
                File[] fileArray = dir.listFiles(new FileFilter(sourceFileMask){
                    final String includeRegexp;
                    {
                        this.includeRegexp = StringOperations.replaceWildCharsWithGroups((String)string);
                    }

                    @Override
                    public boolean accept(File pathname) {
                        if (isFileSystemCaseSensitive) {
                            return pathname.getName().matches(this.includeRegexp);
                        }
                        return pathname.getName().toLowerCase().matches(this.includeRegexp.toLowerCase());
                    }
                });
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File _file = fileArray[n2];
                    if (Thread.interrupted()) {
                        throw new EngineExceptionI(Messages.getString("FileConcatActionCodeI.3"));
                    }
                    if (_file.isFile()) {
                        sourceFiles.add(_file);
                    }
                    ++n2;
                }
            }
        }
        if ("alphabetical - ascending".equals(this.fileSortOrder)) {
            sourceFiles.sort((f1, f2) -> f1.getName().compareTo(f2.getName()));
        } else if ("alphabetical - descending".equals(this.fileSortOrder)) {
            sourceFiles.sort((f1, f2) -> f2.getName().compareTo(f1.getName()));
        }
        long totalSize = 0L;
        try {
            File outFile = new File(this.outFileName);
            boolean isOutputFileAlreadyExistsAndNotEmpty = outFile.exists() && outFile.length() > 0L;
            BufferedOutputStream _out = new BufferedOutputStream(new FileOutputStream(this.outFileName, this.appendMode));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)_out, this.outEncoding);
            if (isOutputFileAlreadyExistsAndNotEmpty && this.appendMode && this.addAppendLineSeparator) {
                out.write(this.fileSeparator.toCharArray());
            }
            int i = 0;
            while (i < sourceFiles.size()) {
                boolean removeHeader;
                if (i > 0 || this.isDirectBind && !this.isFirstBindedResult) {
                    out.write(this.fileSeparator.toCharArray());
                }
                int byteSize = this.headerSize > this.footerSize ? this.headerSize : this.footerSize;
                byteSize = byteSize < this.fileBufferSize ? this.fileBufferSize : byteSize;
                char[] buf = new char[byteSize];
                int _byteSize = byteSize;
                boolean bl = i == 0 && !this.appendMode ? !this.keepHeaderOnFirstFile : (removeHeader = true);
                boolean removeFooter = i == sourceFiles.size() - 1 ? !this.keepFooterOnLastFile : true;
                long size = this.getCharacterNumberFromFile((File)sourceFiles.get(i));
                BufferedInputStream _in = new BufferedInputStream(new FileInputStream((File)sourceFiles.get(i)));
                InputStreamReader in = new InputStreamReader((InputStream)_in, this.inEncoding);
                long nbRead = 0L;
                int c = 0;
                do {
                    boolean skip = false;
                    if (removeHeader && this.headerSize > 0) {
                        _byteSize = this.headerSize;
                        skip = true;
                        removeHeader = false;
                    } else if (removeFooter && this.footerSize > 0) {
                        if (nbRead + (long)byteSize + (long)this.footerSize.intValue() <= size) {
                            _byteSize = byteSize;
                        } else if (nbRead + (long)this.footerSize.intValue() == size) {
                            _byteSize = this.footerSize;
                            skip = true;
                            removeFooter = false;
                        } else if (nbRead + (long)byteSize + (long)this.footerSize.intValue() > size) {
                            _byteSize = (int)(size - nbRead - (long)this.footerSize.intValue());
                        }
                    } else {
                        _byteSize = byteSize;
                    }
                    c = in.read(buf, 0, _byteSize);
                    if (c > 0) {
                        if (!skip) {
                            out.write(buf, 0, c);
                        }
                        nbRead += (long)c;
                    }
                    this.publishVariable("OUT_FILE_SIZE", new Long(totalSize += nbRead));
                } while (c >= 0);
                this.publishVariable("IN_NB_FILES", new Integer(i + 1));
                in.close();
                _in.close();
                out.flush();
                ++i;
            }
            out.close();
            _out.close();
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return 0;
    }

    private long getCharacterNumberFromFile(File file) throws IOException {
        StringBuilder stringBuilder;
        long size = 0L;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Reader inputStreamReader = null;
        try {
            int charsRead;
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, this.inEncoding);
            int bufferSize = 1024;
            char[] buffer = new char[1024];
            stringBuilder = new StringBuilder();
            int counter = 0;
            while ((charsRead = inputStreamReader.read(buffer, 0, buffer.length)) > 0) {
                stringBuilder.append(buffer, 0, charsRead);
                if (++counter % 10000 != 0) continue;
                size += (long)stringBuilder.length();
                stringBuilder = new StringBuilder();
            }
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return size += (long)stringBuilder.length();
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

