/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.action.ant.AntCopy;
import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.tools.ant.types.FileSet;

public class FileCopyActionCodeI
extends AntActionCodeTypeI {
    AntCopy fileManager;
    public static final String FILE_SEPARATOR = ";";
    String sFromFile;
    String sFromDir;
    String sToFile;
    String sToDir;
    String sOverwriteMode = "NOT";
    long lOverwriteDelay = 0L;
    boolean bFlattenMode = false;
    boolean bIncludeEmpty = false;
    boolean bPreserveLastModified = false;
    String sExcludes;
    String sIncludes;
    String sGlobMapper;
    private boolean failsOnError;
    private boolean casesensitive;
    private boolean defaultExcludes;
    private String sGlobMapperType;

    public FileCopyActionCodeI() {
        this.actionCodeName = "Copy File Class";
        this.actionClassName = "FileCopyActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("FileCopyActionCodeI.0"), 3, "DEBUG");
        this.connectionName = this.getLocalStringBindedParameter(rSet, "SQL_CONNECTION", "");
        this.sqlTransName = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_NAME", "T1");
        this.sqlTransType = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_TYPE", "AUTOCOMMIT");
        this.sqlSchemaName = this.getLocalStringBindedParameter(rSet, "SQL_SCHEMA_NAME", "");
        if (!this.sqlSchemaName.equals("")) {
            this.sqlSchemaName = String.valueOf(this.sqlSchemaName) + ".";
        }
        this.sToDir = this.getLocalStringBindedParameter(rSet, "FILE_TO_DIR", "");
        this.sToFile = this.getLocalStringBindedParameter(rSet, "FILE_TO_FILE", "");
        this.sFromDir = this.getLocalStringBindedParameter(rSet, "FILE_FROM_DIR", "");
        this.sFromFile = this.getLocalStringBindedParameter(rSet, "FILE_FROM_FILE", "");
        this.sOverwriteMode = this.getLocalStringBindedParameter(rSet, "FILE_OVERWRITE_MODE", "NOT");
        this.lOverwriteDelay = this.getLocalLongBindedParameter(rSet, "FILE_OVERWRITE_DELAY", Long.MAX_VALUE);
        this.bFlattenMode = this.getLocalBooleanBindedParameter(rSet, "FILE_FLATTEN_MODE", false);
        this.bIncludeEmpty = this.getLocalBooleanBindedParameter(rSet, "FILE_INCLUDE_EMPTY_DIRS", false);
        this.bPreserveLastModified = this.getLocalBooleanBindedParameter(rSet, "FILE_PRESERVE_LAST_MODIFIED", false);
        this.sIncludes = this.getLocalStringBindedParameter(rSet, "FILE_INCLUDES", "");
        this.sExcludes = this.getLocalStringBindedParameter(rSet, "FILE_EXCLUDES", "");
        this.sGlobMapper = this.getLocalStringBindedParameter(rSet, "FILE_TARGET_MAPPER", "");
        this.sGlobMapperType = this.getLocalStringBindedParameter(rSet, "FILE_TARGET_MAPPER_TYPE", "glob");
        this.casesensitive = this.getLocalBooleanBindedParameter(rSet, "FILE_CASE_SENSITIVE", true);
        this.defaultExcludes = this.getLocalBooleanBindedParameter(rSet, "FILE_DEFAULT_EXLUDES", true);
        this.failsOnError = this.getLocalBooleanBindedParameter(rSet, "FILE_FAILS_ON_ERROR", true);
        this.debugLog("prepare", String.valueOf(this.actionName) + Messages.getString("FileCopyActionCodeI.1"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        int prec = this.fileManager != null ? this.fileManager.getNumFile() : 0;
        this.fileManager = new AntCopy(this.casesensitive, this.defaultExcludes);
        this.fileManager.setAntProject(this.project);
        this.fileManager.setActionCode(this);
        this.fileManager.setNumFile(prec);
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("FileCopyActionCodeI.2")) + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("FileCopyActionCodeI.3"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
            this.fileManager.setJdbcInformation(this.jdbcConnection, this.sqlSchemaName);
        }
        try {
            String separator;
            String[] lstglobMapper;
            String[] lstExcludes;
            String[] lstIncludes;
            if (this.jdbcConnection != null) {
                if (this.sqlTransType.equals("AUTOCOMMIT") || this.sqlTransType.equals("AUTONOMOUS")) {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)true);
                } else {
                    ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)false);
                }
            }
            this.fileManager.setFailOnError(this.failsOnError);
            if (!this.sToDir.isEmpty()) {
                this.fileManager.setToDir(new File(this.sToDir));
            }
            if (!this.sFromFile.isEmpty()) {
                this.fileManager.setFromFile(new File(this.sFromFile));
            }
            File fromDir = new File(this.sFromDir);
            if (!this.sFromDir.isEmpty() && this.sIncludes.isEmpty() && this.sExcludes.isEmpty()) {
                this.fileManager.initFileSet();
                this.fileManager.setFromDir(fromDir);
            }
            if (!this.sToFile.isEmpty()) {
                this.fileManager.setToFile(new File(this.sToFile));
            }
            this.fileManager.setFlatten(this.bFlattenMode);
            this.fileManager.setIncludeEmptyDirs(this.bIncludeEmpty);
            this.fileManager.setPreserveLastModified(this.bPreserveLastModified);
            FileSet fileSet = new FileSet();
            fileSet.setDir(fromDir);
            if (!this.sIncludes.isEmpty() && (lstIncludes = this.sIncludes.replace(",", FILE_SEPARATOR).split(FILE_SEPARATOR)) != null && lstIncludes.length > 0) {
                fileSet.appendIncludes(lstIncludes);
                this.fileManager.addFileset(fileSet);
            }
            if (!this.sExcludes.isEmpty() && (lstExcludes = this.sExcludes.replace(",", FILE_SEPARATOR).split(FILE_SEPARATOR)) != null && lstExcludes.length > 0) {
                if (!fileSet.hasPatterns()) {
                    this.fileManager.addFileset(fileSet);
                }
                fileSet.appendExcludes(lstExcludes);
            }
            if (this.sOverwriteMode.equals("NOT")) {
                this.fileManager.setOverwrite(false);
                this.lOverwriteDelay = Long.MAX_VALUE;
                this.fileManager.setGranularity(this.lOverwriteDelay);
            } else if (this.sOverwriteMode.equals("ALWAYS")) {
                this.fileManager.setOverwrite(true);
                this.lOverwriteDelay = 0L;
                this.fileManager.setGranularity(this.lOverwriteDelay);
            } else if (this.sOverwriteMode.equals("NEWER")) {
                this.fileManager.setOverwrite(false);
                this.lOverwriteDelay = 0L;
                this.fileManager.setGranularity(this.lOverwriteDelay);
            } else if (this.sOverwriteMode.equals("AFTER_DELAY")) {
                this.fileManager.setOverwrite(false);
                this.fileManager.setGranularity(this.lOverwriteDelay);
            }
            if (!this.sGlobMapper.isEmpty() && (lstglobMapper = this.sGlobMapper.split(separator = this.sGlobMapper.contains(">") ? ">" : "=")) != null && lstglobMapper.length == 2) {
                this.fileManager.setGlobalMapper(lstglobMapper[0], lstglobMapper[1], this.sGlobMapperType);
            }
            this.fileManager.execute();
            this.publishCumulativeVariable("FILE_NB", String.valueOf(this.fileManager.getNumFile() - prec), "Integer", false);
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>executeSimpleCode : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

