/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.ftp.FtpActionCodeI;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FtpExecActionCodeI
extends FtpActionCodeI {
    String ftpRemotePath;
    private String command;
    private Boolean multiCommand;
    private String multiCommandSeparators;
    private String multiCommandExclusionsRules;
    private Boolean ftpSendSiteCommand;
    private Integer ftpMinAcceptedReturnCode;
    private Integer ftpMaxAcceptedReturnCode;

    public FtpExecActionCodeI() {
        this.actionCodeName = "Ftp Get Class";
        this.actionClassName = "FtpGetActionCodeI";
        this.bNullCodeAllowed = true;
    }

    @Override
    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.multiCommand = this.getLocalBooleanBindedParameter(rSet, "MULTI_COMMANDS", true);
        this.multiCommandSeparators = this.getLocalStringBindedParameter(rSet, "MULTI_COMMANDS_SEPARATORS", "\n");
        this.multiCommandExclusionsRules = this.getLocalStringBindedParameter(rSet, "SQL_MULTI_QUERYS_EXCLUSION_PATTERNS", "/\\*|\\*/;'");
        if (this.actionTxtCode != null && !this.actionTxtCode.equals("")) {
            if (rSet != null) {
                try {
                    this.command = this.getFinalBindedCode(rSet, this.actionTxtCode);
                }
                catch (Exception e) {
                    this.debugLog("prepare", "Exception : " + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                    throw new EngineExceptionI((Throwable)e);
                }
            } else {
                this.command = this.actionTxtCode;
            }
        }
        this.debugLog("prepare", Messages.getString("FtpExecActionCodeI.0"), 3, "DEBUG");
        this.ftpHostname = this.getLocalSecretBindedParameter(rSet, "FTP_HOSTNAME", null);
        this.ftpUser = this.getLocalSecretBindedParameter(rSet, "FTP_USER", null);
        if (this.ftpHostname == null || this.ftpUser == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("FtpExecActionCodeI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("FtpExecActionCodeI.2"));
        }
        this.ftpPassword = this.getLocalSecretBindedParameter(rSet, "FTP_PASSWORD", this.getLocalStringBindedParameter(rSet, "FTP_UNCRYPTED_PASSWORD", ""));
        this.FTPSProtocol = this.getLocalStringBindedParameter(rSet, "FTP_SECURE_PROTOCOL", "NONE");
        this.implicitFTPS = this.getLocalBooleanBindedParameter(rSet, "FTP_IMPLICIT_FTPS", true);
        this.ftpPort = this.getLocalSecretBindedParameter(rSet, "FTP_PORT", null);
        if (this.ftpPort.isNull()) {
            int dftPort = this.FTPSProtocol.equals("NONE") ? 21 : (this.implicitFTPS != false ? 990 : 21);
            this.publishVariable("FTP_PORT", String.valueOf(dftPort), "Integer", false);
            this.ftpPort.setDefaultValue(String.valueOf(dftPort));
        }
        this.ftpMode = this.getLocalStringBindedParameter(rSet, "FTP_FILE_MODE", null);
        if (this.ftpMode != null) {
            this.ftpMode = this.ftpMode.toLowerCase(Locale.getDefault());
        }
        this.ftpPassiveMode = this.getLocalBooleanBindedParameter(rSet, "FTP_PASSIVE_MODE", true);
        this.ftpRemotePath = this.getLocalStringBindedParameter(rSet, "FTP_REMOTE_PATH", "");
        this.ftpMinAcceptedReturnCode = this.getLocalIntegerBindedParameter(rSet, "FTP_MIN_ACCEPTED_RETURN_CODE", 200);
        this.ftpMaxAcceptedReturnCode = this.getLocalIntegerBindedParameter(rSet, "FTP_MAX_ACCEPTED_RETURN_CODE", 399);
        this.ftpSendSiteCommand = false;
        super.prepare(rSet);
        this.debugLog("prepare", String.valueOf(this.actionName) + Messages.getString("FtpExecActionCodeI.3"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    boolean acceptFilter(String filter, String attribute) throws EngineExceptionI {
        Boolean bFinded;
        block6: {
            block5: {
                bFinded = false;
                if (filter != null) break block5;
                return true;
            }
            if (!filter.equals("")) break block6;
            return true;
        }
        try {
            Pattern pDeb = Pattern.compile(filter);
            Matcher mDeb = pDeb.matcher(attribute);
            bFinded = mDeb.matches();
        }
        catch (PatternSyntaxException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpExecActionCodeI.4"), "String", false);
            throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpExecActionCodeI.5"));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return bFinded;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        try {
            try {
                boolean reply = false;
                this.setProxySocketFactory();
                if (this.connect()) {
                    if (this.ftpPassiveMode.booleanValue()) {
                        this.ftp.enterLocalPassiveMode();
                    }
                    long debTime = new Date().getTime();
                    Boolean changeDirOk = true;
                    if (!this.ftpRemotePath.equals("")) {
                        changeDirOk = this.ftp.changeWorkingDirectory(this.ftpRemotePath);
                    }
                    if (!changeDirOk.booleanValue()) {
                        this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + Messages.getString("FtpExecActionCodeI.6") + this.ftpRemotePath, "String", false);
                        throw new EngineExceptionI(String.valueOf(this.actionClassName) + Messages.getString("FtpExecActionCodeI.7") + this.ftpRemotePath);
                    }
                    if (this.command != null && !this.command.isEmpty()) {
                        ArrayList<String> _cmds = new ArrayList<String>();
                        if (this.multiCommand.booleanValue()) {
                            String[] stringArray = this.command.split("\n");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String _cmd = stringArray[n2];
                                _cmds.add(_cmd);
                                ++n2;
                            }
                        } else {
                            _cmds.add(this.command);
                        }
                        String msg = null;
                        for (String _command : _cmds) {
                            String[] cmds;
                            if (this.ftpSendSiteCommand.booleanValue() || (cmds = _command.split(" ")).length < 1) continue;
                            String cmd = cmds[0];
                            String args = null;
                            if (cmds.length > 1) {
                                args = "";
                                int i = 1;
                                while (i < cmds.length) {
                                    if (i > 1) {
                                        args = String.valueOf(args) + " ";
                                    }
                                    args = String.valueOf(args) + cmds[i];
                                    ++i;
                                }
                            }
                            String msgRet = null;
                            if (cmd.toLowerCase().trim().equals("ls")) {
                                String[] result = args != null ? this.ftp.listNames(args) : this.ftp.listNames();
                                ret = this.ftp.getReplyCode();
                                if (result != null) {
                                    String[] stringArray = result;
                                    int n = result.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        String tmp = stringArray[n3];
                                        msgRet = msgRet != null ? String.valueOf(msgRet) + "\n" : "";
                                        msgRet = String.valueOf(msgRet) + tmp;
                                        ++n3;
                                    }
                                }
                            } else {
                                ret = args == null ? this.ftp.sendCommand(cmd) : this.ftp.sendCommand(cmd, args);
                                msgRet = this.ftp.getReplyString();
                            }
                            if (ret >= this.ftpMinAcceptedReturnCode && ret <= this.ftpMaxAcceptedReturnCode) {
                                if (msgRet == null || msgRet.isEmpty()) continue;
                                msg = msg != null ? String.valueOf(msg) + "\n" : "";
                                msg = String.valueOf(msg) + msgRet;
                                this.publishVariable("RET_MESS", msg, "String");
                                continue;
                            }
                            throw new EngineExceptionI(this.ftp.getReplyString());
                        }
                    }
                }
            }
            catch (Exception e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(this.actionClassName) + "=>executeSimpleCode : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            try {
                this.ftp.logout();
                this.ftp.disconnect();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

