/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.IndyContentHandler;
import com.indy.engine.actionCodes.utils.XmlDataTypeProvider;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.actionCodes.xml.unload.XmlWriterAPI;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.indy.engine.common.tools.internal.JavaGenericOperation;
import com.indy.engine.common.tools.internal.JavaGenericOutputStreamTransformer;
import com.indy.engine.core.IScriptingEngineProvider;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JdbcToXmlActionCodeI
extends ActionCodeTypeI {
    private boolean forceWritemode = false;
    private int flushFrequency = 100000;
    private int statisticFrequency = 100000;
    protected boolean handleStatisticAndLog = true;
    private int totalElements;
    private int totalAttributes;
    private int totalLines;
    private long totalQueryTime;
    private long totalGenarationTime;
    private TreeMap<String, IndyResultSet> resultSets;
    private HashMap<String, IndyQuerySet> querySets;
    private IndyElement root;
    private InputStream is;
    BidiMap<String, String> namespaces = new BidiMap();
    private String targetNamespace;
    private boolean prefixForElement;
    private boolean prefixForAttribute;
    private File temporaryFolder;
    Map<String, IndyItem> tags = new HashMap<String, IndyItem>();
    private String fileMask;
    private String superRoot;
    private String superRootType;
    private long totalSize;
    private long previousTotalSize = 0L;
    private boolean writeXmlDescriptor;
    private Integer fetchSize;
    protected boolean commit;
    private AbstractXmlWriterAPI xwa;
    private String lastOutFile;
    private boolean writeMetaDataAttribut;
    private boolean writeAllTag;
    private String elementToKeep;
    private boolean writeKeyValue;
    private String disableBranchs;
    private int nbexecutedQuerys;
    private String outFileNameVar;
    private boolean nillableIsForce;
    private String xsiPrefix;
    private boolean defaultNillable;
    AbstractDataTypeConverter dataTypeProvider;
    private Boolean forceUsedCData = false;
    AbstractXmlWriterAPI.NoDataBehaviour noDataBehaviour = AbstractXmlWriterAPI.NoDataBehaviour.deleteExistingFile;
    AbstractXmlWriterAPI.FileAlreadyExistsBehaviour fileAlreadyExistsBehaviour = AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.replace;
    private boolean isWriteNullJsonNode = false;
    private boolean isWriteEmptyJsonNode = false;
    private boolean isJsonLinesFormat = false;
    boolean defaultWriteXsiType = false;
    private String emptyValueKeyWord;
    private String attributeNullValueReplacement;
    private boolean useJsonWriter = false;
    private OutputStreamTransformerInitalizer osti;
    static int FORCE_NILLABLE_TO_TRUE = 1;
    static int FORCE_NILLABLE_TO_FALSE = 2;
    static int NILLABLE_TO_TRUE = 4;
    static int NILLABLE_TO_DEFAULT = 0;
    static Templates templates;
    private static final Object templatesLock;
    public static String xsiUri;
    public static String jsonUri;
    public String jsonPrefix = null;
    private boolean writeJsonAttributes = false;
    Map<String, Long> previousStat = new HashMap<String, Long>();
    boolean opening = false;
    int nbFiles;
    int previousNbFiles = 0;
    IndyElement jsonRootElement;
    List<Object> eltsToOpen = new ArrayList<Object>();
    List<IndyElement> eltsToClose = new ArrayList<IndyElement>();
    boolean hasXsiAttribute = false;
    public boolean hasRawData;

    static {
        templatesLock = new Object();
        xsiUri = "http://www.w3.org/2001/XMLSchema-instance";
        jsonUri = "http://www.stambia.com/2014/json";
    }

    public JdbcToXmlActionCodeI() {
        super("Java Jdbc to Xml Class", false);
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return 0;
    }

    protected int prepare(ResultSet rs) throws EngineExceptionI {
        String jsonEscapeSlashCharacter;
        int ret = 0;
        String overload = this.getLocalStringBindedParameter(rs, "OVERRIDE_ACTION_PARAMETERS", null);
        if (overload != null) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(overload.getBytes()));
                this.fillOverLoadParameters(prop);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.outFileNameVar = this.getLocalStringBindedParameter(rs, "OUT_FILE_NAME_VAR", null);
        this.connectionName = this.getLocalStringBindedParameter(rs, "SQL_CONNECTION", "");
        this.sqlTransName = this.getLocalStringBindedParameter(rs, "SQL_TRANSACTION_NAME", "T1");
        this.setTransactionAndCommit(this.getLocalStringBindedParameter(rs, "SQL_TRANSACTION_TYPE", null), true);
        this.is = new ByteArrayInputStream(this.actionTxtCode.getBytes(StandardCharsets.UTF_8));
        this.writeXmlDescriptor = this.getLocalBooleanBindedParameter(rs, "WRITE_XML_DESCRIPTOR", false);
        String tempFolder = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + Constant.VAR_CORE_TEMPORARY_FOLDER);
        this.temporaryFolder = new File(String.valueOf(tempFolder) + "/" + "JdbcToXmlActionCodeLog");
        if (!this.temporaryFolder.exists()) {
            this.temporaryFolder.mkdirs();
        }
        this.fileMask = this.getLocalStringBindedParameter(rs, "OUT_FILE_MASK", null);
        this.superRoot = this.getLocalStringBindedParameter(rs, "SUPER_ROOT_NAME", null);
        this.superRootType = this.getLocalStringBindedParameter(rs, "SUPER_ROOT_TYPE", null);
        if (this.superRoot != null && this.superRoot.equals("<disable>")) {
            this.superRoot = null;
        }
        this.fetchSize = this.getLocalIntegerBindedParameter(rs, "SQL_FETCH_SIZE", this.runtimeContext.DEFAULT_FETCH_SIZE);
        this.writeMetaDataAttribut = this.getLocalBooleanBindedParameter(rs, "WRITE_METADATA_ATTRIBUTS", false);
        this.commit = this.getLocalBooleanBindedParameter(rs, "XML_COMMIT", true);
        String xmlVersion = this.getLocalStringBindedParameter(rs, "WRITE_XML_VERSION", "1.0");
        String encoding = this.getLocalStringBindedParameter(rs, "OUT_FILE_ENCODING", null);
        this.writeAllTag = this.getLocalBooleanBindedParameter(rs, "WRITE_ALL_TAG", true);
        this.elementToKeep = this.getLocalStringBindedParameter(rs, "KEEP_ELEMENTS", "").replaceAll(" ", "");
        this.writeKeyValue = this.getLocalBooleanBindedParameter(rs, "WRITE_KEY_VALUES", false);
        this.isJsonLinesFormat = this.getLocalBooleanBindedParameter(rs, "JSON_LINES_FORMAT", false);
        if (encoding != null && encoding.isEmpty()) {
            encoding = null;
        }
        boolean writeXmlDeclaration = this.getLocalBooleanBindedParameter(rs, "WRITE_XML_DECLARATION", true);
        String inputFile = this.getLocalStringBindedParameter(rs, "OUT_FILE_NAME");
        if (inputFile != null && inputFile.startsWith("<tempDir>")) {
            File _tempFilder = new File(tempFolder);
            if (!_tempFilder.exists()) {
                _tempFilder.mkdirs();
            }
            inputFile = _tempFilder + "/" + inputFile.substring(9);
        }
        File outFile = new File(inputFile);
        String xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY", null);
        String xmlOutPutFactoryModule = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY_MODULE", null);
        if (xmlOutPutFactoryClassName == null) {
            xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(rs, "XML_FACTORY_CLASS_NAME", this.runtimeContext.defaultXmlOutputFactory);
        }
        if (xmlOutPutFactoryClassName.contains("Json")) {
            this.useJsonWriter = true;
        }
        if (xmlOutPutFactoryClassName.matches("Bson")) {
            this.useJsonWriter = true;
        }
        this.handleStatisticAndLog = true;
        this.noDataBehaviour = AbstractXmlWriterAPI.NoDataBehaviour.valueOf(this.getLocalStringBindedParameter(rs, "NO_DATA_BEHAVIOUR", AbstractXmlWriterAPI.NoDataBehaviour.deleteExistingFile.name()));
        this.fileAlreadyExistsBehaviour = AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.valueOf(this.getLocalStringBindedParameter(rs, "FILE_EXISTS_BEHAVIOUR", AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.replace.name()));
        String _streamHookOne = this.getLocalStringBindedParameter(rs, "STREAM_HOOK_01", null);
        if (_streamHookOne != null) {
            this.osti = new OutputStreamTransformerInitalizer();
            OutputStreamTransformer.OutputStreamTransformerStatisticHandler ostsh = new OutputStreamTransformer.OutputStreamTransformerStatisticHandler(){

                public void handle(String name, long value) {
                    JdbcToXmlActionCodeI.this.handleStatistic(name, value);
                }
            };
            this.osti.init(_streamHookOne, this, this.engineContext, this.useJsonWriter, ostsh, (Map)this.namespaces);
        } else {
            this.osti = null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String json = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY.property.AVRO_SCHEMA", null);
        if (json != null) {
            properties.put("AVRO_SCHEMA", json);
        }
        if ("Disable".equals(jsonEscapeSlashCharacter = this.getLocalStringBindedParameter(rs, "JSON_ESCAPE_SLASH_CHARACTER", "Enable"))) {
            properties.put("JSON_ESCAPE_SLASH_CHARACTER", jsonEscapeSlashCharacter);
        }
        this.xwa = this.createWriter(encoding, writeXmlDeclaration, xmlVersion, xmlOutPutFactoryModule, xmlOutPutFactoryClassName, outFile, properties);
        this.disableBranchs = this.getLocalStringBindedParameter(rs, "DISABLE_BRANCHS", "");
        String _nillable = this.getLocalStringBindedParameter(rs, "NIL_BEHAVIOUR", "FalseIfNotDefined");
        this.defaultNillable = false;
        if (_nillable.equals("TrueIfNotDefined") || _nillable.equals("ForceToTrue")) {
            this.defaultNillable = true;
        }
        if (_nillable.equals("ForceToFalse") || _nillable.equals("ForceToTrue")) {
            this.nillableIsForce = true;
        }
        String jsonNodeNullBehaviour = this.getLocalStringBindedParameter(rs, "JSON_NODE_NULL_BEHAVIOUR", "Do Not Write Node");
        this.isWriteNullJsonNode = jsonNodeNullBehaviour.equals("Write Null Node");
        this.isWriteEmptyJsonNode = jsonNodeNullBehaviour.equals("Write Empty Node");
        this.defaultWriteXsiType = this.getLocalBooleanBindedParameter(rs, "ADD_XSI_TYPE", false);
        this.forceUsedCData = this.getLocalBooleanBindedParameter(rs, "FORCE_USED_CDATA", false);
        String dataTypeProviderClassName = this.getLocalStringBindedParameter(rs, "DATA_TYPE_PROVIDER", null);
        if (dataTypeProviderClassName != null) {
            try {
                String dataTypeProviderModule = this.getLocalStringBindedParameter(rs, "DATA_TYPE_PROVIDER_MODULE", null);
                ClassLoader cl = dataTypeProviderModule != null ? ClassLoaderServiceProvider.INSTANCE.getClassLoader(dataTypeProviderModule, dataTypeProviderClassName) : ((Object)((Object)this)).getClass().getClassLoader();
                Class<?> clazz = cl.loadClass(dataTypeProviderClassName);
                this.dataTypeProvider = (AbstractDataTypeConverter)clazz.newInstance();
            }
            catch (Exception e) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("JdbcToXmlActionCodeI.0")) + dataTypeProviderClassName, (Throwable)e);
            }
        } else {
            this.dataTypeProvider = new XmlDataTypeProvider();
        }
        this.emptyValueKeyWord = this.getLocalStringBindedParameter(rs, "EMPTY_VALUE_KEYWORD", null);
        this.attributeNullValueReplacement = this.getLocalStringBindedParameter(rs, "ATTRIBUTE_NULL_VALUE_REPLACEMENT", null);
        this.clearOverLoadParameters();
        return ret;
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        int ret = 0;
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.1"), String.valueOf(Messages.getString("JdbcToXmlActionCodeI.2")) + this.totalLines, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.3"), String.valueOf(Messages.getString("JdbcToXmlActionCodeI.4")) + this.totalElements, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.5"), String.valueOf(Messages.getString("JdbcToXmlActionCodeI.6")) + this.totalAttributes, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.7"), String.valueOf(Messages.getString("JdbcToXmlActionCodeI.8")) + this.totalAttributes, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.9"), String.valueOf(Messages.getString("JdbcToXmlActionCodeI.10")) + this.totalQueryTime, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        this.debugLog(Messages.getString("JdbcToXmlActionCodeI.11"), String.valueOf(Messages.getString("JdbcToXmlActionCodeI.12")) + this.totalGenarationTime, this.runtimeContext.LOG_LEVEL1, this.runtimeContext.LOG_INFO);
        return ret;
    }

    public String convertCharset(String str, Charset newCharSet) {
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformSource3(InputStream inputStream, OutputStream os) throws EngineExceptionI {
        try {
            if (templates == null) {
                Object object = templatesLock;
                synchronized (object) {
                    if (templates == null) {
                        InputStream xslID = ((Object)((Object)new JdbcToXmlActionCodeI())).getClass().getClassLoader().getResourceAsStream("com/indy/engine/actionCodes/a/a.xsl");
                        TransformerFactory tfactory = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
                        tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                        tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                        tfactory.setURIResolver(new URIResolver(){

                            @Override
                            public Source resolve(String href, String base) throws TransformerException {
                                File file = new File("build/xsl/" + href);
                                if (file.exists()) {
                                    try {
                                        return new SAXSource(new InputSource(new FileInputStream(file)));
                                    }
                                    catch (FileNotFoundException e) {
                                        throw new TransformerException(e);
                                    }
                                }
                                return new SAXSource(new InputSource(((Object)((Object)new JdbcToXmlActionCodeI())).getClass().getClassLoader().getResourceAsStream("com/indy/engine/actionCodes/a/" + href)));
                            }
                        });
                        templates = tfactory.newTemplates(new StreamSource(xslID));
                    }
                }
            }
            Transformer transformer = templates.newTransformer();
            final ArrayList errors = new ArrayList();
            final ArrayList warnings = new ArrayList();
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException arg0) throws TransformerException {
                    warnings.add(arg0);
                }

                @Override
                public void fatalError(TransformerException arg0) throws TransformerException {
                    errors.add(arg0);
                }

                @Override
                public void error(TransformerException arg0) throws TransformerException {
                    errors.add(arg0);
                }
            });
            transformer.setParameter("elementsToKeep", this.elementToKeep);
            transformer.setParameter("branchsToDisable", this.disableBranchs);
            transformer.transform(new StreamSource(inputStream), new StreamResult(os));
            if (errors.size() > 0) {
                throw new EngineExceptionI((Throwable)errors.get(0));
            }
        }
        catch (TransformerConfigurationException e1) {
            throw new EngineExceptionI((Throwable)e1);
        }
        catch (TransformerException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public void buildMemoryTree(InputStream is) throws EngineExceptionI {
        try {
            this.resultSets = new TreeMap();
            this.querySets = new HashMap();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parserFactory.setFeature("http://xml.org/sax/features/validation", false);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader saxReader = parser.getXMLReader();
            SimpleContentHandler sch = new SimpleContentHandler(this.resultSets, this.querySets);
            saxReader.setContentHandler((ContentHandler)((Object)sch));
            saxReader.parse(new InputSource(is));
            this.root = sch.root;
            this.updateNamespace(this.root);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private void updateNamespace(IndyItem item) {
        if (!item.disablePrefix) {
            boolean enable;
            String string = item.namespace != null ? item.namespace : this.targetNamespace;
            boolean bl = enable = item == this.root || item.forcePrefix || this.prefixForElement && item instanceof IndyElement || this.prefixForAttribute && item instanceof IndyAttribute || string != null && this.targetNamespace == null || string != null && !string.equals(this.targetNamespace);
            if (string != null && enable) {
                item.namespace = string;
                item.prefix = (String)this.namespaces.getFrom((Object)string);
            }
        }
        if (item instanceof IndyElement) {
            for (IndyItem indyItem : ((IndyElement)item).elements) {
                this.updateNamespace(indyItem);
            }
            for (IndyItem indyItem : ((IndyElement)item).attributes) {
                this.updateNamespace(indyItem);
            }
        }
    }

    public void connection() {
        for (IndyResultSet rs : this.resultSets.values()) {
            rs.connection = this.jdbcConnection;
        }
    }

    public void handleDataStatistics(boolean last) {
        if (this.handleStatisticAndLog) {
            this.publishStatistic("SQL_NB_ROWS", this.totalLines, last);
            this.publishStatistic("XML_NB_ELEMENTS", this.totalElements, last);
            this.publishStatistic("XML_NB_ATTRIBUTES", this.totalAttributes, last);
        }
    }

    private void handleStatistic(String name, long value) {
        if (this.handleStatisticAndLog) {
            Long _value = this.previousStat.get(name);
            if (_value == null) {
                _value = value;
            } else {
                _value = _value + value;
                this.previousStat.put(name, _value);
            }
            this.publishCumulativeVariable(name, _value, "Long", false);
        }
    }

    public void handleFileStatistics(boolean last) {
        if (this.handleStatisticAndLog) {
            this.publishStatistic("OUT_FILE_SIZE", this.totalSize, last);
            this.publishStatistic("OUT_NB_FILES", this.nbFiles, last);
        }
    }

    public void handleQueryStatistics(boolean last) {
        if (this.handleStatisticAndLog) {
            this.publishStatistic("SQL_QUERYS_DURATION", this.totalQueryTime, last);
            this.publishStatistic("SQL_EXECUTED_QUERYS_NB", this.nbexecutedQuerys, last);
        }
    }

    public void startNewDocument() throws XMLStreamException, IOException {
        this.opening = this.xwa.startNewDocument(this.hasRawData);
        this.xwa.xmlw.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                String str = (String)JdbcToXmlActionCodeI.this.namespaces.getFrom((Object)namespaceURI);
                return str;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)JdbcToXmlActionCodeI.this.namespaces.getTo((Object)prefix);
            }
        });
    }

    public void endCurrentDocument(File file) throws Exception {
        boolean create = this.xwa.endCurrentDocument(file);
        if (create) {
            ++this.nbFiles;
            this.totalSize += file.length();
        }
        if (this.outFileNameVar != null) {
            this.engineContext.addVariable(this.outFileNameVar, this.actionContext.getActionName(), (Object)file.getAbsolutePath(), "string", false, false);
        }
        this.handleFileStatistics(false);
        this.handleDataStatistics(false);
        this.handleQueryStatistics(false);
    }

    public void write() throws EngineExceptionI {
        long start = System.currentTimeMillis();
        try {
            try {
                this.root.write();
            }
            catch (Exception e) {
                if (e instanceof EngineExceptionI) {
                    throw (EngineExceptionI)((Object)e);
                }
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            try {
                this.xwa.close();
            }
            catch (Exception e) {
                this.getActionCodeLogger().warn(Messages.getString("JdbcToXmlActionCodeI.13"), (Throwable)e);
            }
            try {
                if (this.root != null) {
                    this.root.closeAllResultSet();
                }
            }
            catch (Exception e) {
                this.getActionCodeLogger().warn(Messages.getString("JdbcToXmlActionCodeI.14"), (Throwable)e);
            }
        }
        this.totalGenarationTime = System.currentTimeMillis() - start - this.totalQueryTime;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        ByteArrayOutputStream out;
        block50: {
            String timeStamp;
            block49: {
                if (this.connectionName != null && !this.connectionName.equals("")) {
                    this.write(this.sessionName, String.valueOf(this.actionClassName) + "=>executeSimpleCode", String.valueOf(this.actionName) + Messages.getString("JdbcToXmlActionCodeI.15") + this.connectionName, 3, this.actionLevel, "DEBUG");
                    this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                    try {
                        ActionCodeTypeI.setAutoCommit((Connection)this.jdbcConnection, (boolean)this.isAutoCommit());
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.isRdbmsLinked = true;
                }
                this.dataTypeProvider.setGetDateHasTimestamp(this.getDateAsTimestamp);
                out = new ByteArrayOutputStream();
                timeStamp = new Long(System.currentTimeMillis()).toString();
                if (this.writeXmlDescriptor) {
                    String descriptor1 = String.valueOf(this.temporaryFolder.getAbsolutePath()) + "/" + timeStamp + "_descriptor1.xml";
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(descriptor1);
                        byte[] buf = new byte[1024];
                        int num = 0;
                        while ((num = this.is.read(buf)) != -1) {
                            fos.write(buf, 0, num);
                        }
                        fos.write(10);
                        fos.flush();
                        this.is.reset();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block49;
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                            break block49;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                            }
                        }
                    }
                    if (fos == null) break block49;
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.transformSource3(this.is, out);
            if (this.writeXmlDescriptor) {
                String descriptor2 = String.valueOf(this.temporaryFolder.getAbsolutePath()) + "/" + timeStamp + "_descriptor2.xml";
                FileOutputStream fos2 = null;
                try {
                    fos2 = new FileOutputStream(descriptor2);
                    fos2.write(out.toByteArray());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (fos2 != null) {
                        try {
                            fos2.close();
                        }
                        catch (IOException e4) {
                            e4.printStackTrace();
                        }
                    }
                    break block50;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        break block50;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (fos2 != null) {
                            try {
                                fos2.close();
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                        }
                    }
                }
                if (fos2 == null) break block50;
                try {
                    fos2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.buildMemoryTree(new ByteArrayInputStream(out.toByteArray()));
        this.flushFrequency = 10000;
        this.connection();
        this.addAdditionnalNamespaces();
        ClassLoader cl2 = null;
        if (this.osti != null && this.osti.streamHookOneCL != null) {
            cl2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.osti.streamHookOneCL);
        }
        try {
            try {
                this.write();
            }
            catch (EngineExceptionI e) {
                if (this.xwa.getWrapperException() != null && e.getCause() instanceof IOException) {
                    throw new EngineExceptionI((Throwable)this.xwa.getWrapperException());
                }
                throw e;
            }
        }
        finally {
            if (cl2 != null) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
        }
        if (this.xwa.getWrapperException() != null) {
            throw new EngineExceptionI((Throwable)this.xwa.getWrapperException());
        }
        this.handleDataStatistics(true);
        this.handleQueryStatistics(true);
        this.handleFileStatistics(true);
        return 0;
    }

    private File getOutFile() {
        return this.xwa.getOutFile();
    }

    boolean openEltToOpen(XMLStreamWriter xmlw) throws Exception {
        boolean justOpen = false;
        int i = 0;
        while (i < this.eltsToOpen.size()) {
            Object item = this.eltsToOpen.get(i);
            if (item instanceof IndyElement) {
                IndyElement elt = (IndyElement)item;
                if (!elt.isRoot || this.opening) {
                    this.xwa.writeStartElement(elt);
                    if ((this.defaultWriteXsiType || elt.writeXsiType) && elt.type != null && !elt.type.isEmpty()) {
                        xmlw.writeAttribute(this.xsiPrefix, xsiUri, "type", elt.type);
                    }
                    if (elt instanceof IndyElement && elt.isJsonArray) {
                        xmlw.writeAttribute(this.xsiPrefix, xsiUri, "type", String.valueOf(this.jsonPrefix) + ":array");
                        if (this.jsonRootElement == null) {
                            this.jsonRootElement = elt;
                        }
                    }
                    if (elt instanceof IndyElement && elt.isJsonObject) {
                        xmlw.writeAttribute(this.xsiPrefix, xsiUri, "type", String.valueOf(this.jsonPrefix) + ":object");
                        if (this.jsonRootElement == null) {
                            this.jsonRootElement = elt;
                        }
                    }
                    if (elt.isRoot && this.superRoot == null) {
                        for (String prefix : this.namespaces.keySet()) {
                            String nameSpaceUri = (String)this.namespaces.getTo((Object)prefix);
                            if (prefix != null) {
                                xmlw.writeNamespace(prefix, nameSpaceUri);
                                continue;
                            }
                            if (this.targetNamespace == null || !nameSpaceUri.equals(this.targetNamespace)) continue;
                            xmlw.writeDefaultNamespace(this.targetNamespace);
                        }
                    }
                    if (elt.isRoot && this.writeMetaDataAttribut) {
                        xmlw.writeNamespace("md", "http://www.stambia.com/md");
                    }
                    if (elt.staticStartItem != null && elt.staticStartItem.size() > 0) {
                        for (StaticItem _item : elt.staticStartItem) {
                            _item.write(this.xwa.xmlw);
                        }
                    }
                    if (i == this.eltsToOpen.size() - 1) {
                        justOpen = true;
                    } else if (elt.staticEndItem != null && elt.staticEndItem.size() > 0) {
                        for (StaticItem _item : elt.staticEndItem) {
                            _item.write(this.xwa.xmlw);
                        }
                    }
                }
                if (!elt.isRoot || !this.opening || this.commit) {
                    this.eltsToClose.add(elt);
                }
                ++this.totalElements;
            } else {
                Map staticAttribute = (Map)item;
                for (String name : staticAttribute.keySet()) {
                    if (name.startsWith("md:")) {
                        this.xwa.xmlw.writeAttribute(name, (String)staticAttribute.get(name));
                    } else {
                        this.xwa.xmlw.writeAttribute("md", "http://www.stambia.com/md", name, (String)staticAttribute.get(name));
                    }
                    ++this.totalAttributes;
                }
            }
            if ((this.totalAttributes + this.totalElements) % this.flushFrequency == 0) {
                this.xwa.xmlw.flush();
            }
            if ((this.totalAttributes + this.totalElements + this.totalLines) % this.statisticFrequency == 0) {
                this.handleDataStatistics(false);
            }
            ++i;
        }
        this.eltsToOpen.clear();
        return justOpen;
    }

    static boolean equals(Object value1, Object value2) {
        if (value1 == null && value2 != null) {
            return false;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        String str1 = value1.toString();
        String str2 = value2.toString();
        return str1.equals(str2);
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (this.root != null) {
            try {
                this.root.interrupAllResultSet();
            }
            catch (EngineExceptionI e) {
                this.write(this.sessionName, "JdbcActionCode=>stopAction(th)", String.valueOf(this.actionName) + " : Exception\n" + e.getMessage(), 1, this.actionLevel, "ERROR");
            }
        }
        if (th != null) {
            if (this.xwa != null) {
                this.xwa.interrupt();
            }
            th.interrupt();
        }
    }

    protected AbstractXmlWriterAPI createWriter(String _encoding, boolean writeXmlDeclaration, String xmlVersion, String xmlOutPutFactoryModule, String xmlOutPutFactoryClassName, File outFile, Map<String, Object> properties) {
        return new XmlWriterAPI(this.commit, _encoding, writeXmlDeclaration, xmlVersion, xmlOutPutFactoryModule, xmlOutPutFactoryClassName, outFile, this.handleStatisticAndLog, this, this.noDataBehaviour, this.fileAlreadyExistsBehaviour, this.osti != null ? this.osti.streamHookOne : null, properties){

            @Override
            public IndyElement getRoot() {
                return JdbcToXmlActionCodeI.this.root;
            }
        };
    }

    void addAdditionnalNamespaces() {
        if (this.defaultWriteXsiType || this.hasXsiAttribute) {
            this.xsiPrefix = (String)this.namespaces.getFrom((Object)xsiUri);
            if (this.xsiPrefix == null) {
                this.xsiPrefix = this.namespaces.getTo((Object)"xsi") != null ? "stbXsi" : "xsi";
                this.namespaces.put((Object)this.xsiPrefix, (Object)xsiUri);
            }
        }
        if (this.writeJsonAttributes) {
            this.jsonPrefix = (String)this.namespaces.getFrom((Object)jsonUri);
            if (this.jsonPrefix == null) {
                this.jsonPrefix = this.namespaces.getTo((Object)"json") != null ? "stbJson" : "json";
                this.namespaces.put((Object)this.jsonPrefix, (Object)jsonUri);
            }
        }
    }

    public class IndyAttribute
    extends IndyItem {
        public String getValue() throws SQLException, XMLStreamException, EngineExceptionI {
            if (this.resultSet != null) {
                return this.resultSet.getValue(this.alias);
            }
            return null;
        }

        public boolean write() throws SQLException, XMLStreamException, EngineExceptionI {
            boolean justOpen = false;
            if (this.resultSet != null) {
                String value = null;
                value = this.resultSet.getValue(this.alias);
                if (value == null && JdbcToXmlActionCodeI.this.attributeNullValueReplacement != null) {
                    value = JdbcToXmlActionCodeI.this.attributeNullValueReplacement;
                }
                if (value != null) {
                    if (this.isTagged && this.valueTag == null) {
                        this.valueTag = value;
                    }
                    try {
                        justOpen = JdbcToXmlActionCodeI.this.openEltToOpen(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                        JdbcToXmlActionCodeI.this.xwa.writeAttribute(this, value, this.resultSet.currentValue, this.resultSet.currentType);
                    }
                    catch (Exception e) {
                        throw new EngineExceptionI(String.valueOf(Messages.getString("JdbcToXmlActionCodeI.16")) + this.name + Messages.getString("JdbcToXmlActionCodeI.17") + value + "\"", (Throwable)e);
                    }
                    JdbcToXmlActionCodeI jdbcToXmlActionCodeI = JdbcToXmlActionCodeI.this;
                    jdbcToXmlActionCodeI.totalAttributes = jdbcToXmlActionCodeI.totalAttributes + 1;
                    if ((JdbcToXmlActionCodeI.this.totalAttributes + JdbcToXmlActionCodeI.this.totalElements) % JdbcToXmlActionCodeI.this.flushFrequency == 0) {
                        ((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw.flush();
                    }
                    if ((JdbcToXmlActionCodeI.this.totalAttributes + JdbcToXmlActionCodeI.this.totalElements + JdbcToXmlActionCodeI.this.totalLines) % JdbcToXmlActionCodeI.this.statisticFrequency == 0) {
                        JdbcToXmlActionCodeI.this.handleDataStatistics(false);
                    }
                }
            }
            return justOpen;
        }

        public void print() {
            System.out.println("Attribute: " + this.name);
        }
    }

    public class IndyElement
    extends IndyItem {
        boolean isKey;
        public boolean isRoot;
        List<IndyAttribute> attributes;
        List<IndyAttribute> internalProperty;
        List<IndyElement> elements;
        public boolean useCDATA;
        IndyQuerySet tmp;
        public boolean isLast;
        public boolean isNillable;
        List<StaticItem> staticStartItem;
        List<StaticItem> staticEndItem;
        public boolean doNext;
        private int position;
        int hasNext;
        Collection<IndyResultSet> allResultSet;
        Map<String, String> staticAttributes;
        public boolean isFirstElement;
        public boolean isJsonArray;
        public boolean isJsonObject;

        public void setNillable(boolean isNillable) {
            this.isNillable = isNillable;
            if (isNillable && !JdbcToXmlActionCodeI.this.hasXsiAttribute) {
                JdbcToXmlActionCodeI.this.hasXsiAttribute = true;
            }
        }

        public Collection<IndyResultSet> getAllResultSets() {
            if (this.allResultSet != null) {
                return this.allResultSet;
            }
            this.allResultSet = new HashSet<IndyResultSet>();
            for (IndyElement elt : this.elements) {
                this.allResultSet.addAll(elt.getAllResultSets());
            }
            if (this.resultSet != null) {
                this.allResultSet.add(this.resultSet);
            }
            return this.allResultSet;
        }

        public boolean hasNext() {
            if (this.hasNext != -1) {
                return this.hasNext == 1;
            }
            if (this.doNext) {
                this.hasNext = 1;
                return true;
            }
            for (IndyElement elt : this.elements) {
                if (!elt.hasNext()) continue;
                this.hasNext = 1;
                return true;
            }
            this.hasNext = 0;
            return false;
        }

        public IndyElement() {
            this.isKey = false;
            this.isRoot = false;
            this.attributes = new ArrayList<IndyAttribute>();
            this.internalProperty = new ArrayList<IndyAttribute>();
            this.elements = new ArrayList<IndyElement>();
            this.isNillable = false;
            this.staticStartItem = new ArrayList<StaticItem>();
            this.staticEndItem = new ArrayList<StaticItem>();
            this.doNext = false;
            this.position = -1;
            this.hasNext = -1;
            this.isJsonArray = false;
            this.isJsonObject = false;
        }

        public File defineNewFile() {
            String _fileMask = JdbcToXmlActionCodeI.this.fileMask;
            if (_fileMask == null && JdbcToXmlActionCodeI.this.superRoot == null && !JdbcToXmlActionCodeI.this.isJsonLinesFormat && (this.position > 0 || this.position == 0 && !this.resultSet.isEndeded())) {
                String string = _fileMask = JdbcToXmlActionCodeI.this.fileMask == null ? "[POSITION]-[FILE_NAME]" : JdbcToXmlActionCodeI.this.fileMask;
            }
            if (_fileMask != null) {
                String filename = _fileMask;
                for (String key : JdbcToXmlActionCodeI.this.tags.keySet()) {
                    IndyItem item = JdbcToXmlActionCodeI.this.tags.get(key);
                    if (item.valueTag == null) continue;
                    filename = filename.replaceAll("\\[" + key + "\\]", item.valueTag.replaceAll("\\\\", "\\\\\\\\").replaceAll("[<>*\\?\\|\"]", "_").replaceAll(Pattern.quote("$"), Matcher.quoteReplacement("\\$")));
                }
                filename = filename.replaceAll("\\[TIMESTAMP\\]", new Long(System.currentTimeMillis()).toString());
                if (JdbcToXmlActionCodeI.this.getOutFile().getName().lastIndexOf(".") > -1) {
                    String extension = JdbcToXmlActionCodeI.this.getOutFile().getName().substring(JdbcToXmlActionCodeI.this.getOutFile().getName().lastIndexOf(".") + 1);
                    String nameWithOutExtension = JdbcToXmlActionCodeI.this.getOutFile().getName().substring(0, JdbcToXmlActionCodeI.this.getOutFile().getName().lastIndexOf("."));
                    filename = filename.replaceAll("\\[FILE_SHORT_NAME\\]", nameWithOutExtension);
                    filename = filename.replaceAll("\\[FILE_EXTENSION\\]", extension);
                }
                filename = filename.replaceAll("\\[POSITION\\]", Integer.valueOf(this.position).toString());
                File file = new File(filename = filename.replaceAll("\\[FILE_NAME\\]", JdbcToXmlActionCodeI.this.getOutFile().getName()));
                if (!file.isAbsolute()) {
                    file = new File(String.valueOf(JdbcToXmlActionCodeI.this.getOutFile().getParent()) + "/" + filename);
                }
                for (IndyItem item : JdbcToXmlActionCodeI.this.tags.values()) {
                    item.valueTag = null;
                }
                return file;
            }
            return JdbcToXmlActionCodeI.this.getOutFile();
        }

        public void print() {
            System.out.println("Element :" + this.name);
            for (IndyAttribute attr : this.attributes) {
                attr.print();
            }
            for (IndyElement el : this.elements) {
                el.print();
            }
        }

        public void write() throws Exception {
            boolean isChangeJsonNodeBehaviour;
            JdbcToXmlActionCodeI.this.interruptedException();
            boolean stop = false;
            if (this.isRoot && (this.resultSet == null || JdbcToXmlActionCodeI.this.superRoot != null)) {
                JdbcToXmlActionCodeI.this.startNewDocument();
                if (JdbcToXmlActionCodeI.this.superRoot != null) {
                    JdbcToXmlActionCodeI.this.xwa.writeStartElement(JdbcToXmlActionCodeI.this.superRoot);
                    for (String prefix : JdbcToXmlActionCodeI.this.namespaces.keySet()) {
                        String nameSpaceUri = (String)JdbcToXmlActionCodeI.this.namespaces.getTo((Object)prefix);
                        if (prefix != null) {
                            JdbcToXmlActionCodeI.this.xwa.writeNamespace(prefix, nameSpaceUri);
                            continue;
                        }
                        if (JdbcToXmlActionCodeI.this.targetNamespace == null || !nameSpaceUri.equals(JdbcToXmlActionCodeI.this.targetNamespace)) continue;
                        JdbcToXmlActionCodeI.this.xwa.writeDefaultNamespace(JdbcToXmlActionCodeI.this.targetNamespace);
                    }
                    if (JdbcToXmlActionCodeI.this.writeJsonAttributes) {
                        ((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw.writeAttribute(JdbcToXmlActionCodeI.this.xsiPrefix, xsiUri, "type", String.valueOf(JdbcToXmlActionCodeI.this.jsonPrefix) + ":array");
                    }
                }
            }
            if (JdbcToXmlActionCodeI.this.elementToKeep.contains(this.defType)) {
                JdbcToXmlActionCodeI.this.forceWritemode = true;
            }
            boolean bl = isChangeJsonNodeBehaviour = JdbcToXmlActionCodeI.this.isWriteNullJsonNode || JdbcToXmlActionCodeI.this.isWriteEmptyJsonNode;
            if (this.resultSet != null) {
                boolean justOnce = !this.hasNext() && this.resultSet.hasFollowingToRead;
                boolean isFirstCreatedDocument = false;
                while ((this.resultSet.evalFiltersOk() || justOnce) && !stop) {
                    Object tmp;
                    JdbcToXmlActionCodeI.this.interruptedException();
                    justOnce = false;
                    ++this.position;
                    if (this.isRoot && JdbcToXmlActionCodeI.this.superRoot == null && (!JdbcToXmlActionCodeI.this.isJsonLinesFormat || JdbcToXmlActionCodeI.this.isJsonLinesFormat && !isFirstCreatedDocument)) {
                        JdbcToXmlActionCodeI.this.startNewDocument();
                        isFirstCreatedDocument = true;
                    }
                    String data = null;
                    String val = this.resultSet.getValue(this.alias);
                    if (val == null) {
                        boolean _break = false;
                        if (this.hasNext()) {
                            String _alias = this.isKey ? this.alias : null;
                            for (IndyResultSet indyResultSet : this.getAllResultSets()) {
                                val = indyResultSet.goToNext(_alias);
                                String string = _alias = val == null ? (_alias = null) : _alias;
                            }
                            if (val == null || !this.resultSet.lastFiltersOk) {
                                _break = true;
                            }
                        } else {
                            _break = true;
                        }
                        if (_break) {
                            if (this.isNillable && !this.isKey) {
                                JdbcToXmlActionCodeI.this.eltsToOpen.add(this);
                                for (IndyAttribute attribute : this.internalProperty) {
                                    if (!attribute.name.equals("internalProperty:nodeName")) continue;
                                    tmp = attribute.getValue();
                                    if (tmp != null && ((String)tmp).contains(":")) {
                                        this.dynamicName = ((String)tmp).substring(0, ((String)tmp).indexOf(":"));
                                        this.dynamicNamespace = ((String)tmp).substring(((String)tmp).indexOf(":"));
                                        continue;
                                    }
                                    this.dynamicName = tmp;
                                }
                                boolean justOpen = JdbcToXmlActionCodeI.this.openEltToOpen(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                                ((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw.writeAttribute(JdbcToXmlActionCodeI.this.xsiPrefix, xsiUri, "nil", "true");
                                if (justOpen && this.staticEndItem != null && this.staticEndItem.size() > 0) {
                                    for (StaticItem staticItem : this.staticEndItem) {
                                        staticItem.write(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                                    }
                                }
                                this.closeElement(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                            }
                            break;
                        }
                    }
                    if (this.isKey || this.type != null) {
                        if (this.isTagged && this.valueTag == null) {
                            this.valueTag = val;
                        }
                        if (this.isKey) {
                            this.resultSet.addFilter(this.alias, val);
                        }
                        if (this.type != null || this.isKey && JdbcToXmlActionCodeI.this.writeKeyValue) {
                            data = val;
                        }
                    }
                    JdbcToXmlActionCodeI.this.eltsToOpen.add(this);
                    if (this.staticAttributes != null && this.staticAttributes.size() > 0) {
                        JdbcToXmlActionCodeI.this.eltsToOpen.add(this.staticAttributes);
                    }
                    boolean justOpen = false;
                    for (IndyAttribute attribute : this.internalProperty) {
                        if (attribute.name.equals("internalProperty:nodeLocalName")) {
                            this.dynamicName = attribute.getValue();
                            continue;
                        }
                        if (attribute.name.equals("internalProperty:nodePrefix")) {
                            this.dynamicPrefix = attribute.getValue();
                            continue;
                        }
                        if (attribute.name.equals("internalProperty:nodeURI")) {
                            this.dynamicNamespace = attribute.getValue();
                            continue;
                        }
                        if (!attribute.name.equals("internalProperty:nodeName")) continue;
                        tmp = attribute.getValue();
                        if (tmp != null && ((String)tmp).contains(":")) {
                            this.dynamicName = ((String)tmp).substring(0, ((String)tmp).indexOf(":"));
                            this.dynamicNamespace = ((String)tmp).substring(((String)tmp).indexOf(":"));
                            continue;
                        }
                        this.dynamicName = tmp;
                    }
                    for (IndyAttribute attribute : this.attributes) {
                        if (!attribute.write()) continue;
                        justOpen = true;
                    }
                    if (data != null) {
                        if (this.isTagged && this.valueTag == null) {
                            this.valueTag = data;
                        }
                        if (JdbcToXmlActionCodeI.this.openEltToOpen(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw)) {
                            justOpen = true;
                        }
                        JdbcToXmlActionCodeI.this.xwa.writeText(this, data, this.resultSet.currentValue, this.resultSet.currentType);
                    }
                    if (JdbcToXmlActionCodeI.this.forceWritemode && JdbcToXmlActionCodeI.this.openEltToOpen(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw)) {
                        justOpen = true;
                    }
                    if (justOpen && this.staticEndItem != null && this.staticEndItem.size() > 0) {
                        for (StaticItem _item : this.staticEndItem) {
                            _item.write(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                        }
                    }
                    for (IndyElement elt : this.elements) {
                        elt.write();
                    }
                    this.closeElement(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                    if (this.isKey) {
                        this.resultSet.removeFilter(this.alias);
                    } else {
                        stop = true;
                    }
                    if (this.doNext) {
                        this.resultSet.next();
                    }
                    if (data == null && JdbcToXmlActionCodeI.this.isJsonLinesFormat && !this.resultSet.isEndeded()) {
                        JdbcToXmlActionCodeI.this.xwa.writeNewLineCharacter();
                    }
                    if (!this.isRoot || JdbcToXmlActionCodeI.this.superRoot != null || JdbcToXmlActionCodeI.this.isJsonLinesFormat && (!JdbcToXmlActionCodeI.this.isJsonLinesFormat || !this.resultSet.isEndeded())) continue;
                    JdbcToXmlActionCodeI.this.endCurrentDocument(this.defineNewFile());
                }
            } else {
                JdbcToXmlActionCodeI.this.eltsToOpen.add(this);
                if (this.staticAttributes != null && this.staticAttributes.size() > 0) {
                    JdbcToXmlActionCodeI.this.eltsToOpen.add(this.staticAttributes);
                }
                for (IndyAttribute attribute : this.attributes) {
                    attribute.write();
                }
                if (isChangeJsonNodeBehaviour || JdbcToXmlActionCodeI.this.forceWritemode) {
                    JdbcToXmlActionCodeI.this.openEltToOpen(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
                }
                if (!isChangeJsonNodeBehaviour || this.isChildrenHavingData(this.elements, this.getFullPath())) {
                    for (IndyElement elt : this.elements) {
                        elt.write();
                    }
                } else if (JdbcToXmlActionCodeI.this.isWriteNullJsonNode) {
                    ((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw.writeAttribute(JdbcToXmlActionCodeI.this.xsiPrefix, xsiUri, "nil", "true");
                }
                this.closeElement(((JdbcToXmlActionCodeI)JdbcToXmlActionCodeI.this).xwa.xmlw);
            }
            if (this.isFirstElement && this.resultSet.hasFollowingToRead) {
                this.resultSet.hasFollowingToRead = false;
            }
            if (JdbcToXmlActionCodeI.this.elementToKeep.contains(this.defType)) {
                JdbcToXmlActionCodeI.this.forceWritemode = false;
            }
            if (this.isRoot && (this.resultSet == null || JdbcToXmlActionCodeI.this.superRoot != null)) {
                if (JdbcToXmlActionCodeI.this.superRoot != null) {
                    JdbcToXmlActionCodeI.this.xwa.writeEndElement(this);
                }
                JdbcToXmlActionCodeI.this.endCurrentDocument(this.defineNewFile());
            }
        }

        private boolean isChildrenHavingData(List<IndyElement> elements, String fullPath) {
            if (elements == null || elements.isEmpty()) {
                return false;
            }
            for (IndyElement indyElement : elements) {
                block6: {
                    IndyResultSet indyResultSet = indyElement.resultSet;
                    if (indyResultSet != null && indyResultSet.getValue(indyElement.alias) == null) {
                        indyResultSet.next();
                    }
                    if (indyResultSet == null || indyResultSet.getValue(indyElement.alias) == null) break block6;
                    return true;
                }
                try {
                    return this.isChildrenHavingData(indyElement.elements, fullPath);
                }
                catch (EngineExceptionI e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public void closeElement(XMLStreamWriter xmlw) throws XMLStreamException {
            if (JdbcToXmlActionCodeI.this.eltsToClose.contains(this)) {
                if (this == JdbcToXmlActionCodeI.this.jsonRootElement) {
                    JdbcToXmlActionCodeI.this.jsonRootElement = null;
                }
                JdbcToXmlActionCodeI.this.xwa.writeEndElement(this);
                JdbcToXmlActionCodeI.this.eltsToClose.remove(this);
            } else {
                int min = JdbcToXmlActionCodeI.this.eltsToOpen.indexOf(this);
                int max = JdbcToXmlActionCodeI.this.eltsToOpen.size() - 1;
                while (max >= min) {
                    JdbcToXmlActionCodeI.this.eltsToOpen.remove(max);
                    --max;
                }
            }
        }

        public void setParent(IndyElement parent) {
            if (parent != null) {
                this.parent = parent;
                parent.elements.add(this);
            }
        }

        public void addAttribute(IndyAttribute attr) {
            if (attr.internalProperties) {
                this.internalProperty.add(attr);
            } else {
                this.attributes.add(attr);
            }
            attr.parent = this;
        }

        public void closeAllResultSet() throws EngineExceptionI {
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
            for (IndyElement element : this.elements) {
                element.closeAllResultSet();
            }
        }

        public void addStaticAttribute(String qName, String value) {
            if (qName != null && value != null) {
                if (this.staticAttributes == null) {
                    this.staticAttributes = new HashMap<String, String>();
                }
                this.staticAttributes.put(qName, value);
            }
        }

        public void interrupAllResultSet() throws EngineExceptionI {
            if (this.resultSet != null) {
                this.resultSet.cancel();
                try {
                    JdbcToXmlActionCodeI.this.jdbcConnection.isClosed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (IndyElement element : this.elements) {
                element.interrupAllResultSet();
            }
        }
    }

    class IndyItem {
        public String dynamicNamespace;
        public String namespace;
        public String dynamicPrefix;
        public String prefix;
        public boolean disablePrefix;
        public String dynamicName;
        public String name;
        String id;
        public String alias;
        public String type;
        public boolean isRawData = false;
        boolean writeXsiType = false;
        int iType;
        String location;
        int jdbcType = -1;
        int jdbcIndex = -1;
        IndyItem parent;
        IndyResultSet resultSet;
        boolean isTagged = false;
        String valueTag;
        public String defType;
        public boolean forcePrefix;
        public boolean internalProperties;
        public String raw;

        IndyItem() {
        }

        public String getNSUri() {
            if (this.dynamicNamespace != null) {
                return this.dynamicNamespace;
            }
            return this.namespace;
        }

        public String getPrefix() {
            if (this.dynamicPrefix != null) {
                return this.dynamicPrefix;
            }
            return this.prefix;
        }

        public String getLocalName() {
            if (this.dynamicName != null) {
                if (JdbcToXmlActionCodeI.this.jsonRootElement != null && !JdbcToXmlActionCodeI.this.useJsonWriter && !JsonUtils.checkIfNameIsValid((String)this.dynamicName)) {
                    try {
                        return "_." + JsonUtils.encodeHexString((String)this.dynamicName) + "._";
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    return this.dynamicName;
                }
            }
            return this.name;
        }

        String getFullPath() {
            String p = this.parent != null ? String.valueOf(this.parent.getFullPath()) + "/" : "/";
            return String.valueOf(p) + this.name;
        }
    }

    class IndyQuerySet {
        String name;
        public Map<String, String> currentFilters = new HashMap<String, String>();

        public IndyQuerySet(String name) {
            this.name = name;
        }

        public void addFilter(String keyName, String keyVal) {
            if (keyName != null && keyVal != null) {
                this.currentFilters.put(keyName, keyVal);
            }
        }

        public void removeFilter(String keyName) {
            this.currentFilters.remove(keyName);
        }
    }

    class IndyResultSet {
        boolean hasFollowingToRead = false;
        private boolean hasLast = false;
        private HashMap<String, String> followingFields = new HashMap();
        private HashMap<String, Object> followingObjectFields = new HashMap();
        private HashMap<String, Integer> followingTypeFields = new HashMap();
        private ResultSet rs;
        ResultSetMetaData rsMd;
        boolean ended = false;
        boolean started = false;
        boolean neverExecuted = true;
        String query;
        private HashMap<String, String> filtersMap;
        private Connection connection;
        private IndyQuerySet sourceSet;
        private String name;
        Map<String, FieldInfo> fieldInfos;
        long totalGetTime;
        private Statement statement;
        boolean hasData = false;
        long nbRow = 0L;
        long lastNbRow = -1L;
        int followingValueIsPrepared = 0;
        boolean lastFiltersOk = false;
        Object currentValue;
        int currentType;

        public String goToNext(String alias) throws EngineExceptionI {
            boolean hasMoreElt = true;
            boolean filtersOk = true;
            String value = null;
            while (value == null && hasMoreElt && filtersOk) {
                hasMoreElt = this.next();
                if (!hasMoreElt) continue;
                filtersOk = this.evalFiltersOk();
                if (alias == null || !filtersOk) continue;
                value = this.getValue(alias);
            }
            return value;
        }

        public void setFollowingValues() throws EngineExceptionI {
            if (this.nbRow != this.lastNbRow) {
                this.lastNbRow = this.nbRow;
                if (this.followingFields.size() > 0 && this.started && !this.ended) {
                    for (String alias : this.followingFields.keySet()) {
                        FieldInfo fieldInfo = this.fieldInfos.get(alias.toUpperCase());
                        if (fieldInfo != null) {
                            String tmp;
                            Object _currentValue = null;
                            try {
                                tmp = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().jdbcToString(fieldInfo.type, this.rs, fieldInfo.index);
                                if (tmp != null && JdbcToXmlActionCodeI.this.emptyValueKeyWord != null && tmp.equals(JdbcToXmlActionCodeI.this.emptyValueKeyWord)) {
                                    tmp = "";
                                    _currentValue = "";
                                } else {
                                    _currentValue = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().getCurrentValue();
                                }
                            }
                            catch (SQLException e) {
                                throw new EngineExceptionI((Throwable)e);
                            }
                            this.followingFields.put(alias, tmp);
                            this.followingObjectFields.put(alias, _currentValue);
                            this.followingTypeFields.put(alias, fieldInfo.type);
                            continue;
                        }
                        this.followingFields.put(alias, null);
                        this.followingObjectFields.put(alias, null);
                        this.followingTypeFields.put(alias, null);
                    }
                    this.hasFollowingToRead = true;
                }
            }
        }

        public void initFieldInfo() throws SQLException {
            this.fieldInfos = new TreeMap<String, FieldInfo>();
            int i = 1;
            while (i <= this.rs.getMetaData().getColumnCount()) {
                FieldInfo fi = new FieldInfo();
                String fieldName = this.rs.getMetaData().getColumnLabel(i);
                fi.type = this.rs.getMetaData().getColumnType(i);
                fi.index = i++;
                this.fieldInfos.put(fieldName.toUpperCase(), fi);
            }
        }

        public IndyResultSet(String name, IndyQuerySet sourceSet) {
            this.name = name;
            this.sourceSet = sourceSet;
        }

        void initResultSet() throws SQLException {
            this.statement = JdbcToXmlActionCodeI.createResultSetStatement((Connection)this.connection);
            if (JdbcToXmlActionCodeI.this.fetchSize != null) {
                this.statement.setFetchSize(JdbcToXmlActionCodeI.this.fetchSize);
            }
            long start = System.currentTimeMillis();
            JdbcToXmlActionCodeI.this.debugLog("initResultSet", "name: " + this.name + " Query:\n " + this.query, JdbcToXmlActionCodeI.this.runtimeContext.LOG_LEVEL3, JdbcToXmlActionCodeI.this.runtimeContext.LOG_DEBUG);
            try {
                this.rs = this.statement.executeQuery(this.query);
            }
            catch (SQLException e) {
                throw new SQLException(String.valueOf(e.getMessage()) + "\n" + this.query, e);
            }
            this.rsMd = this.rs.getMetaData();
            this.initFieldInfo();
            long end = System.currentTimeMillis();
            JdbcToXmlActionCodeI.this.debugLog("initResultSet", String.valueOf(Messages.getString("JdbcToXmlActionCodeI.18")) + this.name + Messages.getString("JdbcToXmlActionCodeI.19") + (end - start) + "s", JdbcToXmlActionCodeI.this.runtimeContext.LOG_LEVEL3, JdbcToXmlActionCodeI.this.runtimeContext.LOG_DEBUG);
            JdbcToXmlActionCodeI jdbcToXmlActionCodeI = JdbcToXmlActionCodeI.this;
            jdbcToXmlActionCodeI.totalQueryTime = jdbcToXmlActionCodeI.totalQueryTime + (end - start);
            JdbcToXmlActionCodeI jdbcToXmlActionCodeI2 = JdbcToXmlActionCodeI.this;
            jdbcToXmlActionCodeI2.nbexecutedQuerys = jdbcToXmlActionCodeI2.nbexecutedQuerys + 1;
            JdbcToXmlActionCodeI.this.handleQueryStatistics(false);
            this.neverExecuted = false;
        }

        boolean next() throws EngineExceptionI {
            try {
                if (this.neverExecuted) {
                    this.initResultSet();
                }
                this.hasData = this.rs.next();
                if (this.hasData) {
                    ++this.nbRow;
                    JdbcToXmlActionCodeI jdbcToXmlActionCodeI = JdbcToXmlActionCodeI.this;
                    jdbcToXmlActionCodeI.totalLines = jdbcToXmlActionCodeI.totalLines + 1;
                    if ((JdbcToXmlActionCodeI.this.totalAttributes + JdbcToXmlActionCodeI.this.totalElements + JdbcToXmlActionCodeI.this.totalLines) % JdbcToXmlActionCodeI.this.statisticFrequency == 0) {
                        JdbcToXmlActionCodeI.this.handleDataStatistics(false);
                    }
                    this.started = true;
                } else {
                    this.ended = true;
                }
                return this.hasData;
            }
            catch (SQLException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }

        public String printFilter() {
            String ret = "";
            if (this.sourceSet.currentFilters != null) {
                for (String key : this.sourceSet.currentFilters.keySet()) {
                    ret = String.valueOf(ret) + key + "=" + this.sourceSet.currentFilters.get(key) + ";";
                }
            }
            return ret;
        }

        boolean evalFiltersOk() throws EngineExceptionI {
            if (this.neverExecuted) {
                this.next();
            }
            Map<String, String> filtersMap = this.sourceSet.currentFilters;
            if (this.started && !this.ended) {
                if (filtersMap != null) {
                    for (String alias : filtersMap.keySet()) {
                        String str = null;
                        str = this.getValue(alias);
                        boolean compare = JdbcToXmlActionCodeI.equals(str, filtersMap.get(alias));
                        if (compare) continue;
                        this.lastFiltersOk = false;
                        return this.lastFiltersOk;
                    }
                }
                this.lastFiltersOk = true;
                this.setFollowingValues();
                return this.lastFiltersOk;
            }
            this.lastFiltersOk = false;
            return this.lastFiltersOk;
        }

        public boolean hasCurrent() {
            return this.started && !this.ended;
        }

        public String getValue(String name) throws EngineExceptionI {
            this.currentValue = null;
            this.currentType = 1111;
            long start = System.currentTimeMillis();
            if (this.followingFields.containsKey(name)) {
                this.currentValue = this.followingObjectFields.get(name);
                this.currentType = this.followingTypeFields.get(name);
                return this.followingFields.get(name);
            }
            if (this.started && !this.ended) {
                FieldInfo fieldInfo = this.fieldInfos.get(name.toUpperCase());
                if (fieldInfo != null) {
                    String tmp;
                    try {
                        tmp = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().jdbcToString(fieldInfo.type, this.rs, fieldInfo.index);
                        if (tmp != null && JdbcToXmlActionCodeI.this.emptyValueKeyWord != null && tmp.equals(JdbcToXmlActionCodeI.this.emptyValueKeyWord)) {
                            tmp = "";
                            this.currentValue = "";
                        } else {
                            this.currentValue = JdbcToXmlActionCodeI.this.dataTypeProvider.getUnparser().getCurrentValue();
                        }
                        this.currentType = fieldInfo.type;
                    }
                    catch (SQLException e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                    long end = System.currentTimeMillis();
                    this.totalGetTime += start - end;
                    return tmp;
                }
                new EngineExceptionI(String.valueOf(Messages.getString("JdbcToXmlActionCodeI.20")) + name.toUpperCase());
            }
            return null;
        }

        public void close() throws EngineExceptionI {
            if (this.rs != null) {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                        this.statement = null;
                    }
                    this.rs.close();
                    this.rs = null;
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }

        public void cancel() throws EngineExceptionI {
            if (this.rs != null) {
                try {
                    if (this.statement != null) {
                        this.statement.cancel();
                    }
                }
                catch (SQLException e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }

        public boolean isEndeded() {
            return this.ended;
        }

        public boolean isStarted() {
            return this.started;
        }

        void addFilter(String alias, String val) {
            this.sourceSet.addFilter(alias, val);
        }

        void removeFilter(String alias) {
            this.sourceSet.removeFilter(alias);
        }

        class FieldInfo {
            int index;
            int type;

            FieldInfo() {
            }
        }
    }

    public static final class OutputStreamTransformerInitalizer {
        OutputStreamTransformer streamHookOne;
        ClassLoader streamHookOneCL;

        void init(String _streamHookOne, ActionCodeTypeI action, ISessionContext engineContext, boolean useJsonWriter, OutputStreamTransformer.OutputStreamTransformerStatisticHandler ostsh, Map namespaces) throws EngineExceptionI {
            try {
                Properties prop = new Properties();
                prop.load(new ByteArrayInputStream(_streamHookOne.getBytes()));
                String _clazz = prop.getProperty("class");
                if (_clazz != null) {
                    if (_clazz.equals("com.indy.engine.common.tools.impl.JavaGenericOutputStreamTransformer")) {
                        _clazz = JavaGenericOutputStreamTransformer.class.getName();
                    }
                    Class<?> clazz = null;
                    String classModules = prop.getProperty("class.module");
                    ClassLoader CL = ClassLoaderServiceProvider.INSTANCE.getClassLoader(classModules, _clazz);
                    clazz = CL.loadClass(_clazz);
                    Object o = clazz.newInstance();
                    if (o instanceof JavaRealObjectHandler) {
                        o = JavaRealObjectHandler.getJavaObjectHandler((JavaRealObjectHandler)((JavaRealObjectHandler)o));
                    }
                    if (o instanceof JavaObjectHandler) {
                        this.streamHookOne = new JavaGenericOutputStreamTransformer();
                        ((JavaGenericOutputStreamTransformer)this.streamHookOne).setJavaObjectHandler((JavaObjectHandler)o);
                        if (!useJsonWriter) {
                            ((JavaGenericOutputStreamTransformer)this.streamHookOne).xmlSerDes(true);
                        }
                    } else {
                        this.streamHookOne = (OutputStreamTransformer)clazz.newInstance();
                    }
                    this.streamHookOne.setStatisticHandler(ostsh);
                    String scriptEngineName = null;
                    String scriptEngineTransaction = null;
                    String handlerObjectName = null;
                    for (Object key : prop.keySet()) {
                        if (key.equals("script.handler.language.name")) {
                            scriptEngineName = (String)prop.get(key);
                            continue;
                        }
                        if (key.equals("script.handler.connection.name")) {
                            scriptEngineTransaction = (String)prop.get(key);
                            continue;
                        }
                        if (key.equals("script.handler.object.name")) {
                            handlerObjectName = (String)prop.get(key);
                            continue;
                        }
                        if (key.equals("script.handler.module")) {
                            String moduleName = (String)prop.get(key);
                            if (moduleName == null || moduleName.isEmpty()) {
                                moduleName = "default";
                            }
                            this.streamHookOneCL = ClassLoaderServiceProvider.INSTANCE.getClassLoader(moduleName);
                            continue;
                        }
                        if (key.equals("class")) continue;
                        this.streamHookOne.setProperty((String)key, (String)prop.get(key));
                    }
                    if (namespaces != null) {
                        this.streamHookOne.setInternalProperty("namespaces", (Object)namespaces);
                    }
                    if (scriptEngineName != null) {
                        Object se = null;
                        se = scriptEngineName.equals("beanshell") ? engineContext.getScriptingProvider().createScriptingEngine(IScriptingEngineProvider.EngineRuntime.BEANSHELL, scriptEngineName, scriptEngineTransaction, action, null).getScriptingEngine() : engineContext.getScriptingProvider().createScriptingEngine(IScriptingEngineProvider.EngineRuntime.JS, scriptEngineName, scriptEngineTransaction, action, null).getScriptingEngine();
                        if (this.streamHookOne instanceof JavaGenericOutputStreamTransformer) {
                            ((JavaGenericOutputStreamTransformer)this.streamHookOne).setJavaObjectHandler(JavaGenericOperation.getJavaObjectHandler((Object)se, (String)scriptEngineName, (String)handlerObjectName));
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new EngineExceptionI(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                if (e instanceof EngineExceptionI) {
                    throw (EngineExceptionI)((Object)e);
                }
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public class SimpleContentHandler
    extends IndyContentHandler {
        IndyElement root;
        List<IndyItem> pile = new ArrayList<IndyItem>();
        private TreeMap<String, IndyResultSet> resultSets;
        private HashMap<String, IndyQuerySet> querySets;
        boolean tag;
        boolean staticOpen = false;
        String currentTag;

        public SimpleContentHandler(TreeMap<String, IndyResultSet> resultSets, HashMap<String, IndyQuerySet> querySets) {
            this.resultSets = resultSets;
            this.querySets = querySets;
        }

        public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
            this.tag = false;
            if (rawName != null && rawName.equals("md:static") || this.staticOpen) {
                this.staticOpen = true;
                IndyElement currentElement = (IndyElement)this.getCurrent();
                if (rawName == null || !rawName.equals("md:static")) {
                    currentElement.staticEndItem.add(new StaticStartElement(nameSpaceURI, localName, rawName));
                    int index = 0;
                    while (index < attributs.getLength()) {
                        currentElement.staticEndItem.add(new StaticAttribute(attributs.getURI(index), attributs.getLocalName(index), attributs.getQName(index), attributs.getValue(index)));
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < attributs.getLength()) {
                        currentElement.staticStartItem.add(new StaticAttribute(attributs.getURI(index), attributs.getLocalName(index), attributs.getQName(index), attributs.getValue(index)));
                        ++index;
                    }
                }
            } else if (localName.equals("tag")) {
                this.tag = true;
            } else if (localName.equals("element")) {
                this.parseElement(nameSpaceURI, localName, rawName, attributs);
            } else if (localName.equals("attribute") && this.pile.size() > 0) {
                this.parseAttribute(nameSpaceURI, localName, rawName, attributs);
            } else if (localName.equals("namespace") && this.pile.size() == 0) {
                this.parseNamespace(nameSpaceURI, localName, rawName, attributs);
            } else if (localName.equals("data") && this.pile.size() == 0) {
                JdbcToXmlActionCodeI.this.targetNamespace = attributs.getValue("targetNamespace");
                String tmp = attributs.getValue("prefixForElement");
                JdbcToXmlActionCodeI.this.prefixForElement = tmp != null && tmp.equals("qualified");
                tmp = attributs.getValue("prefixForAttribute");
                JdbcToXmlActionCodeI.this.prefixForAttribute = tmp != null && tmp.equals("qualified");
            }
        }

        private void parseNamespace(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            String uri = attributs.getValue("name");
            String prefix = attributs.getValue("prefix");
            JdbcToXmlActionCodeI.this.namespaces.put((Object)prefix, (Object)uri);
        }

        private boolean parseItem(IndyItem item, Attributes attributs, int index) {
            if (attributs.getQName(index).equals("sqlToXml:id")) {
                item.id = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("sqlToXml:alias")) {
                item.alias = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("name")) {
                item.name = attributs.getValue(index);
                if (item.name.startsWith("internalProperty:")) {
                    item.internalProperties = true;
                }
                return true;
            }
            if (attributs.getQName(index).equals("type")) {
                item.type = attributs.getValue(index);
                if (item.type.isEmpty()) {
                    item.type = null;
                } else if (item.type.equals("json:array")) {
                    item.type = null;
                } else if (item.type.equals("json:object")) {
                    item.type = null;
                } else if (item.type.equals("rawData")) {
                    item.isRawData = true;
                    JdbcToXmlActionCodeI.this.hasRawData = true;
                }
                if (JdbcToXmlActionCodeI.this.dataTypeProvider != null && item.type != null) {
                    item.iType = JdbcToXmlActionCodeI.this.dataTypeProvider.getDataType(item.type);
                }
                return true;
            }
            if (attributs.getQName(index).equals("sqlToXml:location")) {
                item.location = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("namespace")) {
                item.namespace = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("md:defType")) {
                item.defType = attributs.getValue(index);
                if (item.defType.startsWith("com.stambia.json")) {
                    boolean b;
                    JdbcToXmlActionCodeI.this.writeJsonAttributes = true;
                    if (!JdbcToXmlActionCodeI.this.hasXsiAttribute) {
                        JdbcToXmlActionCodeI.this.hasXsiAttribute = true;
                    }
                    boolean bl = b = JdbcToXmlActionCodeI.this.nillableIsForce ? JdbcToXmlActionCodeI.this.defaultNillable : true;
                    if (item.defType.toLowerCase().endsWith("value")) {
                        item.writeXsiType = true;
                        ((IndyElement)item).isNillable = b;
                    } else if (item.defType.toLowerCase().endsWith("array")) {
                        ((IndyElement)item).isJsonArray = true;
                        ((IndyElement)item).isNillable = b;
                    } else if (item.defType.toLowerCase().endsWith("object")) {
                        ((IndyElement)item).isJsonObject = true;
                        ((IndyElement)item).isNillable = b;
                    }
                }
                return true;
            }
            if (attributs.getQName(index).equals("defType")) {
                item.defType = attributs.getValue(index);
                return true;
            }
            if (attributs.getQName(index).equals("prefixQualification")) {
                String tmp = attributs.getValue(index);
                item.disablePrefix = tmp != null && tmp.equals("disable");
                item.forcePrefix = tmp != null && tmp.equals("force");
                return true;
            }
            return false;
        }

        private void parseAttribute(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            IndyElement elt = (IndyElement)this.pile.get(this.pile.size() - 1);
            IndyAttribute attr = new IndyAttribute();
            this.pile.add(attr);
            int index = 0;
            while (index < attributs.getLength()) {
                String sourceSetName;
                if (!this.parseItem(attr, attributs, index) && attributs.getQName(index).equals("sqlToXml:sourceSet") && (sourceSetName = attributs.getValue(index)) != null && !sourceSetName.isEmpty()) {
                    attr.resultSet = this.resultSets.get(sourceSetName);
                }
                ++index;
            }
            elt.addAttribute(attr);
            if (attr.resultSet != null && attr.resultSet.hasLast) {
                attr.resultSet.followingFields.put(attr.alias, null);
            }
        }

        private void parseElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) {
            IndyElement element = new IndyElement();
            element.useCDATA = JdbcToXmlActionCodeI.this.forceUsedCData;
            if (this.root == null) {
                this.root = element;
                this.root.isRoot = true;
            }
            if (this.pile.size() > 0) {
                element.setParent((IndyElement)this.pile.get(this.pile.size() - 1));
            }
            this.pile.add(element);
            String sourceSetName = null;
            String querySetName = null;
            boolean distinct = false;
            if (element != null) {
                element.setNillable(JdbcToXmlActionCodeI.this.defaultNillable);
                String forceNillable = null;
                int index = 0;
                while (index < attributs.getLength()) {
                    String tmp1 = attributs.getValue(index);
                    if (!this.parseItem(element, attributs, index)) {
                        String tmp;
                        if (attributs.getQName(index).equals("sqlToXml:isKey")) {
                            element.isKey = attributs.getValue(index) != null && attributs.getValue(index).equals("true");
                        } else if (attributs.getQName(index).equals("sqlToXml:sourceSet")) {
                            sourceSetName = attributs.getValue(index);
                        } else if (attributs.getQName(index).equals("sqlToXml:querySet")) {
                            querySetName = attributs.getValue(index);
                        } else if (attributs.getQName(index).equals("cdata")) {
                            tmp = attributs.getValue(index);
                            if (!JdbcToXmlActionCodeI.this.forceUsedCData.booleanValue()) {
                                element.useCDATA = tmp != null && tmp.equals("true");
                            }
                        } else if (attributs.getQName(index).equals("sqlToXml:isLast")) {
                            tmp = attributs.getValue(index);
                            element.isLast = tmp != null && tmp.equals("true");
                        } else if (attributs.getQName(index).equals("sqlToXml:distinct")) {
                            tmp = attributs.getValue(index);
                            distinct = tmp != null && tmp.equals("true");
                        } else if (attributs.getQName(index).equals("isNillable") && !JdbcToXmlActionCodeI.this.nillableIsForce) {
                            if (attributs.getValue(index) != null) {
                                if (attributs.getValue(index).equals("true")) {
                                    element.setNillable(true);
                                } else if (attributs.getValue(index).equals("false")) {
                                    element.setNillable(false);
                                }
                            }
                        } else if (attributs.getQName(index).equals("sqlToXml:forceIsNillable") && !JdbcToXmlActionCodeI.this.nillableIsForce) {
                            forceNillable = attributs.getValue(index);
                        }
                    }
                    if (!attributs.getQName(index).startsWith("sqlToXml:") && JdbcToXmlActionCodeI.this.writeMetaDataAttribut) {
                        element.addStaticAttribute(attributs.getQName(index), attributs.getValue(index));
                    }
                    ++index;
                }
                if (forceNillable != null) {
                    if (forceNillable.equals("true")) {
                        element.setNillable(true);
                    } else if (forceNillable.equals("false")) {
                        element.setNillable(false);
                    }
                }
            }
            IndyQuerySet qs = null;
            if (querySetName != null && !querySetName.isEmpty() && (qs = this.querySets.get(querySetName)) == null) {
                qs = new IndyQuerySet(querySetName);
                this.querySets.put(querySetName, qs);
            }
            IndyResultSet irs = null;
            if (!(sourceSetName == null || sourceSetName.isEmpty() || "__monoSS__".equals(querySetName) && !JdbcToXmlActionCodeI.this.isRdbmsLinked.booleanValue() || (irs = this.resultSets.get(sourceSetName)) != null || qs == null)) {
                irs = new IndyResultSet(sourceSetName, qs);
                this.resultSets.put(sourceSetName, irs);
                element.isFirstElement = true;
            }
            if (irs != null) {
                if (element.isLast && !irs.hasLast) {
                    irs.hasLast = true;
                    element.doNext = true;
                } else if (irs.hasLast) {
                    irs.followingFields.put(element.alias, null);
                    element.isLast = false;
                }
                element.resultSet = irs;
            }
        }

        public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
            if (this.staticOpen) {
                if (rawName != null && rawName.equals("md:static")) {
                    this.staticOpen = false;
                } else {
                    IndyElement currentElement = (IndyElement)this.getCurrent();
                    currentElement.staticEndItem.add(new StaticEndElement());
                }
                return;
            }
            if (this.pile.size() > 0) {
                if (localName.equals("tag") && this.currentTag != null) {
                    JdbcToXmlActionCodeI.this.tags.put(this.currentTag, this.getCurrent());
                    IndyItem current = this.getCurrent();
                    current.isTagged = true;
                    this.tag = false;
                    this.currentTag = null;
                }
                if (localName.equals("element") || localName.equals("attribute")) {
                    this.pile.remove(this.pile.size() - 1);
                }
            }
        }

        public IndyItem getCurrent() {
            if (this.pile.size() > 0) {
                return this.pile.get(this.pile.size() - 1);
            }
            return null;
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            if (this.staticOpen) {
                IndyElement currentElement = (IndyElement)this.getCurrent();
                currentElement.staticEndItem.add(new StaticCharacter(new String(ch, start, end)));
                return;
            }
            if (this.pile.size() > 0) {
                if (this.tag) {
                    this.currentTag = this.currentTag == null ? new String(ch, start, end) : String.valueOf(this.currentTag) + new String(ch, start, end);
                } else {
                    String query = new String(ch, start, end);
                    IndyElement element = (IndyElement)this.getCurrent();
                    IndyResultSet irs = element.resultSet;
                    try {
                        irs.query = irs.query == null ? query : String.valueOf(irs.query) + query;
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    final class StaticAttribute
    implements StaticItem {
        private String nameSpaceURI;
        private String localName;
        private String prefix;
        private String value;

        public StaticAttribute(String nameSpaceURI, String localName, String rawName, String value) {
            this.nameSpaceURI = nameSpaceURI != null && !nameSpaceURI.isEmpty() ? nameSpaceURI : null;
            this.localName = localName;
            this.value = value;
            if (rawName != null && rawName.endsWith(":" + localName)) {
                String[] split = rawName.split(":");
                this.prefix = split[0];
            }
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            if (this.prefix != null && this.nameSpaceURI != null) {
                writer.writeAttribute(this.prefix, this.nameSpaceURI, this.localName, this.value);
            } else if (this.nameSpaceURI != null) {
                writer.writeAttribute(this.nameSpaceURI, this.localName, this.value);
            } else {
                try {
                    writer.writeAttribute(this.localName, this.value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    final class StaticCharacter
    implements StaticItem {
        String str;

        private StaticCharacter(String str) {
            this.str = str;
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeCharacters(this.str);
        }
    }

    final class StaticEndElement
    implements StaticItem {
        private StaticEndElement() {
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeEndElement();
        }
    }

    static interface StaticItem {
        public void write(XMLStreamWriter var1) throws XMLStreamException;
    }

    final class StaticStartElement
    implements StaticItem {
        String nameSpaceURI;
        String localName;
        String prefix;

        private StaticStartElement(String nameSpaceURI, String localName, String rawName) {
            this.nameSpaceURI = nameSpaceURI != null && !nameSpaceURI.isEmpty() ? nameSpaceURI : null;
            this.localName = localName;
            if (rawName != null && rawName.endsWith(":" + localName)) {
                String[] split = rawName.split(":");
                this.prefix = split[0];
            }
        }

        @Override
        public void write(XMLStreamWriter writer) throws XMLStreamException {
            if (this.prefix != null && this.nameSpaceURI != null) {
                writer.writeStartElement(this.prefix, this.localName, this.nameSpaceURI);
            } else if (this.nameSpaceURI != null) {
                writer.writeStartElement(this.localName, this.nameSpaceURI);
            } else {
                writer.writeStartElement(this.localName);
            }
        }
    }
}

