/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.common.tools.ProcessWrapper;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OperatingSystemActionCodeI
extends ActionCodeTypeI {
    String strFinalActionCode = "";
    Process osProc = null;
    Runtime osRuntime = null;
    String workingDir = null;
    String charset = null;
    private String launcher;
    private Integer standatdInputLimit;
    private Integer errorInputLimit;
    private List<Integer> successfulExitedCodes;
    private long timeout;
    boolean ignoreStderr = false;

    public OperatingSystemActionCodeI() {
        this.actionCodeName = "Operating System";
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (this.osProc != null) {
            this.osProc.destroy();
        }
        if (th != null) {
            th.interrupt();
        }
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.strFinalActionCode = this.getFinalBindedCode(sourceRSet, this.actionTxtCode);
        this.executeSimpleCode();
        return ret;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.workingDir = this.getLocalStringBindedParameter(rSet, "OS_WORKING_DIR", this.runtimeContext.TEMPORARY_FOLDER);
        this.charset = this.getLocalStringBindedParameter(rSet, "OS_CHARSET", Charset.defaultCharset().name());
        this.launcher = this.getLocalStringBindedParameter(rSet, "OS_SHELL_LAUNCHER", null);
        this.standatdInputLimit = this.getLocalIntegerBindedParameter(rSet, "OS_STANDARD_INPUT_LIMIT_SIZE", -1);
        this.errorInputLimit = this.getLocalIntegerBindedParameter(rSet, "OS_ERROR_INPUT_LIMIT_SIZE", -1);
        String _successfulReturnCodes = this.getLocalStringBindedParameter(rSet, "OS_SUCCESSFUL_EXIT_CODE", "0");
        this.successfulExitedCodes = new ArrayList<Integer>();
        String[] stringArray = _successfulReturnCodes.split("[| ;,]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            try {
                Integer i = Integer.parseInt(str);
                this.successfulExitedCodes.add(i);
            }
            catch (Exception e) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("OperatingSystemActionCodeI.0")) + str, (Throwable)e);
            }
            ++n2;
        }
        this.timeout = this.getLocalLongBindedParameter(rSet, "OS_TIMEOUT", new Long(-1L));
        this.ignoreStderr = this.getLocalBooleanBindedParameter(rSet, "OS_IGNORE_STDERR", false);
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        this.strFinalActionCode = this.actionTxtCode;
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        StringBuffer sErr = new StringBuffer();
        StringBuffer sIn = new StringBuffer();
        Integer retCode = null;
        try {
            this.osRuntime = Runtime.getRuntime();
            if (this.launcher != null) {
                String[] strs = this.launcher.split(" ");
                String[] strs2 = new String[strs.length + 1];
                int i = 0;
                while (i < strs.length) {
                    strs2[i] = strs[i];
                    ++i;
                }
                strs2[strs2.length - 1] = this.strFinalActionCode;
                this.osProc = this.osRuntime.exec(strs2, null, new File(this.workingDir));
            } else {
                this.osProc = this.osRuntime.exec(this.strFinalActionCode, null, new File(this.workingDir));
            }
            ProcessWrapper pw = ProcessWrapper.wrap((Process)this.osProc);
            pw.setErrorStringBuffer(sErr, this.errorInputLimit.intValue());
            pw.setInputStringBuffer(sIn, this.standatdInputLimit.intValue());
            pw.setCharset(Charset.forName(this.charset));
            pw.setTimeout(this.timeout);
            pw.waitFor();
            if (sIn.length() > 0) {
                this.publishVariable("OS_RET_MESS", sIn, "String");
            }
            if (sErr.length() > 0) {
                this.publishVariable("OS_ERR_MESS", sErr.toString(), "String");
            }
            retCode = this.osProc.exitValue();
            this.publishVariable("OS_RET_CODE", "" + retCode, "Integer");
        }
        catch (Exception e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), e.getMessage(), "String");
            throw new EngineExceptionI((Throwable)e);
        }
        if (sErr.length() > 0 && !this.ignoreStderr) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("OperatingSystemActionCodeI.1")) + sErr);
        }
        if (this.getStoppingAction().booleanValue()) {
            throw new EngineExceptionI(Messages.getString("OperatingSystemActionCodeI.2"));
        }
        if (retCode == null) {
            throw new EngineExceptionI(Messages.getString("OperatingSystemActionCodeI.3"));
        }
        if (!this.successfulExitedCodes.contains(retCode)) {
            throw new EngineExceptionI(String.valueOf(Messages.getString("OperatingSystemActionCodeI.4")) + retCode + Messages.getString("OperatingSystemActionCodeI.5") + this.successfulExitedCodes.toString().replace("[", "").replace("]", ""));
        }
        return ret;
    }
}

