/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.mail.MailActionCode;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.base.core.auth.AuthenticationFactory;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeUtility;

public class ReadMailActionCodeI
extends MailActionCode {
    ISecretValue mailHost;
    ISecretValue mailUser;
    ISecretValue mailPassword;
    String mailFolder;
    String mailProtocol;
    String serverFolder;
    String mailFromFilter;
    String mailToFilter;
    String mailCCFilter;
    String mailSubjectFilter;
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String DEFAULT_MAIL_PORT = "110";
    private static final String DEFAULT_SSL_MAIL_PORT = "995";
    private static final String DEFAULT_SSL_PROTOCOL = "SSL";
    ISecretValue mailPort;
    Boolean mailUseSSL = false;
    String mailSSLProtocol = "SSL";
    Boolean mailWaitMode;
    String folderOptions;
    boolean keepOnServer;
    Boolean extractAtt;
    Boolean extractMsg;
    Boolean extractHeader;
    String msgPrefix;
    String attPrefix;
    boolean useUCase;
    boolean noMailError;
    long timeOut;
    long pollint;
    int maxMsg;
    int nbMessages = 0;
    Boolean textIsHtml = false;
    private String markAs;

    public ReadMailActionCodeI() {
        this.actionCodeName = "Read Mail Class";
        this.bNullCodeAllowed = true;
    }

    boolean existsAllTables() throws EngineExceptionI {
        return this.existsTable(null, null, "IND_SESSION_MAIL_HEADER") && this.existsTable(null, null, "IND_SESSION_MAIL_LST_INFO");
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("ReadMailActionCodeI.0"), 3, "DEBUG");
        this.mailHost = this.getLocalSecretBindedParameter(rSet, "MAIL_HOSTNAME", null);
        if (this.mailHost.isNull()) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("ReadMailActionCodeI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("ReadMailActionCodeI.2"));
        }
        this.setStandardConnectionParameters(rSet);
        this.mailUseSSL = this.getLocalBooleanBindedParameter(rSet, "MAIL_USE_SSL", false);
        if (this.mailUseSSL.booleanValue()) {
            this.mailSSLProtocol = this.getLocalStringBindedParameter(rSet, "MAIL_SSL_PROTOCOL", DEFAULT_SSL_PROTOCOL);
        }
        this.mailPort = this.getLocalSecretBindedParameter(rSet, "MAIL_PORT", null);
        if (this.mailPort == null) {
            if (this.mailUseSSL.booleanValue()) {
                this.mailPort.setDefaultValue(DEFAULT_SSL_MAIL_PORT);
            } else {
                this.mailPort.setDefaultValue(DEFAULT_MAIL_PORT);
            }
        }
        this.mailUser = this.getLocalSecretBindedParameter(rSet, "MAIL_USER", null);
        if (this.mailUser.isNull()) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("ReadMailActionCodeI.3"), "String", false);
            throw new EngineExceptionI(Messages.getString("ReadMailActionCodeI.4"));
        }
        this.mailPassword = this.getLocalSecretBindedParameter(rSet, "MAIL_PASSWORD", this.getLocalStringBindedParameter(rSet, "MAIL_UNCRYPTED_PASSWORD", ""));
        this.oauth2JsonString = this.getLocalStringBindedParameter(rSet, "SECURITY_MD_TO_JSON", null);
        this.serverFolder = this.getLocalStringBindedParameter(rSet, "MAIL_SERVER_FOLDER", "INBOX");
        this.mailProtocol = this.getLocalStringBindedParameter(rSet, "MAIL_PROTOCOL", "pop3").toLowerCase();
        if (!this.mailProtocol.equals("imap") && !this.mailProtocol.equals("pop3")) {
            this.mailProtocol = "pop3";
        }
        this.mailFromFilter = this.getLocalStringBindedParameter(rSet, "MAIL_FROM_FILTER", "");
        this.mailToFilter = this.getLocalStringBindedParameter(rSet, "MAIL_TO_FILTER", "");
        this.mailCCFilter = this.getLocalStringBindedParameter(rSet, "MAIL_CC_FILTER", "");
        this.mailSubjectFilter = this.getLocalStringBindedParameter(rSet, "MAIL_SUBJECT_FILTER", "");
        this.folderOptions = this.getLocalStringBindedParameter(rSet, "MAIL_FOLDER_OPTIONS", "none");
        this.keepOnServer = this.getLocalBooleanBindedParameter(rSet, "MAIL_KEEP_ON_SERVER", false);
        this.extractAtt = this.getLocalBooleanBindedParameter(rSet, "MAIL_EXTRACT_ATTACHEMENTS", true);
        this.extractMsg = this.getLocalBooleanBindedParameter(rSet, "MAIL_EXTRACT_MESSAGE", true);
        if (this.extractAtt.booleanValue() || this.extractMsg.booleanValue()) {
            this.mailFolder = this.getLocalStringBindedParameter(rSet, "MAIL_FILES_FOLDER", this.runtimeContext.TEMPORARY_FOLDER);
            if ('\\' == File.separatorChar) {
                this.mailFolder = this.mailFolder.replace('/', File.separatorChar);
            }
        } else {
            this.mailFolder = "";
        }
        this.useUCase = this.getLocalBooleanBindedParameter(rSet, "MAIL_USE_UCASE", false);
        this.noMailError = this.getLocalBooleanBindedParameter(rSet, "MAIL_NO_MAIL_ERROR", false);
        this.msgPrefix = this.getLocalStringBindedParameter(rSet, "MAIL_MESSAGE_PREFIX", "MSG");
        this.attPrefix = this.getLocalStringBindedParameter(rSet, "MAIL_ATTACHEMENT_PREFIX", "");
        this.timeOut = this.getLocalIntegerBindedParameter(rSet, "MAIL_TIMEOUT", -1).intValue();
        this.pollint = this.getLocalIntegerBindedParameter(rSet, "MAIL_POLLINT", 1000).intValue();
        this.mailWaitMode = this.getLocalBooleanBindedParameter(rSet, "MAIL_WAIT_MODE", false);
        this.maxMsg = this.getLocalIntegerBindedParameter(rSet, "MAIL_NB_MSG", -99);
        if (this.maxMsg == -99) {
            this.maxMsg = this.mailWaitMode != false ? 1 : Integer.MAX_VALUE;
        }
        this.markAs = this.getLocalStringBindedParameter(rSet, "MAIL_MARK_AS", null);
        this.mailExtraProperties = this.getLocalStringBindedParameter(rSet, "MAIL_EXTRA_PROPERTIES", null);
        this.debugLog("prepare", Messages.getString("ReadMailActionCodeI.5"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    private Map<String, Integer> storeAttachements(Part p, String mailFolder, Map<String, Integer> attachementNameMap) throws EngineExceptionI {
        block22: {
            try {
                if (p.isMimeType("text/*")) break block22;
                Object content = p.getContent();
                if (content instanceof InputStream) {
                    String outFolderName;
                    String filePrefix = this.attPrefix;
                    if (this.useUCase) {
                        filePrefix = this.attPrefix.toUpperCase(Locale.getDefault());
                    }
                    String fileNameExt = filePrefix;
                    String contenttype = p.getContentType();
                    String fileNameFromContentType = "";
                    if (contenttype.contains("name=")) {
                        fileNameFromContentType = contenttype.split("name=\"")[1].split("\"")[0];
                        fileNameExt = String.valueOf(fileNameExt) + fileNameFromContentType;
                    }
                    if (!(outFolderName = mailFolder).endsWith(File.separator)) {
                        outFolderName = String.valueOf(outFolderName) + File.separator;
                    }
                    String fileName = fileNameExt.equals(this.attPrefix) ? "stambia_email_attachment.dat" : fileNameExt;
                    String outFileName = String.valueOf(outFolderName) + fileName;
                    if (attachementNameMap.containsKey(outFileName)) {
                        int counter = attachementNameMap.get(outFileName) + 1;
                        attachementNameMap.put(outFileName, counter);
                        outFileName = String.valueOf(outFolderName) + filePrefix + counter + "-" + (fileNameExt.equals(this.attPrefix) ? "stambia_email_attachment.dat" : fileNameFromContentType);
                    } else {
                        attachementNameMap.put(outFileName, 1);
                    }
                    File outFile = new File(outFileName);
                    outFile = new File(this.checkFilePath(outFolderName, outFile, false));
                    try (BufferedInputStream fis = null;){
                        Throwable throwable = null;
                        Object var15_18 = null;
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outFile));){
                            int flux;
                            fis = new BufferedInputStream(p.getInputStream());
                            while ((flux = fis.read()) != -1) {
                                fos.write(flux);
                            }
                            break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                this.storeMultipartAttachements(p, mailFolder, attachementNameMap);
            }
            catch (Exception e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "ReadMailActionCodeI=>storeAttachements : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return attachementNameMap;
    }

    private void storeMultipartAttachements(Part p, String mailFolder, Map<String, Integer> attachementNameMap) throws IOException, MessagingException, EngineExceptionI {
        Multipart mp = (Multipart)p.getContent();
        int n = mp.getCount();
        int id = 0;
        String fileNameExt = "";
        String outFolderName = mailFolder;
        if (!outFolderName.endsWith(File.separator)) {
            outFolderName = String.valueOf(outFolderName) + File.separator;
        }
        int j = 0;
        while (j < n) {
            BodyPart part = mp.getBodyPart(j);
            String disposition = part.getDisposition();
            if (disposition != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"))) {
                String outFileName;
                String fileNameWithoutPrefix;
                ++id;
                if (part.getFileName() != null) {
                    fileNameWithoutPrefix = MimeUtility.decodeText((String)part.getFileName());
                    fileNameExt = String.valueOf(this.attPrefix) + fileNameWithoutPrefix;
                } else {
                    fileNameWithoutPrefix = "att" + j;
                    if (part.getContentType().startsWith("text/plain")) {
                        fileNameWithoutPrefix = String.valueOf(fileNameWithoutPrefix) + ".txt";
                    } else if (part.getContentType().startsWith("text/html")) {
                        fileNameWithoutPrefix = String.valueOf(fileNameWithoutPrefix) + ".html";
                    }
                    fileNameExt = String.valueOf(this.attPrefix) + fileNameWithoutPrefix;
                }
                if (this.useUCase) {
                    fileNameExt = fileNameExt.toUpperCase(Locale.getDefault());
                }
                if (attachementNameMap.containsKey(outFileName = String.valueOf(outFolderName) + fileNameExt)) {
                    int counter = attachementNameMap.get(outFileName) + 1;
                    attachementNameMap.put(outFileName, counter);
                    fileNameExt = String.valueOf(this.attPrefix) + counter + "-" + fileNameWithoutPrefix;
                    fileNameExt = this.useUCase ? fileNameExt.toUpperCase(Locale.getDefault()) : fileNameExt;
                    outFileName = String.valueOf(mailFolder) + File.separator + fileNameExt;
                } else {
                    attachementNameMap.put(outFileName, 1);
                }
                File outFile = new File(outFileName);
                outFile = new File(this.checkFilePath(outFolderName, outFile, false));
                BufferedInputStream fis = new BufferedInputStream(part.getInputStream());
                Throwable throwable = null;
                Object var17_19 = null;
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outFile));){
                    int flux;
                    while ((flux = fis.read()) != -1) {
                        fos.write(flux);
                    }
                    if (this.isRdbmsLinked.booleanValue()) {
                        this.insertInfoDataInTables(id, "ATTACH", fileNameExt);
                    }
                    fis.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++j;
        }
    }

    private String checkFilePath(String outFolderName, File file, boolean isDirectory) throws IOException {
        String canonicalDestinationPath = null;
        if (outFolderName != null && file != null) {
            canonicalDestinationPath = file.getCanonicalPath();
            if (isDirectory && !canonicalDestinationPath.endsWith(File.separator)) {
                canonicalDestinationPath = String.valueOf(canonicalDestinationPath) + File.separator;
            }
            if (canonicalDestinationPath != null && !canonicalDestinationPath.toLowerCase().startsWith(outFolderName.toLowerCase())) {
                throw new IOException("Entry " + canonicalDestinationPath + " is outside of the target directory " + outFolderName);
            }
        }
        return canonicalDestinationPath;
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            this.textIsHtml = p.isMimeType("text/html");
            return s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            int i = 0;
            while (i < mp.getCount()) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text == null) {
                        text = this.getText((Part)bp);
                    }
                } else if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s != null) {
                        return s;
                    }
                } else {
                    return this.getText((Part)bp);
                }
                ++i;
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int i = 0;
            while (i < mp.getCount()) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s != null) {
                    return s;
                }
                ++i;
            }
        }
        return null;
    }

    boolean acceptFilter(String filter, String attribute) throws EngineExceptionI {
        Boolean bFinded;
        block6: {
            block5: {
                bFinded = false;
                if (filter != null) break block5;
                return true;
            }
            if (!filter.equals("")) break block6;
            return true;
        }
        try {
            Pattern pDeb = Pattern.compile(filter);
            Matcher mDeb = pDeb.matcher(attribute);
            bFinded = mDeb.find(0);
        }
        catch (PatternSyntaxException patternSyntaxException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return bFinded;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        int nbMessages = 0;
        Map<String, Integer> attachementNameMap = new HashMap<String, Integer>();
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("ReadMailActionCodeI.6")) + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            this.createMailTables();
            this.isRdbmsLinked = true;
        }
        Store store = null;
        try {
            try {
                Properties props = (Properties)this.secret((ISecretStatement)new ISecretStatement<Properties>(){

                    public Properties execute(ISecretContext context) throws Throwable {
                        Properties props = new Properties();
                        if (ReadMailActionCodeI.this.mailUseSSL.booleanValue()) {
                            try {
                                Class<?> c = Class.forName(ReadMailActionCodeI.this.runtimeContext.defaultSSLProvider);
                                Provider p = (Provider)c.newInstance();
                                Security.addProvider(p);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            props.put("mail." + ReadMailActionCodeI.this.mailProtocol + ".socketFactory.class", ReadMailActionCodeI.SSL_FACTORY);
                            props.put("mail." + ReadMailActionCodeI.this.mailProtocol + ".socketFactory.fallback", "false");
                            props.put("mail." + ReadMailActionCodeI.this.mailProtocol + ".socketFactory.port", ReadMailActionCodeI.this.mailPort.getString(context));
                            props.put("mail." + ReadMailActionCodeI.this.mailProtocol + ".port", ReadMailActionCodeI.this.mailPort.getString(context));
                            if (ReadMailActionCodeI.this.mailSSLProtocol.equals("TLS")) {
                                props.put("mail." + ReadMailActionCodeI.this.mailProtocol + ".starttls.enable", "true");
                            }
                        } else {
                            props.put("mail." + ReadMailActionCodeI.this.mailProtocol + ".port", ReadMailActionCodeI.this.mailPort.getString(context));
                        }
                        return props;
                    }
                });
                this.appendSessionExtraProperties(props);
                final Session session = Session.getInstance((Properties)props, null);
                store = (Store)this.secret((ISecretStatement)new ISecretStatement<Store>(){

                    public Store execute(ISecretContext context) throws Throwable {
                        String password;
                        if (ReadMailActionCodeI.this.oauth2JsonString == null) {
                            password = ReadMailActionCodeI.this.mailPassword.decryptString(context);
                        } else {
                            Properties properties = OAuth2Utils.authJsonToProperties((String)ReadMailActionCodeI.this.oauth2JsonString);
                            password = AuthenticationFactory.getOAuth2Token((Map)OAuth2Utils.convertPropertiesToMap((Properties)properties));
                        }
                        URLName urln = new URLName(ReadMailActionCodeI.this.mailProtocol, ReadMailActionCodeI.this.mailHost.getString(context), Integer.parseInt(ReadMailActionCodeI.this.mailPort.getString(context)), null, ReadMailActionCodeI.this.mailUser.getString(context), password);
                        Store _store = session.getStore(urln);
                        try {
                            _store.connect();
                        }
                        catch (Exception ex) {
                            _store.close();
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            PrintStream debugStream = new PrintStream(bos);
                            session.setDebugOut(debugStream);
                            session.setDebug(true);
                            _store = session.getStore(urln);
                            try {
                                try {
                                    _store.connect();
                                }
                                catch (MessagingException e) {
                                    debugStream.flush();
                                    throw new MessagingException(String.format(Messages.getString("ReadMailActionCodeI.7"), bos.toString()), (Exception)((Object)e));
                                }
                            }
                            finally {
                                debugStream.close();
                            }
                        }
                        return _store;
                    }
                });
                this.debugLog("executeSimpleCode", "Connection to hostname ok", 3, "DEBUG");
                Folder folder = store.getFolder(this.serverFolder);
                long debTime = new Date().getTime();
                int NbMsg = 0;
                boolean shouldWait = true;
                while (shouldWait && new Date().getTime() < (this.timeOut == -1L ? Long.MAX_VALUE : debTime + this.timeOut)) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    folder.open(this.markAs != null || !this.keepOnServer ? 2 : 1);
                    this.debugLog("executeSimpleCode", "Server Folder ok", 4, "DEBUG");
                    Message[] message = folder.getMessages();
                    if (message.length > 0 && (this.extractMsg.booleanValue() || this.extractAtt.booleanValue())) {
                        File f = new File(this.mailFolder);
                        f = new File(this.checkFilePath(this.mailFolder, f, true));
                        f.mkdirs();
                    }
                    this.debugLog("executeSimpleCode", " Creation r\ufffdpertoire ok", 3, "DEBUG");
                    int i = 0;
                    int n = message.length;
                    while (i < n && NbMsg < this.maxMsg) {
                        String messageFolder = this.mailFolder;
                        if (!messageFolder.endsWith(File.separator)) {
                            messageFolder = String.valueOf(messageFolder) + File.separator;
                        }
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        boolean acceptFilters = false;
                        Message msg = message[i];
                        boolean bl = !(this.mailFromFilter != null && !this.mailFromFilter.isEmpty() && !this.acceptFilter(this.mailFromFilter, this.getFromString(msg)) || this.mailSubjectFilter != null && !this.mailSubjectFilter.isEmpty() && !this.acceptFilter(this.mailSubjectFilter, msg.getSubject() != null ? msg.getSubject() : "") || this.mailToFilter != null && !this.mailToFilter.isEmpty() && !this.acceptFilter(this.mailToFilter, this.getToString(msg)) || this.mailCCFilter != null && !this.mailCCFilter.isEmpty() && !this.acceptFilter(this.mailCCFilter, this.getCCString(msg))) ? true : (acceptFilters = false);
                        if (acceptFilters && !msg.isSet(Flags.Flag.DELETED)) {
                            Object object;
                            if (this.isRdbmsLinked.booleanValue()) {
                                this.insertHeaderDataInTables(msg, messageFolder, this.attPrefix, this.msgPrefix, false);
                            }
                            try {
                                File f;
                                if (!this.folderOptions.equals("none")) {
                                    if (this.folderOptions.equals("sender")) {
                                        messageFolder = String.valueOf(messageFolder) + this.getFromString(msg).replaceAll("[\\s\\p{Punct}&&[^.]]", "_");
                                    } else if (this.folderOptions.equals("subject")) {
                                        messageFolder = String.valueOf(messageFolder) + msg.getSubject().replaceAll("[\\s\\p{Punct}&&[^.]]", "_");
                                    }
                                }
                                if (this.extractMsg.booleanValue()) {
                                    f = new File(messageFolder);
                                    f = new File(this.checkFilePath(messageFolder, f, true));
                                    f.mkdirs();
                                    String msgMain = this.getText((Part)msg);
                                    String fileNameExt = "";
                                    fileNameExt = this.textIsHtml != false ? String.valueOf(this.msgPrefix) + String.valueOf(NbMsg + 1) + ".html" : String.valueOf(this.msgPrefix) + String.valueOf(NbMsg + 1) + ".txt";
                                    if (this.useUCase) {
                                        fileNameExt = fileNameExt.toUpperCase(Locale.getDefault());
                                    }
                                    object = null;
                                    Object var22_29 = null;
                                    try (FileOutputStream fstream = new FileOutputStream(String.valueOf(messageFolder) + fileNameExt);){
                                        if (this.isRdbmsLinked.booleanValue()) {
                                            this.insertInfoDataInTables(1, "BODY", fileNameExt);
                                        }
                                        if (msgMain != null) {
                                            fstream.write(msgMain.getBytes());
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (object == null) {
                                            object = throwable;
                                        } else if (object != throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                        throw object;
                                    }
                                }
                                if (this.extractAtt.booleanValue()) {
                                    f = new File(messageFolder);
                                    f = new File(this.checkFilePath(messageFolder, f, true));
                                    f.mkdirs();
                                    attachementNameMap = this.storeAttachements((Part)msg, messageFolder, attachementNameMap);
                                }
                            }
                            catch (IOException e) {
                                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "ReadMailActionCodeI=>executeSimpleCode : " + e.getMessage(), "String", false);
                                throw new EngineExceptionI((Throwable)e);
                            }
                            if (!this.keepOnServer) {
                                msg.setFlag(Flags.Flag.DELETED, true);
                            }
                            if (this.markAs != null) {
                                object = this.markAs.split("[,; ]");
                                int n2 = ((String[])object).length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    String _flag = object[n3];
                                    String flag = _flag.trim();
                                    if (flag != null) {
                                        if ((flag = flag.toUpperCase()).equals("READ")) {
                                            msg.setFlag(Flags.Flag.SEEN, true);
                                        } else if (flag.equals("UNREAD")) {
                                            msg.setFlag(Flags.Flag.SEEN, false);
                                        } else if (flag.equals("DELETED")) {
                                            msg.setFlag(Flags.Flag.DELETED, true);
                                        } else if (flag.equals("DRAFT")) {
                                            msg.setFlag(Flags.Flag.DRAFT, true);
                                        } else if (flag.equals("ANSWERED")) {
                                            msg.setFlag(Flags.Flag.ANSWERED, true);
                                        } else if (flag.equals("RECENT")) {
                                            msg.setFlag(Flags.Flag.RECENT, true);
                                        } else if (flag.equals("SEEN")) {
                                            msg.setFlag(Flags.Flag.SEEN, true);
                                        } else if (flag.equals("FLAGGED")) {
                                            msg.setFlag(Flags.Flag.FLAGGED, true);
                                        } else {
                                            msg.setFlags(new Flags(_flag), true);
                                        }
                                    }
                                    ++n3;
                                }
                            }
                            ++NbMsg;
                            this.publishVariable("MAIL_NB", String.valueOf(++nbMessages), "Integer", false);
                        }
                        ++i;
                    }
                    if (NbMsg == 0 && this.noMailError) {
                        this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("ReadMailActionCodeI.8"), "String", false);
                        throw new EngineExceptionI(Messages.getString("ReadMailActionCodeI.9"));
                    }
                    folder.close(true);
                    shouldWait = this.mailWaitMode != false && NbMsg < this.maxMsg;
                    if (!shouldWait) continue;
                    try {
                        Thread.sleep(this.pollint);
                    }
                    catch (InterruptedException e) {
                        this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("ReadMailActionCodeI.10")) + e.getMessage(), "String", false);
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                this.publishCumulativeVariable("MAIL_NB", String.valueOf(nbMessages), "Integer", false);
                store.close();
            }
            catch (InterruptedException e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("ReadMailActionCodeI.11"), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            catch (Exception e) {
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), String.valueOf(Messages.getString("ReadMailActionCodeI.12")) + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

