/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.mail.MailActionCode;
import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.Tools;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.base.core.auth.AuthenticationFactory;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.sun.mail.util.MailSSLSocketFactory;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMailActionCodeI
extends MailActionCode {
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final String DEFAULT_MAIL_PORT = "25";
    private static final String DEFAULT_SSL_MAIL_PORT = "995";
    private static final String DEFAULT_SSL_PROTOCOL = "SSL";
    ISecretValue mailHost;
    ISecretValue mailPort;
    String mailFrom;
    String mailTo;
    Boolean mailUseSSL = false;
    String mailSSLProtocol = "SSL";
    String mailBCC;
    String mailCC;
    String mailSubject;
    String mailAttach;
    String mailText;
    String mailTextType = "txt";
    ISecretValue mailUser;
    ISecretValue mailPassword;
    int nbMessages = 0;
    Transport mailTransport = null;
    private String contentType;
    private String mailBodyFile;
    private String mailBodyFileEncoding;
    private File temporaryFolder;

    public SendMailActionCodeI() {
        this.actionCodeName = "Send Mail Operation";
        this.bNullCodeAllowed = true;
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (this.mailTransport != null && this.mailTransport.isConnected()) {
            try {
                this.mailTransport.close();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        if (th != null) {
            th.interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("SendMailActionCodeI.0"), 3, "DEBUG");
        String tempFolder = this.getStringParameter(String.valueOf(this.runtimeContext.VAR_PREFIXE) + Constant.VAR_CORE_TEMPORARY_FOLDER);
        this.temporaryFolder = new File(String.valueOf(tempFolder) + "/" + "SendMailActionCode");
        this.setStandardConnectionParameters(rSet);
        this.mailHost = this.getLocalSecretBindedParameter(rSet, "MAIL_HOSTNAME", null);
        this.mailFrom = this.getLocalStringBindedParameter(rSet, "MAIL_FROM", null);
        if (this.mailHost.isNull() || this.mailFrom == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "MAIL_HOSTNAME and MAIL_FROM are mandatory", "String", false);
            throw new EngineExceptionI("MAIL_HOSTNAME and MAIL_FROM are mandatory");
        }
        this.mailUseSSL = this.getLocalBooleanBindedParameter(rSet, "MAIL_USE_SSL", false);
        if (this.mailUseSSL.booleanValue()) {
            this.mailSSLProtocol = this.getLocalStringBindedParameter(rSet, "MAIL_SSL_PROTOCOL", DEFAULT_SSL_PROTOCOL);
        }
        this.mailPort = this.getLocalSecretBindedParameter(rSet, "MAIL_PORT", null);
        if (this.mailPort.isNull()) {
            if (this.mailUseSSL.booleanValue()) {
                this.mailPort.setDefaultValue(DEFAULT_SSL_MAIL_PORT);
            } else {
                this.mailPort.setDefaultValue(DEFAULT_MAIL_PORT);
            }
        }
        this.mailUser = this.getLocalSecretBindedParameter(rSet, "MAIL_USER", null);
        this.mailPassword = this.getLocalSecretBindedParameter(rSet, "MAIL_PASSWORD", this.getLocalStringBindedParameter(rSet, "MAIL_UNCRYPTED_PASSWORD", ""));
        this.oauth2JsonString = this.getLocalStringBindedParameter(rSet, "SECURITY_MD_TO_JSON", null);
        this.mailTo = this.getLocalStringBindedParameter(rSet, "MAIL_TO", "");
        this.mailCC = this.getLocalStringBindedParameter(rSet, "MAIL_CC", "");
        this.mailBCC = this.getLocalStringBindedParameter(rSet, "MAIL_BCC", "");
        if (this.mailTo.isEmpty() && this.mailCC.isEmpty() && this.mailBCC.isEmpty()) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Either MAIL_TO or MAIL_CC or MAIL_BCC should be filled", "String", false);
            throw new EngineExceptionI("Either MAIL_TO or MAIL_CC or MAIL_BCC should be filled");
        }
        this.mailSubject = this.getLocalStringBindedParameter(rSet, "MAIL_SUBJECT", "");
        this.mailAttach = this.getLocalStringBindedParameter(rSet, "MAIL_ATTACH", "");
        this.mailBodyFile = this.getLocalStringBindedParameter(rSet, "MAIL_CONTENT_FILE", null);
        this.mailBodyFileEncoding = this.getLocalStringBindedParameter(rSet, "MAIL_CONTENT_FILE_ENCODING", null);
        String txt = null;
        if (this.mailBodyFile != null && !this.mailBodyFile.isEmpty()) {
            File file = new File(this.mailBodyFile);
            if (!file.exists()) throw new EngineExceptionI(String.valueOf(Messages.getString("SendMailActionCodeI.2")) + this.mailBodyFile + Messages.getString("SendMailActionCodeI.3"));
            try {
                txt = Tools.readFileAsString((String)this.mailBodyFile, (String)this.mailBodyFileEncoding);
            }
            catch (IOException e) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("SendMailActionCodeI.1")) + this.mailBodyFile + " file", (Throwable)e);
            }
        } else {
            this.mailBodyFile = null;
        }
        String volatileActionCode = null;
        if (rSet == null) {
            if (txt != null) {
                txt = this.actionContext.executeSubstitutionScript(txt, "s");
            }
            volatileActionCode = txt != null ? txt : this.actionTxtCode;
        } else {
            String _txt;
            String string = _txt = txt != null ? txt : this.actionTxtCode;
            if (_txt != null) {
                volatileActionCode = this.getFinalBindedCode(rSet, txt != null ? txt : this.actionTxtCode);
            }
        }
        this.mailText = volatileActionCode == null || volatileActionCode.isEmpty() ? this.getLocalStringBindedParameter(rSet, "MAIL_TEXT", "") : volatileActionCode;
        this.contentType = this.getLocalBooleanBindedParameter(rSet, "MAIL_HTML_MODE", false) != false ? "text/html" : "";
        this.mailExtraProperties = this.getLocalStringBindedParameter(rSet, "MAIL_EXTRA_PROPERTIES", null);
        this.debugLog("prepare", Messages.getString("SendMailActionCodeI.4"), 3, "DEBUG");
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    String[] getlstAttachedFiles(String pAddr) throws EngineExceptionI {
        String[] lstFound = null;
        try {
            lstFound = pAddr.split(";");
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return lstFound;
    }

    InternetAddress[] getlstAdresses(String pAddr) throws EngineExceptionI {
        InternetAddress[] internetAddresses = null;
        String[] lstFound = pAddr.split(";");
        int i = 0;
        internetAddresses = new InternetAddress[lstFound.length];
        while (i != lstFound.length) {
            try {
                internetAddresses[i] = new InternetAddress(lstFound[i]);
            }
            catch (Exception e) {
                this.debugLog("getlstAdresses", "Exception : " + e.getMessage(), 0, "ERROR");
                throw new EngineExceptionI((Throwable)e);
            }
            ++i;
        }
        return internetAddresses;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", String.valueOf(Messages.getString("SendMailActionCodeI.5")) + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            this.createMailTables();
            this.isRdbmsLinked = true;
        }
        String msgId = UUID.randomUUID().toString();
        this.logger.info(String.valueOf(Messages.getString("SendMailActionCodeI.6")) + msgId);
        this.logger.info(String.valueOf(msgId) + Messages.getString("SendMailActionCodeI.7") + this.mailSubject + Messages.getString("SendMailActionCodeI.8") + this.mailTo + Messages.getString("SendMailActionCodeI.9") + this.mailCC + " ; " + Messages.getString("SendMailActionCodeI.10") + this.mailBCC);
        try {
            try {
                this.debugLog("executeSimpleCode", Messages.getString("SendMailActionCodeI.11"), 3, "DEBUG");
                final Properties props = new Properties();
                Object internetAddresses = null;
                this.nbMessages = 0;
                final MimeMessage message = (MimeMessage)this.secret((ISecretStatement)new ISecretStatement<MimeMessage>(){

                    public MimeMessage execute(final ISecretContext context) throws Throwable {
                        Session session;
                        props.put("mail.smtp.host", SendMailActionCodeI.this.mailHost.getString(context));
                        if (SendMailActionCodeI.this.mailUseSSL.booleanValue()) {
                            try {
                                Class<?> c = Class.forName(SendMailActionCodeI.this.runtimeContext.defaultSSLProvider);
                                Provider p = (Provider)c.newInstance();
                                Security.addProvider(p);
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                            if (SendMailActionCodeI.this.mailSSLProtocol.equals("TLS")) {
                                try {
                                    MailSSLSocketFactory socketFactory = new MailSSLSocketFactory();
                                    socketFactory.setTrustAllHosts(true);
                                    props.put("mail.smtp.ssl.socketFactory", socketFactory);
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                                props.put("mail.smtp.starttls.enable", "true");
                            } else {
                                props.put("mail.smtp.socketFactory.class", SendMailActionCodeI.SSL_FACTORY);
                            }
                            props.put("mail.smtp.socketFactory.fallback", "false");
                            props.put("mail.smtp.socketFactory.port", SendMailActionCodeI.this.mailPort.getString(context));
                            props.put("mail.smtp.port", SendMailActionCodeI.this.mailPort.getString(context));
                        } else {
                            props.put("mail.smtp.port", SendMailActionCodeI.this.mailPort.getString(context));
                        }
                        SendMailActionCodeI.this.appendSessionExtraProperties(props);
                        if (!SendMailActionCodeI.this.mailUser.isNull()) {
                            props.put("mail.smtp.auth", "true");
                            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                                protected PasswordAuthentication getPasswordAuthentication() {
                                    try {
                                        String password;
                                        if (SendMailActionCodeI.this.oauth2JsonString == null) {
                                            password = (this).SendMailActionCodeI.this.mailPassword.decryptString(context);
                                        } else {
                                            Properties properties = OAuth2Utils.authJsonToProperties((String)SendMailActionCodeI.this.oauth2JsonString);
                                            password = AuthenticationFactory.getOAuth2Token((Map)OAuth2Utils.convertPropertiesToMap((Properties)properties));
                                        }
                                        return new PasswordAuthentication((this).SendMailActionCodeI.this.mailUser.getString(context), password);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        return null;
                                    }
                                }
                            });
                        } else {
                            session = Session.getInstance((Properties)props, null);
                        }
                        SendMailActionCodeI.this.mailTransport = session.getTransport("smtp");
                        SendMailActionCodeI.this.mailTransport.connect();
                        if (SendMailActionCodeI.this.contentType != null && !SendMailActionCodeI.this.contentType.isEmpty() && !SendMailActionCodeI.this.contentType.contains("charset=")) {
                            SendMailActionCodeI sendMailActionCodeI = SendMailActionCodeI.this;
                            sendMailActionCodeI.contentType = String.valueOf(sendMailActionCodeI.contentType) + "; charset=UTF-8";
                        }
                        MimeMessage message = new MimeMessage(session);
                        message.setFrom((Address)new InternetAddress(SendMailActionCodeI.this.mailFrom));
                        if (!SendMailActionCodeI.this.mailTo.isEmpty()) {
                            InternetAddress[] internetTo = SendMailActionCodeI.this.getlstAdresses(SendMailActionCodeI.this.mailTo);
                            message.addRecipients(Message.RecipientType.TO, (Address[])internetTo);
                        }
                        if (!SendMailActionCodeI.this.mailCC.isEmpty()) {
                            InternetAddress[] internetCC = SendMailActionCodeI.this.getlstAdresses(SendMailActionCodeI.this.mailCC);
                            message.addRecipients(Message.RecipientType.CC, (Address[])internetCC);
                        }
                        if (!SendMailActionCodeI.this.mailBCC.isEmpty()) {
                            InternetAddress[] internetBCC = SendMailActionCodeI.this.getlstAdresses(SendMailActionCodeI.this.mailBCC);
                            message.addRecipients(Message.RecipientType.BCC, (Address[])internetBCC);
                        }
                        return message;
                    }
                });
                message.setSubject(this.mailSubject);
                BidiMap inlineAttachments = new BidiMap();
                String[] lstFiles = this.getlstAttachedFiles(this.mailAttach);
                ArrayList<File> attachmentsFiles = new ArrayList<File>();
                String[] stringArray = lstFiles;
                int n = lstFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    if (!file.isEmpty()) {
                        attachmentsFiles.add(new File(file));
                    }
                    ++n2;
                }
                String newText = this.contentType.contains("text/html") ? this.extractImage(this.mailText, (BidiMap<String, String>)inlineAttachments, this.mailBodyFile, attachmentsFiles) : this.mailText;
                if (attachmentsFiles.size() > 0 || inlineAttachments.size() > 0) {
                    MimeMultipart root;
                    MimeMultipart attachments = root = new MimeMultipart("mixed");
                    Multipart alternative = this.newChild((Multipart)root, "alternative");
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    if (!this.contentType.isEmpty()) {
                        Multipart htmlAndInline = this.newChild(alternative, "related");
                        htmlAndInline.addBodyPart((BodyPart)messageBodyPart);
                        messageBodyPart.setContent((Object)newText, this.contentType);
                        for (Object obj : inlineAttachments.keySet()) {
                            MimeBodyPart mimePart = new MimeBodyPart();
                            String file = (String)obj;
                            String id = (String)inlineAttachments.get((Object)file);
                            FileDataSource fds = new FileDataSource(file);
                            mimePart.setFileName(fds.getName());
                            mimePart.setDataHandler(new DataHandler((DataSource)fds));
                            mimePart.setHeader("Content-ID", "<" + id + ">");
                            htmlAndInline.addBodyPart((BodyPart)mimePart);
                        }
                    } else {
                        alternative.addBodyPart((BodyPart)messageBodyPart);
                        messageBodyPart.setText(newText);
                    }
                    for (File file : attachmentsFiles) {
                        MimeBodyPart mimePart = new MimeBodyPart();
                        FileDataSource source = new FileDataSource(file);
                        mimePart.setDataHandler(new DataHandler((DataSource)source));
                        mimePart.setFileName(file.getName());
                        attachments.addBodyPart((BodyPart)mimePart);
                    }
                    message.setContent((Multipart)root);
                } else if (this.contentType != null && !this.contentType.isEmpty()) {
                    message.setContent((Object)newText, this.contentType);
                } else {
                    message.setText(newText, "UTF-8");
                }
                this.logger.info(String.valueOf(msgId) + Messages.getString("SendMailActionCodeI.12"));
                this.secret((ISecretStatement)new ISecretStatement<Object>(){

                    public Object execute(ISecretContext context) throws Throwable {
                        SendMailActionCodeI.this.mailTransport.sendMessage((Message)message, message.getAllRecipients());
                        if (SendMailActionCodeI.this.isRdbmsLinked.booleanValue()) {
                            SendMailActionCodeI.this.insertHeaderDataInTables((Message)message, null, null, null, true);
                        }
                        return null;
                    }
                });
                this.logger.info(String.valueOf(msgId) + Messages.getString("SendMailActionCodeI.13"));
                ++this.nbMessages;
                this.publishCumulativeVariable("MAIL_NB", String.valueOf(this.nbMessages), "Integer", false);
            }
            catch (Exception e) {
                this.logger.error(String.valueOf(Messages.getString("SendMailActionCodeI.14")) + msgId, (Throwable)e);
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                this.debugLog("executeSimpleCode", "Exception " + e.getMessage(), 0, "ERROR");
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (this.mailTransport != null && this.mailTransport.isConnected()) {
                try {
                    this.mailTransport.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    private String extractImage(String txt, BidiMap<String, String> inlineAttachments, String parent, List<File> attachmentsFiles) {
        Pattern pDeb2 = Pattern.compile("(<img.+src[ ]*=[ ]*\"([^\"]*)\".*>)|(@import[ ]+\"([^\"]*)\"[;]?)");
        Matcher mDeb2 = pDeb2.matcher(txt);
        int deb = 0;
        String nexText = "";
        int i = 0;
        while (mDeb2.find()) {
            int iDeb = mDeb2.start(2);
            int iFin = mDeb2.end(2);
            int iDeb2 = mDeb2.start(4);
            int iFin2 = mDeb2.end(4);
            int iD = iDeb;
            int iF = iFin;
            if (iD > -1) {
                boolean ok = false;
                String file = txt.substring(iD, iF);
                try {
                    File _file = new File(file);
                    if (!_file.isAbsolute() && parent != null) {
                        File _parent = new File(parent).getParentFile();
                        _file = new File(_parent, file);
                        ok = _file.exists();
                        file = _file.getAbsolutePath();
                    } else {
                        ok = _file.exists();
                        if (!ok && file.startsWith("cid:")) {
                            String name = file.substring(4);
                            if (attachmentsFiles != null) {
                                for (File __file : attachmentsFiles) {
                                    if (!__file.getName().equals(name)) continue;
                                    attachmentsFiles.remove(__file);
                                    _file = __file;
                                    ok = true;
                                    break;
                                }
                            }
                        }
                        file = _file.getAbsolutePath();
                    }
                }
                catch (Exception e) {
                    this.debugLog("extractImage", e.getMessage(), 0, "ERROR");
                }
                if (ok) {
                    String index = (String)inlineAttachments.getTo((Object)file);
                    if (index == null) {
                        index = "img" + String.valueOf(i++);
                        inlineAttachments.put((Object)file, (Object)index);
                    }
                    nexText = String.valueOf(nexText) + txt.substring(deb, iD);
                    nexText = String.valueOf(nexText) + "cid:" + index;
                    deb = iF;
                    continue;
                }
                nexText = String.valueOf(nexText) + txt.substring(deb, iF);
                deb = iF;
                continue;
            }
            if (iDeb2 <= -1) continue;
            nexText = String.valueOf(nexText) + txt.substring(deb, iDeb2);
            String file = txt.substring(iDeb2, iFin2);
            File _file = new File(file);
            if (!_file.isAbsolute() && parent != null) {
                File _parent = new File(parent).getParentFile();
                _file = new File(_parent, file);
            }
            if (_file.exists()) {
                try {
                    String tt = Tools.readFileAsString((String)_file.getAbsolutePath(), null);
                    nexText = String.valueOf(nexText) + tt;
                }
                catch (IOException e) {
                    nexText = String.valueOf(nexText) + file;
                    this.debugLog("extractCss", e.getMessage(), 0, "ERROR");
                }
            }
            deb = iFin2;
        }
        if (txt.length() > deb) {
            nexText = String.valueOf(nexText) + txt.substring(deb);
        }
        return nexText;
    }

    public static void main(String[] args) {
        BidiMap map = new BidiMap();
        String txt = "\n<kdozkdozkdozk\n<img src=\"coucou\"> dkzodkzodkozd <image src=\"coucou2\"> dkzodkzodkozd";
        SendMailActionCodeI smac = new SendMailActionCodeI();
        System.out.println(smac.extractImage(txt, (BidiMap<String, String>)map, null, null));
    }

    private Multipart newChild(Multipart parent, String type) throws MessagingException {
        MimeMultipart child = new MimeMultipart(type);
        MimeBodyPart mbp = new MimeBodyPart();
        parent.addBodyPart((BodyPart)mbp);
        mbp.setContent((Multipart)child);
        return child;
    }
}

