/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.UUID;

public class WriteTxtFileActionCodeI
extends ActionCodeTypeI {
    String actionFile = "";
    String valNewLineChar = System.getProperty("line.separator");
    String valEncoding;
    String valAppend;
    String volatileActionCode;
    private Boolean appendSeparator;

    public WriteTxtFileActionCodeI() {
        this.actionCodeName = "Write Txt file Class";
        this.bNullCodeAllowed = true;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.execute();
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        this.volatileActionCode = rSet == null ? this.actionTxtCode : this.getFinalBindedCode(rSet, this.actionTxtCode);
        int ret = 0;
        this.actionFile = this.getLocalStringBindedParameter(rSet, "TXT_WRITE_FILENAME", null);
        if (this.actionFile == null) {
            this.debugLog("prepare", "TXT_WRITE_FILENAME is mandatory", 1, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "TXT_WRITE_FILENAME is mandatory", "String", false);
        }
        this.valNewLineChar = this.getLocalStringBindedParameter(rSet, "TXT_WRITE_NEWLINE_CHAR", System.getProperty("line.separator"));
        if (this.valNewLineChar != null) {
            this.valNewLineChar = this.valNewLineChar.replaceAll("\\\\r", "\r").replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n");
        }
        this.valEncoding = this.getLocalStringBindedParameter(rSet, "TXT_WRITE_ENCODING", Charset.defaultCharset().displayName());
        this.valAppend = this.getLocalStringBindedParameter(rSet, "TXT_WRITE_APPEND", "false");
        this.valAppend = this.valAppend.equals("true") ? "after" : this.valAppend;
        this.appendSeparator = !this.valAppend.equals("false") ? this.getLocalBooleanBindedParameter(rSet, "TXT_WRITE_APPEND_LINE_SEPARATOR", true) : Boolean.valueOf(false);
        return ret;
    }

    public void execute() throws EngineExceptionI {
        block11: {
            if (this.volatileActionCode == null) {
                this.volatileActionCode = "";
            }
            try {
                String _appendSeparator;
                File f = new File(this.actionFile);
                if (f.getParentFile() != null) {
                    f.getParentFile().mkdirs();
                }
                f = null;
                File file = new File(this.actionFile);
                String string = _appendSeparator = file.exists() && this.appendSeparator != false ? this.valNewLineChar : "";
                if (this.valAppend.equals("before") && file.exists()) {
                    this.insertStringInFile(file, String.valueOf(this.volatileActionCode.replaceAll("\\u000A", this.valNewLineChar)) + _appendSeparator, this.valNewLineChar, this.valEncoding);
                    break block11;
                }
                FileOutputStream fout = null;
                OutputStream bout = null;
                OutputStreamWriter out = null;
                try {
                    fout = new FileOutputStream(this.actionFile, this.valAppend.equals("after"));
                    bout = new BufferedOutputStream(fout);
                    out = new OutputStreamWriter(bout, this.valEncoding);
                    out.write(String.valueOf(_appendSeparator) + this.volatileActionCode.replaceAll("\\u000A", this.valNewLineChar));
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (bout != null) {
                        bout.close();
                    }
                    if (fout != null) {
                        ((OutputStream)fout).close();
                    }
                }
            }
            catch (Exception e) {
                this.debugLog("executeSimpleCode", "Exception : " + e.getMessage(), 1, "ERROR");
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception: " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public void insertStringInFile(File inFile, String lineToBeInserted, String lineSeparator, String encoding) throws Exception {
        String tmp = UUID.randomUUID().toString();
        File outFile = new File(inFile.getParentFile(), String.valueOf(inFile.getName()) + "." + tmp + ".tmp");
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            fos = new FileOutputStream(outFile);
            bos = new BufferedOutputStream(fos);
            bos.write(lineToBeInserted.getBytes(encoding));
            fis = new FileInputStream(inFile);
            bis = new BufferedInputStream(fis);
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (bis != null) {
                bis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        if (inFile.delete()) {
            if (!outFile.renameTo(inFile)) {
                throw new EngineExceptionI(String.valueOf(Messages.getString("WriteTxtFileActionCodeI.0")) + inFile.getAbsolutePath() + " file");
            }
        } else {
            throw new EngineExceptionI(String.valueOf(Messages.getString("WriteTxtFileActionCodeI.1")) + inFile.getAbsolutePath() + " file");
        }
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        this.execute();
        return ret;
    }
}

