/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.actionCodes.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsltActionCodeI
extends ActionCodeTypeI {
    private Transformer transformer;
    private String inAsString;
    private String outAsString;
    private boolean isOutDirectory;
    private String xsltAsString;
    String code;
    private String sessionClassLoaderName;

    public XsltActionCodeI() {
        super("Xslt File Class", true);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return 0;
    }

    public static void main(String[] args) {
        XsltActionCodeI xac = new XsltActionCodeI();
        xac.xsltAsString = "E:\\Work\\temp\\test.xsl";
        xac.inAsString = "E:\\Work\\temp\\conversion.xml";
        xac.outAsString = "E:\\Work\\temp\\conversion2.xml";
        try {
            xac.executeSimpleCode();
        }
        catch (EngineExceptionI e) {
            e.printStackTrace();
        }
    }

    public static Source createSource(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory Factory2 = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = Factory2.newDocumentBuilder();
        constructeur.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.toLowerCase().endsWith(".dtd")) {
                    StringReader stringInput = new StringReader(" ");
                    return new InputSource(stringInput);
                }
                return null;
            }
        });
        Document document = constructeur.parse(in);
        return new DOMSource(document);
    }

    public static Transformer createTransformer(TransformerFactory fabriqueT, InputStream xsl) throws ParserConfigurationException, SAXException, IOException, TransformerException, EngineExceptionI {
        final ArrayList warningException = new ArrayList();
        final ArrayList fatalErrorException = new ArrayList();
        final ArrayList errorException = new ArrayList();
        fabriqueT.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        fabriqueT.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        StreamSource stylesource = new StreamSource(xsl);
        fabriqueT.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException arg0) throws TransformerException {
                warningException.add(arg0);
            }

            @Override
            public void fatalError(TransformerException arg0) throws TransformerException {
                fatalErrorException.add(arg0);
            }

            @Override
            public void error(TransformerException arg0) throws TransformerException {
                errorException.add(arg0);
            }
        });
        try {
            return fabriqueT.newTransformer(stylesource);
        }
        catch (Exception e) {
            if (fatalErrorException.size() > 0) {
                throw (TransformerException)fatalErrorException.get(0);
            }
            if (errorException.size() > 0) {
                throw (TransformerException)errorException.get(0);
            }
            throw new EngineExceptionI((Throwable)e);
        }
    }

    public static Transformer createTransformer(InputStream xsl) throws ParserConfigurationException, SAXException, IOException, TransformerException, EngineExceptionI {
        TransformerFactory fabriqueT = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null);
        return XsltActionCodeI.createTransformer(fabriqueT, xsl);
    }

    int runTransform(String inputFile, String outputFile, String xslFile) throws EngineExceptionI {
        boolean ret = false;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            try {
                File outFile = new File(outputFile.trim());
                File temporaryFile = null;
                if (!this.isOutDirectory) {
                    temporaryFile = new File(String.valueOf(outFile.getParent()) + "/" + new Long(System.currentTimeMillis()).toString() + ".temp." + outFile.getName());
                    outFile.getParentFile().mkdirs();
                    fos = new FileOutputStream(temporaryFile);
                }
                fis = new FileInputStream(inputFile.trim());
                if (this.transformer == null) {
                    ClassLoader ncl = null;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (this.sessionClassLoaderName != null) {
                        ncl = this.getActionContext().getSessionClassLoader(this.sessionClassLoaderName);
                        Thread.currentThread().setContextClassLoader(ncl);
                    }
                    InputStream xslInput = xslFile != null ? new FileInputStream(xslFile.trim()) : new ByteArrayInputStream(this.code.getBytes());
                    TransformerFactory trans = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", cl);
                    this.transformer = XsltActionCodeI.createTransformer(trans, xslInput);
                    if (ncl != null) {
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                }
                if (this.isOutDirectory) {
                    if (!outFile.exists()) {
                        outFile.mkdir();
                    }
                    this.transformer.transform(XsltActionCodeI.createSource(fis), new StreamResult(outFile));
                } else {
                    boolean deleted;
                    this.transformer.transform(XsltActionCodeI.createSource(fis), new StreamResult(fos));
                    if (outFile.exists() && !(deleted = outFile.delete())) {
                        throw new EngineExceptionI(String.valueOf(Messages.getString("XsltActionCodeI.0")) + outFile.getAbsolutePath());
                    }
                    if (!outFile.getParentFile().exists()) {
                        outFile.getParentFile().mkdirs();
                    }
                    this.closeStreams(fis, fos);
                    boolean test = temporaryFile.renameTo(outFile);
                    if (!test) {
                        throw new EngineExceptionI(String.valueOf(Messages.getString("XsltActionCodeI.1")) + temporaryFile.getAbsolutePath() + Messages.getString("XsltActionCodeI.2") + outFile.getAbsolutePath());
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (SAXException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (IOException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (TransformerException e) {
                throw new EngineExceptionI((Throwable)e);
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.closeStreams(fis, fos);
            throw throwable;
        }
        this.closeStreams(fis, fos);
        return 0;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        return this.runTransform(this.inAsString, this.outAsString, this.xsltAsString);
    }

    private void closeStreams(FileInputStream fis, FileOutputStream fos) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        int ret = 0;
        try {
            this.inAsString = this.getLocalStringBindedParameter(sourceRSet, "IN_FILE_NAME");
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(Messages.getString("XsltActionCodeI.3"));
        }
        try {
            this.outAsString = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_NAME");
        }
        catch (EngineExceptionI e) {
            // empty catch block
        }
        String outDirectory = null;
        try {
            outDirectory = this.getLocalStringBindedParameter(sourceRSet, "OUT_FILE_DIR");
        }
        catch (EngineExceptionI engineExceptionI) {
            // empty catch block
        }
        if (outDirectory != null && outDirectory.length() > 0) {
            if (this.outAsString != null && this.outAsString.length() > 0) {
                throw new EngineExceptionI(Messages.getString("XsltActionCodeI.4"));
            }
            this.outAsString = outDirectory;
            this.isOutDirectory = true;
        } else if (this.outAsString == null || this.outAsString.length() == 0) {
            throw new EngineExceptionI(Messages.getString("XsltActionCodeI.5"));
        }
        boolean cacheXsl = this.getLocalBooleanBindedParameter(sourceRSet, "XSL_ACTIVE_CACHE", false);
        if (!cacheXsl && this.transformer != null) {
            this.transformer = null;
        }
        if (this.transformer == null) {
            try {
                this.xsltAsString = this.getLocalStringBindedParameter(sourceRSet, "XSLT_FILE_NAME");
            }
            catch (EngineExceptionI e) {
                if (this.actionTxtCode == null || this.actionTxtCode.trim().isEmpty()) {
                    throw new EngineExceptionI(Messages.getString("XsltActionCodeI.6"));
                }
                if (sourceRSet != null) {
                    BindExpressionReplacer.BindedExpressionPlaceHolder expr = BindExpressionReplacer.replaceBindedExpressions((String)this.actionTxtCode);
                    if (expr.hasSessionVariablesToResolve()) {
                        throw new EngineExceptionI("This action does support to resolve variables on bind expressions");
                    }
                    this.code = expr.getBindedExpression();
                }
                this.code = this.actionTxtCode;
            }
        }
        this.sessionClassLoaderName = this.getLocalStringBindedParameter(sourceRSet, "SESSION_CLASS_LOADER_NAME", null);
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        this.prepare(null);
        return 0;
    }
}

